<!DOCTYPE html>
<html lang="pt">
    <meta http-equiv="content-type" content="text/html;charset=utf-8" />

    <head>
        <title><?php echo e(env('EMPRESA')); ?> - <?php echo $__env->yieldContent('titulo'); ?></title>
        <meta charset="utf-8">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="robots" content="noindex">
        <link rel="icon" href="data:;base64," type="image/x-icon">
        <link rel="apple-touch-icon" href="data:;base64,">
        <meta property="og:titulo" content="<?php echo $__env->yieldContent('titulo'); ?>" />
        <meta property="og:url" content="<?php echo $__env->yieldContent('url'); ?>" />
        <meta property="og:description" content="<?php echo $__env->yieldContent('description'); ?>" />
        <meta property="og:image" content="<?php echo $__env->yieldContent('image'); ?>" />
        <meta property="og:image:width" content="954" />
        <meta property="og:image:height" content="500" />    
        <link rel="stylesheet" href="<?php echo e(url('site')); ?>/static/strap34/assets/css/bootstrap.min.css">
        <!-- Theme style -->
        <link href="<?php echo e(url('site')); ?>/static/strap34/assets/css/theme-style.css?v=<?php echo e(rand()); ?>" rel="stylesheet">
        <!-- Your custom override -->
        <link href="<?php echo e(url('site')); ?>/static/strap34/assets/css/portal-styleae52.css?v=<?php echo e(rand()); ?>" rel="stylesheet">
        <link href="<?php echo e(url('site')); ?>/static/css/fontawesome/6.5.2/css/all.min.css" rel="stylesheet">

        <link href='https://fonts.googleapis.com/css?family=Rambla:400,700' rel='stylesheet' type='text/css'>
        <link href='https://fonts.googleapis.com/css?family=Calligraffitti' rel='stylesheet' type='text/css'>
        <link href='https://fonts.googleapis.com/css?family=Roboto+Slab:400,700' rel='stylesheet' type='text/css'>
        <link href='https://fonts.googleapis.com/css?family=Roboto:100,400,700' rel='stylesheet' type='text/css'>
        <link rel="stylesheet" href="<?php echo e(url('site')); ?>/css/style.css?v=<?php echo e(rand()); ?>">


    </head>

    <body class="header-ontop page-index-music navbar-layout-default">
        <!-- HEADER-->
        <div id="header">
            <div data-toggle="sticky">
                <!--Header search region - hidden by default -->
                <div class="header-search collapse" id="search">
                    <form action="<?php echo e(route('site.buscar')); ?>" method="POST" role="form" class="search-form container">
                        <?php echo csrf_field(); ?>
                        <input type="text" name="s" id="search_header_id" class="form-control search" required="required" placeholder="digite o nome do evento">
                        <button type="submit" class="btn btn-link"><span class="sr-only">procurar </span><i class="fa fa-search fa-flip-horizontal search-icon"></i></button>
                        <button type="button" class="btn btn-link close-btn" data-toggle="search-form-close"><span class="sr-only">fechar </span><i class="fa fa-times search-icon"></i></button>
                    </form>
                </div>
                <div class="header">
                    <div class="header-inner container">
                        <!--branding/logo -->
                        <div class="header-brand">
                            <div class="logo-box">
                                <div class="logo-imgwrap">
                                    <a href="<?php echo e(route('site.home')); ?>">
                                        <img src="<?php echo e(url('site')); ?>/images/logo.png" alt="Logo <?php echo e(env('EMPRESA')); ?>">
                                    </a>
                                </div>
                            </div>
                        </div>
                        <!-- other header content -->
                        <div class="header-block order-12">
                            <!--Search trigger -->
                            <a href="#search" class="btn btn-icon btn-link header-btn float-right order-11 btn-search-header" data-toggle="search-form" data-target=".header-search"><i class="fa fa-search fa-flip-horizontal search-icon-open"></i></a>
                            <!-- mobile collapse menu button - data-toggle="collapse" = default BS menu - data-toggle="off-canvas" = Off-cavnas Menu - data-toggle="overlay" = Overlay Menu -->
                            <a href="#top" class="btn btn-link btn-icon header-btn float-right d-lg-none" data-toggle="off-canvas" data-target=".navbar-main" data-settings='{"cloneTarget":true, "targetClassExtras": "navbar-offcanvas"}'> <i class="fa fa-bars"></i> </a>
                            <div class="header-divider d-none d-lg-block"></div>
                        </div>
                        <div class="navbar navbar-expand-md navbar-static-top">
                            <!--everything within this div is collapsed on mobile-->
                            <div class="navbar-main collapse">
                                <!--main navigation-->
                                <?php if(Auth::check()): ?>
                                    <ul class="nav navbar-nav float-lg-right dropdown-effect-fade">
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('site.home')); ?>" class="nav-link"> Home</a>
                                        </li>
                                        
                                        <li class="nav-item d-lg-flex dropdown">
                                            <a href="#" class="nav-link dropdown-toggle animated dropdown" data-toggle="dropdown" data-hover="dropdown" aria-expanded="false">
                                                <i class="fa fa-user"></i> Olá <?php echo e(Auth::user()->name); ?>

                                            </a>
                                            <div class="dropdown-menu dropdown-menu-right">
                                                <a href="<?php echo e(route('cliente.ingressos')); ?>" class="dropdown-item">Meus Ingressos</a>
                                                <a href="<?php echo e(route('minha.conta')); ?>" class="dropdown-item">Minha Conta</a>
                                                <a href="javascript:void(0)" onclick="javascript:Sair()" class="dropdown-item">Sair</a>
                                            </div>
                                        </li>
                                    </ul>
                                <?php else: ?>
                                    <ul class="nav navbar-nav float-lg-right dropdown-effect-fade">
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('site.home')); ?>" class="nav-link"> Home</a>
                                        </li>
                                        
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('login')); ?>" data-dimiss="jpanel-menu" class="nav-link"> <span class="nav-link-inner" data-title="Login">Login</span> </a>
                                        </li>
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('register')); ?>" data-dimiss="jpanel-menu" class="nav-link"> <span class="nav-link-inner" data-title="Criar conta">Criar Conta</span> </a>
                                        </li>
                                    </ul>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- PAGE CONTENT -->
        <?php echo $__env->yieldContent('content'); ?>
        <!-- FOOTER-->
        <footer id="footer" class="footer-light">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="text-center">
                            <a class="logo" href="<?php echo e(route('site.home')); ?>">
                                <img src="<?php echo e(url('site')); ?>/images/logo.png" style="max-height:30px">
                            </a>
                            <ul class="list-inline footer-links mt-3">
                                <li class="list-inline-item"><a href="admin/login/<?php echo e(route('site.home')); ?>">Login</a> | </li>
                                <li class="list-inline-item"><a href="criar-conta/<?php echo e(route('site.home')); ?>">Criar Conta</a> | </li>
                                <li class="list-inline-item"><a href="meus-ingressos/<?php echo e(route('site.home')); ?>">Meus Ingressos</a> | </li>
                                <li class="list-inline-item"><a href="como-funciona/<?php echo e(route('site.home')); ?>">Organize seu Evento</a> | </li>
                                <li class="list-inline-item"><a href="mailto:suamarca@pagtickets.com.br" target="_blank">Fale conosco</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <hr class="my-2">
                <div class="subfooter text-sm text-center">
                    <p>
                        © <?php echo e(env('EMPRESA')); ?> - Todos os direitos reservados.
                        <br>
                        CNPJ: 00.000.000/0001-00
                    </p>
                    <ul class="list-inline footer-links">
                        <li class="list-inline-item"><a href="termos-de-uso/<?php echo e(route('site.home')); ?>">Termos de uso</a></li>
                        <li class="list-inline-item"><a href="politica-de-privacidade/<?php echo e(route('site.home')); ?>">Política de privacidade</a></li>
                    </ul>
                </div>
            </div>
        </footer>
        <form action="<?php echo e(route('logout')); ?>" method="post" id="sair"><?php echo csrf_field(); ?></form>
        <div class="hidden-elements js-off-canvas-exclude"></div>
        <!--jQuery 3.3.1 via CDN -->
        <script src="<?php echo e(url('site')); ?>/static/strap34/assets/js/jquery-3.3.1.min.js"></script>
        <!-- Popper 1.16.0 via CDN, needed for Bootstrap Tooltips & Popovers -->
        <script src="<?php echo e(url('site')); ?>/static/strap34/assets/js/popper-1.16.0.min.js"></script>
        <!-- Bootstrap v4.5.0 JS via CDN -->
        <script src="<?php echo e(url('site')); ?>/static/strap34/assets/js/bootstrap.min.js"></script>
        <script src="<?php echo e(url('site')); ?>/static/js/auth.js"></script>
        <script src="<?php echo e(url('site')); ?>/static/strap34/assets/js/script.min.js"></script> 
        <script src="https://cdnjs.cloudflare.com/ajax/libs/fixto/0.5.0/fixto.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.2.1/owl.carousel.min.js"></script>
        <script>
            $(document).ready(function() {
                setTimeout(() => {
                    $('#slideDestaques').show();
                }, 500);
            });
            function Sair() {
                document.getElementById("sair").submit();
            }
        </script>
        <?php echo $__env->yieldContent('js'); ?>
    </body>

</html>
<?php /**PATH F:\Laravel\MusaTicket\resources\views/site/base.blade.php ENDPATH**/ ?>