<?php $__env->startSection('titulo', 'Cadastro de Eventos'); ?>
<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <div class="container-full">
            <div class="content-header">
                <div class="d-flex align-items-center">
                    <div class="me-auto">
                        <h3 class="page-title">Cadastro de Eventos</h3>
                    </div>
                </div>
            </div>

            <!-- Main content -->
            <section class="content">
                <div class="row">
                    <div class="col-6">
                        <div class="box">
                            <div class="box-body">
                                <form action="<?php echo e(route('evento.store')); ?>" method="post" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <div class="form-body">
                                        <div class="row">
                                            <div class="mb-3 col-sm-12">
                                                <label class="form-label"  for="imageInput">
                                                    <img src="<?php echo e(url('site/images/sem-foto.jpeg')); ?>" id="selectedImage" width="150" style="border-radius: 20px;">
                                                    <br>
                                                    Clique para anexar Foto, tamanho máximo 8Mb
                                                </label>
                                                <input name="image" type="file" class="form-control" style="display: none" id="imageInput" accept="image/*">
                                            </div>
                                            <div class="col-lg-6 col-md-3 col-12">
                                                <div class="form-group">
                                                    <label class="fw-700 fs-16 form-label">Categoria</label>
                                                    <select name="categoria_id" id="categoria_id" class="form-select"
                                                        data-placeholder="Choose a Category" tabindex="1">
                                                        <option value="Selecione um estado">Selecione uma categoria</option>
                                                        <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($categoria->id); ?>"><?php echo e($categoria->titulo); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-3 col-12">
                                                <div class="form-group">
                                                    <label class="fw-700 fs-16 form-label">Tipo</label>
                                                    <select name="tipo" id="tipo" class="form-select" data-placeholder="Choose a Category" tabindex="1">
                                                        <option value="Público">Público</option>
                                                        <option value="Privado">Privado</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="fw-700 fs-16 form-label">Data/Hora Início</label>
                                                    <input name="data_inicio" value="<?php echo e(old('data_inicio')); ?>" type="text" class="form-control date-time">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="fw-700 fs-16 form-label">Data/Hora Final</label>
                                                    <input name="data_fim" value="<?php echo e(old('data_fim')); ?>" type="text" class="form-control date-time">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="fw-700 fs-16 form-label">Evento</label>
                                                    <input name="titulo" value="<?php echo e(old('titulo')); ?>" type="text" class="form-control" placeholder="Evento">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="fw-700 fs-16 form-label">Qtd de Pacotes</label>
                                                    <input name="qtd_pacotes" value="<?php echo e(old('qtd_pacotes')); ?>" type="text" class="form-control" placeholder="Qtd de Pacotes">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="fw-700 fs-16 form-label">Local</label>
                                                    <input name="local" value="<?php echo e(old('local')); ?>" type="text" class="form-control" placeholder="Local">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="fw-700 fs-16 form-label">CEP</label>
                                                    <input name="cep" id="cep" value="<?php echo e(old('cep')); ?>"
                                                        type="tel" class="form-control cep" placeholder="CEP">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="fw-700 fs-16 form-label">Endereço</label>
                                                    <input name="endereco" id="endereco" value="<?php echo e(old('endereco')); ?>"
                                                        type="text" class="form-control" placeholder="Endereço">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="fw-700 fs-16 form-label">Endereço Completo</label>
                                                    <input name="endereco_site" id="endereco_site" value="<?php echo e(old('endereco_site')); ?>" type="text" class="form-control" placeholder="Endereço">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="fw-700 fs-16 form-label">Nº</label>
                                                    <input name="numero" id="numero" value="<?php echo e(old('numero')); ?>"
                                                        type="text" class="form-control" placeholder="Nº">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="fw-700 fs-16 form-label">Complemento</label>
                                                    <input name="complemento" id="complemento"
                                                        value="<?php echo e(old('complemento')); ?>" type="text" class="form-control"
                                                        placeholder="Complemento">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="fw-700 fs-16 form-label">Bairro</label>
                                                    <input name="bairro" id="bairro" value="<?php echo e(old('bairro')); ?>"
                                                        type="text" class="form-control" placeholder="Bairro">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="fw-700 fs-16 form-label">Cidade</label>
                                                    <input name="cidade" id="cidade" value="<?php echo e(old('cidade')); ?>"
                                                        type="text" class="form-control" placeholder="Cidade">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-3 col-12">
                                                <div class="form-group">
                                                    <label class="fw-700 fs-16 form-label">Estado</label>
                                                    <select name="estado" id="estado" class="form-select"
                                                        data-placeholder="Choose a Category" tabindex="1">
                                                        <option value="Selecione um estado">Selecione um estado</option>
                                                        <?php $__currentLoopData = $estados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($estado->uf); ?>"><?php echo e($estado->uf); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="fw-700 fs-16 form-label">Status</label>
                                                    <div class="radio-list">
                                                        <label class="p-0 radio-inline me-10">
                                                            <div class="radio radio-info">
                                                                <input id="statuss" type="radio" name="status" value="Ativo" checked>
                                                                <label for="statuss">Ativo</label>
                                                            </div>
                                                        </label>
                                                        <label class="radio-inline">
                                                            <div class="radio radio-info">
                                                                <input id="statusn" type="radio" name="status" value="Inativo">
                                                                <label for="statusn">Inativo</label>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <button type="submit" class="btn btn-primary"> <i class="fa fa-check"></i> Cadastrar</button>
                                            </div>
                                        </div>
                                    </div>
                            </div>
                            </form>
                        </div>
                    </div>
                </div>
        </div>
        </section>
        <!-- /.content -->
    </div>
    </div>
    <!-- /.content-wrapper -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(url('adm')); ?>/assets/vendor_components/formatter/formatter.js"></script>
    <script src="<?php echo e(url('adm')); ?>/assets/vendor_components/formatter/jquery.formatter.js"></script>
    <script src="<?php echo e(url('adm')); ?>/src/js/pages/formatter.js"></script>

    <script src="<?php echo e(url('adm')); ?>/assets/vendor_components/sweetalert/sweetalert.min.js"></script>
    <script src="<?php echo e(url('adm')); ?>/assets/vendor_components/sweetalert/jquery.sweet-alert.custom.js"></script>
    <script>
        $(document).ready(function() {

            const imageInput = document.getElementById('imageInput');
        const selectedImage = document.getElementById('selectedImage');

        imageInput.addEventListener('change', () => {
        const file = imageInput.files[0];
        const reader = new FileReader();

        reader.addEventListener('load', () => {
            selectedImage.setAttribute('src', reader.result);
        });
            reader.readAsDataURL(file);
        });



            $("#cep").on("blur", function() {
                var numCep = $("#cep").val();
                var url = "https://viacep.com.br/ws/" + numCep.replace(/[\.-]/g, '') + "/json";
                $.ajax({
                    url: url,
                    type: "get",
                    dataType: "json",
                    success: function(dados) {
                        console.log(dados);
                        $("#cep").val(dados.cep);
                        $("#endereco").val(dados.logradouro);
                        $("#bairro").val(dados.bairro);
                        $("#cidade").val(dados.localidade);
                        $("#estado").val(dados.uf);
                    }
                })
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.base.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\MusaTicket\resources\views/admin/eventos/create.blade.php ENDPATH**/ ?>