<!DOCTYPE html>
<html lang="en">

<head>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <meta name="description"
        content="A Musa Ticket é a sua plataforma completa para criação, divulgação e venda de ingressos online. Gerencie seus eventos com facilidade, segurança e suporte eficiente.">
    <meta name="keywords"
        content="Musa Ticket, venda de ingressos, eventos online, plataforma de ingressos, gestão de eventos, venda de ingressos online, ingressos digitais, eventos musicais, ingressos para shows, criar eventos, eventos pagos, eventos gratuitos, venda de ingressos Brasil">
    <title><?php echo e(env('APP_NAME')); ?></title>
    <link href="<?php echo e(url('site')); ?>/images/logos/favicon.png" rel="icon">
    <link rel="apple-touch-icon" href="<?php echo e(url('site')); ?>/images/logos/touch-icon-iphone.png">
    <link rel="apple-touch-icon" sizes="152x152" href="<?php echo e(url('site')); ?>/images/logos/touch-icon-ipad.png">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(url('site')); ?>/images/logos/touch-icon-iphone-retina.png">
    <link rel="apple-touch-icon" sizes="167x167" href="<?php echo e(url('site')); ?>/images/logos/touch-icon-ipad-retina.png">
    <link href="<?php echo e(url('site')); ?>/css/plugins.bundle.css" rel="stylesheet" type="text/css">
    <link href="<?php echo e(url('site')); ?>/css/styles.bundle.css?v=<?php echo e(rand()); ?>" rel="stylesheet" type="text/css">
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;500;600;700;800&amp;display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto+Slab:wght@100;200;300;400;500;600;700;800;900&amp;display=swap" rel="stylesheet"><!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>

<body>
    <div id="line_loader"></div>
    <div id="loader">
        <div class="loader">
            <div class="loader__eq mx-auto">
                <span></span>
                <span></span>
                <span></span>
                <span></span>
                <span></span>
                <span></span>
            </div>
            <span class="loader__text mt-2">Loading</span>
        </div>
    </div>
    <div id="wrapper">
        <aside id="sidebar">
            <div class="sidebar-head d-flex align-items-center justify-content-between">
                <a href="<?php echo e(route('site.home')); ?>" class="brand external">
                    <img src="<?php echo e(url('vendas')); ?>/images/logo.png" alt="<?php echo e(env('APP_NAME')); ?>"> </a>
                <a href="javascript:void(0);" role="button" class="sidebar-toggler" aria-label="Sidebar toggler">
                    <div class="d-none d-lg-block"><i class="ri-menu-3-line sidebar-menu-1"></i>
                        <i class="ri-menu-line sidebar-menu-2"></i>
                    </div>
                    <i class="ri-menu-fold-line d-lg-none"></i>
                </a>
            </div>
            <div class="sidebar-body" data-scroll="true">
                <nav class="navbar d-block p-0">
                    <ul class="navbar-nav">
                        <li class="nav-item">
                            <a href="<?php echo e(route('site.home')); ?>" class="nav-link d-flex align-items-center <?php echo e(request()->routeIs('site.home') ? 'active' : ''); ?>">
                                <i class="ri-home-4-line fs-5"></i> <span class="ps-3">Home</span>
                            </a>
                        </li>

                        <li class="nav-item nav-item--head"><span class="nav-item--head__text">Categorias</span> <span class="nav-item--head__dots">...</span></li>
                        <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="nav-item">
                                <a href="<?php echo e(route('site.categoria', $categoria->url)); ?>"
                                    class="nav-link d-flex align-items-center <?php echo e(request()->is('categoria/' . $categoria->url) ? 'active' : ''); ?>">
                                    <i class="<?php echo e($categoria->ico_2); ?> fs-5"></i>
                                    <span class="ps-3"><?php echo e($categoria->titulo); ?></span>
                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <li class="nav-item">
                            <a href="<?php echo e(route('site.categorias')); ?>" class="nav-link d-flex align-items-center <?php echo e(request()->routeIs('site.categorias') ? 'active' : ''); ?>">
                                <i class="ri-newspaper-line fs-5"></i>
                                <span class="ps-3">Ver Todas</span>
                            </a>
                        </li>

                        <li class="nav-item nav-item--head"><span class="nav-item--head__text">Escolha o Local</span> <span class="nav-item--head__dots">...</span></li>
                        <li class="nav-item">
                            <a href="#" class="nav-link d-flex align-items-center">
                                <i class="ri-disc-line fs-5"></i>
                                <span class="ps-3">Horto Louge</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#" class="nav-link d-flex align-items-center">
                                <i class="ri-disc-line fs-5"></i>
                                <span class="ps-3">Blitz Music Bar</span>
                            </a>
                        </li>
                        
                    </ul>
                </nav>
            </div>
            <div class="sidebar-foot">
                <a href="#" class="btn btn-primary d-flex">
                    <div class="btn__wrap">
                        <i class="ri-music-fill"></i>
                        <span>Publique seu Evento</span>
                    </div>
                </a>
            </div>
        </aside>
        <header id="header">
            <div class="container">
                <div class="header-container">
                    <div class="d-flex align-items-center">
                        <a href="javascript:void(0);" role="button" class="header-text sidebar-toggler d-lg-none me-3" aria-label="Sidebar toggler"><i class="ri-menu-3-line"></i></a>
                        <form action="#" id="search_form" class="me-3">
                            <label for="search_input"><i class="ri-search-2-line"></i></label>
                            <input type="text" placeholder="Pesquise eventos, categorias ou locais..." id="search_input" class="form-control form-control-sm">
                        </form>
                        <div id="search_results" class="search pb-3">
                            <div class="search__head">
                                <div class="search__head__filter">
                                    <a href="<?php echo e(route('site.categorias')); ?>" class="btn btn-sm btn-light-primary active">Eventos</a>
                                    <a href="<?php echo e(route('site.categorias')); ?>" class="btn btn-sm btn-light-primary">Categorias</a>
                                    <a href="" class="btn btn-sm btn-light-primary">Locais</a>
                                </div>
                            </div>
                            <div class="search__body" data-scroll="true" id="result_busca">
                                <div class="mb-4">
                                    <div class="d-flex align-items-center justify-content-between mb-3">
                                        <span class="search__title">Categorias</span>
                                        <a href="<?php echo e(route('site.categorias')); ?>" class="btn btn-link">mostrar tudo</a>
                                    </div>
                                    <div class="row g-4 list">
                                        <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-xl-3 col-md-4 col-sm-6">
                                                <div class="list__item">
                                                    <a href="<?php echo e(url('site.categoria', $categoria->url)); ?>" class="list__cover">
                                                        <img src="<?php echo e(url("storage/{$categoria->ico}")); ?>" alt="<?php echo e($categoria->titulo); ?>">
                                                    </a>
                                                    <div class="list__content">
                                                        <a href="<?php echo e(url('site.categoria', $categoria->url)); ?>" class="list__title text-truncate"><?php echo e($categoria->titulo); ?></a>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex align-items-center">
                            <div class="dropdown ms-3 ms-sm-4">
                                <a href="javascript:void(0);" class="avatar header-text" role="button" id="user_menu" data-bs-toggle="dropdown" aria-expanded="false">
                                    <?php if(Auth::check()): ?>
                                        <div class="avatar__image">
                                            <img src="<?php echo e(url('site')); ?>/images/users/thumb.jpg" alt="user">
                                        </div>
                                        <span class="ps-2 d-none d-sm-block"><?php echo e(Auth::user()->name); ?></span>
                                    <?php else: ?>
                                        <div class="avatar__image">
                                            <img src="<?php echo e(url('site')); ?>/images/users/thumb.jpg" alt="user">
                                        </div>
                                        <span class="ps-2 d-none d-sm-block">Área do Cliente</span>
                                    <?php endif; ?>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-md dropdown-menu-end" aria-labelledby="user_menu">
                                    <?php if(Auth::check()): ?>
                                        <li>
                                            <div class="py-2 px-3 avatar avatar--lg">
                                                <div class="avatar__image">
                                                    <img src="<?php echo e(url('site')); ?>/images/users/thumb.jpg" alt="user">
                                                </div>
                                                <div class="avatar__content"><span class="avatar__title"><?php echo e(Auth::user()->name); ?></span>
                                                    <span class="avatar__subtitle">Cliente</span>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="dropdown-divider"></li>
                                        <li>
                                            <a class="dropdown-item d-flex align-items-center" href="#">
                                                <i class="ri-user-3-line fs-5"></i>
                                                <span class="ps-2">Meu Perfil</span>
                                            </a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item d-flex align-items-center" href="#">
                                                <i class="ri-ticket-line fs-5"></i>
                                                <span class="ps-2">Meus Ingressos</span>
                                            </a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item d-flex align-items-center" href="#">
                                                <i class="ri-heart-line fs-5"></i>
                                                <span class="ps-2">Meus Favoritos</span>
                                            </a>
                                        </li>
                                        <li class="dropdown-divider"></li>
                                        <li>
                                            <a onclick="Sair()" class="dropdown-item d-flex align-items-center external text-danger" href="javascript:void(0)">
                                                <i class="ri-logout-circle-line fs-5"></i>
                                                <span class="ps-2">Sair</span>
                                            </a>
                                        </li>
                                    <?php else: ?>
                                        <li class="dropdown-divider"></li>
                                        <li>
                                            <a class="dropdown-item d-flex align-items-center" href="<?php echo e(route('site.login')); ?>">
                                                <i class="ri-user-3-line fs-5"></i>
                                                <span class="ps-2">Login</span>
                                            </a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item d-flex align-items-center" href="<?php echo e(route('site.cadastro')); ?>">
                                                <i class="ri-user-add-line fs-5"></i>
                                                <span class="ps-2">Cadastre-se</span>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </header>
        <?php echo $__env->yieldContent('content'); ?>

    </div>
    <div id="player">
        <div class="container">
            <div class="player-container">
                <div class="player-progress">
                    <progress class="amplitude-buffered-progress player-progress__bar" value="0"></progress>
                    <progress class="amplitude-song-played-progress player-progress__bar"></progress>
                    <input type="range" class="amplitude-song-slider player-progress__slider" aria-label="Progress slider">
                </div>
                <div class="cover d-flex align-items-center">
                    <div class="cover__image">
                        <img data-amplitude-song-info="cover_art_url" src="<?php echo e(url('site')); ?>/images/cover/small/1.jpg" alt="">
                    </div>
                    <div class="cover__content ps-3 d-none d-sm-block">
                        <a href="<?php echo e(url('site')); ?>/song-details.html" class="cover__title text-truncate" data-amplitude-song-info="name"></a>
                        <a href="<?php echo e(url('site')); ?>/artist-details.html" class="cover__subtitle text-truncate" data-amplitude-song-info="artist"></a>
                    </div>
                </div>
                <div class="player-control">
                    <button type="button" class="amplitude-repeat btn btn-icon me-4 d-none d-md-block" aria-label="Repeat">
                        <i class="ri-repeat-2-fill fs-5"></i>
                    </button>
                    <button type="button" class="amplitude-prev btn btn-icon" aria-label="Backward">
                        <i class="ri-skip-back-mini-fill"></i>
                    </button>
                    <button type="button" class="amplitude-play-pause btn btn-icon btn-default rounded-pill" aria-label="Play pause">
                        <i class="ri-play-fill icon-play"></i>
                        <i class="ri-pause-fill icon-pause"></i>
                    </button>
                    <button type="button" class="amplitude-next btn btn-icon" aria-label="Forward">
                        <i class="ri-skip-forward-mini-fill"></i>
                    </button>
                    <button type="button" class="amplitude-shuffle amplitude-shuffle-off btn btn-icon ms-4 d-none d-md-block" aria-label="Shuffle">
                        <i class="ri-shuffle-fill fs-5"></i>
                    </button>
                </div>
                <div class="player-info">
                    <div class="me-4 d-none d-xl-block">
                        <span class="amplitude-current-minutes"></span>:
                        <span class="amplitude-current-seconds"></span> /
                        <span class="amplitude-duration-minutes"></span>:
                        <span class="amplitude-duration-seconds"></span>
                    </div>
                    <div class="player-volume dropdown d-none d-md-block">
                        <button class="btn btn-icon" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-label="Volume" aria-expanded="false">
                            <i class="ri-volume-mute-fill fs-5 d-none"></i>
                            <i class="ri-volume-down-fill fs-5"></i>
                            <i class="ri-volume-up-fill fs-5 d-none"></i>
                        </button>
                        <div class="dropdown-menu prevent-click">
                            <input type="range" class="amplitude-volume-slider" value="50" min="0" max="100" aria-label="Volume slider">
                        </div>
                    </div>
                    <div class="playlist dropstart me-3">
                        <button class="btn btn-icon" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-label="Playlist" aria-expanded="false">
                            <i class="ri-play-list-fill fs-5"></i>
                        </button>
                        <div class="dropdown-menu playlist__dropdown">
                            <div class="playlist__head d-flex align-items-center justify-content-between">
                                <h6 class="mb-0">Lineup</h6>
                                <a href="javascript:void(0);" role="button" id="clear_playlist" class="btn btn-link">Limpar</a>
                            </div>
                            <div id="playlist" class="list playlist__body" data-scroll="true">
                                <div class="col-sm-8 col-10 mx-auto mt-5 text-center">
                                    <i class="ri-music-2-line mb-3"></i>
                                    <p>Monte seu player.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div id="backdrop"></div>
    <form action="<?php echo e(route('logout')); ?>" method="post" id="sair"><?php echo csrf_field(); ?></form>
    <script src="<?php echo e(url('vendas')); ?>/static/strap34/assets/js/jquery-3.3.1.min.js"></script>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            let playlist = [
                <?php $__currentLoopData = $Play; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $musica): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                {
                    id: <?php echo e($musica->id); ?>,
                    name: "<?php echo e($musica->titulo); ?>",
                    artist: "<?php echo e($musica->artista); ?>",
                    album: "Mummy",
                    url: "<?php echo e(url("storage/{$musica->file}")); ?>",
                    cover_art_url: "<?php echo e(url("storage/{$musica->capa}")); ?>"
                }<?php echo e(!$loop->last ? ',' : ''); ?>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ];

            // Salva no localStorage como o Player.js espera
            localStorage.setItem("songs", JSON.stringify(playlist));

            // Aguarda o DOM e inicializa o player
            if (typeof Player !== 'undefined' && typeof Player.init === 'function') {
                Player.init();

                const waitForAmplitude = setInterval(() => {
                    if (Amplitude.getSongs().length > 0) {
                        // Reconfigura o Amplitude com a playlist e ativando a sequência automática
                        Amplitude.init({
                            songs: playlist,
                            continue_next: true
                        });

                        // Dá play na primeira música
                        Amplitude.playSongAtIndex(0);

                        clearInterval(waitForAmplitude);
                    }
                }, 300);
            }
        });

        $(document).ready(function() {
            $("#search_input").keyup(function() {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: "<?php echo e(route('busca.rapida')); ?>",
                    method: 'POST',
                    data: {
                        s: $("#search_input").val()
                    },
                    success: function(result) {
                        $("#result_busca").html(result);
                    }
                });
            });
        });
    </script>
    <script>
        function Sair() {
            document.getElementById("sair").submit();
        }
    </script>

    <?php echo $__env->yieldContent('js'); ?>

    <script src="<?php echo e(url('site')); ?>/js/plugins.bundle.js"></script>
    <script src="<?php echo e(url('site')); ?>/js/scripts.bundle.js?v=<?php echo e(rand()); ?>"></script>
</body>

</html>
<?php /**PATH /home/musaticketcom/novo.musaticket.com.br/resources/views/site/base.blade.php ENDPATH**/ ?>