<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="utf-8" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="icon" href="<?php echo e(url('site')); ?>/images/favicon.ico" type="image/x-icon" sizes="256x256" />
    <meta name="next-size-adjust" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <title><?php echo $__env->yieldContent('titulo'); ?></title>

    <!-- CSS (corrigido link duplicado) -->
    <link rel="stylesheet" href="<?php echo e(url('site')); ?>/css/style.css?v=<?php echo e(rand()); ?>" />
    <link rel="stylesheet" href="<?php echo e(url('site')); ?>/css/style_2.css?v=<?php echo e(rand()); ?>" />
    <link rel="stylesheet" href="<?php echo e(url('site')); ?>/css/style_3.css?v=<?php echo e(rand()); ?>" />
    <link rel="stylesheet" href="<?php echo e(url('site')); ?>/css/style_4.css?v=<?php echo e(rand()); ?>" />
    <link rel="stylesheet" href="<?php echo e(url('site')); ?>/css/style_5.css?v=<?php echo e(rand()); ?>" />

    <!-- JS (coloquei defer para não bloquear renderização) -->
    <script src="<?php echo e(url('site')); ?>/js/scritp.js" defer></script>
    <script src="<?php echo e(url('site')); ?>/js/script_2.js" defer></script>
    <script src="<?php echo e(url('site')); ?>/js/script_3.js" defer></script>
    <script src="<?php echo e(url('site')); ?>/js/carousel.js" defer></script>

    <meta property="og:title" content="<?php echo $__env->yieldContent('titulo'); ?>" />
    <meta property="og:url" content="<?php echo $__env->yieldContent('url'); ?>" />
    <meta property="og:description" content="<?php echo $__env->yieldContent('description'); ?>" />
    <?php echo $__env->yieldContent('application_ld_json'); ?>
    <meta property="og:image" content="<?php echo $__env->yieldContent('image'); ?>" />
    <meta property="og:image:width" content="954" />
    <meta property="og:image:height" content="500" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="<?php echo e(url('vendas')); ?>/static/strap34/assets/js/jquery-3.3.1.min.js"></script>
    <script>
        ! function(f, b, e, v, n, t, s) {
            if (f.fbq) return;
            n = f.fbq = function() {
                n.callMethod ? n.callMethod.apply(n, arguments) : n.queue.push(arguments)
            };
            if (!f._fbq) f._fbq = n;
            n.push = n;
            n.loaded = !0;
            n.version = '2.0';
            n.queue = [];
            t = b.createElement(e);
            t.async = !0;
            t.src = v;
            s = b.getElementsByTagName(e)[0];
            s.parentNode.insertBefore(t, s)
        }(window, document, 'script', 'https://connect.facebook.net/en_US/fbevents.js');

        fbq('init', '<?php echo e(env('PIXEL')); ?>');
        fbq('track', 'PageView');
    </script>
    <noscript>
        <img height="1" width="1" style="display:none" src="https://www.facebook.com/tr?id=<?php echo e(env('PIXEL')); ?>&ev=PageView&noscript=1" />
    </noscript>

    <script src="https://sdk.mercadopago.com/js/v2"></script>
    <?php echo $__env->yieldContent('css'); ?>

    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-RSKJE20DT1"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());

        gtag('config', 'G-RSKJE20DT1');
    </script>

</head>

<body class="scrollbar scrollbar-none relative bg-primary-white" data-auth="<?php echo e(Auth::check() ? '1' : '0'); ?>">
    <?php if(Auth::check()): ?>
        <div class="sempreDireita">
            <a href="https://api.whatsapp.com/send?phone=55<?php echo e(tiraMoeda(env('WHATSAPP_SUPORTE'))); ?>&text=Olá, eu me chamo <?php echo e(Auth::user()->name); ?>, estou no Site da Afoxé Filhos de Gandhy e preciso de ajuda para minha conta. Meu código do cliente Afoxé Filhos de Gandhy é <?php echo e(Auth::user()->id); ?>."
                target="_blank">
                <img src="<?php echo e(url('site/images/whatsapp.png')); ?>" width="20" style="margin-right: 5px">
                Atendimento ao Cliente
            </a>
        </div>
        
        
    <?php endif; ?>

    <div id="_rht_toaster" style="position: fixed; z-index: 9999; inset: 16px; pointer-events: none"></div>

    <div class="relative w-full">
        <div class="fixed top-0 left-0 right-0 z-30">
            <div class="w-full 4xl:mx-auto">
                <!-- ====== HEADER ====== -->
                <header class="h-[72px] bg-primary-green flex justify-between items-center px-4 md:px-8 z-[9999]">
                    <div class="h-[72px] 4xl:px-12 w-full 4xl:w-[70%] 4xl:mx-auto flex justify-between items-center">

                        <!-- Logo -->
                        <div>
                            <a href="<?php echo e(route('site.home')); ?>" class="cursor-pointer block">
                                <img alt="Logo" loading="lazy" width="150" decoding="async" src="<?php echo e(url('site')); ?>/images/logo-branca.png" />
                            </a>
                        </div>

                        <!-- Menu desktop -->
                        <ul class="grow shrink basis-0 self-stretch justify-start items-center hidden lg:flex w-full ml-12">
                            
                            <a class="h-full" href="<?php echo e(route('site.home')); ?>">
                                <li class="self-stretch p-4 justify-center items-center gap-2 flex h-full cursor-pointer
            <?php echo e(request()->routeIs('site.home') ? 'bg-green-light text-primary-musa' : 'bg-primary-green text-white'); ?>">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 24 24" fill="none" stroke="<?php echo e(request()->routeIs('site.home') ? '#023324' : '#F1F7FF'); ?>" stroke-width="2"
                                        stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-house">
                                        <path d="M15 21v-8a1 1 0 0 0-1-1h-4a1 1 0 0 0-1 1v8"></path>
                                        <path d="M3 10a2 2 0 0 1 .709-1.528l7-5.999a2 2 0 0 1 2.582 0l7 5.999A2 2 0 0 1 21 10v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                                    </svg>
                                    <div class="h-full flex items-center text-base font-normal leading-none">
                                        <span class="text-base">Início</span>
                                    </div>
                                </li>
                            </a>

                            
                            <a class="h-full" href="<?php echo e(route('site.eventos')); ?>">
                                <li class="self-stretch p-4 justify-center items-center gap-2 flex h-full cursor-pointer
            <?php echo e(request()->routeIs('site.eventos') ? 'bg-green-light text-primary-musa' : 'bg-primary-green text-white'); ?>">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 24 24" fill="none" stroke="<?php echo e(request()->routeIs('site.eventos') ? '#023324' : '#F1F7FF'); ?>" stroke-width="2"
                                        stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-party-popper">
                                        <path d="M5.8 11.3 2 22l10.7-3.79"></path>
                                        <path d="M4 3h.01"></path>
                                        <path d="M22 8h.01"></path>
                                        <path d="M15 2h.01"></path>
                                        <path d="M22 20h.01"></path>
                                        <path d="m22 2-2.24.75a2.9 2.9 0 0 0-1.96 3.12c.1.86-.57 1.63-1.45 1.63h-.38c-.86 0-1.6.6-1.76 1.44L14 10"></path>
                                        <path d="m22 13-.82-.33c-.86-.34-1.82.2-1.98 1.11c-.11.7-.72 1.22-1.43 1.22H17"></path>
                                        <path d="m11 2 .33.82c.34.86-.2 1.82-1.11 1.98C9.52 4.9 9 5.52 9 6.23V7"></path>
                                        <path d="M11 13c1.93 1.93 2.83 4.17 2 5-.83.83-3.07-.07-5-2-1.93-1.93-2.83-4.17-2-5 .83-.83 3.07.07 5 2Z"></path>
                                    </svg>
                                    <div class="h-full flex items-center text-base font-normal leading-none">
                                        <span class="text-base">Eventos</span>
                                    </div>
                                </li>
                            </a>

                            
                            <a class="h-full" href="<?php echo e(route('site.locais')); ?>">
                                <li class="self-stretch p-4 justify-center items-center gap-2 flex h-full cursor-pointer
            <?php echo e(request()->is('locais*') ? 'bg-green-light text-primary-musa' : 'bg-primary-green text-white'); ?>">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 24 24" fill="none" stroke="<?php echo e(request()->is('locais*') ? '#023324' : '#F1F7FF'); ?>" stroke-width="2"
                                        stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-briefcase-business">
                                        <path d="M12 12h.01"></path>
                                        <path d="M16 6V4a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v2"></path>
                                        <path d="M22 13a18.15 18.15 0 0 1-20 0"></path>
                                        <rect width="20" height="14" x="2" y="6" rx="2"></rect>
                                    </svg>
                                    <div class="h-full flex items-center text-base font-normal leading-none">
                                        <span class="text-base">Produtores</span>
                                    </div>
                                </li>
                            </a>

                            
                            <a class="h-full" href="<?php echo e(route('site.ajuda')); ?>">
                                <li
                                    class="self-stretch p-4 justify-center items-center gap-2 flex h-full cursor-pointer
                                    <?php echo e(request()->routeIs('site.ajuda') ? 'bg-green-light text-primary-musa' : 'bg-primary-green text-white'); ?>">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 24 24" fill="none" stroke="<?php echo e(request()->routeIs('site.ajuda') ? '#023324' : '#F1F7FF'); ?>" stroke-width="2"
                                        stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-help">
                                        <circle cx="12" cy="12" r="10"></circle>
                                        <path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"></path>
                                        <path d="M12 17h.01"></path>
                                    </svg>
                                    <div class="h-full flex items-center text-base font-normal leading-none">
                                        <span class="text-base">Ajuda</span>
                                    </div>
                                </li>
                            </a>
                        </ul>


                        <!-- Busca desktop -->
                        <div class="hidden md:block">
                            <div class="relative h-full md:w-[400px] lg:w-[280px]">
                                <input class="bg-green-light w-full md:h-10 h-11 px-4 rounded-full text-tertiary-green text-base font-normal leading-none focus:outline-none placeholder:text-tertiary-green focus:bg-white"
                                    placeholder="Pesquisar evento" type="text" value="" />
                                <div class="absolute right-3 top-1/2 transform -translate-y-1/2">
                                    <button>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                            class="lucide lucide-search absolute right-1 top-1/2 transform -translate-y-1/2 text-tertiary-green">
                                            <circle cx="11" cy="11" r="8"></circle>
                                            <path d="m21 21-4.3-4.3"></path>
                                        </svg>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- Botão hambúrguer (VISÍVEL NO MOBILE) -->
                        <button id="menuButton" type="button" aria-label="Abrir menu" aria-controls="mobileMenu" aria-expanded="false" class="xl:hidden block p-2 ml-3 text-white cursor-pointer relative z-[10000]">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-8 h-8" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                                <line x1="3" y1="12" x2="21" y2="12" />
                                <line x1="3" y1="6" x2="21" y2="6" />
                                <line x1="3" y1="18" x2="21" y2="18" />
                            </svg>
                        </button>

                        <!-- Ações (desktop) -->
                        <div class="flex-row items-center hidden lg:flex">
                            <div class="relative">
                                <a href="carrinho">
                                    <button class="rounded-full bg-green-button p-[0.5rem] md:ml-4 hover:bg-green-hover">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                            class="lucide lucide-shopping-cart text-primary-musa">
                                            <circle cx="8" cy="21" r="1"></circle>
                                            <circle cx="19" cy="21" r="1"></circle>
                                            <path d="M2.05 2.05h2l2.66 12.42a2 2 0 0 0 2 1.58h9.78a2 2 0 0 0 1.95-1.57l1.65-7.43H5.12"></path>
                                        </svg>
                                    </button>
                                </a>
                            </div>
                            <div class="ml-4">
                                <button type="button" class="btnConta bg-green-button w-full flex hover:bg-green-hover rounded-full px-4 py-[0.6rem] relative">
                                    <div class="flex items-center w-full gap-x-3 pr-6 justify-between">
                                        <div><span class="text-center text-primary-musa">Conta</span></div>
                                        <div class="absolute right-3 top-1/2 transform -translate-y-1/2">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                class="lucide lucide-chevron-down">
                                                <path d="m6 9 6 6 6-6"></path>
                                            </svg>
                                        </div>
                                    </div>
                                </button>
                            </div>
                        </div>
                    </div>
                </header>
                <!-- Dropdown Conta -->
                <div id="menuConta" class="hidden absolute right-0 top-[72px] w-[250px] bg-green-light px-3 py-3 rounded-b-2xl shadow-lg z-[99999]">
                    <h1 class="text-base">Bem vindo,</h1>
                    <h1 class="font-bold text-primary-musa"><?php echo e(Auth::check() ? Auth::user()->name : 'Visitante'); ?></h1>
                    <hr class="my-2 bg-primary-green border-primary-green">
                    <ul>
                        <a href="<?php echo e(route('cliente.ingressos')); ?>">
                            <li class="cursor-pointer hover:text-primary-musa transition mb-2 flex items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                    class="lucide lucide-ticket text-primary-musa">
                                    <path d="M2 9a3 3 0 0 1 0 6v2a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2v-2a3 3 0 0 1 0-6V7a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2Z"></path>
                                    <path d="M13 5v2"></path>
                                    <path d="M13 17v2"></path>
                                    <path d="M13 11v2"></path>
                                </svg>
                                <p class="ml-2">Meus ingressos</p>
                            </li>
                        </a>
                        <a href="<?php echo e(route('minha.conta')); ?>">
                            <li class="cursor-pointer hover:text-primary-musa transition mb-2 flex items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                    class="lucide lucide-user text-primary-musa">
                                    <path d="M19 21v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="12" cy="7" r="4"></circle>
                                </svg>
                                <p class="ml-2">Meus dados</p>
                            </li>
                        </a>
                        <?php if(Auth::check() && Auth::user()->nivel < 3): ?>
                            <a href="<?php echo e(route('dashboard')); ?>">
                                <li class="cursor-pointer hover:text-primary-musa transition mb-2 flex items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                        class="lucide lucide-user text-primary-musa">
                                        <path d="M19 21v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2"></path>
                                        <circle cx="12" cy="7" r="4"></circle>
                                    </svg>
                                    <p class="ml-2">Área do Produtor</p>
                                </li>
                            </a>
                        <?php endif; ?>
                        <?php if(Auth::check()): ?>
                            <a href="javascript:void(0)" onclick="javascript:Sair();">
                                <li class="cursor-pointer hover:text-primary-musa transition mb-2 flex items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                        class="lucide lucide-log-out text-primary-musa">
                                        <path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"></path>
                                        <polyline points="16 17 21 12 16 7"></polyline>
                                        <line x1="21" x2="9" y1="12" y2="12"></line>
                                    </svg>
                                    <p class="ml-2">Sair</p>
                                </li>
                            </a>
                        <?php endif; ?>

                    </ul>
                </div>
            </div>
        </div>

        <!-- CONTEÚDO -->
        <div class="pt-0">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </div>

    <!-- Backdrop + Menu Mobile (fora do header para cobrir a tela toda) -->
    <div id="backdrop" class="fixed inset-0 bg-black/40 opacity-0 pointer-events-none transition-opacity duration-300 z-[9998]"></div>

    <nav id="mobileMenu" class="fixed right-0 top-0 w-[100%] max-w-[420px] min-h-screen bg-white z-[9999] transform translate-x-full transition-transform duration-300 ease-in-out p-4 shadow-xl" role="dialog" aria-modal="true"
        aria-labelledby="mobileMenuTitle" tabindex="-1">
        <button class="w-fit ml-auto p-2" id="closeMenu" aria-label="Fechar menu">
            <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-x">
                <path d="M18 6 6 18"></path>
                <path d="m6 6 12 12"></path>
            </svg>
        </button>
        <div>
            <h1 class="text-sm">Bem vindo,</h1>
            <h1 id="mobileMenuTitle" class="font-bold text-xl"><?php echo e(Auth::check() ? Auth::user()->name : 'Visitante'); ?></h1>
        </div>
        <hr class="my-2 border-black">
        <ul class="my-6">
            <a href="<?php echo e(route('site.home')); ?>">
                <li class="flex items-center mb-6"><span class="mr-3">🏠</span><span class="text-lg">Início</span></li>
            </a>
            <a href="<?php echo e(route('site.eventos')); ?>">
                <li class="flex items-center mb-6"><span class="mr-3">🎉</span><span class="text-lg">Eventos</span></li>
            </a>
            <a href="<?php echo e(route('site.locais')); ?>">
                <li class="flex items-center mb-6"><span class="mr-3">📍</span><span class="text-lg">Produtores</span></li>
            </a>
            <a href="<?php echo e(route('cliente.ingressos')); ?>">
                <li class="flex items-center mb-6"><span class="mr-3">🎟️</span><span class="text-lg">Meus ingressos</span></li>
            </a>
            <?php if(Auth::check() && Auth::user()->nivel < 3): ?>
                <a href="<?php echo e(route('dashboard')); ?>">
                    <li class="flex items-center mb-6"><span class="mr-3">👨🏽‍💻</span><span class="text-lg">Área do Produtor</span></li>
                </a>
            <?php endif; ?>
            <!-- Também pode acionar o mesmo comportamento -->
            <li class="flex items-center mb-6">
                <button type="button" class="btnConta flex items-center"><span class="mr-3">👤</span><span class="text-lg">Conta</span></button>
            </li>
            <?php if(Auth::check()): ?>
                <hr class="mt-2 mb-4 border border-gray-300">
                <a href="javascript:void(0)" onclick="javascript:Sair();">
                    <li class="flex items-center mb-6"><span class="mr-3">🚪</span><span class="text-lg">Sair</span></li>
                </a>
            <?php endif; ?>

        </ul>
    </nav>

    <!-- ===== Modal de Login ===== -->
    <div id="modalLogin" class="hidden fixed inset-0 flex items-center justify-center z-[99999] bg-black/50">
        <div class="relative
                  w-[95%] max-h-[100%]
                  md:w-4/6 lg:w-3/6 xl:w-[40%] 4xl:w-[25%]
                  my-6 mx-auto bg-white rounded-2xl shadow-lg">
            <button id="closeModalLogin" class="absolute top-2 right-6 cursor-pointer" aria-label="Fechar modal">
                <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 512 512" height="28" width="28" xmlns="http://www.w3.org/2000/svg">
                    <path d="M405 136.798L375.202 107 256 226.202 136.798 107 107 136.798 226.202 256 107 375.202 136.798 405 256 285.798 375.202 405 405 375.202 285.798 256z"></path>
                </svg>
            </button>

            <div class="p-6">
                <h1 class="text-primary-green font-bold text-2xl mb-3 mt-6">Entrar na minha conta</h1>
                
                <?php if($errors->any()): ?>
                    <div class="mb-4">
                        <ul class="text-red-600 text-sm">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li style="font-weight: bold; background: #FFBFBF; padding: 10px; border-radius: 20px; padding-left: 20px;"><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <!-- Dentro do Modal de Login -->
                <form class="w-full" action="<?php echo e(route('login')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="flex flex-col gap-y-3">
                        <div class="relative">
                            <label class="mb-1 text-primary-green">E-mail</label>
                            <input id="email" name="email" type="text" value="<?php echo e(old('email')); ?>"
                                class="bg-green-light w-full h-11 px-4 rounded-full text-tertiary-green 
                   text-base leading-none focus:outline-none 
                   placeholder:text-tertiary-green focus:bg-green-light/60"
                                placeholder="nome@email.com">
                        </div>
                        <div class="relative">
                            <label class="mb-1 text-primary-green">Senha</label>
                            <input id="password" name="password" type="password"
                                class="bg-green-light w-full h-11 px-4 rounded-full text-tertiary-green 
                   text-base leading-none focus:outline-none 
                   placeholder:text-tertiary-green focus:bg-green-light/60"
                                placeholder="Insira sua senha">
                        </div>
                    </div>

                    <!-- Link Esqueceu a Senha -->
                    <button id="forgotPasswordLink" type="button" class="my-3">
                        <span class="hover:text-primary-green transition">Esqueceu a senha?</span>
                    </button>

                    <div class="px-6">
                        <div class="flex items-center justify-center flex-col gap-2 pb-10 w-full">
                            <div class="w-full md:w-[90%]">
                                <button type="submit" id="btnLogin"
                                    class="bg-primary-green w-full flex hover:bg-primary-green/90 
                                    rounded-full px-4 py-[0.6rem] disabled:bg-disabled disabled:cursor-not-allowed 
                                    relative justify-center items-center">
                                    <!-- Texto -->
                                    <span id="btnLoginText" class="text-center text-white">Entrar</span>

                                    <!-- Loader 3 dots -->
                                    <span id="btnLoginLoader" class="hidden flex gap-3 items-center justify-center">
                                        <span class="dot"></span>
                                        <span class="dot delay-150"></span>
                                        <span class="dot delay-300"></span>
                                    </span>
                                </button>
                            </div>
                        </div>
                    </div>
                </form>

                <div class="px-6">
                    <div class="flex items-center justify-center flex-col gap-2 pb-10 w-full">
                        <div class="mt-1 w-full flex justify-center">
                            <h2>Não possui uma conta?
                                <a href="<?php echo e(route('site.cadastro')); ?>" class="text-primary-green font-bold cursor-pointer text-center">
                                    Criar conta
                                </a>
                            </h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="modalForgotPassword" class="hidden fixed inset-0 flex items-center justify-center z-[99999] bg-black/50">
        <div class="relative w-[95%] max-h-[100%]
        md:w-4/6 lg:w-3/6 xl:w-[40%] 4xl:w-[25%]
        my-6 mx-auto bg-white rounded-2xl shadow-lg">

            <!-- Botão fechar -->
            <div class="absolute top-2 right-6 cursor-pointer" id="closeForgotPassword">
                <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 512 512" height="28" width="28">
                    <path d="M405 136.798L375.202 107 256 226.202 136.798 107
                         107 136.798 226.202 256 107 375.202
                         136.798 405 256 285.798 375.202 405
                         405 375.202 285.798 256z"></path>
                </svg>
            </div>

            <!-- Conteúdo -->
            <div class="h-full p-6 flex justify-start items-start overflow-auto">
                <div class="w-full md:w-[90%]">
                    <h1 class="text-primary-green font-bold text-2xl mb-1 mt-6">Esqueceu sua senha?</h1>
                    <h2 class="mb-6 text-gray-dark text-sm">
                        Digite seu e-mail para receber um link para redefinir sua senha.
                    </h2>
                    <?php if($errors->any()): ?>
                        <div class="mb-4">
                            <ul class="text-red-600 text-sm">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li style="font-weight: bold; background: #FFBFBF; padding: 10px; border-radius: 20px; padding-left: 20px;"><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <form method="POST" action="<?php echo e(route('password.email')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="relative h-full w-auto">
                            <label class="mb-1 text-primary-green">E-mail</label>
                            <input id="email_forgot" name="email" type="email"
                                class="bg-green-light w-full md:h-10 h-11 px-4 rounded-full 
                                   text-tertiary-green text-base font-normal leading-none 
                                   focus:outline-none placeholder:text-tertiary-green 
                                   focus:bg-green-light/60"
                                placeholder="Insira seu e-mail">
                            <div class="absolute right-3 top-1/2 transform -translate-y-1/2"></div>
                        </div>

                        <!-- Botão igual ao do login -->
                        <div class="px-6">
                            <div class="flex justify-center w-full mt-6">
                                <button type="submit" id="btnForgot"
                                    class="bg-primary-green w-full flex hover:bg-primary-green/90 
                                        rounded-full px-4 py-[0.6rem] disabled:bg-disabled 
                                        disabled:cursor-not-allowed relative justify-center items-center">

                                    <!-- Texto -->
                                    <span id="btnForgotText" class="text-center text-white">Enviar</span>

                                    <!-- Loader 3 dots -->
                                    <span id="btnForgotLoader" class="hidden flex gap-3 items-center justify-center">
                                        <span class="dot"></span>
                                        <span class="dot delay-150"></span>
                                        <span class="dot delay-300"></span>
                                    </span>
                                </button>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>




    <form action="<?php echo e(route('logout')); ?>" method="post" id="sair"><?php echo csrf_field(); ?></form>
    <!-- Scripts da página -->
    <script>
        (function() {
            // Estado de login vindo do Blade
            const isLogged = document.body.getAttribute('data-auth') === '1';

            // Elementos
            const btnsConta = document.querySelectorAll('.btnConta'); // pode ter em vários lugares
            const menuConta = document.getElementById('menuConta');
            const modalLogin = document.getElementById('modalLogin');
            const closeModalLogin = document.getElementById('closeModalLogin');

            // Mobile menu
            const menuButton = document.getElementById('menuButton');
            const mobileMenu = document.getElementById('mobileMenu');
            const closeMenu = document.getElementById('closeMenu');
            const backdrop = document.getElementById('backdrop');
            let lastFocused = null;

            // Helpers visibilidade
            const show = el => el && el.classList.remove('hidden');
            const hide = el => el && el.classList.add('hidden');
            const toggle = el => el && el.classList.toggle('hidden');

            // Fecha tudo relacionado a conta
            function closeAccountUIs() {
                hide(menuConta);
                hide(modalLogin);
            }

            // Clique nos botões "Conta" (abre um ou outro)
            btnsConta.forEach(btn => {
                btn.addEventListener('click', (e) => {
                    e.stopPropagation();
                    // Garante que só um fica aberto
                    closeAccountUIs();
                    if (isLogged) {
                        // usuário logado → abre o menu
                        toggle(menuConta);
                    } else {
                        // não logado → abre o modal
                        show(modalLogin);
                        // 👇 FECHA o menu mobile se estiver aberto
                        closeMenuFn();
                    }
                });
            });


            // Fechar modal no X
            if (closeModalLogin) {
                closeModalLogin.addEventListener('click', () => hide(modalLogin));
            }

            // Fechar clicando fora (menu e modal)
            document.addEventListener('click', (e) => {
                const clickInsideMenu = menuConta && menuConta.contains(e.target);
                const clickInsideModal = modalLogin && modalLogin.contains(e.target);
                const clickOnAnyBtn = Array.from(btnsConta).some(btn => btn.contains(e.target));

                if (!clickOnAnyBtn && !clickInsideMenu && !clickInsideModal) {
                    closeAccountUIs();
                }

                // Caso clique no backdrop do modal (fora do conteúdo interno)
                if (modalLogin && !modalLogin.classList.contains('hidden')) {
                    // se específico no overlay (inset-0), fechar
                    if (e.target === modalLogin) hide(modalLogin);
                }
            });

            // ESC fecha tudo
            document.addEventListener('keydown', (e) => {
                if (e.key === 'Escape') {
                    closeAccountUIs();
                    closeMenuFn();
                }
            });

            // ===== Lógica do menu mobile =====
            function openMenu() {
                lastFocused = document.activeElement;
                document.body.style.overflow = 'hidden';
                mobileMenu.classList.remove('translate-x-full');
                mobileMenu.classList.add('translate-x-0');
                backdrop.classList.remove('pointer-events-none');
                requestAnimationFrame(() => {
                    backdrop.classList.add('opacity-100');
                    mobileMenu.focus();
                });
                if (menuButton) menuButton.setAttribute('aria-expanded', 'true');
            }

            function closeMenuFn() {
                document.body.style.overflow = '';
                if (mobileMenu) {
                    mobileMenu.classList.remove('translate-x-0');
                    mobileMenu.classList.add('translate-x-full');
                }
                if (backdrop) {
                    backdrop.classList.remove('opacity-100');
                    backdrop.classList.add('pointer-events-none');
                }
                if (menuButton) menuButton.setAttribute('aria-expanded', 'false');
                if (lastFocused) lastFocused.focus();
            }

            if (menuButton && mobileMenu && closeMenu && backdrop) {
                menuButton.addEventListener('click', openMenu);
                closeMenu.addEventListener('click', closeMenuFn);
                backdrop.addEventListener('click', closeMenuFn);
            }
        })();

        function Sair() {
            document.getElementById("sair").submit();
        }

        (function() {
            'use strict';
            const KEY = 'tempoCar';
            const MAX = 900; // 15 minutos em segundos
            const label = document.getElementById('tempoCarLabel');
            const pad2 = (n) => String(n).padStart(2, '0');
            const format = (s) => `${pad2(Math.floor(s/60))}:${pad2(s%60)}`;
            let rest = parseInt(sessionStorage.getItem(KEY), 10);
            // se não existe ou é inválido, reinicia
            if (!Number.isFinite(rest) || rest < 0 || rest > 86400) {
                rest = MAX;
                sessionStorage.setItem(KEY, String(rest));
            }

            function updateUI() {
                if (label) label.textContent = format(rest);
            }
            updateUI();

            setInterval(() => {
                rest = Math.max(0, rest - 1);
                sessionStorage.setItem(KEY, String(rest));
                updateUI();
                if (rest <= 0) {
                    // opcional: redirecionar ou avisar
                    // alert("Seu tempo de reserva expirou.");
                }
            }, 1000);

            // função global p/ resetar
            window.resetTempoCar = function(seconds = MAX) {
                rest = seconds;
                sessionStorage.setItem(KEY, String(rest));
                updateUI();
            };
        })();

        <?php if(empty(Auth::check())): ?>
            document.addEventListener("DOMContentLoaded", function() {
                // === LOGIN ABERTURA AUTOMÁTICA SE ERRO ===
                <?php if($errors->any()): ?>
                    const modalLogin = document.getElementById("modalLogin");
                    if (modalLogin) modalLogin.classList.remove("hidden");
                <?php endif; ?>

                // === BOTÃO LOGIN COM LOADER ===
                const form = document.querySelector("#modalLogin form");
                const btnLogin = document.getElementById("btnLogin");
                const btnText = document.getElementById("btnLoginText");
                const btnLoader = document.getElementById("btnLoginLoader");

                if (form) {
                    form.addEventListener("submit", function() {
                        btnLogin.disabled = true;
                        btnLogin.classList.remove("bg-primary-green", "hover:bg-primary-green/90");
                        btnLogin.style.background = "none";

                        btnText.classList.add("hidden");
                        btnLoader.classList.remove("hidden");
                    });
                }

                // === MODAL ESQUECEU A SENHA ===
                const modalForgot = document.getElementById("modalForgotPassword");
                const closeForgot = document.getElementById("closeForgotPassword");
                const forgotLink = document.getElementById("forgotPasswordLink");

                if (forgotLink) {
                    forgotLink.addEventListener("click", function(e) {
                        e.preventDefault();
                        modalForgot.classList.remove("hidden");
                        // Fecha login para não sobrepor
                        const modalLogin = document.getElementById("modalLogin");
                        if (modalLogin) modalLogin.classList.add("hidden");
                    });
                }

                if (closeForgot) {
                    closeForgot.addEventListener("click", function() {
                        modalForgot.classList.add("hidden");
                    });
                }

                // Fecha clicando fora
                if (modalForgot) {
                    modalForgot.addEventListener("click", function(e) {
                        if (e.target === modalForgot) {
                            modalForgot.classList.add("hidden");
                        }
                    });
                }
            });

            // === BOTÃO "ESQUECI A SENHA" COM LOADER ===
            const forgotForm = document.querySelector("#modalForgotPassword form");
            const btnForgot = document.getElementById("btnForgot");
            const btnForgotText = document.getElementById("btnForgotText");
            const btnForgotLoader = document.getElementById("btnForgotLoader");

            if (forgotForm && btnForgot) {
                forgotForm.addEventListener("submit", function() {
                    btnForgot.disabled = true;
                    // remove o fundo como no login
                    btnForgot.classList.remove("bg-primary-green", "hover:bg-primary-green/90");
                    btnForgot.style.background = "none";

                    btnForgotText.classList.add("hidden");
                    btnForgotLoader.classList.remove("hidden");
                });
            }


            document.addEventListener("DOMContentLoaded", function() {
                // ====== ERROS DE LOGIN ======
                <?php if($errors->login->any()): ?>
                    const modalLogin = document.getElementById("modalLogin");
                    if (modalLogin) modalLogin.classList.remove("hidden");
                <?php endif; ?>

                // ====== ERROS DE ESQUECEU SENHA ======
                <?php if($errors->forgot->any()): ?>
                    const modalForgot = document.getElementById("modalForgotPassword");
                    if (modalForgot) modalForgot.classList.remove("hidden");

                    Swal.fire({
                        icon: 'error',
                        title: 'Não foi possível enviar',
                        text: '<?php echo e($errors->forgot->first('email')); ?>',
                        confirmButtonText: 'Ok',
                        confirmButtonColor: '#023324'
                    });

                    const modalForgot = document.getElementById("modalForgotPassword");
                    if (modalForgot) modalForgot.classList.add("hidden");

                    Swal.fire({
                        icon: 'success',
                        title: 'Verifique seu e-mail',
                        html: ` ... `,
                        confirmButtonText: 'Ok',
                        confirmButtonColor: '#023324'
                    });
                <?php endif; ?>

                // ====== SUCESSO NO ESQUECEU SENHA ======
                <?php if(session('status')): ?>
                    const modalForgot = document.getElementById("modalForgotPassword");
                    if (modalForgot) modalForgot.classList.add("hidden");

                    Swal.fire({
                        icon: 'success',
                        title: 'Verifique seu e-mail',
                        html: `
                <div style="text-align:left">
                    <p>Enviamos um link para redefinir sua senha.</p>
                    <p>Confira sua <b>caixa de entrada</b> e também a pasta <b>Spam/Lixo Eletrônico</b>.</p>
                </div>
            `,
                        confirmButtonText: 'Ok',
                        confirmButtonColor: '#023324'
                    });
                <?php endif; ?>
            });
        <?php endif; ?>
    </script>

    <?php echo $__env->yieldContent('js'); ?>
</body>

</html>
<?php /**PATH D:\Laravel\FilhosGandhy\3.0\resources\views/site/base.blade.php ENDPATH**/ ?>