<?php $__env->startSection('content'); ?>

<main id="page_content">
    <div class="hero" style="background-image: url(<?php echo e(url('site')); ?>/images/banner/home.jpg);"></div>
    <div class="under-hero container">
        <div class="section">
            <div class="section">
                <div class="section__head">
                    <div class="flex-grow-1">
                        <h3 class="mb-0">Categorias</h3>
                    </div>
                    <a href="<?php echo e(route('site.categorias')); ?>" class="btn btn-link">Ver tudo</a>
                </div>
                <div class="swiper-carousel swiper-carousel-button">
                    <div class="swiper" data-swiper-slides="6" data-swiper-autoplay="true">
                        <div class="swiper-wrapper">
                            <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="swiper-slide">
                                    <div class="avatar avatar--xxl d-block text-center">
                                        <div class="avatar__image">
                                            <a href="<?php echo e(route('site.categoria', $categoria->url)); ?>">
                                                <img src="<?php echo e(url("storage/{$categoria->ico}")); ?>" alt="<?php echo e($categoria->titulo); ?>">
                                            </a>
                                        </div>
                                        <a href="<?php echo e(route('site.categoria', $categoria->url)); ?>" class="avatar__title mt-3"><?php echo e($categoria->titulo); ?></a>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                </div>
            </div>

            <div class="section__head">
                <div class="flex-grow-1">
                    <h3 class="mb-0">Próximos eventos</h3>
                </div>
            </div>
            <div class="row g-4">
                <?php $__currentLoopData = $eventos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $evento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-4 col-md-6">
                    <div class="cover cover--round">
                        <a  target="_blank" href="<?php echo e(route('site.evento',[$evento->url,$evento->id])); ?>" class="cover__image">
                            <img src="<?php echo e(url("storage/{$evento->banner}")); ?>" style="width: 100%; height: 200px; object-fit: cover; object-position: center;">
                        </a>
                        <div class="cover__foot mt-3 px-2">
                            <p class="cover__subtitle d-flex mb-2">
                                <i class="ri-map-pin-fill fs-6"></i>
                                <span class="ms-1 fw-semi-bold"><?php echo e($evento->local); ?> - <?php echo e($evento->cidade); ?>,<?php echo e($evento->estado); ?></small>
                            </p>
                            <p class="cover__subtitle d-flex mb-2">
                                <i class="ri-calendar-fill fs-6"></i>
                                <span class="ms-1 fw-semi-bold">
                                    <?php echo e($semana[date('w',strtotime($evento->data_inicio))]); ?>, <?php echo e(date('d',strtotime($evento->data_inicio))); ?>/<?php echo e(substr($mes[date('m', strtotime($evento->data_inicio))], 0, 3)); ?>

                                 às <?php echo e(date('H:i',strtotime($evento->data_inicio))); ?>

                                </small>
                            </p>
                            <a href="<?php echo e(route('site.evento',[$evento->url,$evento->id])); ?>" class="cover__title fs-6 mb-3">
                                <?php echo e($evento->titulo); ?>

                            </a>
                            <div class="d-flex align-items-center justify-content-between">
                                <a target="_blank" href="<?php echo e(route('site.evento',[$evento->url,$evento->id])); ?>" class="btn btn-sm btn-light-primary" style="width: 100%">Compre Aqui</a>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
    <?php echo $__env->make('site.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('site.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/musaticketcom/novo.musaticket.com.br/resources/views/site/categorias.blade.php ENDPATH**/ ?>