<?php $__env->startSection('titulo', 'Participantes ' . $Evento->titulo); ?>
<?php $__env->startSection('content'); ?>
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                <?php echo $__env->make('admin.evento.include.info', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div class="row">
                    <div class="col-sm-12">
                        <div class="box">
                            <div class="box-body">
                                <table id="tickets" class="table mt-0 table-hover no-wrap dataTable no-footer" data-page-size="10" role="grid" aria-describedby="tickets_info">
                                    <thead>
                                        <tr role="row">
                                            <th class="sorting">CheckIn</th>
                                            <th class="sorting">Participante</th>
                                            <th class="sorting">Data Check-in</th>
                                            <th class="sorting">Tipo</th>
                                            <th class="sorting">Nº Ingresso</th>
                                            <th class="sorting">Nº Pedido</th>
                                        </tr>
                                    </thead>
                                    <tbody id="result_ingressos">
                                        <?php $__currentLoopData = $Evento->Ingressos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr role="row" class="odd">
                                                <td class="center">
                                                    <?php if($item->check_in_status == '0'): ?>
                                                        <button onclick="javascript:CheckIn(<?php echo e($item->id); ?>)" type="button" class="waves-effect waves-light btn btn-secondary btn-flat mb-5 btn-sm">Fazer Check-in</button>
                                                    <?php else: ?>
                                                        <button onclick="javascript:CheckIn(<?php echo e($item->id); ?>)" type="button" class="waves-effect waves-light btn btn-success mb-5 btn-sm" style="width: 100px"><i class="glyphicon glyphicon-ok"></i></button>
                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e($item->nome_completo); ?></td>
                                                <td><?php echo e(!empty($item->check_in_data) ? date('d/m/Y H:i', strtotime($item->check_in_data)) : ''); ?></td>
                                                <td><?php echo e($item->Pacote->nome); ?></td>
                                                <td><?php echo e($item->registro); ?></td>
                                                <td><?php echo e($item->Pedido->registro); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(url('adm')); ?>/assets/vendor_components/datatable/datatables.min.js"></script>
    <script src="<?php echo e(url('adm')); ?>/assets/vendor_components/jquery.peity/jquery.peity.js"></script>
    <script src="<?php echo e(url('adm')); ?>/src/js/pages/data-table.js"></script>
    <script src="<?php echo e(url('adm')); ?>/src/js/pages/app-ticket.js"></script>
    <script>
        function CheckIn(id){
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('checkIn.store')); ?>",
                method: 'POST',
                data: {
                   id
                },
                success: function(result) {
                    $("#result_ingressos").html(result);
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.base.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\MusaTicket\resources\views/admin/evento/checkin-online.blade.php ENDPATH**/ ?>