<?php $__env->startSection('titulo', $evento->titulo); ?>
<?php $__env->startSection('url', route('site.evento', [$evento->url, $evento->id])); ?>
<?php $__env->startSection('description', lmword($evento->descricao, 180)); ?>
<?php $__env->startSection('image', $evento->banner); ?>
<?php $__env->startSection('analytics', $evento->analytics); ?>
<?php $__env->startSection('ads', $evento->ads); ?>
<?php $__env->startSection('pixel', $evento->pixel ?? env('PIXEL')); ?>

<?php $__env->startSection('content'); ?>
    <div class="relative w-full false">
        
        <div class="fixed top-0 left-0 right-0 z-30">
            <div class="w-full 4xl:mx-auto">
                <header class="h-[72px] bg-primary-green flex justify-between items-center px-4 md:px-8 z-[9999]">
                    <div class="h-[72px] 4xl:px-12 w-full 4xl:w-[70%] 4xl:mx-auto flex justify-between items-center">
                        <a href="<?php echo e(route('site.home')); ?>">
                            <img alt="Logo" loading="lazy" width="150" decoding="async" src="<?php echo e(url('site')); ?>/images/logo-branca.png" />
                        </a>
                        <div class="flex justify-end font-bold text-white" title="Tempo restante para encerrar o carrinho!">
                            <div class="border-2 border-white rounded-full flex p-2 gap-1 align-middle min-w-[94px]">
                                <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 1024 1024">
                                    <path
                                        d="M945 412H689c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h256c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zM811 548H689c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h122c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zM477.3 322.5H434c-6.2 0-11.2 5-11.2 11.2v248c0 3.6 1.7 6.9 4.6 9l148.9 108.6c5 3.6 12 2.6 15.6-2.4l25.7-35.1v-0.1c3.6-5 2.5-12-2.5-15.6l-126.7-91.6V333.7c0.1-6.2-5-11.2-11.1-11.2z">
                                    </path>
                                    <path
                                        d="M804.8 673.9H747c-5.6 0-10.9 2.9-13.9 7.7-12.7 20.1-27.5 38.7-44.5 55.7-29.3 29.3-63.4 52.3-101.3 68.3-39.3 16.6-81 25-124 25-43.1 0-84.8-8.4-124-25-37.9-16-72-39-101.3-68.3s-52.3-63.4-68.3-101.3c-16.6-39.2-25-80.9-25-124 0-43.1 8.4-84.7 25-124 16-37.9 39-72 68.3-101.3 29.3-29.3 63.4-52.3 101.3-68.3 39.2-16.6 81-25 124-25 43.1 0 84.8 8.4 124 25 37.9 16 72 39 101.3 68.3 17 17 31.8 35.6 44.5 55.7 3 4.8 8.3 7.7 13.9 7.7h57.8c6.9 0 11.3-7.2 8.2-13.3-65.2-129.7-197.4-214-345-215.7-216.1-2.7-395.6 174.2-396 390.1C71.6 727.5 246.9 903 463.2 903c149.5 0 283.9-84.6 349.8-215.8 3.1-6.1-1.4-13.3-8.2-13.3z">
                                    </path>
                                </svg>
                                <span id="tempoCarLabel" class="text-left">15:00</span>
                            </div>
                        </div>
                    </div>
                </header>
            </div>
        </div>
        <div class="pt-[64px]">
            <div class=" relative bg-primary-white px-4 md:px-12  4xl:w-[70%] 4xl:mx-auto">
                <section class="relative h-full  ">
                    <div class="flex flex-col lg:flex-row gap-y-4 lg:gap-8 justify-center items-center py-6 lg:py-12">
                        <div class="  lg:px-6 lg:py-6 mx-auto lg:bg-[#e9e9e9] rounded-xl w-full lg:w-[70%]">
                            <div class="flex flex-col lg:flex-row lg:items-center justify-between">
                                <h2 class=" font-bold text-2xl lg:text-3xl  leading-10 text-primary-green ">Pagamento</h2>
                            </div>
                            <p class="text-gray-dark  mt-1 text-base lg:text-lg ">Selecione sua forma de pagamento e finalize a compra</p>
                            <div class="bg-white rounded-2xl px-2 py-4 mt-4">
                                <div id="paymentBrick_container"></div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>


    <div id="modalPagamento" class="hidden fixed inset-0 flex items-center justify-center z-[99999] bg-black/50">
        <div class="relative w-[95%] max-h-[100%] md:w-4/6 lg:w-3/6 xl:w-[40%] 4xl:w-[25%] my-6 mx-auto bg-white rounded-2xl shadow-lg">
            <button id="closeModalPagamento" class="absolute top-2 right-6 cursor-pointer" aria-label="Fechar modal">
                <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 512 512" height="28" width="28" xmlns="http://www.w3.org/2000/svg">
                    <path d="M405 136.798L375.202 107 256 226.202 136.798 107 107 136.798 226.202 256 107 375.202 136.798 405 256 285.798 375.202 405 405 375.202 285.798 256z"></path>
                </svg>
            </button>
            <div class="p-6">
                <div id="statusScreenBrick_container"></div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script type="text/javascript">
        // CSRF em todas as requisições jQuery
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        // Variáveis globais controladas
        var mp = new MercadoPago('<?php echo e($getway['public_key']); ?>');
        var bricksBuilder = mp.bricks();
        var responseId = null;
        var pedidoId = null;
        var boletoId = null;
        var statusTimer = null;
        var isModalOpen = false;

        // Helpers
        function lower(s) {
            return (s && typeof s === 'string') ? s.toLowerCase() : '';
        }

        function isOnline() {
            return typeof navigator !== 'undefined' ? !!navigator.onLine : true;
        }

        // Render do Payment Brick (sem async/await)
        function renderPaymentBrick() {
            var settings = {
                initialization: {
                    amount: <?php echo e(moeda2($carrinho['total_final_cts'] + porcentagem(4.98, $carrinho['total_final_cts']))); ?>,
                    payer: {
                        email: "<?php echo e(Auth::check() ? Auth::user()->email : ''); ?>"
                    }
                },
                customization: {
                    paymentMethods: {
                        bankTransfer: "all",
                        <?php if(Auth::user()->negativado == '0'): ?>
                            creditCard: "all",
                        <?php endif; ?>
                        prepaidCard: "all",
                        mercadoPago: "all",
                        minInstallments: 1,
                        maxInstallments: 10
                    }
                },
                callbacks: {
                    onReady: function() {
                        /* console.log('Brick pronto'); */
                    },
                    onSubmit: function(ctx) {
                        // ctx: { selectedPaymentMethod, formData }
                        // Captura dados do formulário Laravel
                        var formPedido = $('#form_pedido').serializeArray();
                        var formObject = {};
                        for (var i = 0; i < formPedido.length; i++) {
                            formObject[formPedido[i].name] = formPedido[i].value;
                        }
                        // Campos isolados por ID (se existirem)
                        var nomeCampo = $('#id_nome_completo').val();
                        var emailCampo = $('#id_email').val();
                        var cpfCampo = $('#id_cpf_cnpj').val();
                        if (typeof nomeCampo !== 'undefined') formObject['name'] = nomeCampo;
                        if (typeof emailCampo !== 'undefined') formObject['email'] = emailCampo;
                        if (typeof cpfCampo !== 'undefined') formObject['cpf'] = cpfCampo;

                        // Junta os dados do Brick + Form
                        var finalPayload = {};
                        // Copia formData do Brick
                        if (ctx && ctx.formData) {
                            for (var k in ctx.formData) {
                                if (ctx.formData.hasOwnProperty(k)) finalPayload[k] = ctx.formData[k];
                            }
                        }
                        // Copia formObject
                        for (var k2 in formObject) {
                            if (formObject.hasOwnProperty(k2)) finalPayload[k2] = formObject[k2];
                        }

                        // Retorna uma Promise conforme contrato do Brick
                        return new Promise(function(resolve, reject) {
                            $.ajax({
                                url: "<?php echo e(route('to.pay')); ?>",
                                method: "POST",
                                contentType: "application/json; charset=UTF-8",
                                data: JSON.stringify(finalPayload),
                                dataType: "json",
                                timeout: 30000
                            }).done(function(resp) {
                                // Espera: { id, pedido_id, boleto_id, ... }
                                responseId = resp && resp.id ? resp.id : null;
                                pedidoId = resp && resp.pedido_id ? resp.pedido_id : null;
                                boletoId = resp && resp.boleto_id ? resp.boleto_id : null;

                                // Render da tela de status (compatível)
                                bricksBuilder.create('statusScreen', 'statusScreenBrick_container', {
                                    initialization: {
                                        paymentId: responseId
                                    },
                                    callbacks: {
                                        onReady: function() {},
                                        onError: function(err) {
                                            console.error(err);
                                        }
                                    }
                                }).then(function() {
                                    $("#modalPagamento").removeClass("hidden").addClass("flex");
                                    isModalOpen = true;
                                    startPolling(); // inicia o polling só depois que abriu o modal
                                    resolve();
                                })["catch"](function(err) {
                                    console.error(err);
                                    reject();
                                });
                            }).fail(function(xhr) {
                                console.error('Falha ao criar pagamento', xhr && xhr.responseText);
                                reject();
                            });
                        });
                    },
                    onError: function(error) {
                        console.error(error);
                    }
                }
            };

            bricksBuilder.create("payment", "paymentBrick_container", settings)
                .then(function() {
                    /* ok */
                })["catch"](function(err) {
                    console.error(err);
                });
        }
        renderPaymentBrick();

        // -------- Polling do status (GET em /retorno-mp/{boletoId}) ----------
        function startPolling() {
            // evita múltiplos timers
            stopPolling();

            // dispara já uma vez, depois a cada 5s
            checkStatus();
            statusTimer = setInterval(checkStatus, 5000);
        }

        function stopPolling() {
            if (statusTimer) {
                clearInterval(statusTimer);
                statusTimer = null;
            }
        }

        function checkStatus() {
            if (!responseId || !boletoId) {
                return;
            }
            if (!isOnline()) {
                return;
            } // economiza tentativas quando offline

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "/retorno-mp/" + encodeURIComponent(responseId),
                method: "GET",
                dataType: "json",
                timeout: 20000
            }).done(function(result) {
                if (!result || !result.success) {
                    return;
                }

                var status = lower(result.response);
                var isPix = (result && result.dados && result.dados.payment_method_id === 'pix');

                if (status === 'approved') {
                    stopPolling();
                    if (isModalOpen) {
                        $("#modalPagamento").addClass("hidden").removeClass("flex");
                        isModalOpen = false;
                    }
                    showSuccessAlert(result && result.redirect);
                } else if ((status === 'pending' || status === 'in_process' || status === 'authorized') && !isPix) {
                    // Cartão pendente: informa e segue para meus ingressos (como você já faz)
                    stopPolling();
                    if (isModalOpen) {
                        $("#modalPagamento").addClass("hidden").removeClass("flex");
                        isModalOpen = false;

                    }
                    showProcessAlert();
                } else {
                    // mantém polling; nada a fazer
                }
            }).fail(function() {
                // falhou: deixa o intervalo seguir, próxima tentativa em 5s
            });
        }

        // Pausa/retoma polling quando a aba/app perde foco (Android WebView compatível)
        document.addEventListener('visibilitychange', function() {
            if (document.hidden) {
                stopPolling();
            } else if (isModalOpen) {
                startPolling();
            }
        }, false);

        // Limpa ao sair
        window.addEventListener('beforeunload', function() {
            stopPolling();
        }, false);

        // ------ Alerts (sem arrow) ------
        function showSuccessAlert(redirectUrl) {
            var timerInterval;
            Swal.fire({
                title: "Pagamento Confirmado",
                html: "Você está sendo redirecionado... <b></b>",
                timer: 2000,
                timerProgressBar: true,
                didOpen: function() {
                    Swal.showLoading();
                    var b = Swal.getPopup().querySelector("b");
                    timerInterval = setInterval(function() {
                        var left = Swal.getTimerLeft ? Swal.getTimerLeft() : 0;
                        if (b) {
                            b.textContent = Math.ceil(left / 1000) + "s";
                        }
                    }, 100);
                },
                willClose: function() {
                    clearInterval(timerInterval);
                    if (redirectUrl) {
                        window.location.href = redirectUrl;
                    } else {
                        window.location.href = "<?php echo e(route('cliente.ingressos')); ?>";
                    }
                }
            });
        }

        function showProcessAlert() {
            var timerInterval;
            Swal.fire({
                title: "Pagamento em processamento...",
                html: "Você está sendo redirecionado... <b></b>",
                timer: 2000,
                timerProgressBar: true,
                didOpen: function() {
                    Swal.showLoading();
                    var b = Swal.getPopup().querySelector("b");
                    timerInterval = setInterval(function() {
                        var left = Swal.getTimerLeft ? Swal.getTimerLeft() : 0;
                        if (b) {
                            b.textContent = Math.ceil(left / 1000) + "s";
                        }
                    }, 100);
                },
                willClose: function() {
                    clearInterval(timerInterval);
                    window.location.href = "<?php echo e(route('cliente.ingressos')); ?>";
                }
            });
        }

        // --------- Listener de método selecionado (sem querySelectorAll do Brick) ----------
        // Como os elementos do Brick são dinâmicos, use um observer leve e listeners delegados
        (function() {
            var root = document.getElementById('paymentBrick_container');
            if (!root) return;

            root.addEventListener('change', function(ev) {
                var target = ev.target || ev.srcElement;
                if (!target) return;

                // classes do Brick variam por versão; checamos por input type radio
                if (target.type === 'radio') {
                    var container = target.closest ? target.closest('[class*="selector"]') : null;
                    var texto = '';
                    if (container) {
                        var p = container.getElementsByTagName('p');
                        if (p && p[0] && p[0].textContent) texto = p[0].textContent;
                    }
                    if (lower(texto).indexOf('crédito') !== -1 || lower(texto).indexOf('credito') !== -1) {
                        var parcel = document.getElementById("id_number_installments");
                        if (parcel) parcel.disabled = false;
                        var cardData = document.querySelector(".card-payment-data");
                        if (cardData) cardData.style.display = "block";
                    }
                }
            }, false);
        })();

        const closeModalPagamento = document.getElementById('closeModalPagamento');

        if (closeModalPagamento) {
            closeModalPagamento.addEventListener('click', () => {
                $("#modalPagamento").addClass("hidden").removeClass("flex");
                isModalOpen = false;
            });
        }

        // $(document).ready(function() {
        //     $("#modalPagamento").removeClass("hidden").addClass("flex");
        //     isModalOpen = true;
        // });
    </script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('site.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laravel\FilhosGandhy\3.0\resources\views/site/checkout.blade.php ENDPATH**/ ?>