<?php $__env->startSection('url', route('site.evento', [$evento->url, $evento->id])); ?>
<?php $__env->startSection('type', 'Página'); ?>
<?php $__env->startSection('titulo', $evento->titulo); ?>
<?php $__env->startSection('description', 'O ' . $evento->titulo . ' irá acontecner em ' . $evento->local); ?>
<?php $__env->startSection('image', url("storage/{$evento->banner}")); ?>
<?php $__env->startSection('content'); ?>
    <div class="room-details-area checkout-page pt-120" style="background: url(<?php echo e(url("storage/{$evento->banner}")); ?>) no-repeat center center fixed; background-size: cover !important;">
        <div class="container" style="background:#FFF;">
            <div class="row g-3">
                <div class="col-xl-6">
                    <img src="<?php echo e(url("storage/{$evento->banner}")); ?>">
                    <h4><?php echo e($evento->titulo); ?></h4>
                    <div class="location-and-review">
                        <div class="location">
                            <p>
                                <i class="bi bi-geo"></i> <?php echo e($evento->local); ?> <a href="https://maps.app.goo.gl/GopRAXPQ6tyv7TYY8" target="_blank">Como chegar?</a> <br>
                                <i class="bi bi-geo-alt"></i> <?php echo e($evento->endereco_site); ?> <br>
                                <i class="bi bi-calendar3"></i> <?php echo e(date('d/m/Y H:i', strtotime($evento->data_inicio))); ?> - <?php echo e(date('d/m/Y H:i', strtotime($evento->data_fim))); ?>

                            </p>
                        </div>
                    </div>

                    <div class="tour-location">
                        <div class="map-area mb-30">
                            <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d15575.512322118871!2d-38.391951399999996!3d-12.590285999999999!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x7166681c5811cf1%3A0xb9b99da67bb287af!2zTGFtYXLDo28gZG8gUGFzc8OpLCBTw6NvIFNlYmFzdGnDo28gZG8gUGFzc8OpIC0gQkEsIDQzODUwLTAwMA!5e0!3m2!1spt-BR!2sbr!4v1713421332940!5m2!1spt-BR!2sbr" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy"
                                referrerpolicy="no-referrer-when-downgrade"></iframe>
                        </div>
                    </div>
                </div>

                <div class="col-xl-6">
                    <div class="inquiry-form">
                        <form>
                            <div class="cart-menu">
                                <div class="cart-body">
                                    <ul>
                                        <?php $__currentLoopData = $evento->Pacotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pacote): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <input type="hidden" id="preco<?php echo e($pacote->id); ?>" value="<?php echo e($pacote->preco); ?>">
                                            <li class="single-item">
                                                <div class="item-area">
                                                    <div class="main-item">
                                                        <div class="content-and-quantity">
                                                            <div class="content">
                                                                <div class="price-and-btn d-flex align-items-center justify-content-between">
                                                                    <span><?php echo e($pacote->nome); ?></span>
                                                                    <div class="quantity-area">
                                                                        <div class="quantity">
                                                                            <a onclick="javascript:Del(<?php echo e($pacote->id); ?>)" class="quantity__minus"><span><i class="bi bi-dash"></i></span></a>
                                                                            <input id="qtd<?php echo e($pacote->id); ?>" name="quantity" type="text" class="" value="0">
                                                                            <a onclick="javascript:Add(<?php echo e($pacote->id); ?>)" class="quantity__plus"><span><i class="bi bi-plus"></i></span></a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <h6>
                                                                    R$ <?php echo e(moeda($pacote->preco)); ?>

                                                                    <span style="font-size: 10px; font-weight: 100; color:#000">(+ R$ <?php echo e(moeda(porcentagem(env('TAXA'), $pacote->preco))); ?> taxa)</span>
                                                                </h6>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                                <div class="cart-footer">
                                    <div class="pricing-area">
                                        <ul>
                                            <li><strong>Sub Total</strong> <span id="sub_total">R$ 0,00</span></li>
                                            <li><strong>Taxa de serviço</strong> <span id="total_taxa">R$ 0,00</span></li>
                                        </ul>
                                        <ul class="total">
                                            <li><strong>Total</strong> <span class="grandTotal" id="total_geral">R$ 0,00</span></li>
                                        </ul>
                                    </div>
                                    <div class="form-inner">
                                        <?php if(Auth::check()): ?>
                                            <a href="<?php echo e(route('site.checkout', $evento->id)); ?>" class="primary-btn1">Continuar</a>
                                        <?php else: ?>
                                            <a href="javascript:void(0)" class="primary-btn1" data-bs-toggle="modal" data-bs-target="#user-login">Continuar</a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        function Add(id) {
            var qtd = document.getElementById('qtd' + id);
            var valor = parseInt(qtd.value);
            var total = qtd.value = valor + 1;

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('cart.add')); ?>",
                method: 'POST',
                data: {
                    id,
                    total
                },
                success: function(result) {
                    $("#total_pacote" + id).text(result.total_pacote);

                    $.ajax({
                        url: "<?php echo e(route('cart.total')); ?>",
                        method: 'POST',
                        data: {
                            id: <?php echo e($evento->id); ?>

                        },
                        success: function(result) {
                            $("#sub_total").text(result.sub_total);
                            $("#total_taxa").text(result.total_taxa);
                            $("#total_geral").text(result.total_geral);
                        }
                    });
                }
            });
        }

        function Del(id) {
            var qtd = document.getElementById('qtd' + id);
            var valor = parseInt(qtd.value);
            if (valor > 0) {
                var total = qtd.value = valor - 1;
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: "<?php echo e(route('cart.del')); ?>",
                    method: 'POST',
                    data: {
                        id,
                        total
                    },
                    success: function(result) {
                        $("#total_pacote" + id).text(result.total_pacote);

                        $.ajax({
                            url: "<?php echo e(route('cart.total')); ?>",
                            method: 'POST',
                            data: {
                                id: <?php echo e($evento->id); ?>

                            },
                            success: function(result) {
                                $("#sub_total").text(result.sub_total);
                                $("#total_taxa").text(result.total_taxa);
                                $("#total_geral").text(result.total_geral);
                            }
                        });
                    }
                });
            } else {
                Swal.fire({
                    title: 'Atenção!',
                    text: 'A quantidade não pode ser menor que zero',
                    icon: 'error'
                });
            }
        }

        document.addEventListener('DOMContentLoaded', function() {
            // Coloque aqui o código que você quer que execute apenas uma vez ao carregar a página
            onlyOnceFunction();
        });

        function onlyOnceFunction() {
            $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: "<?php echo e(route('cart.total')); ?>",
                    method: 'POST',
                    data: {
                        id: <?php echo e($evento->id); ?>

                    },
                    success: function(result) {
                        $("#sub_total").text(result.sub_total);
                        $("#total_taxa").text(result.total_taxa);
                        $("#total_geral").text(result.total_geral);
                    }
                });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('site.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\Sollares2\resources\views/site/evento.blade.php ENDPATH**/ ?>