<?php $__env->startSection('titulo', $Evento->titulo); ?>
<?php $__env->startSection('content'); ?>
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                <?php echo $__env->make('admin.evento.include.info', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="row">
                    <div class="col-12">
                        <form action="<?php echo e(route('evento.update', $Evento)); ?>" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <h4 class="box-title text-info mb-0"><i class="glyphicon glyphicon-info-sign"></i> Informações básicas</h4>
                                        <hr class="my-15">
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <label class="form-label" for="imageInput">
                                                    <?php if(empty($Evento->banner)): ?>
                                                        <img src="<?php echo e(url('site/images/sem-foto.jpeg')); ?>" id="selectedImage" width="150" style="border-radius: 20px;">
                                                    <?php else: ?>
                                                        <img src="<?php echo e($Evento->banner); ?>" id="selectedImage" width="350" style="border-radius: 20px;">
                                                    <?php endif; ?>
                                                    <br>
                                                    Clique para anexar Foto, tamanho máximo 8Mb
                                                </label>
                                                <input name="image" type="file" class="form-control" style="display: none" id="imageInput" accept="image/*">
                                            </div>
                                            <div class="col-sm-6">
                                                <label class="form-label" for="mapaInput">
                                                    <img src="<?php echo e(url('images/sem-foto.jpeg')); ?>" id="selectedMapa" width="150" style="border-radius: 20px;">
                                                    <br>
                                                    Slide Principal
                                                </label>
                                                <input name="banner_principal" type="file" class="form-control" style="display: none" id="mapaInput" accept="image/*">
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-6">
                                                <div class="form-group">
                                                    <label class="form-label">Nome do evento</label>
                                                    <input name="titulo" value="<?php echo e($Evento->titulo); ?>" type="text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-6">
                                                <div class="form-group">
                                                    <label class="form-label">Categoria</label>
                                                    <select name="categoria_id" id="categoria_id" class="form-select" data-placeholder="Choose a Category" tabindex="1">
                                                        <option value="Selecione um estado">Selecione uma categoria</option>
                                                        <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($categoria->id); ?>" <?php echo e($categoria->id == $Evento->categoria_id ? 'selected' : ''); ?>><?php echo e($categoria->titulo); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-3">
                                                <div class="form-group">
                                                    <label class="form-label">Público Alvo</label>
                                                    <input value="<?php echo e($Evento->publico_alvo); ?>" name="publico_alvo" type="text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-3">
                                                <div class="form-group">
                                                    <label class="form-label">Gênero</label>
                                                    <input value="<?php echo e($Evento->genero); ?>" name="genero" type="text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-3">
                                                <div class="form-group">
                                                    <label class="form-label">Produtora</label>
                                                    <input value="<?php echo e($Evento->produtora); ?>" name="produtora" type="text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-3">
                                                <div class="form-group">
                                                    <label class="form-label">Tema</label>
                                                    <input value="<?php echo e($Evento->tema); ?>" name="tema" type="text" class="form-control">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <h4 class="box-title text-info mb-0"><i class="glyphicon glyphicon-font"></i> Descrição do evento</h4>
                                        <hr class="my-15">
                                        <div class="row">
                                            <textarea id="editor1" name="editor1"></textarea>
                                            <textarea name="descricao" class="textarea" style="width: 100%; height: 200px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;"><?php echo e($Evento->descricao); ?></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <h4 class="box-title text-info mb-0"><i class="glyphicon glyphicon-calendar"></i> Data e horário</h4>
                                        <hr class="my-15">
                                        <div class="row">
                                            <div class="col-lg-3 col-md-3 col-6">
                                                <div class="form-group">
                                                    <label class="form-label">Data Início</label>
                                                    <input name="data_inicio" value="<?php echo e(date('Y-m-d', strtotime($Evento->data_inicio))); ?>" type="date" class="form-control date-time">
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-6">
                                                <div class="form-group">
                                                    <label class="form-label">Hora Início</label>
                                                    <input name="hora_inicio" value="<?php echo e(date('H:i', strtotime($Evento->data_inicio))); ?>" type="time" class="form-control date-time">
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-6">
                                                <div class="form-group">
                                                    <label class="form-label">Data Final</label>
                                                    <input name="data_fim" value="<?php echo e(date('Y-m-d', strtotime($Evento->data_fim))); ?>" type="date" class="form-control date-time">
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-6">
                                                <div class="form-group">
                                                    <label class="form-label">Hora Final</label>
                                                    <input name="hora_fim" value="<?php echo e(date('H:i', strtotime($Evento->data_fim))); ?>" type="time" class="form-control date-time">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <h4 class="box-title text-info mb-0"><i class="glyphicon glyphicon-map-marker"></i> Local do evento</h4>
                                        <hr class="my-15">
                                        <div class="row">
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Latitude, Longitude</label>
                                                    <input name="latitude" value="<?php echo e($Evento->latitude); ?>,<?php echo e($Evento->longitude); ?>" type="text" class="form-control" placeholder="Latitude, Longitude">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Local</label>
                                                    <input name="local" value="<?php echo e($Evento->local); ?>" type="text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">CEP</label>
                                                    <input name="cep" id="cep" value="<?php echo e($Evento->cep); ?>" type="tel" class="form-control cep">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Endereço</label>
                                                    <input name="endereco" id="endereco" value="<?php echo e($Evento->endereco); ?>" type="text" class="form-control" placeholder="Endereço">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Endereço Completo</label>
                                                    <input name="endereco_site" id="endereco_site" value="<?php echo e($Evento->endereco_site); ?>" type="text" class="form-control" placeholder="Endereço">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Nº</label>
                                                    <input name="numero" id="numero" value="<?php echo e($Evento->numero); ?>" type="text" class="form-control" placeholder="Nº">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Complemento</label>
                                                    <input name="complemento" id="complemento" value="<?php echo e($Evento->complemento); ?>" type="text" class="form-control" placeholder="Complemento">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Bairro</label>
                                                    <input name="bairro" id="bairro" value="<?php echo e($Evento->bairro); ?>" type="text" class="form-control" placeholder="Bairro">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Cidade</label>
                                                    <input name="cidade" id="cidade" value="<?php echo e($Evento->cidade); ?>" type="text" class="form-control" placeholder="Cidade">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-3 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Estado</label>
                                                    <select name="estado" id="estado" class="form-select" data-placeholder="Choose a Category" tabindex="1">
                                                        <option value="Selecione um estado">Selecione um estado</option>
                                                        <?php $__currentLoopData = $estados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($estado->uf); ?>" <?php echo e($estado->uf == $Evento->estado ? 'selected' : ''); ?>><?php echo e($estado->uf); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-12" id="ingressos">
                                <div class="box">
                                    <div class="box-body">
                                        <h4 class="box-title text-info mb-0"><i class="glyphicon glyphicon-ticket"></i> Ingressos</h4>
                                        <hr class="my-15">
                                        <div class="row">
                                            <?php if(Auth::user()->nivel == '1'): ?>
                                            <?php endif; ?>
                                            <div class="col-md-12 text-center" style="margin: 100px 0;">
                                                <p class="text-center">Que tipo de ingresso você deseja criar?</p>
                                                <button data-bs-toggle="modal" data-bs-target=".modal_ingresso_pago" type="button" class="waves-effect waves-light btn btn-outline btn-rounded btn-info mb-5">+ Ingresso Pago</button>
                                                <button type="button" class="waves-effect waves-light btn btn-outline btn-rounded btn-info mb-5">+ Ingresso Gratuito</button>
                                            </div>
                                            <div class="table-responsive-sm">
                                                <table class="table mb-0">
                                                    <thead>
                                                        <tr>
                                                            <th scope="col">Tipo</th>
                                                            <th scope="col">Vendidos/Total</th>
                                                            <th scope="col">Valor a Receber</th>
                                                            <th scope="col">Taxa</th>
                                                            <th scope="col">Visibilidade</th>
                                                            <th scope="col"></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody id="result_pacotes">
                                                        <?php $__currentLoopData = $Evento->Pacotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pacote): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <td><?php echo e($pacote->nome); ?></td>
                                                                <td>
                                                                    <?php
                                                                        $vendidos = count($pacote->Ingressos->where('status', '1'));
                                                                        $qtd_ingressos = max($pacote->qtd_ingressos, 1);
                                                                        $qtd = max($pacote->qtd, 1);
                                                                        $valor = floor($vendidos / $qtd_ingressos); // inteiro
                                                                        $percentual = MediaVendas($valor, $qtd);
                                                                    ?>
                                                                    <div class="row">
                                                                        <div class="text-right nopadding">
                                                                            <div class="progress-container">
                                                                                <div class="progress soldticket-bar pull-left">
                                                                                    <div role="progressbar" aria-valuenow="<?php echo e($valor); ?>" aria-valuemin="0" aria-valuemax="<?php echo e($qtd); ?>" class="progress-bar"
                                                                                        style="width: <?php echo e($percentual); ?>%;">
                                                                                    </div>
                                                                                    <span class="progress-sold"><?php echo e($valor); ?></span>
                                                                                    <span class="progress-total"><?php echo e($qtd); ?></span>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                </td>
                                                                <td>R$ <?php echo e(moeda($pacote->preco)); ?></td>
                                                                <td>R$ <?php echo e(moeda(porcentagem(env('TAXA'), $pacote->preco))); ?> </td>
                                                                <td>
                                                                    <button onclick="javascript:UpdateStatus(<?php echo e($pacote->id); ?>)" type="button" class="btn btn-sm btn-toggle btn-info <?php echo e($pacote->status == 'Ativo' ? 'active' : ''); ?>"
                                                                        data-toggle="button" aria-pressed="true"><span class="handle"></span></button>
                                                                </td>
                                                                <td>
                                                                    <?php if(Auth::user()->nivel == '1'): ?>
                                                                        <a href="javascript:void(0)" onclick="javascript:EditPacote(<?php echo e($pacote->id); ?>)">
                                                                            <i class="glyphicon glyphicon-pencil"></i>
                                                                        </a>
                                                                    <?php endif; ?>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                    <tfoot>
                                                        <tr>
                                                            <td colspan="6" id="taxa_servico">
                                                                <div class="switch serviceFee animated fadeIn">
                                                                    <label class="lever-container">
                                                                        <?php if($Evento->taxa_servico == 0): ?>
                                                                        <button onclick="javascript:Desativar(<?php echo e($Evento->id); ?>)" type="button" <?php else: ?> <button onclick="javascript:AtivarTaxa(<?php echo e($Evento->id); ?>)" type="button" <?php endif; ?>
                                                                                class="btn btn-sm btn-toggle btn-<?php echo e($Evento->taxa_servico == 0 ? 'danger' : 'dark'); ?> <?php echo e($Evento->taxa_servico == 0 ? 'active' : ''); ?>"
                                                                                data-toggle="button"
                                                                                aria-pressed="true">
                                                                                <span class="handle"></span>
                                                                            </button>
                                                                    </label>
                                                                    <span class="f-12 f-w-600 switch__description">
                                                                        Absorver a taxa de serviço
                                                                        <br>
                                                                        <strong class="text-danger">Selecionar essa opção a taxa de serviço de <?php echo e(env('TAXA')); ?>% será incluído no preço final
                                                                            da venda e isso não será mostrado ao comprador.</strong>
                                                                    </span>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    </tfoot>
                                                </table>
                                            </div>


                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label class="form-label">Visibilidade do evento</label>
                                                    <div class="radio-list">
                                                        <label class="p-0 radio-inline me-10">
                                                            <div class="radio radio-info">
                                                                <input id="tipo_1" type="radio" name="tipo" value="Público" <?php echo e($Evento->tipo == 'Público' ? 'checked' : ''); ?>>
                                                                <label for="tipo_1">Público</label>
                                                            </div>
                                                        </label>
                                                        <label class="radio-inline">
                                                            <div class="radio radio-info">
                                                                <input id="tipo_2" type="radio" name="tipo" value="Privado" <?php echo e($Evento->tipo == 'Privado' ? 'checked' : ''); ?>>
                                                                <label for="tipo_2">Privado</label>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label class="form-label">Status</label>
                                                    <div class="radio-list">
                                                        <label class="p-0 radio-inline me-10">
                                                            <div class="radio radio-info">
                                                                <input id="status_1" type="radio" name="status" value="Ativo" <?php echo e($Evento->status == 'Ativo' ? 'checked' : ''); ?>>
                                                                <label for="status_1">Ativo</label>
                                                            </div>
                                                        </label>
                                                        <label class="radio-inline">
                                                            <div class="radio radio-info">
                                                                <input id="status_2" type="radio" name="status" value="Pausado" <?php echo e($Evento->status == 'Pausado' ? 'checked' : ''); ?>>
                                                                <label for="status_2">Pausado</label>
                                                            </div>
                                                        </label>
                                                        <label class="radio-inline">
                                                            <div class="radio radio-info">
                                                                <input id="status_3" type="radio" name="status" value="Encerado" <?php echo e($Evento->status == 'Encerado' ? 'checked' : ''); ?>>
                                                                <label for="status_3">Encerado</label>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <button type="submit" class="btn btn-primary btn-sm float-end"> <i class="fa fa-check"></i> Atualizar</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>
            </section>
        </div>
    </div>

    <div class="modal fade modal_ingresso_pago" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myLargeModalLabel">Criar ingresso <strong>Pago</strong></h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Título do ingresso</label>
                                    <input type="text" id="titulo_ingresso_pago" class="form-control" placeholder="Ingresso único, Meia-Entrada, VIP, etc">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Quantidade</label>
                                    <input id="qtd_ingresso_pago" type="text" class="form-control" placeholder="Ex. 100">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Valor a receber</label>
                                    <input type="text" id="valor_ingresso_pago" class="form-control preco" placeholder="R$">
                                </div>
                            </div>
                            <div class="form-group ichack-input">
                                <div class="demo-checkbox">
                                    <input type="checkbox" id="criar_meia_entrada" class="chk-col-info">
                                    <label for="criar_meia_entrada"> Criar meia-entrada para este ingresso</label>
                                </div>
                            </div>
                        </div>
                        <div class="row d-none" id="box_meia_entrada">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Título do ingresso</label>
                                    <input type="text" id="nome_meia_pago" class="form-control" placeholder="Ingresso único, Meia-Entrada, VIP, etc" readonly>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Quantidade</label>
                                    <input id="qtd_meia_pago" type="text" class="form-control" placeholder="Ex. 100">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Valor a receber</label>
                                    <input type="text" id="valor_meia_pago" class="form-control preco" placeholder="R$">
                                </div>
                            </div>
                        </div>
                        <div class="row mt-30">
                            <label class="form-label">Período das vendas deste ingresso</label>
                            <div class="row">
                                <div class="col-lg-3 col-md-3 col-6">
                                    <div class="form-group">
                                        <label class="form-label">Data Início</label>
                                        <input id="data_inicio_pago" value="<?php echo e(old('data_inicio')); ?>" type="date" class="form-control date-time">
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-6">
                                    <div class="form-group">
                                        <label class="form-label">Hora Início</label>
                                        <input id="hora_inicio_pago" value="<?php echo e(old('hora_inicio')); ?>" type="time" class="form-control date-time">
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-6">
                                    <div class="form-group">
                                        <label class="form-label">Data Final</label>
                                        <input id="data_fim_pago" value="<?php echo e(old('data_fim')); ?>" type="date" class="form-control date-time">
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-6">
                                    <div class="form-group">
                                        <label class="form-label">Hora Final</label>
                                        <input id="hora_fim_pago" value="<?php echo e(old('hora_fim')); ?>" type="time" class="form-control date-time">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-30">
                            <label class="form-label">Disponibilidade do Ingresso</label>
                            <div class="form-group">
                                <div class="radio">
                                    <input name="disponibilidade" type="radio" id="Option_1" checked="" value="Público">
                                    <label for="Option_1">Para todo o público </label>
                                </div>
                                <div class="radio">
                                    <input name="disponibilidade" type="radio" id="Option_2" value="Convidados">
                                    <label for="Option_2">Restrito a convidados</label>
                                </div>
                                <div class="radio">
                                    <input name="disponibilidade" type="radio" id="Option_3" value="Manual">
                                    <label for="Option_3">Para ser adicionado manualmente</label>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-30">
                            <label class="form-label">Quantidade permitida por compra</label>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label">Mínima</label>
                                            <input id="qtd_minima_compra" type="text" class="form-control" value="1">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label">Máxima</label>
                                            <input id="qtd_maxima_compra" type="text" class="form-control" value="5">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-30">
                            <label class="form-label">Este pacote vai gerar quantos ingressos?</label>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label">Mínima</label>
                                            <input id="qtd_ingressos" type="text" class="form-control" value="1">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger text-start btn-sm" data-bs-dismiss="modal">Cancelar</button>
                    <button onclick="javascript:IngressoStore()" type="button" class="btn btn-primary float-end btn-sm">Criar Ingresso</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>


    <div class="modal fade pacote_modal_edit" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-lg" id="result_pacote">

        </div>
    </div>


<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
    <style>
        .sweet-alert h2 {
            font-size: 20px !important;
            /* ajuste o valor conforme necessário */
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(url('assets/vendor_plugins/iCheck/icheck.min.js')); ?>"></script>
    <script src="<?php echo e(url('assets/vendor_components/formatter/formatter.js')); ?>"></script>
    <script src="<?php echo e(url('assets/vendor_components/formatter/jquery.formatter.js')); ?>"></script>
    <script src="<?php echo e(url('admin')); ?>/src/js/pages/formatter.js"></script>

    <script src="<?php echo e(url('assets/vendor_components/ckeditor/ckeditor.js')); ?>"></script>
    <script src="<?php echo e(url('assets/vendor_plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.js')); ?>"></script>
    <script src="<?php echo e(url('admin')); ?>/src/js/pages/editor.js"></script>

    <script>
        $(document).ready(function() {
            const inputsValores = document.querySelectorAll('.preco');
            inputsValores.forEach(function(inputValor) {
                inputValor.addEventListener('input', function(event) {
                    // Pega o valor do input e remove tudo que não é número
                    let valor = inputValor.value.replace(/\D/g, '');

                    // Formata o valor como dinheiro
                    if (valor) {
                        valor = (parseInt(valor) / 100).toLocaleString('pt-BR', {
                            style: 'currency',
                            currency: 'BRL'
                        });
                    } else {
                        valor = '';
                    }

                    // Atualiza o valor no input
                    inputValor.value = valor;
                });
            });

            const imageInput = document.getElementById('imageInput');
            const selectedImage = document.getElementById('selectedImage');

            imageInput.addEventListener('change', () => {
                const file = imageInput.files[0];
                const reader = new FileReader();

                reader.addEventListener('load', () => {
                    selectedImage.setAttribute('src', reader.result);
                });
                reader.readAsDataURL(file);
            });

            $("#cep").on("blur", function() {
                var numCep = $("#cep").val();
                var url = "https://viacep.com.br/ws/" + numCep.replace(/[\.-]/g, '') + "/json";
                $.ajax({
                    url: url,
                    type: "get",
                    dataType: "json",
                    success: function(dados) {
                        console.log(dados);
                        $("#cep").val(dados.cep);
                        $("#endereco").val(dados.logradouro);
                        $("#bairro").val(dados.bairro);
                        $("#cidade").val(dados.localidade);
                        $("#estado").val(dados.uf);
                    }
                });
            });
        });

        document.addEventListener('DOMContentLoaded', function() {
            const criarMeiaEntrada = document.getElementById('criar_meia_entrada');
            const boxMeiaEntrada = document.getElementById('box_meia_entrada');
            const tituloIngresso = document.getElementById('titulo_ingresso_pago');
            const valorIngresso = document.getElementById('valor_ingresso_pago');
            const tituloMeia = document.getElementById('nome_meia_pago');
            const valorMeia = document.getElementById('valor_meia_pago');

            // Mostra ou esconde a seção de meia-entrada
            criarMeiaEntrada.addEventListener('change', function() {
                if (this.checked) {
                    boxMeiaEntrada.classList.remove('d-none');
                } else {
                    boxMeiaEntrada.classList.add('d-none');
                }
            });

            // Atualiza o título da meia-entrada
            tituloIngresso.addEventListener('input', function() {
                const titulo = tituloIngresso.value;
                tituloMeia.value = `${titulo} (meia-entrada)`;
            });

            // Função para formatar valor no padrão brasileiro
            function formatarValor(valor) {
                return valor.toLocaleString('pt-BR', {
                    minimumFractionDigits: 2,
                    maximumFractionDigits: 2
                });
            }

            // Calcula e formata os valores após o input
            valorIngresso.addEventListener('keyup', function() {
                // Remove caracteres inválidos e converte para número
                let valor = parseFloat(valorIngresso.value.replace(/[^\d,]/g, '').replace(',', '.'));

                if (!isNaN(valor)) {
                    // Calcula o valor da meia-entrada
                    const meiaEntrada = valor / 2;

                    // Formata os valores
                    valorIngresso.value = `R$ ${formatarValor(valor)}`;
                    valorMeia.value = `R$ ${formatarValor(meiaEntrada)}`;
                } else {
                    // Reseta os valores caso não seja um número válido
                    valorIngresso.value = '';
                    valorMeia.value = '';
                }
            });
        });

        document.addEventListener('DOMContentLoaded', function() {
            const porDataRadio = document.getElementById('por_data');
            const porLoteRadio = document.getElementById('por_lote');

            porDataRadio.addEventListener('change', function() {
                console.log('data');
                if (this.checked) {
                    $("#box_por_data").removeClass('d-none');
                    $("#box_por_lote").addClass('d-none');
                }
            });

            porLoteRadio.addEventListener('change', function() {
                console.log('periodo');
                if (this.checked) {
                    $("#box_por_lote").removeClass('d-none');
                    $("#box_por_data").addClass('d-none');
                }
            });
        });


        function IngressoStore() {
            var disponibilidade = $("input[name='disponibilidade']:checked").val();

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "<?php echo e(route('pacote.store')); ?>",
                method: 'POST',
                data: {
                    evento_id: <?php echo e($Evento->id); ?>,
                    nome: $("#titulo_ingresso_pago").val(),
                    qtd: $("#qtd_ingresso_pago").val(),
                    preco: $("#valor_ingresso_pago").val(),
                    nome_meia_pago: $("#nome_meia_pago").val(),
                    qtd_meia_pago: $("#qtd_meia_pago").val(),
                    valor_meia_pago: $("#valor_meia_pago").val(),
                    data_inicio: $("#data_inicio_pago").val(),
                    hora_inicio: $("#hora_inicio_pago").val(),
                    data_fim: $("#data_fim_pago").val(),
                    hora_fim: $("#hora_fim_pago").val(),
                    qtd_minima_compra: $("#qtd_minima_compra").val(),
                    qtd_maxima_compra: $("#qtd_maxima_compra").val(),
                    qtd_ingressos: $("#qtd_ingressos").val(),
                    tipo: disponibilidade,
                },
                success: function(result) {
                    // Atualiza o resultado e fecha o modal
                    $("#result_pacotes").html(result);
                    $(".modal_ingresso_pago").modal('hide');

                    // Limpa os campos do formulário
                    $("#titulo_ingresso_pago").val('');
                    $("#qtd_ingresso_pago").val('');
                    $("#valor_ingresso_pago").val('');
                    $("#nome_meia_pago").val('');
                    $("#qtd_meia_pago").val('');
                    $("#valor_meia_pago").val('');
                    $("#data_inicio_pago").val('');
                    $("#hora_inicio_pago").val('');
                    $("#data_fim_pago").val('');
                    $("#hora_fim_pago").val('');
                    $("input[name='disponibilidade']").prop('checked', false); // Desmarca o checkbox
                }
            });
        }

        function IngressoUpdate(id) {
            var disponibilidade = $("input[name='disponibilidade_update']:checked").val();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "<?php echo e(route('pacote.update')); ?>",
                method: 'POST',
                data: {
                    pacote_id: id,
                    evento_id: <?php echo e($Evento->id); ?>,
                    nome: $("#titulo_ingresso_update").val(),
                    qtd: $("#qtd_ingresso_update").val(),
                    preco: $("#valor_ingresso_update").val(),
                    data_inicio: $("#data_inicio_update").val(),
                    hora_inicio: $("#hora_inicio_update").val(),
                    data_fim: $("#data_fim_update").val(),
                    hora_fim: $("#hora_fim_update").val(),
                    qtd_minima_compra: $("#qtd_minima_compra_update").val(),
                    qtd_maxima_compra: $("#qtd_maxima_compra_update").val(),
                    qtd_ingressos: $("#qtd_ingressos_update").val(),
                    tipo: disponibilidade,
                },
                success: function(result) {
                    if (result == 'error_excluir') {
                        swal("Atenção", "Já existe vendas para este ingresso, ele não pode ser removido", "error");
                    } else {
                        $("#result_pacotes").html(result);
                        $(".pacote_modal_edit").modal('hide');
                    }
                }
            });
        }

        function UpdateStatus(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "<?php echo e(route('pacote.update.status')); ?>",
                method: 'POST',
                data: {
                    id: id
                },
                success: function(result) {
                    $("#result_pacotes").html(result); // Corrigido o uso de "result"
                },
                error: function(xhr, status, error) {
                    console.error("Erro na requisição:", error);
                    alert("Não foi possível atualizar o status. Tente novamente.");
                }
            });
        }

        function EditPacote(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "<?php echo e(route('pacote.show')); ?>",
                method: 'POST',
                data: {
                    id: id
                },
                success: function(result) {
                    $("#result_pacote").html(result);
                    $(".pacote_modal_edit").modal('show');
                },
                error: function(xhr, status, error) {
                    console.error("Erro na requisição:", error);
                    alert("Não foi possível atualizar o status. Tente novamente.");
                }
            });
        }
        <?php if(session('success')): ?>
            swal(
                "Sucesso",
                "<?php echo e(session('success')); ?>",
                "success"
            );
        <?php endif; ?>

        function AtivarTaxa(id) {
            swal({
                title: "ABSORVER A TAXA DE SERVIÇO",
                text: "Alterando essa opção, a taxa de serviço será descontada do preço final da venda do ingresso e não será descontada do comprador. Tem certeza que quer continuar?",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Continuar",
                cancelButtonText: "Cancelar",
                closeOnConfirm: false,
                closeOnCancel: false
            }, function(isConfirm) {
                if (isConfirm) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });

                    $.ajax({
                        url: "<?php echo e(route('update.taxa.servico')); ?>",
                        method: 'POST',
                        data: {
                            id
                        },
                        success: function(result) {
                            $("#taxa_servico").html(result.html);
                            if (result.nova_taxa == 10) {
                                swal("Desativado", "Agora a taxa de serviço será paga pelo cliente", "success");
                            } else {
                                swal("Ativado", "Agora a taxa de serviço de <?php echo e(env('TAXA')); ?>% será descontada do preço final", "success");
                            }
                        },
                        error: function(xhr, status, error) {

                        }
                    });
                } else {
                    swal("Cancelado", "A taxa de <?php echo e(env('TAXA')); ?>% será paga pelo cliente,", "error");
                }
            });
        }

        function Desativar(id) {
            swal({
                title: "REPASSAR A TAXA DE SERVIÇO",
                text: "Desativando essa opção, a taxa de serviço será repassada ao comprador. Tem certeza que quer continuar?",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Continuar",
                cancelButtonText: "Cancelar",
                closeOnConfirm: false,
                closeOnCancel: false
            }, function(isConfirm) {
                if (isConfirm) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });

                    $.ajax({
                        url: "<?php echo e(route('update.taxa.servico')); ?>",
                        method: 'POST',
                        data: {
                            id
                        },
                        success: function(result) {
                            $("#taxa_servico").html(result.html);
                            if (result.nova_taxa == 10) {
                                swal("Desativado", "Agora a taxa de serviço será paga pelo cliente", "success");
                            } else {
                                swal("Ativado", "Agora a taxa de serviço de <?php echo e(env('TAXA')); ?>% será descontada do preço final", "success");
                            }
                        },
                        error: function(xhr, status, error) {

                        }
                    });
                } else {
                    swal("Cancelado", "A taxa de <?php echo e(env('TAXA')); ?>% será paga pelo cliente,", "error");
                }
            });
        }
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.base.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laravel\FilhosGandhy\3.0\resources\views/admin/evento/editar.blade.php ENDPATH**/ ?>