
<?php $__env->startSection('titulo', $Evento->titulo); ?>
<?php $__env->startSection('content'); ?>
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                <?php echo $__env->make('admin.evento.include.info', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="row">

                    <div class="col-12">
                        <div class="box">
                            <div class="box-header with-border">
                                <h4 class="box-title">Colaboradores convidado</h4>
                                <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target=".modal-novo-colaborador" class="btn-rounded btn btn-warning mt-10 mt-md-0 btn-sm float-end">Convidar colaborador</a>
                            </div>
                            <!-- /.box-header -->
                            <div class="box-body">
                                <div class="table-responsive-sm">
                                    <table class="table mb-0">
                                        <thead>
                                            <tr>
                                                <th scope="col">Nome</th>
                                                <th scope="col">E-mail</th>
                                                <th scope="col">Nivel</th>
                                                <th scope="col">Status do Convite</th>
                                                <th scope="col">Ações</th>
                                            </tr>
                                        </thead>
                                        <tbody id="result_colaboradores">
                                            <?php $__currentLoopData = $Evento->Colaboradores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $colaborador): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($colaborador->User->name); ?> <?php echo e($colaborador->User->sobrenome); ?></td>
                                                <td><?php echo e($colaborador->User->email); ?></td>
                                                <td><span class="badge badge-pill badge-success"><?php echo e($nivel_colaborador[$colaborador->nivel]); ?></span></td>
                                                <td><span class="badge badge-pill badge-<?php echo e($cor_status_convite[$colaborador->status]); ?>"><?php echo e($status_convite[$colaborador->status]); ?></span></td>
                                                <td>

                                                </td>
                                            </tr>  
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
    <div class="modal fade modal-novo-colaborador" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myLargeModalLabel">Níveis de acesso de colaboradores</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label">O usuário já deve possuir uma conta Musa Ticket registrada com o e-mail informado</label>
                                <input type="text" class="form-control" placeholder="E-mail" id="email">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label">Tipo de acesso:</label>
                                <select class="form-select" id="nivel">
                                    <option value="1">Gerente</option>
                                    <option value="2">Check-in</option>
                                    <option value="3">Visualização</option>
                                    <option value="4">Coordenador de Check-In</option>
                                    <option value="5">PDV (Ponto de venda)</option>
                                </select>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="modal-footer modal-footer-uniform">
                    <button type="button" class="btn btn-danger text-start btn-rounded btn-sm" data-bs-dismiss="modal">Fechar</button>
                    <button onclick="javascript:AddColaborador(<?php echo e($Evento->id); ?>)" type="button" class="btn btn-primary float-end btn-rounded btn-sm" data-bs-dismiss="modal">Adicionar</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script>
        function AddColaborador(id){
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "<?php echo e(route('colaborador.store')); ?>",
                method: 'POST',
                data: {
                    id: id,
                    nivel: $("#nivel").val(),
                    email: $("#email").val(),
                },
                success: function(result) {
                    if(result == 'error'){
                        swal("Atenção", "O email informado não foi encontrato", "error");
                    }else{
                        $("#result_colaboradores").html(result);
                        $(".modal-novo-colaborador").modal('hide');
                    }
                    
                },
                error: function(xhr, status, error) {
                   alert("Não foi possível atualizar o status. Tente novamente.");
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.base.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\MusaTicket\resources\views/admin/evento/colaboradores.blade.php ENDPATH**/ ?>