<?php $__env->startSection('titulo', $evento->titulo); ?>
<?php $__env->startSection('url', route('site.evento', [$evento->url, $evento->id])); ?>
<?php $__env->startSection('description', lmword($evento->descricao, 180)); ?>
<?php $__env->startSection('image', $evento->banner); ?>
<?php $__env->startSection('analytics', $evento->analytics); ?>
<?php $__env->startSection('ads', $evento->ads); ?>
<?php $__env->startSection('pixel', $evento->pixel ?? env('PIXEL')); ?>

<?php $__env->startSection('application_ld_json'); ?>
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Event",
  "name": "<?php echo e($evento->titulo); ?>",
  "startDate": "<?php echo e(\Carbon\Carbon::parse($evento->data_inicio)->toIso8601String()); ?>",
  "endDate": "<?php echo e(\Carbon\Carbon::parse($evento->data_fim)->toIso8601String()); ?>",
  "eventAttendanceMode": "https://schema.org/OfflineEventAttendanceMode",
  "eventStatus": "https://schema.org/EventScheduled",
  "location": {
    "@type": "Place",
    "name": "<?php echo e($evento->local); ?>",
    "address": {
      "@type": "PostalAddress",
      "streetAddress": "<?php echo e($evento->endereco_site); ?>",
      "addressLocality": "<?php echo e($evento->cidade); ?>",
      "addressRegion": "<?php echo e($evento->estado); ?>",
      "addressCountry": "BR"
    }
  },
  "organizer": {
    "@type": "Organization",
    "name": "Musa Ticket",
    "url": "https://musaticket.com.br"
  },
  "image": ["<?php echo e($evento->banner); ?>"],
  "description": <?php echo json_encode(strip_tags($evento->descricao)); ?>,
  "offers": {
    "@type": "Offer",
    "url": "<?php echo e(route('site.evento', [$evento->url, $evento->id])); ?>",
    "price": "<?php echo e(moeda2($evento->Pacotes->first()?->preco)); ?>",
    "priceCurrency": "BRL",
    "availability": "https://schema.org/InStock",
    "validFrom": "<?php echo e(\Carbon\Carbon::parse($evento->Pacotes->first()?->data_inicio ?? $evento->data_inicio)->toIso8601String()); ?>"
  },
  "performer": {
    "@type": "PerformingGroup",
    "name": "<?php echo e($evento->artistas ?? 'Atrações confirmadas'); ?>"
  }
}
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <script type='text/javascript'>
        const setores = [];
        if (!sessionStorage.getItem("tempoCar")) {
            sessionStorage.setItem("tempoCar", 900); // 15 minutos em segundos
        }
    </script>

    <?php
        // ===== Helpers de exibição =====
        $fmt = fn($cts) => 'R$ ' . number_format(((int) $cts) / 100, 2, ',', '.');

        // Garante arrays
        $ingressos = $ingressos ?? [];
        $carrinho = $carrinho ?? [];

        // Agrupa ingressos por pacote para manter a estrutura do layout (um bloco por pacote)
        $itens = collect($ingressos)
            ->groupBy('pacote_id')
            ->map(function ($g) {
                $first = $g->first();
                $qtd = $g->count();
                $preco = (int) ($first['preco'] ?? 0); // unitário sem taxa (centavos)
                $taxa = (int) ($first['taxa'] ?? 0); // taxa unitária (centavos)
                $unit = (int) ($first['valor_final'] ?? $preco + $taxa); // unitário com taxa
                return [
                    'pacote_id' => $first['pacote_id'],
                    'pacote_nome' => $first['pacote_nome'] ?? 'Ingresso',
                    'qtd' => $qtd,
                    'preco' => $preco,
                    'taxa' => $taxa,
                    'unit_total' => $unit,
                    'line_total' => $unit * $qtd,
                ];
            })
            ->values();

        // Totais vindos do carrinho (com fallback se não estiverem setados)
        $subtotalSemTaxaCts = (int) ($carrinho['subtotal_sem_taxa_cts'] ?? $itens->sum(fn($i) => $i['preco'] * $i['qtd']));
        $taxasCts = (int) ($carrinho['taxas_cts'] ?? $itens->sum(fn($i) => $i['taxa'] * $i['qtd']));
        $totalCts = (int) ($carrinho['subtotal_com_taxa_cts'] ?? $subtotalSemTaxaCts + $taxasCts);
        $qtdItens = (int) ($carrinho['qtd_itens'] ?? $itens->sum('qtd'));
    ?>

    <div class="relative w-full false">
        <div class="fixed top-0 left-0 right-0 z-30">
            <div class="w-full 4xl:mx-auto">
                <header class="h-[72px] bg-primary-green flex justify-between items-center px-4 md:px-8 z-[9999]">
                    <div class="h-[72px] 4xl:px-12 w-full 4xl:w-[70%] 4xl:mx-auto flex justify-between items-center">
                        <div class="">
                            <a href="<?php echo e(route('site.home')); ?>">
                                <div class="cursor-pointer">
                                    <img alt="Logo" loading="lazy" width="150" decoding="async" src="<?php echo e(url('site')); ?>/images/logo-branca.png" />
                                </div>
                            </a>
                        </div>
                        <div class="flex justify-end font-bold text-white" title="Tempo restante para encerrar o carrinho!">
                            <div class="border-2 border-white rounded-full flex p-2 gap-1 align-middle min-w-[94px]">
                                <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 1024 1024" class="w-6 h-6" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M945 412H689c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h256c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zM811 548H689c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h122c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zM477.3 322.5H434c-6.2 0-11.2 5-11.2 11.2v248c0 3.6 1.7 6.9 4.6 9l148.9 108.6c5 3.6 12 2.6 15.6-2.4l25.7-35.1v-0.1c3.6-5 2.5-12-2.5-15.6l-126.7-91.6V333.7c0.1-6.2-5-11.2-11.1-11.2z">
                                    </path>
                                    <path
                                        d="M804.8 673.9H747c-5.6 0-10.9 2.9-13.9 7.7-12.7 20.1-27.5 38.7-44.5 55.7-29.3 29.3-63.4 52.3-101.3 68.3-39.3 16.6-81 25-124 25-43.1 0-84.8-8.4-124-25-37.9-16-72-39-101.3-68.3s-52.3-63.4-68.3-101.3c-16.6-39.2-25-80.9-25-124 0-43.1 8.4-84.7 25-124 16-37.9 39-72 68.3-101.3 29.3-29.3 63.4-52.3 101.3-68.3 39.2-16.6 81-25 124-25 43.1 0 84.8 8.4 124 25 37.9 16 72 39 101.3 68.3 17 17 31.8 35.6 44.5 55.7 3 4.8 8.3 7.7 13.9 7.7h57.8c6.9 0 11.3-7.2 8.2-13.3-65.2-129.7-197.4-214-345-215.7-216.1-2.7-395.6 174.2-396 390.1C71.6 727.5 246.9 903 463.2 903c149.5 0 283.9-84.6 349.8-215.8 3.1-6.1-1.4-13.3-8.2-13.3z">
                                    </path>
                                </svg>
                                <span id="tempoCarLabel" class="text-left">15:00</span>
                            </div>
                        </div>
                    </div>
                </header>
            </div>
        </div>

        <div class="pt-[64px]">
            <div class=" relative bg-primary-white px-4 md:px-12  4xl:w-[70%] 4xl:mx-auto">
                <section class="relative py-6 lg:py-10 h-full  w-full">
                    <h2 class="font-bold text-2xl lg:text-3xl text-primary-green lg:mb-4">Meu Carrinho</h2>
                    <div class="flex flex-col lg:flex-row gap-y-4 lg:gap-8 w-full">
                        <div class="w-full h-fit">
                            <div class="lg:bg-[#e9e9e9] w-full h-full  lg:p-6  mx-auto  rounded-2xl ">
                                <h2 class="font-bold text-2xl lg:text-3xl text-[#2c2c2c] hidden lg:block">Itens</h2>
                                <p class="text-gray-dark mb-3 lg:mb-5 mt-1 text-base lg:text-lg">Confira abaixo os itens adicionados ao seu carrinho de compras</p>

                                <div class="hidden lg:grid grid-cols-1 lg:grid-cols-2 p-4 bg-green-button rounded-t-2xl">
                                    <div class="font-normal text-xl leading-8 text-primary-green">Itens</div>
                                    <p class="font-normal text-xl leading-8 text-gray-500 flex items-center justify-between">
                                        <span class="w-full max-w-[200px] text-center text-primary-green">Taxa</span>
                                        <span class="w-full max-w-[260px] text-center text-primary-green">Quantidade</span>
                                        <span class="w-full max-w-[200px] text-center text-primary-green">Total</span>
                                    </p>
                                </div>

                                <div class="grid grid-cols-1 lg:grid-cols-2 gap-3 lg:gap-6  py-4 lg:py-6 bg-white rounded-t-2xl rounded-b-xl lg:rounded-t-none">
                                    <?php $__empty_1 = true; $__currentLoopData = $itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        
                                        <div class="flex flex-col lg:items-center lg:flex-row gap-x-3 lg:gap-x-6 w-full max-xl:justify-center max-xl:max-w-xl max-xl:mx-auto px-4">
                                            <div class="flex flex-row items-center gap-x-3 lg:gap-x-6">
                                                <div class="flex items-center">
                                                    <img src="<?php echo e($evento->banner); ?>" alt="Imagem" style="width: 100%; height: 100px; object-fit: cover; object-position: center; border-radius: 10px;">
                                                </div>
                                                <div class="w-full max-w-sm ">
                                                    <h5 class="font-bold text-lg leading-8 text-[#2c2c2c] "><?php echo e($evento->titulo); ?></h5>
                                                    <p class="text-base lg:text-base leading-8 text-gray-dark lg:my-1"><?php echo e($i['pacote_nome']); ?></p>
                                                </div>
                                            </div>
                                            
                                            <div class="flex items-center justify-between lg:hidden">
                                                <div class="flex flex-col">
                                                    <h6 class="font-medium text-base leading-8"><?php echo e($fmt($i['preco'])); ?></h6>
                                                    <?php if($i['taxa'] > 0): ?>
                                                        <span class="text-sm text-gray-dark">(+<?php echo e($fmt($i['taxa'])); ?> taxa)</span>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="flex lg:hidden">
                                                    
                                                    <span class="text-gray-900 font-semibold text-lg placeholder:text-gray-900 text-center bg-transparent lg:w-12 px-2"><?php echo e($i['qtd']); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="flex items-center flex-col min-[550px]:flex-row w-full max-xl:max-w-xl max-xl:mx-auto gap-2">
                                            <h6 class="text-base leading-9 text-gray-dark w-full max-w-[176px] text-center hidden lg:block">
                                                <?php echo e($i['taxa'] > 0 ? $fmt($i['taxa']) : '—'); ?>

                                            </h6>
                                            <div class="w-full mx-auto justify-center hidden lg:flex items-center">
                                                <span class="font-semibold text-base px-3 text-center bg-transparent w-32 lg:w-8 text-primary-green"><?php echo e($i['qtd']); ?></span>
                                            </div>
                                            <h6 class="text-gray-dark text-base leading-9 w-full max-w-[176px] text-center mt-3 lg:mt-0 hidden lg:block">
                                                <?php echo e($fmt($i['line_total'])); ?>

                                            </h6>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <div class="col-span-2 p-6 text-center text-gray-500">Seu carrinho está vazio.</div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        
                        <div class="lg:px-6 lg:py-6 w-full lg:w-[60%] h-full  rounded-2xl bg-[#e9e9e9]">
                            <div class="hidden lg:flex items-center  gap-2">
                                <h1 class="text-3xl font-bold text-[#2c2c2c]">Informações da compra</h1>
                            </div>
                            <div class="w-full lg:mt-8 bg-white rounded-2xl py-6">
                                <div class="flex items-center justify-between w-full mb-2 lg:mb-4 px-3 lg:px-4">
                                    <p class="font-normal text-base lg:text-lg leading-8 text-gray-dark">Subtotal:</p>
                                    <h6 class="font-bold text-base lg:text-lg leading-8 text-[#2c2c2c]">
                                        <?php echo e($fmt($subtotalSemTaxaCts)); ?>

                                    </h6>
                                </div>
                                <div class="flex items-center justify-between w-full mb-4 px-3 lg:px-4">
                                    <p class="font-normal text-base lg:text-lg leading-8 text-gray-dark">Taxas Administrativa:</p>
                                    <h6 class="font-bold text-base lg:text-lg leading-8 text-[#2c2c2c]">
                                        <?php echo e($fmt($taxasCts)); ?>

                                    </h6>
                                </div>
                                <div class="flex items-center justify-between w-full mb-4 px-3 lg:px-4">
                                    <div class="w-full">
                                        <p class="font-normal text-base lg:text-lg leading-8 text-gray-dark">Cupom de Desconto</p>
                                    </div>
                                    <div>
                                        <button type="button" id="btnMostrarCupom" class="bg-green-button w-full flex hover:bg-green-button/90 rounded-full px-4 py-[0.6rem] disabled:bg-disabled disabled:cursor-not-allowed">
                                            <div class="flex items-center w-full justify-center">
                                                <span class="text-center text-primary-green">Adicionar</span>
                                            </div>
                                        </button>
                                    </div>
                                </div>

                                <!-- bloco do input escondido por padrão -->
                                <div id="blocoCupom" class="w-full flex items-center px-4 mb-4 gap-x-4 hidden">
                                    <div class="w-full">
                                        <div class="relative h-full w-auto">
                                            <input class="bg-green-light w-full md:h-10 h-11 px-4 rounded-full text-tertiary-green text-base font-normal leading-none focus:outline-none placeholder:text-tertiary-green focus:bg-green-light/60"
                                                placeholder="Insira um cupom válido" type="text" id="inputCupom">
                                        </div>
                                    </div>
                                    <div class="w-[30%]">
                                        <button type="button" id="btnAplicarCupom" class="bg-primary-green w-full flex hover:bg-primary-green/90 rounded-full px-4 py-[0.6rem] disabled:bg-disabled disabled:cursor-not-allowed">
                                            <div class="flex items-center w-full justify-center">
                                                <span class="text-center text-secondary-white">Aplicar</span>
                                            </div>
                                        </button>
                                    </div>
                                </div>

                                <div class="flex items-center justify-between w-full pt-4 border-t border-[#dedede] px-3 lg:px-4">
                                    <p class="font-bold text-lg lg:text-xl leading-9 text-[#2c2c2c] mt-2 lg:mt-3">Valor Total</p>
                                    <h6 class="font-bold text-lg lg:text-xl leading-9 text-[#2c2c2c]">
                                        <?php echo e($fmt($totalCts)); ?>

                                    </h6>
                                </div>
                            </div>
                            <div class="mt-6">
                                <div class="flex items-center flex-col sm:flex-row justify-center  w-full ">
                                    
                                    <form action="#" method="GET" class="w-full">
                                        <button id="btnContinuar" type="submit" class="bg-primary-green  w-full flex hover:bg-primary-green/90  rounded-full px-4 py-[0.6rem] disabled:bg-disabled disabled:cursor-not-allowed ">
                                            <div class="flex items-center w-full  justify-center">
                                                <div class=""><span class="text-center text-secondary-white">Continuar</span></div>
                                                <div class="absolute right-3 top-1/2 transform -translate-y-1/2"></div>
                                            </div>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>

                    </div> <!-- /flex -->
                </section>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        (function() {
            'use strict';

            const KEY = 'tempoCar';
            const MAX = 900; // 15 minutos (em segundos)

            const label = document.getElementById('tempoCarLabel');
            const btn = document.getElementById('btnContinuar');

            const pad2 = (n) => String(n).padStart(2, '0');
            const format = (s) => `${pad2(Math.floor(s/60))}:${pad2(s%60)}`;

            // recupera/normaliza tempo restante
            let rest = parseInt(sessionStorage.getItem(KEY), 10);
            if (!Number.isFinite(rest) || rest < 0 || rest > 86400) {
                rest = MAX;
                sessionStorage.setItem(KEY, String(rest));
            }

            function updateUI() {
                if (label) label.textContent = format(rest);
                if (btn) btn.disabled = rest <= 0;
            }
            updateUI();

            // decrementa a cada segundo
            let timerId = setInterval(() => {
                try {
                    rest = Math.max(0, rest - 1);
                    sessionStorage.setItem(KEY, String(rest));
                    updateUI();
                    if (rest <= 0) {
                        clearInterval(timerId);
                        // opcional: redirecionar/avisar
                        // alert('Seu tempo de reserva expirou.');
                    }
                } catch (e) {
                    clearInterval(timerId);
                }
            }, 1000);

            if (btn) {
                btn.addEventListener('click', function(e) {
                    if (rest <= 0) {
                        e.preventDefault();
                        alert('Seu tempo de reserva expirou. Inicie um novo carrinho.');
                    }
                });
            }

            // Exponha um reset global caso recrie o carrinho
            window.resetTempoCar = function(seconds = MAX) {
                rest = Number.isFinite(seconds) && seconds > 0 ? seconds : MAX;
                sessionStorage.setItem(KEY, String(rest));
                updateUI();
            };
        })();

        document.getElementById('btnMostrarCupom').addEventListener('click', function() {
            const bloco = document.getElementById('blocoCupom');
            bloco.classList.toggle('hidden');
        });

        document.getElementById('btnAplicarCupom').addEventListener('click', function() {
            const cupom = document.getElementById('inputCupom').value.trim();
            if (cupom === "") {
                alert("Digite um cupom válido.");
                return;
            }
            // Aqui você pode fazer o submit via AJAX ou redirecionar para aplicar no backend
            console.log("Cupom digitado:", cupom);
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('site.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laravel\DUNNA\Versão O Ingresso\resources\views/site/dados-ingresso.blade.php ENDPATH**/ ?>