
<?php $__env->startSection('titulo', $evento->titulo); ?>
<?php $__env->startSection('url', route('site.evento', [$evento->titulo, $evento->id])); ?>
<?php $__env->startSection('description', lmword($evento->titulo, 180)); ?>
<?php $__env->startSection('image', url("storage/{$evento->banner}")); ?>
<?php $__env->startSection('analytics', ''); ?>
<?php $__env->startSection('ads', ''); ?>
<?php $__env->startSection('pixel', ''); ?>
<?php $__env->startSection('content'); ?>
    <div id="content" class="p-0">
        <div class="event-header d-none d-lg-flex">
            <div class="event-banner-block">
                <div class="bg-section">
                    <div class="bg-wrapper">
                        <div class="img-event-blur" style="background-image: -webkit-linear-gradient(270deg,rgba(0,0,0,.2),rgba(0,0,0,.2)) , url(<?php echo e(url("storage/{$evento->banner}")); ?>);
                        background-image: linear-gradient(180deg,rgba(0,0,0,.2),rgba(0,0,0,.2)) , url(<?php echo e(url("storage/{$evento->banner}")); ?>);">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="banner-section">
            <img src="<?php echo e(url("storage/{$evento->banner}")); ?>" class="banner-img">
        </div>
        <div>
            <div class="container">
                <div class="row pt-4  pt-lg-6">
                    <div class="col-sm-12 d-block d-lg-none">
                        <h3 class="mb-3 event-title">
                            <?php echo e($evento->titulo); ?>

                        </h3>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="text-muted event-info">
                                    <p style="margin-bottom:5px">
                                        <i class="fas fa-map-marker-alt mr-1"></i> <?php echo e($evento->local); ?> - <?php echo e($evento->cidade); ?>,<?php echo e($evento->estado); ?> <br>
                                    </p>
                                    <p>
                                        <i class="far fa-calendar-alt mr-1"></i>
                                        <?php echo e($semana[date('w', strtotime($evento->data_inicio))]); ?>, <?php echo e(date('d', strtotime($evento->data_inicio))); ?>/<?php echo e($mes[date('m', strtotime($evento->data_inicio))]); ?> às <?php echo e(date('H:i', strtotime($evento->data_inicio))); ?>

                                        até
                                        <?php echo e($semana[date('w', strtotime($evento->data_fim))]); ?>, <?php echo e(date('d', strtotime($evento->data_fim))); ?>/<?php echo e($mes[date('m', strtotime($evento->data_fim))]); ?> às <?php echo e(date('H:i', strtotime($evento->data_fim))); ?>

                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Sidebar content -->
                    <div class="col-lg-4 order-lg-2 mb-4 mb-lg-0">
                        <div data-toggle="sticky" data-settings="{'parent': '#content', 'top': 10, 'breakpoint': 992}">
                            <div class="row">
                                <div class="col-md-12">
                                    <form method="POST" action="<?php echo e(route('site.checkout', [$evento->url, $evento->id])); ?>">
                                        <?php echo csrf_field(); ?>
                                        <div class="">
                                            <table class="table table-tickets scroll-sm-hidden">
                                                <thead>
                                                    <tr class="header">
                                                        <th colspan="2">
                                                            Ingressos
                                                            <div style="float: right;">
                                                                <i class="fas fa-shopping-cart"></i> <span class="cart_total">R$ 0,00</span>
                                                            </div>
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php
                                                        $hoje = now(); // Data atual
                                                    ?>
                                                    <?php $__currentLoopData = $evento->Pacotes->where('status', 'Ativo'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $pacote): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php
                                                            // Converter as datas para objetos Carbon
                                                            $dataInicio = \Carbon\Carbon::parse($pacote->data_inicio);
                                                            $dataFim = \Carbon\Carbon::parse($pacote->data_fim);
                                                
                                                            // Contar ingressos já vendidos ou registrados
                                                            $ingressosVendidos = $pacote->Ingressos->count(); 
                                                            // Calcular ingressos restantes
                                                            $ingressosRestantes = $pacote->qtd - $ingressosVendidos;
                                                        ?>
                                                
                                                        
                                                        <?php if($hoje->gte($dataInicio) && $hoje->lte($dataFim) && $ingressosVendidos < $pacote->qtd): ?>
                                                            <tr>
                                                                <td>
                                                                    <span class="ticket-type"><?php echo e($pacote->nome); ?> </span>
                                                                    <br>
                                                                    <span class="ticket-amount">
                                                                        R$ <?php echo e(moeda($pacote->preco)); ?>

                                                                        (+ R$ <?php echo e(moeda(porcentagem(10, $pacote->preco))); ?> taxa)
                                                                    </span>
                                                                    <br>
                                                                    <span class="ticket-notes">
                                                                        <?php if($ingressosRestantes <= 5): ?>
                                                                            <span style="color:red"><strong>Restam apenas <?php echo e($ingressosRestantes); ?> ingressos</strong></span>
                                                                        <?php else: ?>
                                                                            Vendas até <?php echo e($dataFim->format('d/m/Y')); ?> às <?php echo e($dataFim->format('H:i')); ?>

                                                                        <?php endif; ?>
                                                                    </span>
                                                                </td>
                                                                <td class="qtd-panel">
                                                                    <input type="hidden" name="form-<?php echo e($k); ?>-id" value="<?php echo e($pacote->id); ?>" id="id_form-<?php echo e($k); ?>-id">
                                                                    <input type="hidden" name="form-<?php echo e($k); ?>-codigo_promocional" value="" id="id_form-<?php echo e($k); ?>-codigo_promocional">
                                                                    <input type="hidden" name="form-<?php echo e($k); ?>-qtd" value="0" id="id_form-<?php echo e($k); ?>-qtd">
                                                                    <a class="btn-operator" href="javascript:;" onclick="minus('id_form-<?php echo e($k); ?>-qtd')">
                                                                        <i class="fas fa-minus-circle"></i>
                                                                    </a>
                                                                    <span id="qty_label-id_form-<?php echo e($k); ?>-qtd" class="number opt-plus" data-available="<?php echo e($ingressosRestantes <= 5 ? $ingressosRestantes : $pacote->qtd_maxima_compra); ?>" data-min-qty="1" data-total="<?php echo e(moeda($pacote->preco + porcentagem(10, $pacote->preco))); ?>">0</span>
                                                                    <a class="btn-operator" href="javascript:;" onclick="plus('id_form-<?php echo e($k); ?>-qtd')">
                                                                        <i class="fas fa-plus-circle"></i>
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                                
                                                
                                                <tfoot>
                                                    <tr>
                                                        <td colspan="2">
                                                            <p class="text-center table-cart-total" style="display: none;">
                                                                <small class="text-muted">Total:</small> <span class="cart_total cart_total_label">R$ 0,00</span>
                                                                <br>
                                                                <span class="installments-free-label" style="display: none;">em até 5x sem juros</span>
                                                            </p>
                                                            <?php if(Auth::check()): ?>
                                                                <input type="submit" name="acao" value="Comprar Ingressos" class="btn btn-lg btn-block btn-success btn-comprar">
                                                            <?php else: ?>
                                                                <input type="button" id="LoginCheckout" name="acao" value="Comprar Ingressos" class="btn btn-lg btn-block btn-success btn-comprar">
                                                            <?php endif; ?>
                                                        </td>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Main content -->
                    <div class="col-lg-8 pull-lg-3 mb-3">
                        <div class="d-none d-lg-block">
                            <h3 class="mb-3 event-title">
                                <?php echo e($evento->titulo); ?>

                            </h3>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="event-share">
                                        <span class="text-muted" style="font-size: 15px;">Compartilhe</span><br>
                                        <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(route('site.evento', [$evento->url, $evento->id])); ?>/" title="Facebook" target="_blank"><i class="fab fa-facebook"></i></a>
                                        <a href="https://x.com/share?original_referer=<?php echo e(route('site.evento', [$evento->url, $evento->id])); ?>/&amp;source=tweetbutton&amp;text=<?php echo e($evento->titulo); ?>&amp;url=<?php echo e(route('site.evento', [$evento->url, $evento->id])); ?>/" title="X" target="_blank"><i class="fab fa-x-twitter"></i></a>
                                        <a href="https://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo e(route('site.evento', [$evento->url, $evento->id])); ?>/&amp;title=<?php echo e($evento->titulo); ?>" title="Linkedin" target="_blank"><i class="fab fa-linkedin"></i></a>
                                    </div>
                                    <p class="event-info">
                                        <i class="fas fa-map-marker-alt mr-1"></i> <?php echo e($evento->local); ?> - <?php echo e($evento->cidade); ?>,<?php echo e($evento->estado); ?> <br>
                                        <i class="far fa-calendar-alt mr-1"></i>
                                        <?php echo e($semana[date('w', strtotime($evento->data_inicio))]); ?>, <?php echo e(date('d', strtotime($evento->data_inicio))); ?>/<?php echo e($mes[date('m', strtotime($evento->data_inicio))]); ?> às <?php echo e(date('H:i', strtotime($evento->data_inicio))); ?>

                                        até
                                        <?php echo e($semana[date('w', strtotime($evento->data_fim))]); ?>, <?php echo e(date('d', strtotime($evento->data_fim))); ?>/<?php echo e($mes[date('m', strtotime($evento->data_fim))]); ?> às <?php echo e(date('H:i', strtotime($evento->data_fim))); ?>

                                    </p>
                                </div>
                            </div>
                            <hr>
                        </div>

                        <div class="event-share d-block d-lg-none">
                            <span class="text-muted" style="font-size: 15px;">Compartilhe</span><br>
                            <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(route('site.evento', [$evento->url, $evento->id])); ?>/" title="Facebook" target="_blank"><i class="fab fa-facebook"></i></a>
                            <a href="https://x.com/share?original_referer=<?php echo e(route('site.evento', [$evento->url, $evento->id])); ?>/&amp;source=tweetbutton&amp;text=<?php echo e($evento->titulo); ?>&amp;url=<?php echo e(route('site.evento', [$evento->url, $evento->id])); ?>/" title="X" target="_blank"><i class="fab fa-x-twitter"></i></a>
                            <a href="https://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo e(route('site.evento', [$evento->url, $evento->id])); ?>/&amp;title=<?php echo e($evento->titulo); ?>" title="Linkedin" target="_blank"><i class="fab fa-linkedin"></i></a>
                            <a href="https://api.whatsapp.com/send?text=<?php echo e($evento->titulo); ?> <?php echo e(route('site.evento', [$evento->url, $evento->id])); ?>/" title="WhatsApp" target="_blank"><i class="fab fa-whatsapp"></i></a>
                        </div>
                        <h4 class="mt-2 text-muted"><span>Descrição do evento</span></h4>
                        <div class="text-img-fluid">
                            <?php echo $evento->descricao; ?>

                        </div>

                        <h4 class="mt-5 text-muted"><span>Política do evento</span></h4>
                        <h5>Cancelamento de pedidos pagos</h5>
                        <p>
                            Cancelamentos de pedidos serão aceitos até 7 dias após a compra, desde que a solicitação seja enviada até 48 horas antes do início do evento.
                            <br>
                            <a href="javascript:void(0)"><strong>Solicitar Cancelamento</strong></a>
                        </p>
                        <br>
                        <h5>Edição de participantes</h5>
                        <p>
                            Você poderá editar o participante de um ingresso apenas uma vez. Essa opção ficará disponível até 24 horas antes do início do evento.
                            <br>
                            <a href="<?php echo e(route('cliente.ingressos')); ?>"><strong>Editar participantes</strong></a>
                        </p>


                        <h4 class="mt-5 text-muted"><span>Local</span></h4>
                        <h5><?php echo e($evento->local); ?></h5>
                        <div class="event-address"><i class="fa fa-map-marker-alt mr-1"></i> <?php echo e($evento->endereco_site); ?></div>
                        <p>
                            <a href="https://www.google.com/maps/search/<?php echo e($evento->endereco_site); ?>" target="_blank" class="mb-1 btn btn-lg btn-outline-primary btn-rounded mt-2" role="button" aria-pressed="true">
                                Ver Mapa
                            </a>
                        </p>
                        
                    </div>
                </div>
            </div>

        </div>
    </div>
    <div class="modal fade" id="ModalLoginCheckout" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document"> <!-- Modal Grande -->
            <div class="modal-content">
                <div class="modal-body">
                    <form id="loginForm" class="form-login form-wrapper form-narrow" method="POST" action="<?php echo e(route('login')); ?>" style="background: #FFF">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="evento" value="<?php echo e(request()->url()); ?>">
                        <h3 class="title-divider"><span>Login</span></h3>
                        <p class="text-muted text-center">Informe abaixo seu e-mail e senha.</p>
                        <div class="form-group">
                            <input type="email" name="email" class="form-control email" placeholder="Email" required="required">
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <input type="password" name="password" class="form-control password" placeholder="Senha" required="required">
                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <button type="submit" id="loginBtn" class="btn btn-primary btn-lg btn-block">Login</button>
                        <p class="text-center mt-2">
                            <small><a href="javascript:;" onclick="$('#loginModal').modal('hide'); $('#recoverPasswordModal').modal('show');">Esqueceu sua senha?</a></small>
                        </p>
                        <p class="text-center">
                            Não possui uma conta? <a href="<?php echo e(route('register')); ?>">Cadastre-se!</a>
                        </p>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <style>
        #ModalLoginCheckout .modal-content {
            background: transparent;
            border: none;
            /* Remove a borda padrão */
            box-shadow: none;
            /* Remove sombras, se necessário */
        }

        #ModalLoginCheckout .modal-body {
            background: transparent;
            /* Também pode ser ajustado se houver outros elementos */
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11.6.0/dist/sweetalert2.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.6.0/dist/sweetalert2.min.js"></script>

    <script>
        $('#LoginCheckout').click(function(event) {
            event.preventDefault();
            $("#ModalLoginCheckout").modal('show');
        });

        $(document).ready(function() {
            // Verifica se há erros ao carregar a página
            <?php if($errors->has('email') || $errors->has('password')): ?>
                $("#ModalLoginCheckout").modal('show');
            <?php endif; ?>

            <?php if($errors->has('error_qtd')): ?>
                Swal.fire({
                    icon: 'error',
                    title: 'Erro!',
                    text: "<?php echo e($errors->first('error_qtd')); ?>",
                    confirmButtonText: 'OK'
                });
            <?php endif; ?>
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('site.base-pg', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\MusaTicket\resources\views/site/evento.blade.php ENDPATH**/ ?>