
<?php $__env->startSection('titulo', 'Ingressos'); ?>
<?php $__env->startSection('content'); ?>
    <div id="page-header" class="pt-8">
        <div class="container clearfix">
            <h1 class="mb-0 float-md-left page-title">
                Meus Ingressos
            </h1>
            <!-- Page header breadcrumb -->
            <nav class="breadcrumb float-md-right">
                <a class="breadcrumb-item" href="/">Home</a>
                <span class="breadcrumb-item active">Meus Ingressos</span>
            </nav>
        </div>
    </div>
    <div id="content" class="pt-4 mb-10">
        <div class="container">
            <div class="row">
                <?php $__currentLoopData = Auth::user()->Pedidos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pedido): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-4 pb-4" style="display: flex; flex-wrap: wrap;">
                        <div class="card product-card card-no-border">
                            <div class="pos-relative">
                                <a href="/festival-de-mpb-canto-da-alma__8740/" target="_blank">
                                    <img style="width: 350px; height: 183px; object-fit: cover; object-position: center;" class="card-img-top img-fluid card-img-border" src="<?php echo e(url("storage/{$pedido->Evento->banner}")); ?>" alt="<?php echo e($pedido->Evento->titulo); ?>">
                                </a>
                            </div>
                            <!-- Content -->
                            <div class="card-body card-padding">
                                <h4 class="card-title mb-1 mt-1">
                                    <a href="/festival-de-mpb-canto-da-alma__8740/" class="card-link-title" target="_blank">
                                        <?php echo e($pedido->Evento->titulo); ?>

                                    </a>
                                </h4>
                                <p class="card-text mb-2">
                                    <span class="text-primary card-event-date">
                                        <?php echo e($semana[date('w', strtotime($pedido->Evento->data_inicio))]); ?>,
                                        <?php echo e(date('d', strtotime($pedido->Evento->data_inicio))); ?>/<?php echo e(substr($mes[date('m', strtotime($pedido->Evento->data_inicio))], 0, 3)); ?>

                                        às <?php echo e(date('H:i', strtotime($pedido->Evento->data_inicio))); ?></span><br>
                                    <small></small>
                                </p>
                                <p class="card-text">
                                    <?php if($pedido->status == 'Aprovado'): ?>
                                    <a href="<?php echo e(route('print.ingressos',$pedido->registro)); ?>" target="_blank" data-print-order="NGZC364H" class="btn btn-success btn-rounded btn-block">
                                        <i class="fa-solid fa-ticket"></i> Ver Ingressos
                                    </a>
                                    <?php else: ?>
                                    <span class="badge badge-<?php echo e($status_pagamento[$pedido->status]); ?> badge-block mb-2 btn-rounded"><?php echo e($pedido->status); ?></span>
                                    <?php endif; ?>
                                    <button class="btn btn-outline-primary btn-rounded btn-block" onclick="showOrderModal(<?php echo e($pedido->id); ?>)">
                                        <i class="fa-solid fa-pen-to-square"></i> Ver Pedido
                                    </button>
                                </p>
                                <hr>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <div class="modal fade" id="orderDetailModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document"> <!-- Modal Grande -->
                        <div class="modal-content">
                            <!-- Cabeçalho do Modal -->
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Detalhes do Pedido</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <!-- Corpo do Modal -->
                            <div class="modal-body" id="data_pedido">
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script>
        function showOrderModal(id) {
            $('#loader').show();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('pedido.show')); ?>",
                method: 'POST',
                data: {
                    id
                },
                success: function(result) {
                    $('#loader').hide();
                    $("#data_pedido").html(result);
                    $("#orderDetailModal").modal('show');
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('site.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\MusaTicket\resources\views/cliente/ingressos.blade.php ENDPATH**/ ?>