<?php $__env->startSection('titulo', $Evento->titulo); ?>
<?php $__env->startSection('content'); ?>
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                <?php echo $__env->make('admin.evento.include.info', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="row">
                    <div class="col-xl-4 col-md-4 col-sm-12">
                        <div class="box box-body">
                            <div class="fs-18 flexbox align-items-center text-success">
                                <span>Ingressos Aprovados</span>
                                <i class="icon-Ticket"></i>
                            </div>
                            <div class="progress progress-xxs mt-10 mb-10">
                                <div
                                class="progress-bar bg-success"
                                role="progressbar"
                                style="width: <?php echo e(MediaVendas($Evento->Pedidos->where('status','Aprovado')->sum('qtd_pacotes'), $Evento->Pacotes->sum('qtd'))); ?>%; height: 4px;"
                                aria-valuenow="<?php echo e(MediaVendas($Evento->Pedidos->where('status','Aprovado')->sum('qtd_pacotes'), $Evento->Pacotes->sum('qtd'))); ?>"
                                aria-valuemin="0"
                                aria-valuemax="<?php echo e($Evento->Pacotes->sum('qtd')); ?>"></div>
                            </div>
                            <small class="fw-500 mb-5 text-success fs-18"><?php echo e($Evento->Pedidos->where('status','Aprovado')->sum('qtd_pacotes')); ?></small>
                        </div>
                    </div>
                    <div class="col-xl-4 col-md-4 col-sm-12">
                        <div class="box box-body">
                            <div class="fs-18 flexbox align-items-center text-warning">
                                <span>Ingressos Pendentes</span>
                                <i class="icon-Ticket"></i>
                            </div>
                            <div class="progress progress-xxs mt-10 mb-10">
                                <div
                                class="progress-bar bg-warning"
                                role="progressbar"
                                style="width: <?php echo e(MediaVendas($Evento->Pedidos->where('status','Pendente de pagamento')->sum('qtd_pacotes'), $Evento->Pacotes->sum('qtd'))); ?>%; height: 4px;"
                                aria-valuenow="<?php echo e(MediaVendas($Evento->Pedidos->where('status','Pendente de pagamento')->sum('qtd_pacotes'), $Evento->Pacotes->sum('qtd'))); ?>"
                                aria-valuemin="0"
                                aria-valuemax="<?php echo e($Evento->Pacotes->sum('qtd')); ?>"></div>
                            </div>
                            <small class="fw-500 mb-5 text-warning fs-18"><?php echo e($Evento->Pedidos->where('status','Pendente de pagamento')->sum('qtd_pacotes')); ?></small>
                        </div>
                    </div>
                    <div class="col-xl-4 col-md-4 col-sm-12">
                        <div class="box box-body">
                            <div class="fs-18 flexbox align-items-center text-dark">
                                <span>Ingressos Cancelados</span>
                                <i class="icon-Ticket"></i>
                            </div>
                            <div class="progress progress-xxs mt-10 mb-10">
                                <div
                                class="progress-bar bg-dark"
                                role="progressbar"
                                style="width: <?php echo e(MediaVendas($Evento->Pedidos->where('status','Cancelado')->sum('qtd_pacotes'), $Evento->Pacotes->sum('qtd'))); ?>%; height: 4px;"
                                aria-valuenow="<?php echo e(MediaVendas($Evento->Pedidos->where('status','Cancelado')->sum('qtd_pacotes'), $Evento->Pacotes->sum('qtd'))); ?>"
                                aria-valuemin="0"
                                aria-valuemax="<?php echo e($Evento->Pacotes->sum('qtd')); ?>"></div>
                            </div>
                            <small class="fw-500 mb-5 text-dark fs-18"><?php echo e($Evento->Pedidos->where('status','Cancelado')->sum('qtd_pacotes')); ?></small>
                        </div>
                    </div>
                </div>

                <div class="col-lg-12 col-12" id="ingressos">
                    <div class="box">
                        <div class="box-body">
                            <h4 class="box-title text-info mb-0"><i class="glyphicon glyphicon-ticket"></i> Ingressos</h4>
                            <hr class="my-15">
                            <div class="row">
                                <div class="col-md-12 text-center" style="margin: 100px 0;">
                                    <p class="text-center">Que tipo de ingresso você deseja criar?</p>
                                    <button data-bs-toggle="modal" data-bs-target=".modal_ingresso_pago" type="button" class="waves-effect waves-light btn btn-outline btn-rounded btn-info mb-5">+ Ingresso Pago</button>
                                    <button type="button" class="waves-effect waves-light btn btn-outline btn-rounded btn-info mb-5">+ Ingresso Gratuito</button>
                                </div>

                                <div class="table-responsive-sm">
                                    <table class="table mb-0">
                                        <thead>
                                            <tr>
                                                <th scope="col">Tipo</th>
                                                <th scope="col">Vendidos/Total</th>
                                                <th scope="col">Valor a Receber</th>
                                                <th scope="col">Taxa</th>
                                                <th scope="col">Visibilidade</th>
                                                <th scope="col"></th>
                                            </tr>
                                        </thead>
                                        <tbody id="result_pacotes">
                                            <?php $__currentLoopData = $Evento->Pacotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pacote): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($pacote->nome); ?></td>
                                                    <td>
                                                        <div class="row">
                                                            <div class="text-right nopadding">
                                                                <div class="progress-container">
                                                                    <div class="progress soldticket-bar pull-left">
                                                                        <div role="progressbar" aria-valuenow="<?php echo e(count($pacote->Ingressos)); ?>" aria-valuemin="0" aria-valuemax="<?php echo e($pacote->qtd); ?>" class="progress-bar" style="width: <?php echo e(MediaVendas(count($pacote->Ingressos), $pacote->qtd)); ?>%;"></div>
                                                                        <span class="progress-sold"><?php echo e(count($pacote->Ingressos)); ?></span>
                                                                        <span class="progress-total"><?php echo e($pacote->qtd); ?></span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>R$ <?php echo e(moeda($pacote->preco)); ?></td>
                                                    <td>R$ <?php echo e(moeda(porcentagem(env('TAXA'), $pacote->preco))); ?> </td>
                                                    <td>
                                                        <button onclick="javascript:UpdateStatus(<?php echo e($pacote->id); ?>)" type="button" class="btn btn-sm btn-toggle btn-info <?php echo e($pacote->status == 'Ativo' ? 'active' : ''); ?>" data-toggle="button" aria-pressed="true"><span class="handle"></span></button>
                                                    </td>
                                                    <td>
                                                        <a href="javascript:void(0)" onclick="javascript:EditPacote(<?php echo e($pacote->id); ?>)">
                                                            <i class="glyphicon glyphicon-pencil"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>


    <div class="modal fade modal_ingresso_pago" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myLargeModalLabel">Criar ingresso <strong>Pago</strong></h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Título do ingresso</label>
                                    <input type="text" id="titulo_ingresso_pago" class="form-control" placeholder="Ingresso único, Meia-Entrada, VIP, etc">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Quantidade</label>
                                    <input id="qtd_ingresso_pago" type="text" class="form-control" placeholder="Ex. 100">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Valor a receber</label>
                                    <input type="text" id="valor_ingresso_pago" class="form-control preco" placeholder="R$">
                                </div>
                            </div>
                            <div class="form-group ichack-input">
                                <div class="demo-checkbox">
                                    <input type="checkbox" id="criar_meia_entrada" class="chk-col-info">
                                    <label for="criar_meia_entrada"> Criar meia-entrada para este ingresso</label>
                                </div>
                            </div>
                        </div>
                        <div class="row d-none" id="box_meia_entrada">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Título do ingresso</label>
                                    <input type="text" id="nome_meia_pago" class="form-control" placeholder="Ingresso único, Meia-Entrada, VIP, etc" readonly>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Quantidade</label>
                                    <input id="qtd_meia_pago" type="text" class="form-control" placeholder="Ex. 100">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Valor a receber</label>
                                    <input type="text" id="valor_meia_pago" class="form-control preco" placeholder="R$">
                                </div>
                            </div>
                        </div>
                        <div class="row mt-30">
                            <label class="form-label">Período das vendas deste ingresso</label>
                            <div class="row">
                                <div class="col-lg-3 col-md-3 col-6">
                                    <div class="form-group">
                                        <label class="form-label">Data Início</label>
                                        <input id="data_inicio_pago" value="<?php echo e(old('data_inicio')); ?>" type="date" class="form-control date-time">
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-6">
                                    <div class="form-group">
                                        <label class="form-label">Hora Final</label>
                                        <input id="hora_inicio_pago" value="<?php echo e(old('hora_inicio')); ?>" type="time" class="form-control date-time">
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-6">
                                    <div class="form-group">
                                        <label class="form-label">Data Final</label>
                                        <input id="data_fim_pago" value="<?php echo e(old('data_fim')); ?>" type="date" class="form-control date-time">
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-6">
                                    <div class="form-group">
                                        <label class="form-label">Hora Final</label>
                                        <input id="hora_fim_pago" value="<?php echo e(old('hora_fim')); ?>" type="time" class="form-control date-time">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-30">
                            <label class="form-label">Disponibilidade do Ingresso</label>
                            <div class="form-group">
                                <div class="radio">
                                    <input name="disponibilidade" type="radio" id="Option_1" checked="" value="Público">
                                    <label for="Option_1">Para todo o público </label>
                                </div>
                                <div class="radio">
                                    <input name="disponibilidade" type="radio" id="Option_2" value="Convidados">
                                    <label for="Option_2">Restrito a convidados</label>
                                </div>
                                <div class="radio">
                                    <input name="disponibilidade" type="radio" id="Option_3" value="Manual">
                                    <label for="Option_3">Para ser adicionado manualmente</label>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-30">
                            <label class="form-label">Quantidade permitida por compra</label>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label">Mínima</label>
                                            <input id="qtd_minima_compra" type="text" class="form-control" value="1">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label">Máxima</label>
                                            <input id="qtd_maxima_compra" type="text" class="form-control" value="5">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger text-start btn-sm" data-bs-dismiss="modal">Cancelar</button>
                    <button onclick="javascript:IngressoStore()" type="button" class="btn btn-primary float-end btn-sm">Criar Ingresso</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>


    <div class="modal fade pacote_modal_edit" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-lg" id="result_pacote">

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script>

        function IngressoStore() {
            var disponibilidade = $("input[name='disponibilidade']:checked").val();

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "<?php echo e(route('pacote.store')); ?>",
                method: 'POST',
                data: {
                    evento_id: <?php echo e($Evento->id); ?>,
                    nome: $("#titulo_ingresso_pago").val(),
                    qtd: $("#qtd_ingresso_pago").val(),
                    preco: $("#valor_ingresso_pago").val(),
                    nome_meia_pago: $("#nome_meia_pago").val(),
                    qtd_meia_pago: $("#qtd_meia_pago").val(),
                    valor_meia_pago: $("#valor_meia_pago").val(),
                    data_inicio: $("#data_inicio_pago").val(),
                    hora_inicio: $("#hora_inicio_pago").val(),
                    data_fim: $("#data_fim_pago").val(),
                    hora_fim: $("#hora_fim_pago").val(),
                    qtd_minima_compra: $("#qtd_minima_compra").val(),
                    qtd_maxima_compra: $("#qtd_maxima_compra").val(),
                    tipo: disponibilidade,
                },
                success: function(result) {
                    // Atualiza o resultado e fecha o modal
                    $("#result_pacotes").html(result);
                    $(".modal_ingresso_pago").modal('hide');

                    // Limpa os campos do formulário
                    $("#titulo_ingresso_pago").val('');
                    $("#qtd_ingresso_pago").val('');
                    $("#valor_ingresso_pago").val('');
                    $("#nome_meia_pago").val('');
                    $("#qtd_meia_pago").val('');
                    $("#valor_meia_pago").val('');
                    $("#data_inicio_pago").val('');
                    $("#hora_inicio_pago").val('');
                    $("#data_fim_pago").val('');
                    $("#hora_fim_pago").val('');
                    $("input[name='disponibilidade']").prop('checked', false); // Desmarca o checkbox
                }
            });
        }

        function IngressoUpdate(id) {
            var disponibilidade = $("input[name='disponibilidade_update']:checked").val();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "<?php echo e(route('pacote.update')); ?>",
                method: 'POST',
                data: {
                    pacote_id: id,
                    evento_id: <?php echo e($Evento->id); ?>,
                    nome: $("#titulo_ingresso_update").val(),
                    qtd: $("#qtd_ingresso_update").val(),
                    preco: $("#valor_ingresso_update").val(),
                    data_inicio: $("#data_inicio_update").val(),
                    hora_inicio: $("#hora_inicio_update").val(),
                    data_fim: $("#data_fim_update").val(),
                    hora_fim: $("#hora_fim_update").val(),
                    qtd_minima_compra: $("#qtd_minima_compra_update").val(),
                    qtd_maxima_compra: $("#qtd_maxima_compra_update").val(),
                    tipo: disponibilidade,
                },
                success: function(result) {
                    if (result == 'error_excluir') {
                        swal("Atenção", "Já existe vendas para este ingresso, ele não pode ser removido", "error");
                    } else {
                        $("#result_pacotes").html(result);
                        $(".pacote_modal_edit").modal('hide');
                    }
                }
            });
        }

        function UpdateStatus(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "<?php echo e(route('pacote.update.status')); ?>",
                method: 'POST',
                data: {
                    id: id
                },
                success: function(result) {
                    $("#result_pacotes").html(result); // Corrigido o uso de "result"
                },
                error: function(xhr, status, error) {
                    console.error("Erro na requisição:", error);
                    alert("Não foi possível atualizar o status. Tente novamente.");
                }
            });
        }

        function EditPacote(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "<?php echo e(route('pacote.show')); ?>",
                method: 'POST',
                data: {
                    id: id
                },
                success: function(result) {
                    $("#result_pacote").html(result);
                    $(".pacote_modal_edit").modal('show');
                },
                error: function(xhr, status, error) {
                    console.error("Erro na requisição:", error);
                    alert("Não foi possível atualizar o status. Tente novamente.");
                }
            });
        }
        <?php if(session('success')): ?>
            swal(
                "Sucesso",
                "<?php echo e(session('success')); ?>",
                "success"
            );
        <?php endif; ?>
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.base.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\MusaTicket\resources\views/admin/evento/ingressos.blade.php ENDPATH**/ ?>