<?php $__env->startSection('titulo', $Evento->titulo); ?>
<?php $__env->startSection('content'); ?>
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                <?php echo $__env->make('admin.evento.include.info', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="row">
                    <!-- Bloco Detalhes do Evento (60%) -->
                    <div class="col-lg-7 col-md-7 col-sm-12">
                        <div class="box">
                            <div class="box-body">
                                <div class="d-md-flex justify-content-between align-items-center">
                                    <div>
                                        <h4 class="mb-0">Detalhes do evento</h4>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <!-- Coluna Esquerda -->
                                    <div class="col-12 col-xl-6">
                                        <div class="row">
                                            <!-- Status -->
                                            <div class="col-12">
                                                <div class="py-10">
                                                    <div class="text-fade">Status</div>
                                                    <div class="">
                                                        <span
                                                            class="badge badge-lg badge-dot badge-<?php echo e($status[$Evento->status]); ?>"></span>
                                                        <span
                                                            class="text-<?php echo e($status[$Evento->status]); ?>"><?php echo e($Evento->status); ?></span>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Visibilidade -->
                                            <div class="col-12">
                                                <div class="py-10">
                                                    <div class="text-fade">Visibilidade</div>
                                                    <div class=""><?php echo e($Evento->tipo); ?></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Coluna Direita -->
                                    <div class="col-12 col-xl-6">
                                        <div class="row">
                                            <!-- Visualizações da página de vendas -->
                                            <div class="col-12">
                                                <div class="py-10">
                                                    <div class="text-fade">Visualizações da página de vendas
                                                    </div>
                                                    <div class=""><?php echo e($Evento->views); ?></div>
                                                </div>
                                            </div>
                                            <!-- Compartilhar -->
                                            <div class="col-12">
                                                <div class="py-10">
                                                    <div class="text-fade">Compartilhar:
                                                        <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(route('site.evento', [$Evento->url, $Evento->id])); ?>"
                                                            target="_blank">
                                                            <img src="http://d1gkntzr8mxq7s.cloudfront.net/6661d0092d036.svg"
                                                                width="20">
                                                        </a>
                                                        <a href="https://twitter.com/intent/tweet?url=<?php echo e(route('site.evento', [$Evento->url, $Evento->id])); ?>"
                                                            target="_blank">
                                                            <img src="http://d1gkntzr8mxq7s.cloudfront.net/6661ce3f75d4e.svg"
                                                                width="20">
                                                        </a>
                                                        <a href="https://web.whatsapp.com/send?text=<?php echo e(route('site.evento', [$Evento->url, $Evento->id])); ?>"
                                                            target="_blank">
                                                            <img src="http://d1gkntzr8mxq7s.cloudfront.net/6661ccf8020f1.svg"
                                                                width="20">
                                                        </a>
                                                        <a href="https://www.tiktok.com/share/item?url=<?php echo e(route('site.evento', [$Evento->url, $Evento->id])); ?>"
                                                            target="_blank">
                                                            <img src="http://d1gkntzr8mxq7s.cloudfront.net/6679e9aab3b87.svg"
                                                                width="20">
                                                        </a>
                                                        <a href="https://www.instagram.com/?url=<?php echo e(route('site.evento', [$Evento->url, $Evento->id])); ?>"
                                                            target="_blank">
                                                            <img src="http://d1gkntzr8mxq7s.cloudfront.net/667b258544738.svg"
                                                                width="20">
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Link Sympla -->
                                            <div class="col-12">
                                                <div class="py-10">
                                                    <a href="<?php echo e(route('site.evento', [$Evento->url, $Evento->id])); ?>"
                                                        class="text-primary" target="_blank">
                                                        <?php echo e(route('site.evento', [$Evento->url, $Evento->id])); ?>

                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Conteúdo do Detalhes do Evento aqui -->
                            </div>
                        </div>
                    </div>

                    <!-- Bloco Financeiro (40%) -->
                    <div class="col-lg-5 col-md-5 col-sm-12">
                        <div class="box">
                            <div class="box-body">
                                <div class="d-md-flex justify-content-between align-items-center">
                                    <div>
                                        <h4 class="mb-0">Financeiro</h4>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <!-- Coluna Esquerda -->
                                    <div class="col-12 col-xl-6">
                                        <div class="row">
                                            <!-- Vendas Totais -->
                                            <div class="col-12">
                                                <div class="py-10">
                                                    <div class="text-fade">Vendas Totais</div>
                                                    <div class="fs-18 text-success">R$
                                                        <?php echo e(moeda($Evento->Pedidos->sum('total') + $Evento->Pedidos->sum('taxa'))); ?>

                                                    </div>
                                                    <!-- Verde para Vendas Totais -->
                                                </div>
                                            </div>
                                            <!-- Total a Receber -->
                                            <div class="col-12">
                                                <div class="py-10">
                                                    <div class="text-fade">Total sem taxa</div>
                                                    <div class="fs-18">R$ <?php echo e(moeda($Evento->Pedidos->sum('total'))); ?>

                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Ticket Médio Bruto -->
                                            <div class="col-12">
                                                <div class="py-10">
                                                    <div class="text-fade">Ticket médio (bruto)</div>
                                                    <div class="fs-18">R$ 0,00</div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Coluna Direita -->
                                    <div class="col-12 col-xl-6">
                                        <div class="row">
                                            <!-- Em Processamento -->
                                            <div class="col-12">
                                                <div class="py-10">
                                                    <div class="text-fade">Em Processamento (Pendentes)
                                                    </div>
                                                    <div class="fs-18 text-warning">R$ 0,00</div>
                                                    <!-- Amarelo para Em Processamento -->
                                                </div>
                                            </div>
                                            <!-- Total Recebido -->
                                            <div class="col-12">
                                                <div class="py-10">
                                                    <div class="text-fade">Taxas</div>
                                                    <div class="fs-18">R$ <?php echo e(moeda($Evento->Pedidos->sum('taxa'))); ?></div>
                                                </div>
                                            </div>
                                            <!-- Ticket Médio Líquido -->
                                            <div class="col-12">
                                                <div class="py-10">
                                                    <div class="text-fade">Ticket Médio (Líquido)</div>
                                                    <div class="fs-18">R$ 0,00</div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Conteúdo do Financeiro aqui -->
                            </div>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-lg-12 col-12">
                            <div class="box">
                                <div class="box-body">
                                    <div class="d-md-flex justify-content-between align-items-center">
                                        <div>
                                            <h4 class="mb-0">Ingressos</h4>
                                        </div>
                                        

                                    </div>
                                    <br>
                                    <!-- Filtros Dropdown -->
                                    <div class="col-12">
                                        <div class="row">
                                            <!-- Filtrar por Canal de Venda -->
                                            <div class="col-md-4">
                                                <div class="py-10">
                                                    <label for="filter-canal" class="text-fade fw-600">Filtrar por canal
                                                        de
                                                        venda:</label>
                                                    <select id="filter-canal" class="form-control">
                                                        <option value="">Selecione um canal</option>
                                                        <option value="online">Online</option>
                                                        <option value="presencial">Presencial</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <!-- Filtrar por Valor do Ingresso -->
                                            <div class="col-md-4">
                                                <div class="py-10">
                                                    <label for="filter-valor" class="text-fade fw-600">Filtrar por valor
                                                        do
                                                        ingresso:</label>
                                                    <select id="filter-valor" class="form-control">
                                                        <option value="">Selecione um valor</option>
                                                        <option value="0-50">R$ 0,00 - R$ 50,00</option>
                                                        <option value="50-100">R$ 50,00 - R$ 100,00</option>
                                                        <option value="100-200">R$ 100,00 - R$ 200,00</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <!-- Filtrar por Tipo de Ingresso -->
                                            <div class="col-md-4">
                                                <div class="py-10">
                                                    <label for="filter-tipo" class="text-fade fw-600">Filtrar por tipo de
                                                        ingresso:</label>
                                                    <select id="filter-tipo" class="form-control">
                                                        <option value="">Selecione um tipo</option>
                                                        <option value="vip">VIP</option>
                                                        <option value="geral">Geral</option>
                                                        <option value="meia">Meia Entrada</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <br><br>
                                        <div class="col-xl-12 col-12">
                                            <div class="box">
                                                
                                                <div class="box-body" style="position: relative;">
                                                    <div id="vendas_meses" style="min-height: 243px;"></div>
                                                    <div class="resize-triggers">
                                                        <div class="expand-trigger">
                                                            <div style="width: 892px; height: 286px;"></div>
                                                        </div>
                                                        <div class="contract-trigger"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <br><br>
                                        <div class="row">
                                            <div class="col-xl-4 col-md-4 col-sm-12">
                                                <div class="box box-body">
                                                    <div class="fs-18 flexbox align-items-center text-success">
                                                        <span>Ingressos Aprovados</span>
                                                        <i class="icon-Ticket"></i>
                                                    </div>
                                                    <div class="progress progress-xxs mt-10 mb-10">
                                                        <div
                                                        class="progress-bar bg-success"
                                                        role="progressbar"
                                                        style="width: <?php echo e(MediaVendas($Evento->Pedidos->where('status','Aprovado')->sum('qtd_pacotes'), $Evento->Pacotes->sum('qtd'))); ?>%; height: 4px;"
                                                        aria-valuenow="<?php echo e(MediaVendas($Evento->Pedidos->where('status','Aprovado')->sum('qtd_pacotes'), $Evento->Pacotes->sum('qtd'))); ?>"
                                                        aria-valuemin="0"
                                                        aria-valuemax="<?php echo e($Evento->Pacotes->sum('qtd')); ?>"></div>
                                                    </div>
                                                    <small class="fw-500 mb-5 text-success fs-18"><?php echo e($Evento->Pedidos->where('status','Aprovado')->sum('qtd_pacotes')); ?></small>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-md-4 col-sm-12">
                                                <div class="box box-body">
                                                    <div class="fs-18 flexbox align-items-center text-warning">
                                                        <span>Ingressos Pendentes</span>
                                                        <i class="icon-Ticket"></i>
                                                    </div>
                                                    <div class="progress progress-xxs mt-10 mb-10">
                                                        <div
                                                        class="progress-bar bg-warning"
                                                        role="progressbar"
                                                        style="width: <?php echo e(MediaVendas($Evento->Pedidos->where('status','Pendente de pagamento')->sum('qtd_pacotes'), $Evento->Pacotes->sum('qtd'))); ?>%; height: 4px;"
                                                        aria-valuenow="<?php echo e(MediaVendas($Evento->Pedidos->where('status','Pendente de pagamento')->sum('qtd_pacotes'), $Evento->Pacotes->sum('qtd'))); ?>"
                                                        aria-valuemin="0"
                                                        aria-valuemax="<?php echo e($Evento->Pacotes->sum('qtd')); ?>"></div>
                                                    </div>
                                                    <small class="fw-500 mb-5 text-warning fs-18"><?php echo e($Evento->Pedidos->where('status','Pendente de pagamento')->sum('qtd_pacotes')); ?></small>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-md-4 col-sm-12">
                                                <div class="box box-body">
                                                    <div class="fs-18 flexbox align-items-center text-dark">
                                                        <span>Ingressos Cancelados</span>
                                                        <i class="icon-Ticket"></i>
                                                    </div>
                                                    <div class="progress progress-xxs mt-10 mb-10">
                                                        <div
                                                        class="progress-bar bg-dark"
                                                        role="progressbar"
                                                        style="width: <?php echo e(MediaVendas($Evento->Pedidos->where('status','Cancelado')->sum('qtd_pacotes'), $Evento->Pacotes->sum('qtd'))); ?>%; height: 4px;"
                                                        aria-valuenow="<?php echo e(MediaVendas($Evento->Pedidos->where('status','Cancelado')->sum('qtd_pacotes'), $Evento->Pacotes->sum('qtd'))); ?>"
                                                        aria-valuemin="0"
                                                        aria-valuemax="<?php echo e($Evento->Pacotes->sum('qtd')); ?>"></div>
                                                    </div>
                                                    <small class="fw-500 mb-5 text-dark fs-18"><?php echo e($Evento->Pedidos->where('status','Cancelado')->sum('qtd_pacotes')); ?></small>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
            </section>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script>
        var options = {
            series: [8, 2],
            chart: {
                type: 'donut',
                height: 240,
                width: 240,
            },
            legend: {
                show: false,
            },
            dataLabels: {
                enabled: false,
            },
            plotOptions: {
                pie: {
                    customScale: 0.90,
                    donut: {
                        size: '80%',
                        labels: {
                            show: true,
                            total: {
                                showAlways: true,
                                show: true,
                            }
                        }
                    },
                    offsetY: 0,
                },
                stroke: {
                    colors: undefined
                }
            },
            colors: ['#7047EE', '#e8e1ff'],
        };

        var chart = new ApexCharts(document.querySelector("#acesso_evento"), options);
        chart.render();



        var analyticsBarChartOptions = {
            chart: {
                height: 194,
                type: 'bar',
                toolbar: {
                    show: false
                }
            },
            plotOptions: {
                bar: {
                    horizontal: false,
                    columnWidth: '40%',
                    borderRadius: 3
                },
            },
            dataLabels: {
                enabled: false
            },
            colors: ['#3596f7', '#cce5ff'],
            series: [{
                name: 'Vendidos',
                data: [
                    <?php for($i = 0; $i < count($Evento->Pacotes); $i++): ?>
                        '<?php echo e($i + 750); ?>',
                    <?php endfor; ?>
                ]
            }, {
                name: 'Validados',
                data: [
                    <?php for($i = 0; $i < count($Evento->Pacotes); $i++): ?>
                        '<?php echo e($i + 500); ?>',
                    <?php endfor; ?>
                ]
            }],
            xaxis: {
                categories: [
                    <?php $__currentLoopData = $Evento->Pacotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pacote): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        '<?php echo e($pacote->sigla); ?>',
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ],
                axisBorder: {
                    show: false
                },
                axisTicks: {
                    show: false
                },
                labels: {
                    style: {
                        colors: '#333333'
                    }
                }
            },
            yaxis: {
                min: 0,
                max: 1000,
                tickAmount: 3,
                labels: {
                    style: {
                        color: '#333333'
                    }
                }
            },
            legend: {
                show: false,
            },
        }

        var analyticsBarChart = new ApexCharts(
            document.querySelector("#vendas_por_area"),
            analyticsBarChartOptions
        );

        analyticsBarChart.render();


        var analyticsBarChartOptions = {
            chart: {
                height: 228,
                type: 'bar',
                toolbar: {
                    show: true
                }
            },
            plotOptions: {
                bar: {
                    horizontal: false,
                    columnWidth: '45%',
                    borderRadius: 3
                },
            },
            dataLabels: {
                enabled: false
            },
            colors: ['#7047ee'],
            series: [{
                name: 'Total de Vendas',
                data: [1265899, 1059987, 2566699, 3588899, 4999988, 10156488, 3254888, 7584599, 4256699]
            }],
            xaxis: {
                categories: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set'],
                axisBorder: {
                    show: false
                },
                axisTicks: {
                    show: false
                },
                labels: {
                    style: {
                        colors: '#333333'
                    }
                }
            },
            yaxis: {
                min: 0,
                max: 11000000,
                tickAmount: 3,
                labels: {
                    style: {
                        color: '#333333'
                    }
                }
            },
            legend: {
                show: false,
            },
            tooltip: {
                y: {
                    formatter: function(val) {
                        let valorReal; // Declaração da variável fora do bloco if-else

                        // Verificar o valor para aplicar a conversão correta
                        if (val < 1000) {
                            valorReal = val; // Assume que o valor já está correto em reais
                        } else {
                            valorReal = val / 100; // Converte de centavos para reais
                        }

                        // Formatar o valor como moeda
                        return valorReal.toLocaleString('pt-BR', {
                            style: 'currency',
                            currency: 'BRL'
                        });
                    }
                }
            }
        }

        var analyticsBarChart = new ApexCharts(
            document.querySelector("#vendas_meses"),
            analyticsBarChartOptions
        );

        analyticsBarChart.render();


        function Remover(id) {
            swal({
                title: "Atenção",
                text: "Você deseja remover este evento?",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Sim",
                cancelButtonText: "Não",
                closeOnConfirm: false,
                closeOnCancel: false
            }, function(isConfirm) {
                if (isConfirm) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });

                    $.ajax({
                        url: "<?php echo e(route('evento.destroy')); ?>",
                        method: 'POST',
                        data: {
                            id
                        },
                        success: function(result) {
                            if (result == 1) {
                                swal("Erro", "O pacote não pode ser removido", "error");
                            } else {
                                $("#pacote" + id).hide();
                                swal("Removido", "Pacote removido com sucesso", "success");
                                window.location.href = '<?php echo e(route('eventos.index')); ?>';
                            }
                        }
                    });
                } else {
                    swal("Cancelado", "Nenhum pacote foi removido", "error");
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.base.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\MusaTicket\resources\views/admin/evento/index.blade.php ENDPATH**/ ?>