<?php $__env->startSection('titulo', 'Cadastro de Evento'); ?>
<?php $__env->startSection('content'); ?>
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                
                <div class="row">
                    <div class="col-12">
                        <form action="<?php echo e(route('evento.store')); ?>" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <h4 class="box-title text-info mb-0"><i class="glyphicon glyphicon-info-sign"></i> Informações básicas</h4>
                                        <hr class="my-15">
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <label class="form-label" for="imageInput">
                                                    <img src="<?php echo e(url('images/sem-foto.jpeg')); ?>" id="selectedImage" width="150" style="border-radius: 20px;">
                                                    <br>
                                                    Capa do Evento (Formato WhidScreem)
                                                </label>
                                                <input name="image" type="file" class="form-control" style="display: none" id="imageInput" accept="image/*">
                                            </div>
                                            <div class="col-sm-6">
                                                <label class="form-label" for="mapaInput">
                                                    <img src="<?php echo e(url('images/sem-foto.jpeg')); ?>" id="selectedMapa" width="150" style="border-radius: 20px;">
                                                    <br>
                                                    Mapa do Evento
                                                </label>
                                                <input name="mapa" type="file" class="form-control" style="display: none" id="mapaInput" accept="image/*">
                                            </div>

                                            <div class="col-lg-6 col-md-6 col-6">
                                                <div class="form-group">
                                                    <label class="form-label">Nome do evento</label>
                                                    <input name="titulo" type="text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-6">
                                                <div class="form-group">
                                                    <label class="form-label">Categoria</label>
                                                    <select name="categoria_id" id="categoria_id" class="form-select" data-placeholder="Choose a Category" tabindex="1">
                                                        <option value="Selecione um estado">Selecione uma categoria</option>
                                                        <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($categoria->id); ?>"><?php echo e($categoria->titulo); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-3">
                                                <div class="form-group">
                                                    <label class="form-label">Público Alvo</label>
                                                    <input name="publico_alvo" type="text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-3">
                                                <div class="form-group">
                                                    <label class="form-label">Gênero</label>
                                                    <input name="genero" type="text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-3">
                                                <div class="form-group">
                                                    <label class="form-label">Produtora</label>
                                                    <input name="produtora" type="text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-3">
                                                <div class="form-group">
                                                    <label class="form-label">Tema</label>
                                                    <input name="tema" type="text" class="form-control">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <h4 class="box-title text-info mb-0"><i class="glyphicon glyphicon-font"></i> Descrição do evento</h4>
                                        <hr class="my-15">
                                        <div class="row">
                                            <textarea id="editor1" name="editor1"></textarea>
                                            <textarea name="descricao" class="textarea" placeholder="Conte todos os detalhes do seu evento, como a programação e os diferenciais da sua produção!"
                                                style="width: 100%; height: 200px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;"></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <h4 class="box-title text-info mb-0"><i class="glyphicon glyphicon-calendar"></i> Data e horário</h4>
                                        <hr class="my-15">
                                        <div class="row">
                                            <div class="col-lg-3 col-md-3 col-6">
                                                <div class="form-group">
                                                    <label class="form-label">Data Início</label>
                                                    <input name="data_inicio" value="<?php echo e(old('data_inicio')); ?>" type="date" class="form-control date-time">
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-6">
                                                <div class="form-group">
                                                    <label class="form-label">Hora Início</label>
                                                    <input name="hora_inicio" value="<?php echo e(old('hora_inicio')); ?>" type="time" class="form-control date-time">
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-6">
                                                <div class="form-group">
                                                    <label class="form-label">Data Final</label>
                                                    <input name="data_fim" value="<?php echo e(old('data_fim')); ?>" type="date" class="form-control date-time">
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-6">
                                                <div class="form-group">
                                                    <label class="form-label">Hora Final</label>
                                                    <input name="hora_fim" value="<?php echo e(old('hora_fim')); ?>" type="time" class="form-control date-time">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <h4 class="box-title text-info mb-0"><i class="glyphicon glyphicon-map-marker"></i> Local do evento</h4>
                                        <hr class="my-15">
                                        <div class="row">
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Local</label>
                                                    <select name="local_id" class="form-select" id="localSelect">
                                                        <option value="">Selecionar</option>
                                                        <option value="novo">Cadastrar Novo</option>
                                                        <?php $__currentLoopData = $locais; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $local): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($local->id); ?>"><?php echo e($local->local); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <input name="local" id="inputNovoLocal" value="<?php echo e(old('local')); ?>" type="text" class="form-control mt-2" placeholder="Digite o novo local" style="display: none;">
                                                </div>

                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Latitude, Longitude</label>
                                                    <input name="latitude" value="<?php echo e(old('latitude')); ?>" type="text" class="form-control" placeholder="Latitude, Longitude">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">CEP</label>
                                                    <input name="cep" id="cep" value="<?php echo e(old('cep')); ?>" type="tel" class="form-control cep" placeholder="CEP">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Endereço</label>
                                                    <input name="endereco" id="endereco" value="<?php echo e(old('endereco')); ?>" type="text" class="form-control" placeholder="Endereço">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Nº</label>
                                                    <input name="numero" id="numero" value="<?php echo e(old('numero')); ?>" type="text" class="form-control" placeholder="Nº">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Complemento</label>
                                                    <input name="complemento" id="complemento" value="<?php echo e(old('complemento')); ?>" type="text" class="form-control" placeholder="Complemento">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Bairro</label>
                                                    <input name="bairro" id="bairro" value="<?php echo e(old('bairro')); ?>" type="text" class="form-control" placeholder="Bairro">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Cidade</label>
                                                    <input name="cidade" id="cidade" value="<?php echo e(old('cidade')); ?>" type="text" class="form-control" placeholder="Cidade">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-3 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Estado</label>
                                                    <select name="estado" id="estado" class="form-select" data-placeholder="Choose a Category" tabindex="1">
                                                        <option value="Selecione um estado">Selecione um estado</option>
                                                        <?php $__currentLoopData = $estados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($estado->uf); ?>"><?php echo e($estado->uf); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-12 d-none">
                                <div class="box">
                                    <div class="box-body">
                                        <h4 class="box-title text-info mb-0"><i class="glyphicon glyphicon-ticket"></i> Ingressos</h4>
                                        <hr class="my-15">
                                        <div class="row">
                                            <div class="col-md-12 text-center" style="margin: 100px 0;">
                                                <p class="text-center">Que tipo de ingresso você deseja criar?</p>
                                                <button data-bs-toggle="modal" data-bs-target=".modal_ingresso_pago" type="button" class="waves-effect waves-light btn btn-outline btn-rounded btn-info mb-5">+ Ingresso Pago</button>
                                                <button type="button" class="waves-effect waves-light btn btn-outline btn-rounded btn-info mb-5">+ Ingresso Gratuito</button>
                                            </div>

                                            <div class="table-responsive-sm">
                                                <table class="table mb-0">
                                                    <thead>
                                                        <tr>
                                                            <th scope="col">Tipo</th>
                                                            <th scope="col">Vendidos/Total</th>
                                                            <th scope="col">Valor a Receber</th>
                                                            <th scope="col">Taxa</th>
                                                            <th scope="col">Visibilidade</th>
                                                            <th scope="col"></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody id="result_pacotes">
                                                        
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label class="form-label">Abrir Ativo</label>
                                                    <div class="radio-list">
                                                        <label class="p-0 radio-inline me-10">
                                                            <div class="radio radio-info">
                                                                <input id="abrir_ativo_s" type="radio" name="captacao_aberta" value="1">
                                                                <label for="abrir_ativo_s">Sim</label>
                                                            </div>
                                                        </label>
                                                        <label class="radio-inline">
                                                            <div class="radio radio-info">
                                                                <input id="abrir_ativo_n" type="radio" name="captacao_aberta" value="0" checked>
                                                                <label for="abrir_ativo_n">Não</label>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="col-lg-12 col-md-12 col-12">
                                                    <div class="form-group">
                                                        <label class="form-label">Advance</label>
                                                        <input name="advance" type="text" class="form-control preco">
                                                    </div>
                                                </div>
                                                <div class="col-lg-12 col-md-12 col-12">
                                                    <div class="form-group">
                                                        <label class="form-label">Descrição da Captação</label>
                                                        <input name="descricao_captacao" type="text" class="form-control">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="form-label">Visibilidade do evento</label>
                                                    <div class="radio-list">
                                                        <label class="p-0 radio-inline me-10">
                                                            <div class="radio radio-info">
                                                                <input id="statuss" type="radio" name="tipo" value="Público" checked>
                                                                <label for="statuss">Público</label>
                                                            </div>
                                                        </label>
                                                        <label class="radio-inline">
                                                            <div class="radio radio-info">
                                                                <input id="statusn" type="radio" name="tipo" value="Privado">
                                                                <label for="statusn">Privado</label>
                                                            </div>
                                                        </label>
                                                        <label class="radio-inline">
                                                            <div class="radio radio-info">
                                                                <input id="statusc" type="radio" name="tipo" value="Fase de Captação">
                                                                <label for="statusc">Fase de Captação</label>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <button type="submit" class="btn btn-primary btn-sm"> <i class="fa fa-check"></i> Publicar</button>
                                                <button type="submit" class="btn-sm waves-effect waves-light btn btn-outline btn-primary"> <i class="fa fa-check"></i> Salvar Rascunho</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>
            </section>
        </div>
    </div>

    <div class="modal fade modal_ingresso_pago" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myLargeModalLabel">Criar ingresso <strong>Pago</strong></h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Título do ingresso</label>
                                    <input type="text" id="titulo_ingresso_pago" class="form-control" placeholder="Ingresso único, Meia-Entrada, VIP, etc">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Quantidade</label>
                                    <input id="qtd_ingresso_pago" type="text" class="form-control" placeholder="Ex. 100">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Valor a receber</label>
                                    <input type="text" id="valor_ingresso_pago" class="form-control preco" placeholder="R$">
                                </div>
                            </div>
                            <div class="form-group ichack-input">
                                <div class="demo-checkbox">
                                    <input type="checkbox" id="criar_meia_entrada" class="chk-col-info">
                                    <label for="criar_meia_entrada"> Criar meia-entrada para este ingresso</label>
                                </div>
                            </div>
                        </div>
                        <div class="row d-none" id="box_meia_entrada">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Título do ingresso</label>
                                    <input type="text" id="nome_meia_pago" class="form-control" placeholder="Ingresso único, Meia-Entrada, VIP, etc" readonly>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Quantidade</label>
                                    <input id="qtd_meia_pago" type="text" class="form-control" placeholder="Ex. 100">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Valor a receber</label>
                                    <input type="text" id="valor_meia_pago" class="form-control preco" placeholder="R$">
                                </div>
                            </div>
                        </div>
                        <div class="row mt-30">
                            <label class="form-label">Período das vendas deste ingresso</label>
                            <div class="row">
                                <div class="col-lg-3 col-md-3 col-6">
                                    <div class="form-group">
                                        <label class="form-label">Data Início</label>
                                        <input id="data_inicio_pago" value="<?php echo e(old('data_inicio')); ?>" type="date" class="form-control date-time">
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-6">
                                    <div class="form-group">
                                        <label class="form-label">Hora Início</label>
                                        <input id="hora_inicio_pago" value="<?php echo e(old('hora_inicio')); ?>" type="time" class="form-control date-time">
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-6">
                                    <div class="form-group">
                                        <label class="form-label">Data Final</label>
                                        <input id="data_fim_pago" value="<?php echo e(old('data_fim')); ?>" type="date" class="form-control date-time">
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-6">
                                    <div class="form-group">
                                        <label class="form-label">Hora Final</label>
                                        <input id="hora_fim_pago" value="<?php echo e(old('hora_fim')); ?>" type="time" class="form-control date-time">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-30">
                            <label class="form-label">Disponibilidade do Ingresso</label>
                            <div class="form-group">
                                <div class="radio">
                                    <input name="disponibilidade" type="radio" id="Option_1" checked="" value="Público">
                                    <label for="Option_1">Para todo o público </label>
                                </div>
                                <div class="radio">
                                    <input name="disponibilidade" type="radio" id="Option_2" value="Convidados">
                                    <label for="Option_2">Restrito a convidados</label>
                                </div>
                                <div class="radio">
                                    <input name="disponibilidade" type="radio" id="Option_3" value="Manual">
                                    <label for="Option_3">Para ser adicionado manualmente</label>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-30">
                            <label class="form-label">Quantidade permitida por compra</label>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label">Mínima</label>
                                            <input id="qtd_minima_compra" type="text" class="form-control" value="1">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label">Máxima</label>
                                            <input id="qtd_maxima_compra" type="text" class="form-control" value="5">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger text-start btn-sm" data-bs-dismiss="modal">Cancelar</button>
                    <button onclick="javascript:IngressoStore()" type="button" class="btn btn-primary float-end btn-sm">Criar Ingresso</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>


    <div class="modal fade pacote_modal_edit" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-lg" id="result_pacote">

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(url('assets/vendor_plugins/iCheck/icheck.min.js')); ?>"></script>
    <script src="<?php echo e(url('assets/vendor_components/formatter/formatter.js')); ?>"></script>
    <script src="<?php echo e(url('assets/vendor_components/formatter/jquery.formatter.js')); ?>"></script>
    <script src="<?php echo e(url('admin')); ?>/src/js/pages/formatter.js"></script>

    <script src="<?php echo e(url('assets/vendor_components/sweetalert/sweetalert.min.js')); ?>"></script>
    <script src="<?php echo e(url('assets/vendor_components/sweetalert/jquery.sweet-alert.custom.js')); ?>"></script>

    <script src="<?php echo e(url('assets/vendor_components/ckeditor/ckeditor.js')); ?>"></script>
    <script src="<?php echo e(url('assets/vendor_plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.js')); ?>"></script>
    <script src="<?php echo e(url('admin')); ?>/src/js/pages/editor.js"></script>

    <script>
        $(document).ready(function() {


            const mapaInput = document.getElementById('mapaInput');
            const selectedMapa = document.getElementById('selectedMapa');

            mapaInput.addEventListener('change', () => {
                const file = mapaInput.files[0];
                const reader = new FileReader();

                reader.addEventListener('load', () => {
                    selectedMapa.setAttribute('src', reader.result);
                });
                reader.readAsDataURL(file);
            });


            const inputsValores = document.querySelectorAll('.preco');
            inputsValores.forEach(function(inputValor) {
                inputValor.addEventListener('input', function(event) {
                    // Pega o valor do input e remove tudo que não é número
                    let valor = inputValor.value.replace(/\D/g, '');

                    // Formata o valor como dinheiro
                    if (valor) {
                        valor = (parseInt(valor) / 100).toLocaleString('pt-BR', {
                            style: 'currency',
                            currency: 'BRL'
                        });
                    } else {
                        valor = '';
                    }

                    // Atualiza o valor no input
                    inputValor.value = valor;
                });
            });

            const imageInput = document.getElementById('imageInput');
            const selectedImage = document.getElementById('selectedImage');

            imageInput.addEventListener('change', () => {
                const file = imageInput.files[0];
                const reader = new FileReader();

                reader.addEventListener('load', () => {
                    selectedImage.setAttribute('src', reader.result);
                });
                reader.readAsDataURL(file);
            });

            $("#cep").on("blur", function() {
                var numCep = $("#cep").val();
                var url = "https://viacep.com.br/ws/" + numCep.replace(/[\.-]/g, '') + "/json";
                $.ajax({
                    url: url,
                    type: "get",
                    dataType: "json",
                    success: function(dados) {
                        console.log(dados);
                        $("#cep").val(dados.cep);
                        $("#endereco").val(dados.logradouro);
                        $("#bairro").val(dados.bairro);
                        $("#cidade").val(dados.localidade);
                        $("#estado").val(dados.uf);
                    }
                });
            });
        });

        document.addEventListener('DOMContentLoaded', function() {
            const criarMeiaEntrada = document.getElementById('criar_meia_entrada');
            const boxMeiaEntrada = document.getElementById('box_meia_entrada');
            const tituloIngresso = document.getElementById('titulo_ingresso_pago');
            const valorIngresso = document.getElementById('valor_ingresso_pago');
            const tituloMeia = document.getElementById('nome_meia_pago');
            const valorMeia = document.getElementById('valor_meia_pago');

            // Mostra ou esconde a seção de meia-entrada
            criarMeiaEntrada.addEventListener('change', function() {
                if (this.checked) {
                    boxMeiaEntrada.classList.remove('d-none');
                } else {
                    boxMeiaEntrada.classList.add('d-none');
                }
            });

            // Atualiza o título da meia-entrada
            tituloIngresso.addEventListener('input', function() {
                const titulo = tituloIngresso.value;
                tituloMeia.value = `${titulo} (meia-entrada)`;
            });

            // Função para formatar valor no padrão brasileiro
            function formatarValor(valor) {
                return valor.toLocaleString('pt-BR', {
                    minimumFractionDigits: 2,
                    maximumFractionDigits: 2
                });
            }

            // Calcula e formata os valores após o input
            valorIngresso.addEventListener('keyup', function() {
                // Remove caracteres inválidos e converte para número
                let valor = parseFloat(valorIngresso.value.replace(/[^\d,]/g, '').replace(',', '.'));

                if (!isNaN(valor)) {
                    // Calcula o valor da meia-entrada
                    const meiaEntrada = valor / 2;

                    // Formata os valores
                    valorIngresso.value = `R$ ${formatarValor(valor)}`;
                    valorMeia.value = `R$ ${formatarValor(meiaEntrada)}`;
                } else {
                    // Reseta os valores caso não seja um número válido
                    valorIngresso.value = '';
                    valorMeia.value = '';
                }
            });
        });

        document.addEventListener('DOMContentLoaded', function() {
            const porDataRadio = document.getElementById('por_data');
            const porLoteRadio = document.getElementById('por_lote');

            porDataRadio.addEventListener('change', function() {
                console.log('data');
                if (this.checked) {
                    $("#box_por_data").removeClass('d-none');
                    $("#box_por_lote").addClass('d-none');
                }
            });

            porLoteRadio.addEventListener('change', function() {
                console.log('periodo');
                if (this.checked) {
                    $("#box_por_lote").removeClass('d-none');
                    $("#box_por_data").addClass('d-none');
                }
            });
        });


        function IngressoStore() {
            var disponibilidade = $("input[name='disponibilidade']:checked").val();

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "<?php echo e(route('pacote.store')); ?>",
                method: 'POST',
                data: {
                    nome: $("#titulo_ingresso_pago").val(),
                    qtd: $("#qtd_ingresso_pago").val(),
                    preco: $("#valor_ingresso_pago").val(),
                    nome_meia_pago: $("#nome_meia_pago").val(),
                    qtd_meia_pago: $("#qtd_meia_pago").val(),
                    valor_meia_pago: $("#valor_meia_pago").val(),
                    data_inicio: $("#data_inicio_pago").val(),
                    hora_inicio: $("#hora_inicio_pago").val(),
                    data_fim: $("#data_fim_pago").val(),
                    hora_fim: $("#hora_fim_pago").val(),
                    qtd_minima_compra: $("#qtd_minima_compra").val(),
                    qtd_maxima_compra: $("#qtd_maxima_compra").val(),
                    tipo: disponibilidade,
                },
                success: function(result) {
                    $("#result_pacotes").html(result);
                    $(".modal_ingresso_pago").modal('hide');
                }
            });
        }

        function IngressoUpdate(id) {
            var disponibilidade = $("input[name='disponibilidade_update']:checked").val();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "<?php echo e(route('pacote.update')); ?>",
                method: 'POST',
                data: {
                    pacote_id: id,
                    nome: $("#titulo_ingresso_update").val(),
                    qtd: $("#qtd_ingresso_update").val(),
                    preco: $("#valor_ingresso_update").val(),
                    data_inicio: $("#data_inicio_update").val(),
                    hora_inicio: $("#hora_inicio_update").val(),
                    data_fim: $("#data_fim_update").val(),
                    hora_fim: $("#hora_fim_update").val(),
                    qtd_minima_compra: $("#qtd_minima_compra_update").val(),
                    qtd_maxima_compra: $("#qtd_maxima_compra_update").val(),
                    tipo: disponibilidade,
                },
                success: function(result) {
                    if (result == 'error_excluir') {
                        swal("Atenção", "Já existe vendas para este ingresso, ele não pode ser removido", "error");
                    } else {
                        $("#result_pacotes").html(result);
                        $(".pacote_modal_edit").modal('hide');
                    }
                }
            });
        }

        function UpdateStatus(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "<?php echo e(route('pacote.update.status')); ?>",
                method: 'POST',
                data: {
                    id: id
                },
                success: function(result) {
                    $("#result_pacotes").html(result); // Corrigido o uso de "result"
                },
                error: function(xhr, status, error) {
                    console.error("Erro na requisição:", error);
                    alert("Não foi possível atualizar o status. Tente novamente.");
                }
            });
        }

        function EditPacote(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "<?php echo e(route('pacote.show')); ?>",
                method: 'POST',
                data: {
                    id: id
                },
                success: function(result) {
                    $("#result_pacote").html(result);
                    $(".pacote_modal_edit").modal('show');
                },
                error: function(xhr, status, error) {
                    console.error("Erro na requisição:", error);
                    alert("Não foi possível atualizar o status. Tente novamente.");
                }
            });
        }

        document.addEventListener('DOMContentLoaded', function() {
            const select = document.getElementById('localSelect');
            const input = document.getElementById('inputNovoLocal');

            select.addEventListener('change', function() {
                if (select.value === 'novo') {
                    input.style.display = 'block';
                } else {
                    input.style.display = 'none';
                    input.value = ''; // limpa o campo se não for novo
                }
            });
        });


        $(document).ready(function() {
            const $selectLocal = $('#localSelect');

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $selectLocal.on('change', function() {
                const id = $(this).val();

                if (id && id !== 'novo') {
                    $.ajax({
                        url: "<?php echo e(route('get.local')); ?>",
                        method: 'POST',
                        data: {
                            id
                        },
                        success: function(data) {
                            $('#inputNovoLocal').hide();
                            $('#inputNovoLocal').val('');

                            $('[name="local"]').val(data.local);
                            $('[name="cep"]').val(data.cep);
                            $('[name="endereco"]').val(data.endereco);
                            $('[name="numero"]').val(data.numero);
                            $('[name="complemento"]').val(data.complemento);
                            $('[name="bairro"]').val(data.bairro);
                            $('[name="cidade"]').val(data.cidade);
                            $('[name="estado"]').val(data.estado).trigger('change');
                            $('[name="latitude"]').val(`${data.latitude}, ${data.longitude}`);
                        },
                        error: function(xhr) {
                            alert("Erro ao carregar local. Tente novamente.");
                            console.error(xhr.responseText);
                        }
                    });
                } else if (id === 'novo') {
                    $('#inputNovoLocal').show().val('');
                    // limpa os outros campos
                    $('[name="cep"], [name="endereco"], [name="numero"], [name="complemento"], [name="bairro"], [name="cidade"], [name="estado"], [name="latitude"]').val('');
                } else {
                    $('#inputNovoLocal').hide().val('');
                    $('[name="cep"], [name="endereco"], [name="numero"], [name="complemento"], [name="bairro"], [name="cidade"], [name="estado"], [name="latitude"]').val('');
                }
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.base.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laravel\FilhosGandhy\3.0\resources\views/admin/evento/create.blade.php ENDPATH**/ ?>