<?php $__env->startSection('titulo', 'Participantes ' . $Evento->titulo); ?>
<?php $__env->startSection('content'); ?>
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                <?php echo $__env->make('admin.evento.include.info-participantes', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div class="row">
                    <div class="col-sm-12">
                        <div class="box">
                            <div class="box-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label">Filtrar por</label>
                                            <input type="text" class="form-control" placeholder="First Name">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label">Tipos de ingresso</label>
                                            <input type="text" class="form-control" placeholder="Tipos de ingresso">
                                        </div>
                                    </div>
                                </div>
                                <table id="tickets" class="table mt-0 table-hover no-wrap dataTable no-footer"
                                    data-page-size="10" role="grid" aria-describedby="tickets_info">
                                    <thead>
                                        <tr role="row">
                                            <th class="sorting center">Status</th>
                                            <th class="sorting">Participante</th>
                                            <th class="sorting">Nº Ingresso</th>
                                            <th class="sorting">Tipo</th>
                                            <th class="sorting">Comprado Por</th>
                                            <th class="sorting">Nº Pedido</th>
                                            <th class="sorting">Data da Compra</th>
                                            <th class="sorting">Check-in</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $Evento->Ingressos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr role="row" class="odd">
                                                <td class="center">
                                                    <span class="badge badge-xl badge-dot badge-<?php echo e($cor_status_ingresso[$item->status]); ?>"></span>
                                                </td>
                                                <td><?php echo e($item->nome_completo); ?></td>
                                                <td><?php echo e($item->registro); ?></td>
                                                <td><?php echo e($item->Pacote->nome); ?></td>
                                                <td><?php echo e(!empty($item->Pedido->Cliente->name) ? $item->Pedido->Cliente->name : 'Não informado'); ?>

                                                    <?php echo e(!empty($item->Pedido->Cliente->sobrenome) ? $item->Pedido->Cliente->sobrenome : ''); ?>

                                                </td>
                                                <td><?php echo e($item->Pedido->registro); ?></td>
                                                <td><?php echo e(date('d/m/Y H:i', strtotime($item->created_at))); ?></td>
                                                
                                                <td>
                                                    <span class="badge badge-pill badge-<?php echo e($cor_status_checkin[$item->check_in_status]); ?>"><?php echo e($item->check_in_status == '0' ? 'Não realizado' : date('d/m/Y H:i', strtotime($item->check_in_data))); ?></span>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(url('adm')); ?>/assets/vendor_components/datatable/datatables.min.js"></script>
    <script src="<?php echo e(url('adm')); ?>/assets/vendor_components/jquery.peity/jquery.peity.js"></script>
    <script src="<?php echo e(url('adm')); ?>/src/js/pages/data-table.js"></script>
    <script src="<?php echo e(url('adm')); ?>/src/js/pages/app-ticket.js"></script>
    <script></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.base.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\MusaTicket\resources\views/admin/evento/participantes.blade.php ENDPATH**/ ?>