<?php $__env->startSection('url', route('site.evento', [$evento->url, $evento->id])); ?>
<?php $__env->startSection('type', 'Página'); ?>
<?php $__env->startSection('titulo', $evento->titulo); ?>
<?php $__env->startSection('description', 'O ' . $evento->titulo . ' irá acontecner em ' . $evento->local); ?>
<?php $__env->startSection('image', url("storage/{$evento->banner}")); ?>
<?php $__env->startSection('content'); ?>
    <div class="cart-page checkout-page pt-120 mb-120">
        <form action="<?php echo e(route('processar.pagamento')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="container">
                <div class="row g-lg-4 gy-5">
                    <div class="col-lg-7">
                        <div class="col-md-12 item mb-20">
                            <div class="package-card4 four">
                                <a href="javascript:voud(0)" class="package-card-img">
                                    <img src="<?php echo e(url("storage/{$evento->banner}")); ?>" class="img">
                                </a>
                                <div class="package-card-content">
                                    <div class="card-content-top">
                                        <h5 style="margin-top: 10px"><?php echo e($evento->titulo); ?></h5>
                                        <div class="location-and-review">
                                            <div class="location">
                                                <p>
                                                    <i class="bi bi-calendar3"></i>
                                                    <?php echo e(date('d', strtotime($evento->data_inicio))); ?> <?php echo e($mes[date('m', strtotime($evento->data_inicio))]); ?> - <?php echo e(date('Y', strtotime($evento->data_inicio))); ?> às <?php echo e(date('H:i', strtotime($evento->data_inicio))); ?>

                                                    >
                                                    <?php echo e(date('d', strtotime($evento->data_fim))); ?> <?php echo e($mes[date('m', strtotime($evento->data_fim))]); ?> - <?php echo e(date('Y', strtotime($evento->data_fim))); ?> às <?php echo e(date('H:i', strtotime($evento->data_fim))); ?>

                                                </p>
                                                <p><i class="bi bi-geo-alt"></i> <?php echo e($evento->local); ?> - <?php echo e($evento->endereco_site); ?> <a href="#">Como chegar?</a></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="inquiry-form">
                            <div class="titulo1">
                                <h4>Informações do Perticipante</h4>
                            </div>
                            <div class="row">
                                <?php
                                    $index = 1;
                                ?>
                                <?php $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php for($i = 0; $i < $item['qtd']; $i++): ?>
                                        <input type="hidden" name="evento_id[<?php echo e($item['pacote_id']); ?>][<?php echo e($i); ?>]" value="<?php echo e($item['evento_id']); ?>">
                                        <input type="hidden" name="pacote_id[<?php echo e($item['pacote_id']); ?>][<?php echo e($i); ?>]" value="<?php echo e($item['pacote_id']); ?>">
                                        <input type="hidden" name="pacote_nome[<?php echo e($item['pacote_id']); ?>][<?php echo e($i); ?>]" value="<?php echo e($item['pacote']); ?>">
                                        <div class="border-bottom mb-10">
                                            <div class="titulo1">
                                                <h5>Participante Nº <?php echo e($index); ?> - <?php echo e($item['pacote']); ?></h5>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-inner mb-30">
                                                    <label>Nome Completo*</label>
                                                    <input type="text" name="nome_completo[<?php echo e($item['pacote_id']); ?>][<?php echo e($i); ?>]">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-inner mb-30">
                                                    <label>CPF*</label>
                                                    <input type="tel" name="cpf[<?php echo e($item['pacote_id']); ?>][<?php echo e($i); ?>]" class="cpf">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-inner mb-30">
                                                    <label>Email</label>
                                                    <input type="email" name="email[<?php echo e($item['pacote_id']); ?>][<?php echo e($i); ?>]">
                                                </div>
                                            </div>
                                        </div>
                                        <?php
                                            $index++;
                                        ?>
                                    <?php endfor; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-6">
                                    <button type="submit" class="primary-btn1" id="pg1">
                                        <span class="indicator-label" id="indicator-label-pg1">
                                            Processar Pagamento
                                        </span>
                                        <span class="indicator-progress d-none" id="indicator-progress-pg1">
                                            Processando... <span class="spinner-border spinner-border-sm align-middle ms-2"></span>
                                        </span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5">
                        <div class="cart-order-sum-area">
                            <div class="order-summary-wrap">
                                <div class="titulo1">
                                    <h4>Resumo</h4>
                                </div>
                                <ul class="order-summary-list">
                                    <li>
                                        <span><strong>Sub Total</strong></span>
                                        <span><strong>R$ <?php echo e(moeda($total)); ?></strong></span>
                                    </li>
                                    <?php $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <div class="order-info">
                                                <p><?php echo e($item['pacote']); ?> </p>
                                                <p class="shipping"><strong>R$ <?php echo e(moeda($item['total'])); ?></strong> (+ R$ <?php echo e(moeda(porcentagem(env('TAXA'), $item['total']))); ?> taxa) </p>
                                            </div>
                                            <span><?php echo e($item['qtd']); ?></span>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <li>
                                        <div class="coupon-area">
                                            <span>Cupom de desconto</span>
                                            <form>
                                                <div class="form-inner">
                                                    <input type="text" placeholder="Seu código">
                                                    <button type="submit" class="primary-btn1">Aplicar</button>
                                                </div>
                                            </form>
                                        </div>
                                    </li>
                                    <li>
                                        <span>Taxas</span>
                                        <span><strong>R$ <?php echo e(moeda(porcentagem(env('TAXA'), $total))); ?></strong></span>
                                    </li>
                                    <li>
                                        <span>Total</span>
                                        <span>R$ <?php echo e(moeda(porcentagem(env('TAXA'), $total) + $total)); ?></span>
                                    </li>
                                </ul>
                                <div class="choose-payment-method">
                                    <h6>Informações de pagamento</h6>
                                    <div class="payment-option">
                                        <ul>
                                            <li class="paypal">
                                                <img src="<?php echo e(url('site/assets/img/pix.png')); ?>" alt="">
                                                <div class="checked">
                                                    <i class="bi bi-check"></i>
                                                </div>
                                            </li>
                                            <li class="stripe">
                                                <img src="<?php echo e(url('site/assets/img/card.png')); ?>" alt="">
                                                <div class="checked">
                                                    <i class="bi bi-check"></i>
                                                </div>
                                            </li>
                                            <li class="offline active">
                                                <img src="<?php echo e(url('site/assets/img/barcode.png')); ?>" alt="">
                                                <div class="checked">
                                                    <i class="bi bi-check"></i>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="pt-25" id="StripePayment" style="display: none;">
                                        <div class="row g-4">
                                            <div class="col-md-12">
                                                <div class="form-inner">
                                                    <label>Card Number</label>
                                                    <input type="text" placeholder="1234 1234 1234 1234">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-inner">
                                                    <label>Expiry</label>
                                                    <input type="text" placeholder="MM/YY">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-inner">
                                                    <label>CVC</label>
                                                    <input type="text" placeholder="CVC">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <button type="submit" class="primary-btn1" id="pg1">
                                    <span class="indicator-label" id="indicator-label-pg1">
                                        Processar Pagamento
                                    </span>
                                    <span class="indicator-progress d-none" id="indicator-progress-pg1">
                                        Processando... <span class="spinner-border spinner-border-sm align-middle ms-2"></span>
                                    </span>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script>
        $(document).ready(function() {
            $("#pg1").click(function() {
                $("#indicator-label-pg1").addClass('d-none'); // Corrigido para 'd-none'
                $("#indicator-progress-pg1").removeClass('d-none'); // Corrigido para 'd-none'
                $("#indicator-label-pg2").addClass('d-none'); // Corrigido para 'd-none'
                $("#indicator-progress-pg2").removeClass('d-none'); // Corrigido para 'd-none'
            });
            $("#pg2").click(function() {
                $("#indicator-label-pg1").addClass('d-none'); // Corrigido para 'd-none'
                $("#indicator-progress-pg1").removeClass('d-none'); // Corrigido para 'd-none'
                $("#indicator-label-pg2").addClass('d-none'); // Corrigido para 'd-none'
                $("#indicator-progress-pg2").removeClass('d-none'); // Corrigido para 'd-none'
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('site.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\Sollares2\resources\views/site/checkout.blade.php ENDPATH**/ ?>