<?php $__env->startSection('titulo', 'Participantes ' . $Evento->titulo); ?>
<?php $__env->startSection('content'); ?>
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                <?php echo $__env->make('admin.evento.include.info-participantes', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="row">
                    <div class="col-12 col-lg-7">
                        <div class="box">
                            <div class="box-header bg-primary">
                                <h4 class="box-title"><?php echo e(count($Evento->Pacotes)); ?> ingressos disponíveis</h4>
                            </div>
                            <div class="box-body">
                                <div class="table-responsive">
                                    <table class="table product-overview">
                                        <thead>
                                            <tr>
                                                <th style="width: 55%">Tipo de Ingresso</th>
                                                <th style="width: 15%">Término Vendas</th>
                                                <th style="width: 15%">Preço</th>
                                                <th style="width: 15%">Disponibilidade</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $Evento->Pacotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pacote): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($pacote->nome); ?></td>
                                                    <td><?php echo e(date('d/m/Y', strtotime($pacote->data_fim))); ?></td>
                                                    <td>R$ <?php echo e(moeda($pacote->preco)); ?></td>
                                                    <td>
                                                        <select class="form-select" id="qtd<?php echo e($pacote->id); ?>" data-id="<?php echo e($pacote->id); ?>">
                                                            <?php for($i = 0; $i < 20; $i++): ?>
                                                                <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                                                            <?php endfor; ?>
                                                        </select>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-12 col-lg-5">
                        <div class="box">
                            <div class="box-header bg-info">
                                <h4 class="box-title">Resumo</h4>
                            </div>

                            <div class="box-body">
                                <div class="table-responsive" id="result_resumo">
                                    <table class="table simple mb-0">
                                        <tbody>
                                            <tr>
                                                <td>Dados do comprador</td>
                                                <td class="text-end">
                                                    <?php if(!empty($cliente)): ?>
                                                        <?php echo e($cliente['name']); ?><br>
                                                        <?php echo e($cliente['email']); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td class="text-end">
                                                    <button data-bs-toggle="modal" data-bs-target="#modal_dados_comprador" type="button"
                                                        class="waves-effect waves-circle btn-xs btn-circle btn-info mb-5"><i class="glyphicon glyphicon-plus-sign"></i></button>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Forma de Pagamento</td>
                                                <td class="text-end fw-700">
                                                    <?php if(!empty($pagamento['forma_pagamento'])): ?>
                                                        <?php echo e($pagamento['forma_pagamento']); ?> em <?php echo e($pagamento['parcelamento']); ?>X
                                                    <?php endif; ?>
                                                </td>
                                                <td class="text-end">
                                                    <button data-bs-toggle="modal" data-bs-target="#modal_forma_pagamento" type="button"
                                                        class="waves-effect waves-circle btn-xs btn-circle btn-info mb-5"><i class="glyphicon glyphicon-plus-sign"></i></button>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th class="bt-1" colspan="2">Total</th>
                                                <th class="bt-1 text-end fw-900 fs-18">R$ <?php echo e(moeda($total)); ?></th>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="box-footer">
                                <button class="btn btn-danger btn-rounded" onclick="javascript:Cancelar()">Cancelar</button>
                                <button class="btn btn-primary pull-right btn-rounded btn-outline float-end" onclick="javascript:Finalizar()">Finalizar</button>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>

    <div class="modal center-modal fade" id="modal_dados_comprador" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Dados do comprador</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label">Nome completo</label>
                                <input type="text" id="name" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label">E-mail</label>
                                <input type="text" id="email" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer modal-footer-uniform">
                    <button onclick="javascript:AddUser()" type="button" class="btn btn-primary float-end btn-sm btn-rounded">Salvar</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal center-modal fade" id="modal_forma_pagamento" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Configurações de pagamento</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label">Forma de Pagamento</label>
                                <select class="form-select" id="forma_pagamento">
                                    <option selected value="PIX">PIX</option>
                                    <option value="Boleto Bancário">Boleto Bancário</option>
                                    <option value="Dinheiro">Dinheiro</option>
                                    <option value="Cartão de Crédito">Cartão de Crédito</option>
                                    <option value="Cartão de Débito">Cartão de Débito</option>
                                    <option value="Transferência Bancária">Transferência Bancária</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label">Parcelamento</label>
                                <select class="form-select" id="parcelamento">
                                    <option value="1">1 Vez</option>
                                    <option value="2">2 Vezes</option>
                                    <option value="3">3 Vezes</option>
                                    <option value="4">4 Vezes</option>
                                    <option value="5">5 Vezes</option>
                                    <option value="6">6 Vezes</option>
                                    <option value="7">7 Vezes</option>
                                    <option value="8">8 Vezes</option>
                                    <option value="9">9 Vezes</option>
                                    <option value="10">10 Vezes</option>
                                    <option value="11">11 Vezes</option>
                                    <option value="12">12 Vezes</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer modal-footer-uniform">
                    <button onclick="javascript:AddPagamento()" type="button" class="btn btn-primary float-end btn-sm btn-rounded">Salvar</button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(url('adm')); ?>/assets/vendor_components/datatable/datatables.min.js"></script>
    <script src="<?php echo e(url('adm')); ?>/assets/vendor_components/jquery.peity/jquery.peity.js"></script>
    <script src="<?php echo e(url('adm')); ?>/src/js/pages/data-table.js"></script>
    <script src="<?php echo e(url('adm')); ?>/src/js/pages/app-ticket.js"></script>
    <script>
        function Add(id, quantidade) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('add.carrinho')); ?>",
                method: 'POST',
                data: {
                    id: id, // ID do pacote
                    quantidade: quantidade // Quantidade selecionada
                },
                success: function(result) {
                    $("#result_resumo").html(result);
                }
            });
        }

        function AddUser() {
            let name = $("#name").val().trim();
            let email = $("#email").val().trim();

            if (name === "" || email === "") {
                alert("Por favor, preencha todos os campos.");
                return;
            }
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('add.user')); ?>",
                method: 'POST',
                data: {
                    name: name,
                    email: email,
                },
                success: function(result) {
                    $("#modal_dados_comprador").modal('hide');
                    $("#result_resumo").html(result);
                }
            });
        }

        function AddPagamento() {
            let forma_pagamento = $("#forma_pagamento").val();
            let parcelamento = $("#parcelamento").val();
            if (forma_pagamento === "" || parcelamento === "") {
                alert("Por favor, selecione uma forma de pagamento e parcelamento.");
                return;
            }
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('add.pagamento')); ?>",
                method: 'POST',
                data: {
                    forma_pagamento: forma_pagamento,
                    parcelamento: parcelamento,
                },
                success: function(result) {
                    $("#modal_forma_pagamento").modal('hide');
                    $("#result_resumo").html(result);
                }
            });
        }


        // Adiciona o evento de mudança para cada select
        $(document).ready(function() {
            $('select.form-select').on('change', function() {
                const id = $(this).data('id'); // Pega o id do pacote
                const quantidade = $(this).val(); // Pega a quantidade selecionada
                Add(id, quantidade); // Chama a função Add com o id e a quantidade
            });
        });

        function Cancelar() {
            swal({
                title: "ATENÇÃO",
                text: "Cancelar venda?",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Sim",
                cancelButtonText: "Não",
                closeOnConfirm: false,
                closeOnCancel: false
            }, function(isConfirm) {
                if (isConfirm) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "<?php echo e(route('pdv.destroy')); ?>",
                        method: 'POST',

                        success: function(result) {
                            swal("Cancelada!", "A venda foi cancelada com sucesso", "success");
                            setTimeout(() => {
                                swal.close();
                                window.location.href = '<?php echo e(route('evento.participantes', $Evento)); ?>';
                            }, 2000);
                        },
                        error: function(xhr, status, error) {
                            swal("Erro", "Não foi possível remover o evento. Tente novamente.", "error");
                        }
                    });
                } else {
                    swal("Cancelado", "Continue a venda", "error");
                }
            });
        }

        function Finalizar() {
            swal({
                title: "ATENÇÃO",
                text: "Confirmar venda?",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Sim",
                cancelButtonText: "Não",
                closeOnConfirm: false,
                closeOnCancel: false
            }, function(isConfirm) {
                if (isConfirm) {
                    // Verifica se as sessões estão completas
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "<?php echo e(route('validar.sessoes')); ?>", // Rota para validar sessões no backend
                        method: 'POST',
                        data: {
                            evento_id: <?php echo e($Evento->id); ?>

                        },
                        success: function(validation) {
                            if (validation.success) {
                                // Se tudo está preenchido, conclui a venda
                                $.ajax({
                                    url: "<?php echo e(route('participante.store')); ?>",
                                    method: 'POST',
                                    data: {
                                        evento_id: <?php echo e($Evento->id); ?>

                                    },
                                    success: function(result) {
                                        swal("Confirmada!", "A venda foi concluída com sucesso", "success");
                                        setTimeout(() => {
                                            swal.close();
                                            window.location.href = '<?php echo e(route('evento.participantes', $Evento)); ?>';
                                        }, 2000);
                                    },
                                    error: function(xhr, status, error) {
                                        swal("Erro", "Não foi possível concluir a venda. Tente novamente.", "error");
                                    }
                                });
                            } else {
                                // Caso falte alguma informação, exibe o erro
                                swal("Erro", validation.message, "error");
                            }
                        },
                        error: function(xhr, status, error) {
                            swal("Erro", "Ocorreu um erro ao validar as informações. Tente novamente.", "error");
                        }
                    });
                } else {
                    swal("Cancelado", "Continue a venda", "error");
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.base.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\Laravel\MusaTicket\resources\views/admin/evento/pdv.blade.php ENDPATH**/ ?>