<?php $__env->startSection('titulo', 'Dashboard'); ?>
<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <div class="container-full">
            <div class="content-header">
                <div class="d-flex align-items-center">
                    <div class="me-auto">
                        <h4 class="page-title">Dashboard</h4>
                        <div class="d-inline-block align-items-center">
                            <nav>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="#"><i class="mdi mdi-home-outline"></i></a></li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                    <div class="clearfix">
                        <?php if(isset($eventos[0]) && $eventos[0]->status == 'Ativo'): ?>
                            <a href="<?php echo e(route('dashboard')); ?>" class="waves-effect waves-light btn btn-primary-light btn-sm">Vendas Ativas</a>
                            <a href="<?php echo e(route('eventos.inativos')); ?>" class="waves-effect waves-light btn btn-primary btn-sm">Vendas Anteriores</a>
                        <?php else: ?>
                            <a href="<?php echo e(route('dashboard')); ?>" class="waves-effect waves-light btn btn-primary btn-sm">Vendas Ativas</a>
                            <a href="<?php echo e(route('eventos.inativos')); ?>" class="waves-effect waves-light btn btn-primary-light btn-sm">Vendas Anteriores</a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <section class="content">
                <div class="row">
                    <?php $__empty_1 = true; $__currentLoopData = $eventos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $evento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php
                            // Ingressos válidos (status=1 e sem check-in)
                            $ingressosEvento = collect($evento->Pacotes ?? [])
                                ->flatMap(fn($p) => $p->Ingressos ?? [])
                                ->filter(fn($i) => (string) ($i->status ?? '') === '1' && (string) ($i->check_in_situacao ?? '') === '0');

                            $totalIngressosVendidos = $ingressosEvento->count();

                            $getPDV = fn($i) => !empty($i->pdv) ? $i->pdv : optional($i->Pedido)->pdv;

                            // Vendas com base no campo preco atualizado (já com cupom/desconto aplicados)
                            $vendasManuais = $ingressosEvento->filter(fn($i) => $getPDV($i) === 'Manual')->sum(fn($i) => (float) ($i->preco ?? 0));
                            $vendasSite = $ingressosEvento->filter(fn($i) => $getPDV($i) === 'Site')->sum(fn($i) => (float) ($i->preco ?? 0));

                            $totalVendas = $vendasSite + $vendasManuais;

                            $repasses = (float) collect($evento->Repasses ?? [])->sum('valor');
                            $saldo = $vendasSite - $repasses;

                            // Progresso
                            $vendidos = 0;
                            $capacidadeTotal = 0;

                            foreach ($evento->Pacotes ?? [] as $pacote) {
                                $qtdVendidos = collect($pacote->Ingressos ?? [])
                                    ->filter(fn($i) => (string) ($i->status ?? '') === '1' && (string) ($i->check_in_situacao ?? '') === '0')
                                    ->filter(fn($i) => $getPDV($i) !== 'Manual')
                                    ->count();

                                $qtdPorPacote = ($pacote->qtd_ingressos ?? 0) > 0 ? $pacote->qtd_ingressos : 1;
                                $vendidos += $qtdVendidos / $qtdPorPacote;

                                $capacidadeTotal += (int) ($pacote->qtd ?? 0);
                            }

                            $percentual = $capacidadeTotal > 0 ? min(100, round(($vendidos / max(1, $capacidadeTotal)) * 100, 2)) : 0;

                            $fmt = fn($v) => 'R$ ' . moeda($v ?? 0);
                        ?>

                        <div class="col-lg-4 col-12">
                            <div class="box">
                                <div class="box-body">
                                    <div class="d-flex flex-wrap align-items-center">
                                        <div class="d-flex flex-column flex-grow-1 my-lg-0 my-10">
                                            <img src="<?php echo e($evento->banner); ?>" style="width: 100%; height: 200px; object-fit: cover; object-position: top; margin: 0 0 20px 0;">
                                            <span class="text-fade fw-600 fs-16">
                                                <?php echo e($evento->titulo); ?>

                                            </span>
                                            <a href="#" class="hover-danger fs-12">
                                                <?php echo e(mb_substr($semana[date('w', strtotime($evento->data_inicio))] ?? '', 0, 3, 'UTF-8')); ?>,
                                                <?php echo e(date('d', strtotime($evento->data_inicio))); ?> de
                                                <?php echo e(substr($mes[date('m', strtotime($evento->data_inicio))] ?? '', 0, 3)); ?>

                                            </a>
                                        </div>
                                    </div>

                                    <div class="mt-0">
                                        <h6 class="text-warning"><strong>Vendas Site: <?php echo e($fmt($vendasSite)); ?></strong></h6>
                                        <h6 class="text-danger"><strong>Vendas Manual: <?php echo e($fmt($vendasManuais)); ?></strong></h6>
                                        <h6 class="text-warning"><strong>Total de Vendas: <?php echo e($fmt($totalVendas)); ?></strong></h6>
                                        <h6 class="text-success"><strong>Repasses: <?php echo e($fmt($repasses)); ?></strong></h6>
                                        <h6 class="text-warning mb-20"><strong>Saldo: <?php echo e($fmt($saldo)); ?></strong></h6>

                                        <div class="d-flex flex-column w-p100 mt-30">
                                            <span class="text-dark me-10 fs-16 fw-600 pb-15">
                                                Resumo de vendas (<?php echo e(intval($vendidos)); ?>/<?php echo e($capacidadeTotal); ?>) —
                                                <?php echo e($totalIngressosVendidos); ?> ingressos vendidos
                                            </span>
                                            <div class="progress progress-xs w-p100">
                                                <div class="progress-bar bg-danger" role="progressbar" style="width: <?php echo e($percentual); ?>%;" aria-valuenow="<?php echo e($vendidos); ?>" aria-valuemin="0" aria-valuemax="<?php echo e($capacidadeTotal); ?>"></div>
                                            </div>
                                        </div>

                                        <div class="mt-10 d-flex justify-content-between align-items-center">
                                            <a href="<?php echo e(route('evento.index', $evento)); ?>" class="waves-effect waves-light btn btn-primary mb-5" style="width: 100%">Gerenciar</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="col-12">
                            <div class="alert alert-info">Nenhum evento encontrado.</div>
                        </div>
                    <?php endif; ?>
                </div>
            </section>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.base.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laravel\FilhosGandhy\3.0\resources\views/admin/home/index.blade.php ENDPATH**/ ?>