<?php

use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\IngressoController;
use App\Http\Controllers\Ajax\AjaxControlller;
use App\Http\Controllers\AnalyticsController;
use App\Http\Controllers\AsaasController;
use App\Http\Controllers\CancelamentoEventoController;
use App\Http\Controllers\CartController;
use App\Http\Controllers\CarteiraController;
use App\Http\Controllers\ClienteController;
use App\Http\Controllers\ContatoController;
use App\Http\Controllers\CronController;
use App\Http\Controllers\DashBoardController;
use App\Http\Controllers\DebugController;
use App\Http\Controllers\EmailMarketingController;
use App\Http\Controllers\EtiquetaController;
use App\Http\Controllers\EventoController;
use App\Http\Controllers\FinanceiroController;
use App\Http\Controllers\IngressoController as ClienteIngressoController;
use App\Http\Controllers\MailController;
use App\Http\Controllers\PagamentoController;
use App\Http\Controllers\PedidoAppController;
use App\Http\Controllers\PedidoController;
use App\Http\Controllers\PontoAcessoController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\PushController;
use App\Http\Controllers\RelatoriosController;
use App\Http\Controllers\SeguroLopakController;
use App\Http\Controllers\SiteController;
use App\Http\Controllers\UserController;
use App\Http\Middleware\CheckUserLevel;
use App\Models\Analytcs;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;

Route::get('/validar-carteira/{cod}', [PedidoController::class, 'ValidarCarteira'])->name('validar.carteira');
Route::post('/validar-carteira', [PedidoController::class, 'ValidarCarteira'])->name('site.validar.carteira');
Route::post('/consulta-store', [PedidoController::class, 'ConsultaStore'])->name('site.consulta.store');

Route::get('/', [SiteController::class, 'home'])->name('site.home');
Route::get('/solicitar', [SiteController::class, 'solicitar'])->name('site.solicitar');
Route::get('/faq', [SiteController::class, 'faq'])->name('site.faq');
Route::get('/eventos-da-semana', [SiteController::class, 'semana'])->name('site.semana');
Route::get('/carteiras', [SiteController::class, 'eventos'])->name('site.eventos');
Route::get('/locais', [SiteController::class, 'locais'])->name('site.locais');
Route::get('/local/{url}/{id}', [SiteController::class, 'local'])->name('site.local');
Route::get('/carrinho', [SiteController::class, 'categorias'])->name('carrinho');
Route::get('/publicar-meu-evento', [SiteController::class, 'categorias'])->name('publicar.evento');
Route::post('/buscar-eventos', [SiteController::class, 'buscar'])->name('site.buscar');
Route::get('/contato', [SiteController::class, 'contato'])->name('site.contato');
Route::post('/contato', [ContatoController::class, 'store'])->name('contato.store');

//SAC E FAQ
Route::get('/ajuda', [SiteController::class, 'ajuda'])->name('site.ajuda');
Route::get('/duvidas-frequentes', [SiteController::class, 'categorias'])->name('duvidas.frequentes');
Route::get('/politica-de-privacidade', [SiteController::class, 'PoliticaPrivacidade'])->name('politica.privacidade');
Route::get('/termo-de-uso', [SiteController::class, 'TermoUso'])->name('termo.uso');

//EVENTO
Route::get('/carteira/{url}/{id}/{cupom?}', [SiteController::class, 'evento'])->name('site.evento');
Route::get('/evento-privado/{url}/{id}/{cupom?}', [SiteController::class, 'EventoPrivado'])->name('site.privado');
Route::get('/local/{url}/{id}', [SiteController::class, 'local'])->name('site.local');
Route::post('/buscar', [SiteController::class, 'buscar'])->name('site.buscar');

//DIVULGADOR
Route::get('/indicacao/{divulgador}', [SiteController::class, 'indicacao'])->name('site.indicacao');
Route::get('/divulgador/{url}/{id}/{divulgador?}', [SiteController::class, 'divulgador'])->name('site.divulgador');

// CADASTRO
Route::post('/validar-cpf', [SiteController::class, 'ValidarCPF'])->name('validar.cpf');
Route::post('/validar-celular', [SiteController::class, 'ValidarCelular'])->name('validar.celular');
Route::post('/validar-email', [SiteController::class, 'ValidarEmail'])->name('validar.email');
Route::get('/cadastro', [SiteController::class, 'cadastro'])->name('site.cadastro');

//COMPRA
Route::post('/cart', [PedidoController::class, 'cart'])->name('cart');
Route::post('/comprar', [PedidoController::class, 'CompraStore'])->name('compra.store');
Route::get('/dados-ingresso', [PedidoController::class, 'DadosIngresso'])->name('dados.ingresso');
Route::post('/ingressos-cart-update', [PedidoController::class, 'IngressosCartUpdate'])->name('ingressos.cart.update');
Route::get('/checkout', [PedidoController::class, 'checkout'])->name('site.checkout');
Route::post('/pay', [PedidoController::class, 'pay'])->name('to.pay');
Route::get('/retorno-mp/{id}', [PedidoController::class, 'RetornoMercadoPago'])->name('retorno.mp');
Route::post('/webhook-mercadopago', [PedidoController::class, 'WebhookMercadoPago'])->name('webhook.mercadopago');
Route::get('/confirmar-pagamento/{id}', [PedidoController::class, 'ConsultarPagamento'])->name('confirmar.pagamento');
Route::get('/inscricao-gratuita', [PagamentoController::class, 'InscricaoGratuita'])->name('inscricao.gratuita');
Route::get('/success/{Pedido}', [PagamentoController::class, 'success'])->name('success');

//INGRESSOS
Route::get('/ingresso/{id}/{code}', [SiteController::class, 'ingresso'])->name('site.ingresso');
Route::get('/print/ingressos/{registro}', [ClienteIngressoController::class, 'PrintIngressos'])->name('print.ingressos');
Route::get('/recibo-chargeback/{pedido_id}', [ClienteIngressoController::class, 'chargeback'])->name('recibo.chargeback');

//VALIDAÇÕES
Route::get('/validacao-de-email', [UserController::class, 'ValidarEmail'])->name('validacao.email');
Route::get('/trocar-email', [UserController::class, 'TrocarEmail'])->name('trocar.email');
Route::post('/validar-token-email', [UserController::class, 'ValidarTokenEmail'])->name('validar.token.email');

Route::get('/validacao-celular', [UserController::class, 'ValidarCelular'])->name('validacao.celular');
Route::post('/validar-token-celular', [UserController::class, 'ValidarTokenCelular'])->name('validar.token.celular');

//ÁREA DO CLIENTE
Route::group(['prefix' => 'cliente', 'middleware' => 'auth'], function () {

    //INGRESSO
    Route::get('/ingressos', [PedidoController::class, 'index'])->name('cliente.ingressos');
    Route::get('/editar-participantes/{id}', [ClienteIngressoController::class, 'EditarParticipantes'])->name('editar.participantes');
    Route::post('/ingresso/update', [ClienteIngressoController::class, 'IngressoUpdate'])->name('ingressos.dados.update');
    Route::post('/pedido/show', [ClienteIngressoController::class, 'PedidoShow'])->name('pedido.show');
    Route::post('/pedido/destroy', [ClienteIngressoController::class, 'PedidoDestroy'])->name('pedido.destroy');

    Route::get('/minha-conta', [UserController::class, 'perfil'])->name('minha.conta');
    Route::get('/editar-meus-dados', [UserController::class, 'dadosedit'])->name('dados.edit');
    Route::post('/dados-update', [UserController::class, 'update'])->name('dados.update');

    Route::get('/minhas-compras', [UserController::class, 'compras'])->name('cliente.minhas.compras');
    Route::get('/compra/{id}', [UserController::class, 'compra'])->name('cliente.compra');
    Route::get('/meus-dados', [UserController::class, 'dados'])->name('cliente.dados');
    Route::post('/update/notification', [UserController::class, 'UpdateNotification'])->name('update.notification');
    Route::post('/update/password', [UserController::class, 'password'])->name('update.password');
    Route::post('/validar-senhaatual', [UserController::class, 'password'])->name('validar.senha.atual');


    //PATROCINADOR
    Route::get('/minhas-indicacoes', [UserController::class, 'indicacoes'])->name('minhas.indicacoes');

    //VARIFICAÇÃO DA CONTA
    Route::get('/verificar-conta', [UserController::class, 'verificacao'])->name('verificacao.cliente');
});


Route::get('/politica-de-privacidade2', [SiteController::class, 'PoliticaPrivacidade'])->name('site.organize.evento');
Route::get('/publique-seu-evento', [SiteController::class, 'PublicarEvento'])->name('site.publicar.evento');
Route::post('/busca-rapida', [SiteController::class, 'buscar'])->name('busca.rapida');
Route::get('/suporte/{user_id?}', [SiteController::class, 'suporte']);
//CUPOM DE DESCONTO
Route::post('/cupom/store', [SiteController::class, 'CupomStore'])->name('cupom.store');

//CARRINHO
Route::post('/cart-add', [CartController::class, 'Add'])->name('cart.add');
Route::post('/cart-del', [CartController::class, 'Del'])->name('cart.del');
Route::post('/cart-total', [CartController::class, 'total'])->name('cart.total');
Route::post('/cart-destoy-item', [CartController::class, 'destoy'])->name('car.destroy.item');
Route::post('/cart-participantes', [CartController::class, 'participantes'])->name('car.participantes');


//CONTA DO USUÁRIO
// Route::post('/register/store', [UserController::class, 'store'])->name('register.store');
// Route::post('/register/active', [UserController::class, 'active'])->name('register.active');

//ROTAS RESTRITAS
// Route::post('/checkout', [SiteController::class, 'checkout'])->name('site.checkout');
// Route::get('/checkout/{url}/{id}', [SiteController::class, 'evento'])->name('site.checkout');
// Route::post('/checkout-sandbox/{url}/{id}', [SiteController::class, 'checkoutSandBox'])->name('site.checkout.sandbox');

//PAGAMENTOS
Route::post('/processar-pagamento', [PagamentoController::class, 'ProcessarPagamento'])->name('processar.pagamento');
Route::get('/pay/{Pedido}/{Boleto}', [PagamentoController::class, 'Pay'])->name('pay');
Route::post('/payment-card', [PagamentoController::class, 'PaymentCad'])->name('payment.card');
// Route::get('/retorno-mp/{id}', [PagamentoController::class, 'RetornoMercadoPago']);
Route::get('/consultar-pagamento-mp/{id}', [PagamentoController::class, 'ConsultaMercadoPago']);
Route::get('/validar-pagamento', [PagamentoController::class, 'ValidarPagamento']);

Route::get('/aprovar/{payment_id}', [PagamentoController::class, 'aprovar']);


//ASAAS
Route::get('/retorno-asaas/{id}', [AsaasController::class, 'retorno'])->name('retorno.asaas');

Route::group(['prefix' => 'app'], function () {
    Route::get('/pedido/{id}', [PedidoAppController::class, 'pedido'])->name('app.pedido');
    Route::get('/pedido-show/{id}', [PedidoAppController::class, 'PedidoShow']);
    Route::post('/pay/{id}', [PedidoAppController::class, 'PaymentCad'])->name('pay.app');
});


//ADM
Route::group(['prefix' => 'intranet', 'middleware' => ['auth', CheckUserLevel::class]], function () {
    Route::get('/', [DashBoardController::class, 'home'])->name('dashboard');
    Route::get('/enventos-inativos', [DashBoardController::class, 'EventosInativos'])->name('eventos.inativos');

    Route::get('/vendas/show/{Evento}', [EventoController::class, 'index'])->name('evento.index');
    Route::get('/vendas/create', [EventoController::class, 'create'])->name('evento.create');
    Route::post('/get-local', [EventoController::class, 'GetLocal'])->name('get.local');

    Route::post('/vendas/update/{Evento}', [EventoController::class, 'update'])->name('evento.update');
    Route::post('/vendas/store', [EventoController::class, 'store'])->name('evento.store');
    Route::get('/vendas/pacotes/{Evento}', [EventoController::class, 'pacotes'])->name('evento.pacotes');
    Route::post('/vendas/destroy', [EventoController::class, 'destroy'])->name('evento.destroy');
    Route::get('/vendas/integracoes/{Evento}', [EventoController::class, 'integration'])->name('evento.integracoes');
    Route::get('/vendas/editar/{Evento}', [EventoController::class, 'edit'])->name('evento.editar');
    Route::post('/vendas/integracoes/update', [EventoController::class, 'integrationUpdate'])->name('evento.update.integracoes');
    Route::get('/vendas/pre-editar/{Evento}', [EventoController::class, 'edit'])->name('evento.pre');
    Route::get('/vendas/colaboradores/{Evento}', [EventoController::class, 'colaboradores'])->name('evento.colaboradores');
    Route::post('/colaborador-store', [EventoController::class, 'ColaboradorStore'])->name('colaborador.store');
    Route::post('/colaborador-show', [EventoController::class, 'ColaboradorShow'])->name('colaborador.show');
    Route::post('/colaborador-update', [EventoController::class, 'ColaboradorUpdate'])->name('colaborador.update');
    Route::post('/colaborador-destroy', [EventoController::class, 'ColaboradorDestroy'])->name('colaborador.destroy');
    Route::get('/vendas/pdv/{Evento}', [EventoController::class, 'pdv'])->name('evento.pdv');



    Route::post('/pdv-store', [EventoController::class, 'PDVStore'])->name('pdv.store');
    Route::get('/ingressos-dashboard/{Evento}', [EventoController::class, 'ingressos'])->name('ingressos.dashboard');
    Route::get('/cortesias/{Evento}', [EventoController::class, 'cortesias'])->name('evento.cortesias');
    Route::get('/mensagem-do-ingressos/{Evento}', [EventoController::class, 'MSGIngressos'])->name('mensagem.ingressos');
    Route::get('/participantes/{Evento}', [EventoController::class, 'participantes'])->name('evento.participantes');

    Route::post('/add-carrinho', [EventoController::class, 'AddCarrinho'])->name('add.carrinho');
    Route::post('/add-user', [EventoController::class, 'AddUser'])->name('add.user');
    Route::post('/add-pagamento', [EventoController::class, 'AddPagamento'])->name('add.pagamento');
    Route::post('/pdv/destroy', [EventoController::class, 'PdvDestroy'])->name('pdv.destroy');
    Route::post('/participantes/store', [EventoController::class, 'ParticpanteStore'])->name('participante.store');
    Route::post('/validar-sessoes', [EventoController::class, 'ValidarSessoes'])->name('validar.sessoes');
    Route::get('/vendas/checkin/{Evento}', [EventoController::class, 'checkin'])->name('evento.checkin');
    Route::get('/vendas/checkin-on-line/{Evento}', [EventoController::class, 'checkinOnline'])->name('evento.checkin.online');
    Route::post('/checkin-on-line/store', [EventoController::class, 'CheckinStore'])->name('checkIn.store');
    Route::get('/vendas/show/form/{id}', [EventoController::class, 'form'])->name('evento.form');
    Route::get('/vendas/show/level/{id}', [EventoController::class, 'level'])->name('evento.level');
    Route::get('/vendas/show/config/{id}', [EventoController::class, 'config'])->name('evento.config');
    Route::post('/update-taxa-servico', [EventoController::class, 'AtivarTaxa'])->name('update.taxa.servico');
    Route::post('/send-ingresso-email', [EventoController::class, 'SendIngressoEmail'])->name('enviar.ingresso.email');
    Route::get('/vendas/relatorio/{Evento}', [EventoController::class, 'relatorio'])->name('evento.relatorio');
    Route::get('/vendas/cupons/{Evento}', [EventoController::class, 'cupons'])->name('evento.cupons');
    Route::post('/vendas/cupons-store', [EventoController::class, 'CupomStore'])->name('cupom.create.store');
    Route::post('/vendas/cupom-destroy', [EventoController::class, 'CupomDestroy'])->name('cupom.destroy');
    Route::post('/buscar-participante', [EventoController::class, 'BuscarParticipante'])->name('buscar.participante');
    Route::get('/email-marketing/{Evento}', [EventoController::class, 'EmailMarketing'])->name('evento.email.marketing');
    Route::get('/vendas/repasses/{Evento}', [EventoController::class, 'repasses'])->name('evento.repasses');
    Route::post('/vendas/repasses-store', [EventoController::class, 'RepasseStore'])->name('repasse.store');
    Route::get('/evento-bordero/{Evento}', [EventoController::class, 'bordero'])->name('evento.bordero');

    //PDV
    Route::get('/editar-pedido/{id}', [CarteiraController::class, 'editar'])->name('editar.pedido');
    Route::post('/carteira/store', [CarteiraController::class, 'store'])->name('carteira.store');
    Route::post('/carteira/update/{id}', [CarteiraController::class, 'update'])->name('carteira.update');

    //FINANCEIRO
    Route::get('/financeiro/{Evento}', [FinanceiroController::class, 'index'])->name('financeiro.index');
    Route::get('/historico-transacoes/{Evento}', [FinanceiroController::class, 'historico'])->name('historico.transacoes');

    Route::get('/pagamentos', [FinanceiroController::class, 'pagamentos'])->name('financeiro.pagamentos');
    Route::post('/filtrar-pagamentos', [FinanceiroController::class, 'FiltrarPagamentos'])->name('filtrar.pagamentos');
    Route::get('/financeiro/{Evento}', [FinanceiroController::class, 'index'])->name('financeiro.index');
    Route::get('/historico-transacoes/{Evento}', [FinanceiroController::class, 'historico'])->name('historico.transacoes');
    Route::get('/gerenciar-pedido/{Pedido}', [FinanceiroController::class, 'pedido'])->name('gerenciar.pedido');
    Route::post('/cancelamento-pedido/store/{id}', [FinanceiroController::class, 'CancelamentoPedidoStore'])->name('pedido.cancelamento');
    Route::post('/aprovar-pedido', [FinanceiroController::class, 'AprovarPedido'])->name('aprovar.pedido');

    //PACOTES
    Route::post('/pacotes/store', [EventoController::class, 'PacoteStore'])->name('pacote.store');
    Route::post('/pacotes/destroy', [EventoController::class, 'PacoteDestroy'])->name('pacote.destroy');
    Route::post('/pacotes/update-status', [EventoController::class, 'PacoteUpdateStatus'])->name('pacote.update.status');
    Route::post('/pacotes/show', [EventoController::class, 'PacoteShow'])->name('pacote.show');
    Route::post('/pacotes/update', [EventoController::class, 'IngressoUpdate'])->name('pacote.update');

    //EMAIL MARKETING
    Route::post('/email/store', [EmailMarketingController::class, 'EmailStore'])->name('email.store');
    Route::get('/email/status/{Evento}/{Email}', [EmailMarketingController::class, 'status'])->name('email.marketing.status');
    Route::post('/send-email', [EmailMarketingController::class, 'SendEmail'])->name('send.email');
    Route::get('/campanha/{email_id}/{id}', [EmailMarketingController::class, 'campanha'])->name('campanha.read');

    //RELATÓRIOS
    Route::get('/relatorios', [RelatoriosController::class, 'index'])->name('financeiro.relatorios');
    Route::get('/resumo-de-vendas', [RelatoriosController::class, 'resumo'])->name('resumo.vendas');
    Route::post('/relatorio/gerar', [RelatoriosController::class, 'gerar'])->name('gerar.relatorio');
    Route::get('/relatorio-mensal', [RelatoriosController::class, 'mensal'])->name('relatorio.mensal');
    Route::post('/gerar-relatorio-mensal', [RelatoriosController::class, 'GerarMensal'])->name('gerar.relatorio.mensal');

    //RELATÓRIO POR EVENTOS
    Route::get('/relatorio-por-ingresso/{Evento}', [RelatoriosController::class, 'RelIngresso'])->name('relatorio.por.ingresso');

    //AUDITORIA
    Route::get('/auditoria-vendas', [AuditoriaController::class, 'vendas'])->name('auditoria.vendas');
    Route::get('/eventos-hoje', [AuditoriaController::class, 'EventosHoje'])->name('eventos.hoje');

    Route::get('/clientes', [ClienteController::class, 'index'])->name('clientes.index');
    Route::post('/cliente/result', [ClienteController::class, 'result'])->name('result.clientes');
    Route::get('/cliente/show/{User}', [ClienteController::class, 'show'])->name('cliente.show');
    Route::post('/cliente/update/{User}', [ClienteController::class, 'update'])->name('cliente.update');


    Route::get('/seguro-lopak', [SeguroLopakController::class, 'index'])->name('relatorio.seguro.lopak');
    Route::post('/filtrar-seguro-lopak', [SeguroLopakController::class, 'filtrar'])->name('filtrar.seguros.lopak');


    Route::get('/novos-pedidos', [PedidoController::class, 'novos'])->name('novos.pedidos');
    Route::get('/print-carteira/{Pedido}', [PedidoController::class, 'print'])->name('print.carteira');
});

// Route::get('/dashboard', function () {
//     return view('dashboard');
// })->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});


Route::get('/cliente-logar/{User}', [ClienteController::class, 'logar'])->name('cliente.logar');
Route::group(['prefix' => 'ajax', 'middleware' => 'auth'], function () {
    Route::post('/checkout',    [AjaxControlller::class, 'checkout'])->name('ajax.checkout');
    Route::post('/pix',         [AjaxControlller::class, 'pix'])->name('ajax.pix');
});

Route::post('/webhook', [AjaxControlller::class, 'webhook'])->withoutMiddleware([VerifyCsrfToken::class]);

//TAREFAS CRONS
Route::get('/gerar-ingressos-do-pacote', [CronController::class, 'GerarIngressoPacote']);
Route::get('/ajustar-ingressos-casadinhas', [CronController::class, 'AjustarCasadinha']);
Route::get('/verifica-pagamentos/{token}', [CronController::class, 'VerificaPagamentos']);
Route::get('/deleta-cancelados', [CronController::class, 'DeletaCancelados']);
Route::get('/valor-comissao/{token}', [CronController::class, 'ValorComissao']);
// Route::get('/time', [CronController::class, 'time'])->name('time');

//ANALYTCS
Route::get('/download-app', [AnalyticsController::class, 'DownloadApp'])->name('download.app');

//DEBUG
Route::get('/debug', [DebugController::class, 'debug'])->name('debug');
Route::get('/gerar-pedidos', [DebugController::class, 'GerarPedidos']);

//MAIL
Route::get('/send-email/{id}', [MailController::class, 'send']);

//CANCELAMENTO DE EVENTO
Route::get('/cancelamento-de-evento/{id}', [CancelamentoEventoController::class, 'RodarCancelamento']);

//EMAIL MARKETING
Route::get('/campanha/{email_id}/{id}', [EmailMarketingController::class, 'campanha'])->name('campanha.read');

//PUSH
Route::get('/push', [PushController::class, 'push']);
Route::get('/push-alert-de-evento-comprado/{evento_id}', [PushController::class, 'PushAlertaEventoComprado']);


Route::get('/print-etiqueta', [EtiquetaController::class, 'print']);
Route::get('/etiqueta-manual/{id}', [EtiquetaController::class, 'printID']);
Route::get('/etiquetas/pendentes', [EtiquetaController::class, 'pendentes']);
Route::post('/etiquetas/{id}/impresso', [EtiquetaController::class, 'marcarImpresso']);

Route::get('/gerar-token/{id}', [PedidoController::class, 'GerarToken']);


Route::get('/limpar-cache', function () {
    Artisan::call('cache:clear');

    // Artisan::call('config:clear');
    // Artisan::call('route:clear');
    // Artisan::call('view:clear');

    return redirect()->route('site.home');
})->middleware('auth'); // 🔐 protege com login


require __DIR__ . '/auth.php';
