@extends('site.base')
@section('titulo', 'Pagamento Confirmado | ' . env('EMPRESA'))
@section('url', route('site.cadastro'))
@section('description', 'Detalhes do pagamento confirmado em ' . env('EMPRESA'))
@section('pixel_track', 'Purchase')
@section('content')
    <main>
        <div class="relative w-full false" style="margin-bottom: 30px;">
            {{-- CONTEÚDO --}}
            <div class="pt-[64px]" style="margin-top: 50px;">
                <div class="relative w-[95%] md:w-4/6 lg:w-3/6 xl:w-[40%] 4xl:w-[25%] mx-auto">
                    <div class="rounded-2xl shadow-lg bg-white overflow-hidden">
                        {{-- Cabeçalho verde de confirmação --}}
                        <div class="bg-primary-success text-white text-center py-8">
                            <svg xmlns="http://www.w3.org/2000/svg" class="mx-auto w-16 h-16 mb-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2l4-4m5 2a9 9 0 11-18 0a9 9 0 0118 0z" />
                            </svg>
                            <h1 class="font-bold text-2xl">Pagamento Confirmado!</h1>
                            <p class="text-green-100 mt-1">Obrigado por comprar conosco</p>
                        </div>

                        {{-- Corpo da invoice --}}
                        <div class="p-6">
                            <h2 class="text-lg font-semibold text-gray-800 mb-4">Resumo do Pedido</h2>

                            <div class="space-y-3 text-gray-700">
                                <div class="flex justify-between border-b pb-2">
                                    <span class="font-medium">Pedido:</span>
                                    <span>#{{ $Pedido->id ?? '0001' }}</span>
                                </div>
                                <div class="flex justify-between border-b pb-2">
                                    <span class="font-medium">Data:</span>
                                    <span>{{ date('d/m/Y H:i', strtotime($Pedido->created_at)) }}</span>
                                </div>
                                <div class="flex justify-between border-b pb-2">
                                    <span class="font-medium">Método de Pagamento:</span>
                                    <span>{{ $Pedido->forma_pagamento ?? 'Cartão de Crédito' }}</span>
                                </div>
                                <div class="flex justify-between border-b pb-2">
                                    <span class="font-medium">Valor Total:</span>
                                    <span class="font-bold text-primary-green">R$ {{ moeda($Pedido->total) }}</span>
                                </div>
                            </div>

                            {{-- Detalhes dos itens --}}
                            <h2 class="text-lg font-semibold text-gray-800 mt-6 mb-3">Carteira</h2>
                            <ul class="space-y-2">
                                @foreach ($Pedido->Ingressos as $ingresso)
                                    <li class="flex justify-between bg-green-light/40 p-3 rounded-lg">
                                        <span>{{ $ingresso->Pacote->nome }}</span>
                                        <span>{{ $ingresso->nome_completo }}</span>
                                        <span>R$ {{ moeda($ingresso->valor_final) }}</span>
                                    </li>
                                @endforeach
                            </ul>
                            <div class="mt-8 flex flex-col md:flex-row gap-4">
                                <a href="{{ route('cliente.ingressos') }}" class="w-full bg-primary-green hover:bg-primary-green/90 text-white text-center font-medium py-3 rounded-full">
                                    Detalhes da Compra
                                </a>
                                <a href="https://ucesub.com.br/carteira/{{ $Pedido->registro }}" target="_blank" class="w-full bg-primary-success hover:bg-green-hover text-white text-center font-medium py-3 rounded-full">
                                    Ver carteira
                                </a>
                            </div>
                        </div>

                        {{-- Rodapé --}}
                        <div class="bg-gray-100 text-center py-4 text-sm text-gray-500">
                            {{ env('EMPRESA') }} © {{ date('Y') }} - Todos os direitos reservados
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @include('site.footer')
    </main>
@endsection
