@extends('site.base')
@section('titulo', $local->local)
@section('url', route('site.local', [$local->url, $local->id]))
@section('description', lmword($local->descricao ?? $local->local, 180))
@section('image', $local->logo ?? url('site/images/placeholder-local.webp'))

@section('application_ld_json')
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Place",
  "name": "{{ $local->local }}",
  "image": ["{{ $local->logo ?? url('site/images/placeholder-local.webp') }}"],
  "description": {!! json_encode(strip_tags($local->descricao ?? 'Local parceiro da Musa Ticket com eventos disponíveis.')) !!},
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "{{ $local->endereco_site ?? ($local->endereco . ', ' . $local->numero) }}",
    "addressLocality": "{{ $local->cidade }}",
    "addressRegion": "{{ $local->estado }}",
    "postalCode": "{{ $local->cep }}",
    "addressCountry": "BR"
  },
  "geo": {
    "@type": "GeoCoordinates",
    "latitude": "{{ $local->latitude }}",
    "longitude": "{{ $local->longetude }}"
  },
  "url": "{{ route('site.local', [$local->url,$local->id]) }}"
}
</script>
@endsection

@section('content')
    <main class="h-full relative">
        {{-- HERO --}}
        <div class="relative w-full h-full pt-[72px] bg-[#e9e9e9]">
            <div class="absolute inset-0 w-full h-full bg-cover bg-center hidden lg:block" style="background-image:url('{{ $local->logo }}')"></div>
            <div class="absolute inset-0 bg-white/50 backdrop-blur-xl"></div>

            <div class="relative z-10 flex flex-col lg:flex-row lg:items-center justify-center w-full h-full lg:min-h-screen gap-4">
                <div class="flex justify-center lg:w-[400px] lg:h-[400px] w-full h-full lg:max-h-[400px]">
                    <img class="lg:w-[400px] lg:h-[400px] w-full h-full object-cover rounded-none lg:rounded-2xl" src="{{ $local->logo }}" alt="Imagem" sizes="100vw" srcset="{{ $local->logo }}" />
                </div>

                <div class="flex flex-col gap-4 px-4 pb-6 pt-0 lg:px-6 lg:pt-6 max-w-md">
                    <div class="flex justify-between gap-4">
                        <h1 class="text-2xl lg:text-4xl text-gray-info font-bold">{{ $local->local }}</h1>
                    </div>

                    <div class="flex items-center gap-x-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="none" stroke="#303030" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-map">
                            <path
                                d="M14.106 5.553a2 2 0 0 0 1.788 0l3.659-1.83A1 1 0 0 1 21 4.619v12.764a1 1 0 0 1-.553.894l-4.553 2.277a2 2 0 0 1-1.788 0l-4.212-2.106a2 2 0 0 0-1.788 0l-3.659 1.83A1 1 0 0 1 3 19.381V6.618a1 1 0 0 1 .553-.894l4.553-2.277a2 2 0 0 1 1.788 0z">
                            </path>
                            <path d="M15 5.764v15"></path>
                            <path d="M9 3.236v15"></path>
                        </svg>
                        <h2 class="text-gray-info text-base"><span class="font-bold">Bairro:</span> {{ $local->bairro }}</h2>
                    </div>

                    <div class="flex items-center gap-x-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="none" stroke="#303030" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-map-pin">
                            <path d="M20 10c0 4.993-5.539 10.193-7.399 11.799a1 1 0 0 1-1.202 0C9.539 20.193 4 14.993 4 10a8 8 0 0 1 16 0"></path>
                            <circle cx="12" cy="10" r="3"></circle>
                        </svg>
                        <h2 class="text-gray-info text-base"><span class="font-bold">Cidade:</span> {{ $local->cidade }}-{{ $local->estado }}</h2>
                    </div>
                    <div class="lg:flex items-center justify-between mt-2 hidden" style="width: 222px">
                        <button id="btn-comprar" type="button" class="bg-primary-green w-full flex hover:bg-primary-green/90 rounded-full px-12 py-[0.6rem]">
                            <span class="text-center text-green-light">Comprar Ingresso</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div id="rolar_pagina"></div>

        <div class=" relative bg-primary-white px-4 md:px-12  4xl:w-[70%] 4xl:mx-auto ">
            <section class="w-full mt-8 gap-8 grid grid-cols-2 md:grid-cols-4 3xl:grid-cols-5 pb-16">
                @foreach ($local->Eventos->where('status', 'Ativo')->where('data_fim', '>', NOW()) as $e)
                    @php
                        $titulo = $e->titulo ?? ($e['titulo'] ?? 'Evento sem título');
                        $url = $e->url ?? ($e['url'] ?? '#');
                        $img = $e->banner ?? ($e['banner'] ?? ($e->capa ?? ($e['capa'] ?? ($e->imagem ?? ($e['imagem'] ?? '')))));
                        $dataBr = $e->data ?? ($e['data'] ?? ($e->data_inicio ?? ($e['data_inicio'] ?? ($e->inicio ?? ($e['inicio'] ?? null)))));
                        $dataFmt = $dataBr ? \Carbon\Carbon::parse($dataBr)->locale('pt_BR')->isoFormat('ddd, DD [de] MMM') : 'Data em breve';
                        $dataFmt = mb_strtoupper($dataFmt, 'UTF-8');
                    @endphp
                    <a href="{{ route('site.evento', [$e->url, $e->id]) }}">
                        <div class="rounded-2xl border border-gray-border flex flex-col h-full group cursor-pointer">
                            <div class="relative rounded-t-xl overflow-hidden object-cover bg-cover md:h-80 h-40">
                                <img class="rounded-t-xl object-cover shadow-lg transition-transform duration-500 ease-in-out group-hover:scale-105 w-full h-full" src="{{ $img ?: url('site/images/placeholder-evento.webp') }}" alt="{{ $titulo }}"
                                    loading="lazy" />
                            </div>
                            <div class="px-4 pb-4 pt-2 h-[60%] md:h-[35%] 4xl:h-[40%] flex flex-col">
                                <h1 class="text-xl font-bold mt-2 text-primary-musa line-clamp-2 group-hover:text-tertiary-green transition-colors duration-500">{{ $titulo }}</h1>
                                <div class="flex flex-col mt-auto">
                                    <div class="flex items-center gap-2 mt-2">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                            class="lucide lucide-calendar-days text-gray-light">
                                            <path d="M8 2v4"></path>
                                            <path d="M16 2v4"></path>
                                            <rect width="18" height="18" x="3" y="4" rx="2"></rect>
                                            <path d="M3 10h18"></path>
                                        </svg>
                                        <p class="text-sm text-gray-dark">{{ $dataFmt }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </a>
                @endforeach
            </section>
        </div>

        <div class="w-full p-6 bg-[#e9e9e9] rounded-2xl md:mb-5 mt-6 md:mt-0">
            <h2 class="font-bold text-[#2c2c2c] text-2xl md:text-3xl mb-4">Localização </h2>
            <iframe class="rounded-2xl" id="map" width="100%" height="600px" frameborder="0" style="border:0" src="https://www.google.com/maps?q={{ urlencode($local->endereco_site) }}&output=embed" allowfullscreen></iframe>
        </div>
        @include('site.footer')
    </main>
@endsection

@section('js')
    <script>
        (function() {
            'use strict';

            (function bindScrollComprar() {
                const btn = document.getElementById('btn-comprar');
                const tgt = document.getElementById('rolar_pagina');
                if (!btn || !tgt || typeof tgt.scrollIntoView !== 'function') return;

                btn.addEventListener('click', (e) => {
                    e.preventDefault();
                    try {
                        tgt.scrollIntoView({
                            behavior: 'smooth',
                            block: 'start'
                        });
                    } catch (err) {
                        console.error(err);
                    }
                });
            })();

        })(); // <-- faltava isto
    </script>
@endsection
