@extends('site.base')
@section('titulo', 'Todos os Eventos | Garanta seus Ingressos 🎟️ na Musa Ticket')
@section('description', 'Confira todos os eventos disponíveis na Musa Ticket! Garanta seus ingressos para festas, shows, festivais e experiências exclusivas em Salvador e região. Compra segura e rápida.')
@section('url', route('site.eventos'))
@section('image', url('site/images/favicon.png'))
@section('application_ld_json')
    <script type="application/ld+json">
{!! json_encode([
    '@context' => 'https://schema.org',
    '@graph' => $Eventos->map(function ($evento) {
        return [
            '@type' => 'Event',
            'name' => $evento->titulo,
            'startDate' => \Carbon\Carbon::parse($evento->data_inicio)->toIso8601String(),
            'endDate' => \Carbon\Carbon::parse($evento->data_fim)->toIso8601String(),
            'eventAttendanceMode' => 'https://schema.org/OfflineEventAttendanceMode',
            'eventStatus' => 'https://schema.org/EventScheduled',
            'location' => [
                '@type' => 'Place',
                'name' => $evento->local,
                'address' => [
                    '@type' => 'PostalAddress',
                    'streetAddress'   => $evento->endereco_site,
                    'addressLocality' => $evento->cidade,
                    'addressRegion'   => $evento->estado,
                    'addressCountry'  => 'BR',
                ],
            ],
            'organizer' => [
                '@type' => 'Organization',
                'name' => 'Bamor Nova Era',
                'url'  => 'https://musaticket.com.br',
            ],
            'image' => [$evento->banner],
            'description' => strip_tags($evento->descricao ?? ''),
            'offers' => [
                '@type' => 'Offer',
                'url'   => route('site.evento', [$evento->url, $evento->id]),
                'price' => moeda2($evento->Pacotes->first()?->preco ?? 0),
                'priceCurrency' => 'BRL',
                'availability'  => 'https://schema.org/InStock',
                'validFrom'     => \Carbon\Carbon::parse($evento->Pacotes->first()?->data_inicio ?? $evento->data_inicio)->toIso8601String(),
            ],
            'performer' => [
                '@type' => 'PerformingGroup',
                'name'  => $evento->artistas ?? 'Atrações confirmadas',
            ],
        ];
    })
], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT) !!}
</script>

@endsection
@section('content')
    <div class="pt-[64px]">
        <div class=" relative bg-primary-white px-4 md:px-12  4xl:w-[70%] 4xl:mx-auto">
            <div class="flex  flex-col pt-6 md:pt-10 w-full">
                <div class="my-4">
                    <h1 class="font-bold text-2xl md:text-3xl text-primary-green">Todos os eventos</h1>
                </div>
                <div class="flex flex-col md:flex-row justify-between gap-4 md:gap-8  w-full">
                    <div class="w-full">
                        <div class="relative h-full  w-auto"><input
                                class="bg-[#dee6e5] w-full md:h-10 h-11 px-4  rounded-full text-tertiary-green text-base font-normal leading-none focus:outline-none placeholder:text-tertiary-green focus:bg-green-light/60" placeholder="Nome do evento"
                                type="text">
                            <div class="absolute right-3 top-1/2 transform -translate-y-1/2">
                                <span class="">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                        class="lucide lucide-party-popper absolute right-1 top-1/2 transform -translate-y-1/2 text-tertiary-green">
                                        <path d="M5.8 11.3 2 22l10.7-3.79"></path>
                                        <path d="M4 3h.01"></path>
                                        <path d="M22 8h.01"></path>
                                        <path d="M15 2h.01"></path>
                                        <path d="M22 20h.01"></path>
                                        <path d="m22 2-2.24.75a2.9 2.9 0 0 0-1.96 3.12c.1.86-.57 1.63-1.45 1.63h-.38c-.86 0-1.6.6-1.76 1.44L14 10"></path>
                                        <path d="m22 13-.82-.33c-.86-.34-1.82.2-1.98 1.11c-.11.7-.72 1.22-1.43 1.22H17"></path>
                                        <path d="m11 2 .33.82c.34.86-.2 1.82-1.11 1.98C9.52 4.9 9 5.52 9 6.23V7"></path>
                                        <path d="M11 13c1.93 1.93 2.83 4.17 2 5-.83.83-3.07-.07-5-2-1.93-1.93-2.83-4.17-2-5 .83-.83 3.07.07 5 2Z"></path>
                                    </svg>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="w-full">
                        <div class="relative h-full  w-auto">
                            <input class="bg-[#dee6e5] w-full md:h-10 h-11 px-4  rounded-full text-tertiary-green text-base font-normal leading-none focus:outline-none placeholder:text-tertiary-green focus:bg-green-light/60" placeholder="Cidade"
                                type="text">
                            <div class="absolute right-3 top-1/2 transform -translate-y-1/2">
                                <span class="">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                        class="lucide lucide-map-pin absolute right-1 top-1/2 transform -translate-y-1/2 text-tertiary-green">
                                        <path d="M20 10c0 4.993-5.539 10.193-7.399 11.799a1 1 0 0 1-1.202 0C9.539 20.193 4 14.993 4 10a8 8 0 0 1 16 0"></path>
                                        <circle cx="12" cy="10" r="3"></circle>
                                    </svg>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="relative w-full">
                        <div class="react-datepicker-wrapper">
                            <div class="react-datepicker__input-container">
                                <input placeholder="Selecione a data"
                                    class="w-full  px-4  rounded-full text-tertiary-green text-base font-normal leading-none focus:outline-none placeholder:text-tertiary-green focus:bg-green-light/60 bg-[#dee6e5] md:h-10 h-11" type="text"
                                    value="">
                            </div>
                        </div>
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="lucide lucide-calendar-days absolute right-3 top-1/2 transform -translate-y-1/2 text-tertiary-green">
                            <path d="M8 2v4"></path>
                            <path d="M16 2v4"></path>
                            <rect width="18" height="18" x="3" y="4" rx="2"></rect>
                            <path d="M3 10h18"></path>
                            <path d="M8 14h.01"></path>
                            <path d="M12 14h.01"></path>
                            <path d="M16 14h.01"></path>
                            <path d="M8 18h.01"></path>
                            <path d="M12 18h.01"></path>
                            <path d="M16 18h.01"></path>
                        </svg>
                    </div>
                    <div class="w-full">
                        <button type="button" class="bg-primary-green  w-full flex hover:bg-primary-green/90  rounded-full px-4 py-[0.6rem] disabled:bg-disabled disabled:cursor-not-allowed ">
                            <div class="flex items-center w-full  justify-center">
                                <div class=""><span class="text-center text-[#dee6e5]">Pesquisar evento</span></div>
                                <div class="absolute right-3 top-1/2 transform -translate-y-1/2"></div>
                            </div>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class=" relative bg-primary-white px-4 md:px-12  4xl:w-[70%] 4xl:mx-auto ">
            <section class="w-full mt-8 gap-8 grid grid-cols-2 md:grid-cols-4 3xl:grid-cols-5 pb-16">
                @foreach ($Eventos as $e)
                    @php
                        $titulo = $e->titulo ?? ($e['titulo'] ?? 'Evento sem título');
                        $url = $e->url ?? ($e['url'] ?? '#');
                        $img = $e->banner ?? ($e['banner'] ?? ($e->capa ?? ($e['capa'] ?? ($e->imagem ?? ($e['imagem'] ?? '')))));
                        $cidade = $e->cidade ?? ($e['cidade'] ?? '');
                        $uf = $e->estado ?? ($e['estado'] ?? '');
                        $local = $e->local . ' - ' . trim(($cidade ?: '') . ($uf ? ' / ' . $uf : '')) ?: $e->local ?? ($e['local'] ?? 'Local a definir');
                        $dataBr = $e->data ?? ($e['data'] ?? ($e->data_inicio ?? ($e['data_inicio'] ?? ($e->inicio ?? ($e['inicio'] ?? null)))));
                        $dataFmt = $dataBr ? \Carbon\Carbon::parse($dataBr)->locale('pt_BR')->isoFormat('ddd, DD [de] MMM') : 'Data em breve';
                        $dataFmt = mb_strtoupper($dataFmt, 'UTF-8');
                    @endphp
                    <a href="{{ route('site.evento', [$e->url, $e->id]) }}">
                        <div class="rounded-2xl border border-gray-border flex flex-col h-full group cursor-pointer">
                            <div class="relative rounded-t-xl overflow-hidden object-cover bg-cover md:h-80 h-40">
                                <img class="rounded-t-xl object-cover shadow-lg transition-transform duration-500 ease-in-out group-hover:scale-105 w-full h-full" src="{{ $img ?: url('site/images/placeholder-evento.webp') }}" alt="{{ $titulo }}"
                                    loading="lazy" />
                            </div>
                            <div class="px-4 pb-4 pt-2 h-[60%] md:h-[35%] 4xl:h-[40%] flex flex-col">
                                <h1 class="text-xl font-bold mt-2 text-primary-musa line-clamp-2 group-hover:text-tertiary-green transition-colors duration-500">{{ $titulo }}</h1>
                                <div class="flex flex-col mt-auto">
                                    <div class="mt-2 mb-1 gap-2 flex items-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                            class="lucide lucide-map-pin text-gray-light">
                                            <path d="M20 10c0 4.993-5.539 10.193-7.399 11.799a1 1 0 0 1-1.202 0C9.539 20.193 4 14.993 4 10a8 8 0 0 1 16 0"></path>
                                            <circle cx="12" cy="10" r="3"></circle>
                                        </svg>
                                        <p class="text-sm text-gray-dark uppercase">{{ $local }}</p>
                                    </div>
                                    <div class="flex items-center gap-2 mt-2">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                            class="lucide lucide-calendar-days text-gray-light">
                                            <path d="M8 2v4"></path>
                                            <path d="M16 2v4"></path>
                                            <rect width="18" height="18" x="3" y="4" rx="2"></rect>
                                            <path d="M3 10h18"></path>
                                        </svg>
                                        <p class="text-sm text-gray-dark">{{ $dataFmt }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </a>
                @endforeach
            </section>
        </div>
    </div>
@endsection
