 <div class="grid grid-cols-2 lg:grid-cols-4 gap-4 mt-5 transition-all duration-500 ease-in">
     @forelse ($Eventos as $e)
         @php
             $titulo = $e->titulo ?? ($e['titulo'] ?? 'Evento sem título');
             $url = $e->url ?? ($e['url'] ?? '#');
             $img = $e->banner ?? ($e['banner'] ?? ($e->capa ?? ($e['capa'] ?? ($e->imagem ?? ($e['imagem'] ?? '')))));
             $cidade = $e->cidade ?? ($e['cidade'] ?? '');
             $uf = $e->estado ?? ($e['estado'] ?? '');
             $local = $e->local . ' - ' . trim(($cidade ?: '') . ($uf ? ' / ' . $uf : '')) ?: $e->local ?? ($e['local'] ?? 'Local a definir');
             $dataBr = $e->data ?? ($e['data'] ?? ($e->data_inicio ?? ($e['data_inicio'] ?? ($e->inicio ?? ($e['inicio'] ?? null)))));
             $dataFmt = $dataBr ? \Carbon\Carbon::parse($dataBr)->locale('pt_BR')->isoFormat('ddd, DD [de] MMM') : 'Data em breve';
             $dataFmt = mb_strtoupper($dataFmt, 'UTF-8');
         @endphp
         <a href="{{ route('site.evento', [$e->url, $e->id]) }}">
             <div class="rounded-2xl border border-gray-border flex flex-col h-full group cursor-pointer">
                 <div class="relative rounded-t-xl overflow-hidden object-cover bg-cover md:h-80 h-40">
                     <img class="rounded-t-xl object-cover shadow-lg transition-transform duration-500 ease-in-out group-hover:scale-105 w-full h-full" src="{{ $img ?: url('site/images/placeholder-evento.webp') }}" alt="{{ $titulo }}"
                         loading="lazy" />
                 </div>
                 <div class="px-4 pb-4 pt-2 h-[60%] md:h-[35%] 4xl:h-[40%] flex flex-col">
                     <h1 class="text-xl font-bold mt-2 text-primary-musa line-clamp-2 group-hover:text-tertiary-green transition-colors duration-500">{{ $titulo }}</h1>
                     <div class="flex flex-col mt-auto">
                         <div class="mt-2 mb-1 gap-2 flex items-center">
                             <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                 class="lucide lucide-map-pin text-gray-light">
                                 <path d="M20 10c0 4.993-5.539 10.193-7.399 11.799a1 1 0 0 1-1.202 0C9.539 20.193 4 14.993 4 10a8 8 0 0 1 16 0"></path>
                                 <circle cx="12" cy="10" r="3"></circle>
                             </svg>
                             <p class="text-sm text-gray-dark uppercase">{{ $local }}</p>
                         </div>
                         <div class="flex items-center gap-2 mt-2">
                             <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                 class="lucide lucide-calendar-days text-gray-light">
                                 <path d="M8 2v4"></path>
                                 <path d="M16 2v4"></path>
                                 <rect width="18" height="18" x="3" y="4" rx="2"></rect>
                                 <path d="M3 10h18"></path>
                             </svg>
                             <p class="text-sm text-gray-dark">{{ $dataFmt }}</p>
                         </div>
                     </div>
                 </div>
             </div>
         </a>
     @empty
         <div class="col-span-2 lg:col-span-4">
             <p class="text-gray-dark">Nenhum evento encontrado.</p>
         </div>
     @endforelse
