<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <meta name="robots" content="noindex, nofollow">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Musa Ticket</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            display: flex;
            flex-direction: column;
            align-items: center;
            margin: 0;
            padding: 0;
        }

        .ticket {
            width: 380px;
            height: 600px;
            border: 1px solid black;
            padding: 20px;
            text-align: center;
            position: relative;
            background-image: url('{{ url('vendas/images/ingresso.jpg') }}');
            background-size: contain;
            background-repeat: no-repeat;
            background-position: center;
            margin-bottom: 30px;
        }

        .logo {
            width: 80px;
            margin-bottom: 10px;
        }

        h2,
        h3,
        p {
            margin: 5px 0;
        }

        .price {
            font-size: 24px;
            font-weight: bold;
            margin-top: 20px;
        }

        .info-qr-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: absolute;
            bottom: 20px;
            left: 40px;
            right: 40px;
        }

        .price-info {
            text-align: left;
        }

        .qr-code img {
            width: 100px;
        }

        .person-info {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            margin-top: 30px;
        }

        .titulo1 {
            font-size: 20px;
            font-weight: bold;
        }

        .evento_titulo {
            font-size: 18px;
            font-weight: bold;
        }

        .text {
            font-size: 16px;
            font-weight: 600;
        }

        .evento {
            margin-top: 20px;
        }

        /* Quebra de página para impressão */
        .ticket {
            page-break-after: always;
        }

        @media print {
            * {
                -webkit-print-color-adjust: exact;
                color-adjust: exact;
                /* Para navegadores que suportam */
            }
        }

        .cancelado-overlay {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-50deg);
            font-size: 70px;
            color: red;
            font-weight: bold;
            opacity: 0.4;
            white-space: nowrap;
            pointer-events: none;
            z-index: 10;
        }
    </style>

    <meta property="og:title" content="{{ $pedido->Evento->titulo }}" />
    <meta property="og:description" content="{{ lmword($pedido->Evento->descricao, 180) }}" />
    <meta property="og:image" content="{{ $pedido->Evento->banner }}" />
    <meta property="og:image:width" content="954" />
    <meta property="og:image:height" content="500" />
</head>

<body>
    <div class="ticket">
        @if ($ingresso->status == '2')
            <div class="cancelado-overlay">CANCELADO</div>
        @elseif ($ingresso->status == '0')
            <div class="cancelado-overlay">PENDENTE</div>
        @endif
        <img src="{{ url('vendas/images/favicon.png') }}" alt="Musa Logo" class="logo">
        <h2>Musa Ticket</h2>
        <p>{{ $ingresso->code_barras }}</p>
        <p>CNPJ: {{ env('CNPJ') }}</p>
        <div class="evento">
            <h3 class="titulo1">{{ $ingresso->Evento->titulo }}</h3>
            <p class="text">
                {{ substr($semana[date('w', strtotime($ingresso->Evento->data_inicio))], 0, 4) }}, {{ date('d', strtotime($ingresso->Evento->data_inicio)) }} de
                {{ $mes[date('m', strtotime($ingresso->Evento->data_inicio))] }} de {{ date('Y', strtotime($ingresso->Evento->data_inicio)) }} às
                {{ date('H:i', strtotime($ingresso->Evento->data_inicio)) }} <br>
                {{ $ingresso->Evento->local }} <br>
                {{-- {{ $ingresso->Evento->endereco }}, {{ $ingresso->Evento->numero }}, {{ $ingresso->Evento->bairro }}, {{ $ingresso->Evento->cidade }}-{{ $ingresso->Evento->estado }} --}}
            </p>
        </div>
        <div class="person-info">
            <h3 class="evento_titulo">{{ $ingresso->Pacote->nome }}</h3>
            <p class="text">
                {!! $ingresso->qr_code !!}
                <br>
            <h3 class="evento_titulo">R$ {{ moeda($ingresso->valor_final) }}</h3>
            </p>
        </div>
        <div class="info-qr-container">
            <div class="price-info">
                <p class="evento_titulo">{{ $ingresso->nome_completo }}</p>
                <img src="{{ $ingresso->barcode_img }}" alt="Código de Barras" width="100%">
            </div>
        </div>
        <p>{{ $pedido->Evento->mensagem_ingresso }}</p>
    </div>
</body>

</html>
