<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <title>Monitoramento de Acessos</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <style>
        /* estilos iguais aos anteriores */
        * {
            box-sizing: border-box;
        }

        html,
        body {
            margin: 0;
            padding: 0;
            height: 100%;
            width: 100%;
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
        }

        h2 {
            text-align: center;
            margin: 20px 0;
        }

        .table-container {
            width: 100%;
            height: calc(100% - 80px);
            padding: 15px;
            overflow-x: auto;
            overflow-y: auto;
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            margin: 0 auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            min-width: 700px;
        }

        th,
        td {
            padding: 12px 15px;
            border-bottom: 1px solid #ccc;
            word-break: break-word;
        }

        th {
            background-color: #343a40;
            color: #fff;
        }

        tr:hover {
            background-color: #f1f1f1;
        }

        @media (max-width: 768px) {
            h2 {
                font-size: 20px;
            }

            table {
                font-size: 14px;
            }
        }
    </style>

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
</head>

<body>

    <h2>Relatório de Monitoramento</h2>

    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Nome</th>
                    <th>Evento</th>
                    <th style="width: 25%">URL</th>
                    <th>Views</th>
                    <th>Data</th>
                </tr>
            </thead>
            <tbody id="conteudo-monitoramento">
                <tr>
                    <td colspan="7">Carregando dados...</td>
                </tr>
            </tbody>
        </table>
    </div>

    <script>
        function TempoReal() {
            $.ajax({
                url: "{{ route('monitoramento.dados') }}",
                method: 'GET',
                success: function(result) {
                    let html = '';
                    result.forEach(item => {
                        html += `
                            <tr>
                                <td>${item.id}</td>
                                <td>${item.nome}</td>
                                <td>${item.evento}</td>
                                <td><a href="${item.url}" target="_blank">${item.url}</a></td>
                                <td>${item.views}</td>
                                <td>${item.data}</td>
                            </tr>
                        `;
                    });
                    $('#conteudo-monitoramento').html(html);
                },
                error: function(xhr) {
                    console.error('Erro ao carregar dados');
                }
            });
        }

        TempoReal(); // carregamento inicial
        setInterval(TempoReal, 5000); // atualiza a cada 5s
    </script>

</body>

</html>
