<!DOCTYPE html>
<html>

<head>
    <title></title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <style type="text/css">
        /* FONTS */
        @import url('https://fonts.googleapis.com/css?family=Poppins:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i');

        /* CLIENT-SPECIFIC STYLES */
        body, table, td, a { -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100%; }
        table, td { mso-table-lspace: 0pt; mso-table-rspace: 0pt; }
        img { -ms-interpolation-mode: bicubic; }

        /* RESET STYLES */
        img { border: 0; height: auto; line-height: 100%; outline: none; text-decoration: none; }
        table { border-collapse: collapse !important; }
        body { height: 100% !important; margin: 0 !important; padding: 0 !important; width: 100% !important; }

        /* iOS BLUE LINKS */
        a[x-apple-data-detectors] {
            color: inherit !important;
            text-decoration: none !important;
            font-size: inherit !important;
            font-family: inherit !important;
            font-weight: inherit !important;
            line-height: inherit !important;
        }

        /* MOBILE STYLES */
        @media screen and (max-width:600px){
            h1 {
                font-size: 32px !important;
                line-height: 32px !important;
            }
        }

        /* ANDROID CENTER FIX */
        div[style*="margin: 16px 0;"] { margin: 0 !important; }
    </style>
    </head>
    <body style="background-color: #f3f5f7; margin: 0 !important; padding: 0 !important;">

    <!-- HIDDEN PREHEADER TEXT -->
    <div style="display: none; font-size: 1px; color: #fefefe; line-height: 1px; font-family: 'Poppins', sans-serif; max-height: 0px; max-width: 0px; opacity: 0; overflow: hidden;">
        {{ $qtd == 1 ? 'Seu Ingresso' : 'Seus Ingressos'}} para {{ $evento }} já estão disponíveis.
    </div>

    <table border="0" cellpadding="0" cellspacing="0" width="100%">
        <tr>
            <td align="center" style="padding: 0px 10px 0px 10px;">
                <table border="0" cellpadding="0" cellspacing="0" width="100%" style="max-width: 600px;">
                    <tbody>
                        <tr bgcolor="#282828" style="margin: 0; padding: 0;">
                            <td align="center" style="color: #666666; font-family: 'Poppins', sans-serif; font-size: 16px; font-weight: 400; padding: 0;">
                                <img src="https://musaticket.com.br/site/images/logo-branca.png" width="250">
                            </td>
                        </tr>
                        <tr style="margin: 0; padding: 0;">
                            <td align="left" style="color: #666666; font-family: 'Poppins', sans-serif; font-size: 16px; font-weight: 400; padding: 0;">
                                <p style="text-align: center; margin: 0;"><img src="{{ url("storage/{$banner}") }}" width="100%"></p>
                                <p style="font-weight: bold; font-size: 20px; margin: 0 30px;">{{ $evento }}</p>
                            </td>
                        </tr>
                        <tr>
                            <td bgcolor="#ffffff" align="left" style="padding: 20px 30px 20px 30px; color: #666666; font-family: 'Poppins', sans-serif; font-size: 16px; font-weight: 400;">
                                <p style="margin: 0;">
                                    Olá <strong>{{ $name }}</strong>! <br>
                                    Esta é uma confirmação de pagamento <strong>{{ $ref }}</strong></strong>.
                                    <br><br>
                                    ACESSE A ÁREA DO CLIENTE PARA EMISSÃO DE SEUS INGRESSOS.<br>
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td align="center" style="border-radius: 3px;" bgcolor="#FFF">
                                <a href="https://musaticket.com.br/cliente/ingressos" target="_blank" style="background: #282828; font-size: 16px; font-family: Helvetica, Arial, sans-serif; color: #ffffff; text-decoration: none; padding: 8px 20px; border-radius: 3px; border: 1px solid #282828; display: inline-block;">Ver Ingressos</a>
                            </td>
                        </tr>
                        <tr>
                            <td bgcolor="#ffffff" align="left"
                                style="padding: 0px 30px 20px 30px; color: #666666; font-family: &apos;Lato&apos;, Helvetica, Arial, sans-serif; font-size: 16px; font-weight: 400; line-height: 25px;">
                                <p style="margin: 0;">Esta é uma mensagem automática de nosso sistema, você não precisa responder.</p>
                            </td>
                        </tr>
                        <tr>
                            <td bgcolor="#ffffff" align="left"
                                style="padding: 0px 30px 40px 30px; border-radius: 0px 0px 0px 0px; color: #666666; font-family: 'Poppins', sans-serif; font-size: 14px; font-weight: 400; line-height: 25px;">
                                <p style="margin: 0;">Atenciosamente,<br>{{ env('APP_NAME') }}</p>
                            </td>
                        </tr>
                    </tbody>
                </table>
        </tr>

        <tr>
            <td align="center" style="padding: 0 10px 50px 10px;">
                <!--[if (gte mso 9)|(IE)]>
            <table align="center" border="0" cellspacing="0" cellpadding="0" width="600">
            <tr>
            <td align="center" valign="top" width="600">
            <![endif]-->
                <table border="0" cellpadding="0" cellspacing="0" width="100%" style="max-width: 600px;">
                    <tr>
                        <td bgcolor="#ffffff" align="left"
                            style="padding: 0px 30px 30px 30px; color: #aaaaaa; font-family: 'Poppins', sans-serif; font-size: 12px; font-weight: 400; line-height: 18px;">
                            <p style="margin: 0;">Você recebeu este e-mail porque é nosso associado.</p>
                        </td>
                    </tr>
                    <!-- UNSUBSCRIBE -->
                    <tr>
                        <td bgcolor="#ffffff" align="left"
                            style="padding: 0px 30px 30px 30px; color: #aaaaaa; font-family: 'Poppins', sans-serif; font-size: 12px; font-weight: 400; line-height: 18px;">
                            <p style="margin: 0;">{{ env('ENDERECO') }}</p>
                        </td>
                    </tr>
                    <!-- COPYRIGHT -->
                    <tr>
                        <td align="center" style="padding: 30px 30px 30px 30px; color: #333333; font-family: 'Poppins', sans-serif; font-size: 12px; font-weight: 400; line-height: 18px;">
                            <p style="margin: 0;">Copyright © {{ date('Y') }} {{ env('APP_NAME') }}. Todos os direitos reservados.</p>
                        </td>
                    </tr>
                </table>
                <!--[if (gte mso 9)|(IE)]>
            </td>
            </tr>
            </table>
            <![endif]-->
            </td>
        </tr>
    </table>

</body>

</html>
