@props(['vendidos' => 0, 'total' => 0])

@php
    $percentual = $total > 0 ? round(($vendidos / $total) * 100, 1) : 0;

    if ($percentual >= 80) {
        $corBarra = 'linear-gradient(90deg, #16a34a, #22c55e)'; // Verde
        $textoStatus = '🔥 Quase esgotado!';
        $corTexto = 'text-green-700';
    } elseif ($percentual >= 50) {
        $corBarra = 'linear-gradient(90deg, #eab308, #facc15)'; // Amarelo
        $textoStatus = '🎟️ Vendas aceleradas!';
        $corTexto = 'text-yellow-600';
    } elseif ($percentual >= 30) {
        $corBarra = 'linear-gradient(90deg, #f97316, #fb923c)'; // Laranja
        $textoStatus = '🚀 Vendas em andamento';
        $corTexto = 'text-orange-600';
    } else {
        $corBarra = 'linear-gradient(90deg, #dc2626, #ef4444)'; // Vermelho
        $textoStatus = '💤 Início das vendas';
        $corTexto = 'text-red-600';
    }
@endphp

<div class="mt-2 mb-2">
    {{-- Texto de status --}}
    <p class="text-xs font-semibold {{ $corTexto }} mb-1">{{ $textoStatus }}</p>

    <div class="relative w-full bg-red-500 rounded-full h-2.5 overflow-hidden shadow-inner">
        <div class="h-2.5 rounded-full transition-all duration-700 ease-out" style="width: {{ $percentual }}%; background: {{ $corBarra }};">

        </div>

        {{-- Números dentro da barra --}}
        <div class="absolute inset-0 flex justify-between items-center text-[10px] font-semibold px-1">
            <span style="color: #000">{{ $vendidos }} / {{ $total }}</span>
            <span style="color: #000">{{ $percentual }}%</span>
        </div>
    </div>
</div>
