@extends('site.base')
@section('titulo', 'Meus dados')

@section('content')
    <main id="page_content">
        <div class="hero" style="background-image:url({{ url('site') }}/images/banner/event.jpg)"></div>
        <div class="under-hero container">
            <div class="section">
                <div class="row">
                    <div class="col-xl-12 col-md-10 mx-auto">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="mb-0">Meus dados</h4>
                                <small class="text-muted">Atualize seus dados pessoais, endereço, e-mail e senha.</small>
                            </div>

                            <div class="card-body">
                                {{-- ======================= FORM 1: DADOS / ENDEREÇO / E-MAIL ======================= --}}
                                <form action="{{ route('dados.update') }}" method="POST" class="row" id="editForm" novalidate>
                                    @csrf

                                    {{-- DADOS PESSOAIS --}}
                                    <div class="col-12">
                                        <h5 class="mt-2 mb-3">Dados pessoais</h5>
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <label for="nome">Nome Completo</label>
                                        <input type="text" class="form-control @error('nome') is-invalid @enderror" id="nome" name="nome" value="{{ old('nome', trim((Auth::user()->name ?? '') . ' ' . (Auth::user()->sobrenome ?? ''))) }}"
                                            required>
                                        @error('nome')
                                            <div class="invalid-feedback d-block">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <label for="nascimento">Data de Nascimento</label>
                                        <input type="date" class="form-control @error('nascimento') is-invalid @enderror" id="nascimento" name="nascimento" value="{{ old('nascimento', Auth::user()->nascimento) }}" required>
                                        @error('nascimento')
                                            <div class="invalid-feedback d-block">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <label for="cpf">CPF</label>
                                        <input disabled type="text" class="form-control @error('cpf') is-invalid @enderror" id="cpf" name="cpf" value="{{ old('cpf', Auth::user()->cpf) }}" placeholder="000.000.000-00" required
                                            data-original="{{ preg_replace('/\D/', '', Auth::user()->cpf ?? '') }}">
                                        <small id="cpfHelp" class="text-muted"></small>
                                        @error('cpf')
                                            <div class="invalid-feedback d-block">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <label for="rg">RG</label>
                                        <input type="text" class="form-control @error('rg') is-invalid @enderror" id="rg" name="rg" value="{{ old('rg', Auth::user()->rg) }}" required>
                                        @error('rg')
                                            <div class="invalid-feedback d-block">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <label for="celular">Celular (WhatsApp)</label>
                                        <input type="tel" class="form-control @error('celular') is-invalid @enderror" id="celular" name="celular" value="{{ old('celular', Auth::user()->celular) }}" placeholder="(00) 00000-0000" required
                                            data-original="{{ preg_replace('/\D/', '', Auth::user()->celular ?? '') }}">
                                        <small id="celularHelp" class="text-muted"></small>
                                        @error('celular')
                                            <div class="invalid-feedback d-block">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <label>Sexo</label><br>
                                        <div class="toggle-group @error('sexo') is-invalid @enderror">
                                            <input type="radio" id="masculino" name="sexo" value="Masculino" {{ old('sexo', Auth::user()->sexo ?? 'Masculino') === 'Masculino' ? 'checked' : '' }} required>
                                            <label for="masculino">Masculino</label>
                                            <input type="radio" id="feminino" name="sexo" value="Feminino" {{ old('sexo', Auth::user()->sexo) === 'Feminino' ? 'checked' : '' }}>
                                            <label for="feminino">Feminino</label>
                                        </div>
                                        @error('sexo')
                                            <div class="invalid-feedback d-block">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    {{-- ENDEREÇO --}}
                                    <div class="col-12">
                                        <h5 class="mt-4 mb-3">Endereço</h5>
                                    </div>

                                    <div class="col-md-4 mb-4">
                                        <label for="cep">CEP</label>
                                        <input type="text" class="form-control @error('cep') is-invalid @enderror" id="cep" name="cep" value="{{ old('cep', Auth::user()->cep) }}" placeholder="00000-000" required>
                                        <small id="cepHelp" class="text-muted"></small>
                                        @error('cep')
                                            <div class="invalid-feedback d-block">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-md-8 mb-4">
                                        <label for="endereco">Endereço</label>
                                        <input type="text" class="form-control @error('endereco') is-invalid @enderror" id="endereco" name="endereco" value="{{ old('endereco', Auth::user()->endereco) }}" required>
                                        @error('endereco')
                                            <div class="invalid-feedback d-block">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-md-4 mb-4">
                                        <label for="numero">Número</label>
                                        <input type="text" class="form-control @error('numero') is-invalid @enderror" id="numero" name="numero" value="{{ old('numero', Auth::user()->numero) }}" required>
                                        @error('numero')
                                            <div class="invalid-feedback d-block">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-md-8 mb-4">
                                        <label for="complemento">Complemento (opcional)</label>
                                        <input type="text" class="form-control @error('complemento') is-invalid @enderror" id="complemento" name="complemento" value="{{ old('complemento', Auth::user()->complemento) }}">
                                        @error('complemento')
                                            <div class="invalid-feedback d-block">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-md-4 mb-4">
                                        <label for="bairro">Bairro</label>
                                        <input type="text" class="form-control @error('bairro') is-invalid @enderror" id="bairro" name="bairro" value="{{ old('bairro', Auth::user()->bairro) }}" required>
                                        @error('bairro')
                                            <div class="invalid-feedback d-block">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <label for="cidade">Cidade</label>
                                        <input type="text" class="form-control @error('cidade') is-invalid @enderror" id="cidade" name="cidade" value="{{ old('cidade', Auth::user()->cidade) }}" required>
                                        @error('cidade')
                                            <div class="invalid-feedback d-block">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-md-2 mb-4">
                                        <label for="estado">UF</label>
                                        <input type="text" class="form-control @error('estado') is-invalid @enderror" id="estado" name="estado" maxlength="2" style="text-transform:uppercase"
                                            value="{{ old('estado', Auth::user()->estado) }}" required>
                                        @error('estado')
                                            <div class="invalid-feedback d-block">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    {{-- ACESSO (E-MAIL) --}}
                                    <div class="col-12">
                                        <h5 class="mt-4 mb-3">Acesso</h5>
                                    </div>
                                    <div class="col-md-12 mb-4">
                                        <label for="email">E-mail</label>
                                        <input type="email" class="form-control @error('email') is-invalid @enderror" id="email" name="email" value="{{ old('email', Auth::user()->email) }}" placeholder="seu@email.com" required
                                            data-original="{{ strtolower(Auth::user()->email) }}">
                                        <small id="emailHelp" class="text-muted"></small>
                                        @error('email')
                                            <div class="invalid-feedback d-block">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-12 text-center mt-2">
                                        <button type="submit" class="btn btn-success" id="btnSalvar">Salvar alterações</button>
                                    </div>
                                </form>

                                <hr class="my-4">

                                {{-- ======================= FORM 2: TROCAR SENHA ======================= --}}
                                <form action="{{ route('update.password') }}" method="POST" class="row" id="editPassForm" novalidate>
                                    @csrf
                                    <div class="col-12">
                                        <h5 class="mt-1 mb-3">Alterar senha</h5>
                                    </div>

                                    <div class="col-md-4 mb-4">
                                        <label for="current_password">Senha atual</label>
                                        <input type="password" class="form-control" id="current_password" name="password" required minlength="8">
                                        <small id="curPassHelp" class="text-muted"></small>
                                    </div>

                                    <div class="col-md-4 mb-4">
                                        <label for="new_password">Nova senha</label>
                                        <input type="password" class="form-control" id="new_password" name="password_new" required minlength="8">
                                        <small id="newPassHelp" class="text-muted">Mínimo de 8 caracteres.</small>
                                    </div>

                                    <div class="col-md-4 mb-4">
                                        <label for="new_password_confirmation">Confirmar nova senha</label>
                                        <input type="password" class="form-control" id="new_password_confirmation" name="password_new_confirme" required minlength="8">
                                        <small id="confPassHelp" class="text-muted"></small>
                                    </div>

                                    <div class="col-12 text-center mt-2">
                                        <button type="submit" class="btn btn-primary" id="btnTrocarSenha">Atualizar senha</button>
                                    </div>
                                </form>

                                {{-- feedback geral --}}
                                @if ($errors->any())
                                    <div class="alert alert-danger mt-3">
                                        <strong>Ops!</strong> Verifique os campos destacados e tente novamente.
                                    </div>
                                @endif

                                @if (session('success'))
                                    <div class="alert alert-success mt-3">{{ session('success') }}</div>
                                @endif
                                @if (session('error'))
                                    <div class="alert alert-danger mt-3">{{ session('error') }}</div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
@endsection

@section('css')
    <style>
        .toggle-group {
            display: inline-flex;
            border: 1px solid #ddd;
            border-radius: 10px;
            overflow: hidden
        }

        .toggle-group input[type="radio"] {
            display: none
        }

        .toggle-group label {
            padding: 10px 20px;
            cursor: pointer;
            background: #fff;
            color: #000;
            font-weight: 500;
            transition: all .3s;
            margin-bottom: 0
        }

        .toggle-group label:not(:last-child) {
            border-right: 1px solid #ddd
        }

        .toggle-group input[type="radio"]:checked+label {
            background: #196eed;
            color: #fff;
            font-weight: bold
        }

        .is-valid {
            border-color: #28a745 !important
        }

        .is-invalid {
            border-color: #dc3545 !important
        }
    </style>
@endsection

@section('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script>
        /* ===== Helpers ===== */
        const CSRF = $('meta[name="csrf-token"]').attr('content');
        const IGNORE_ID = {{ (int) Auth::id() }};

        function onlyDigits(v) {
            return (v || '').replace(/\D/g, '');
        }

        function markInvalid($el, helpSel, msg) {
            $el.addClass('is-invalid');
            if (helpSel) $(helpSel).text(msg || 'Campo obrigatório');
        }

        function clearInvalid($el, helpSel) {
            $el.removeClass('is-invalid');
            if (helpSel) $(helpSel).text('');
        }

        function isEmpty($el) {
            return !($el.val() || '').toString().trim();
        }

        /* ===== Máscaras ===== */
        $('#cpf').on('input', function() {
            let v = onlyDigits($(this).val()).slice(0, 11);
            v = v.replace(/(\d{3})(\d)/, '$1.$2').replace(/(\d{3})(\d)/, '$1.$2').replace(/(\d{3})(\d{1,2})$/, '$1-$2');
            $(this).val(v);
        });
        $('#celular').on('input', function() {
            let v = onlyDigits($(this).val()).slice(0, 11);
            if (v.length >= 11) v = v.replace(/(\d{2})(\d{5})(\d{0,4})/, '($1) $2-$3');
            else if (v.length >= 10) v = v.replace(/(\d{2})(\d{4})(\d{0,4})/, '($1) $2-$3');
            else if (v.length > 2) v = v.replace(/(\d{2})(\d{0,5})/, '($1) $2');
            else if (v.length > 0) v = v.replace(/(\d{0,2})/, '($1');
            $(this).val(v);
            clearInvalid($('#celular'), '#celularHelp');
        });
        $('#cep').on('input', function() {
            let v = onlyDigits($(this).val()).slice(0, 8);
            if (v.length > 5) v = v.slice(0, 5) + '-' + v.slice(5);
            $(this).val(v);
        });
        $('#estado').on('input', function() {
            this.value = this.value.toUpperCase().slice(0, 2);
        });

        /* ===== Validações locais ===== */
        function isValidCPF(c) {
            c = onlyDigits(c);
            if (!c || c.length !== 11 || /^(\d)\1+$/.test(c)) return false;
            let s = 0,
                r;
            for (let i = 1; i <= 9; i++) s += parseInt(c.substring(i - 1, i)) * (11 - i);
            r = (s * 10) % 11;
            if (r === 10 || r === 11) r = 0;
            if (r !== parseInt(c.substring(9, 10))) return false;
            s = 0;
            for (let i = 1; i <= 10; i++) s += parseInt(c.substring(i - 1, i)) * (12 - i);
            r = (s * 10) % 11;
            if (r === 10 || r === 11) r = 0;
            return r === parseInt(c.substring(10, 11));
        }

        function isValidEmail(e) {
            return /^[^\s@]+@[^\s@]+\.[^\s@]{2,}$/.test((e || '').toLowerCase());
        }

        function isValidCell(full) {
            const d = onlyDigits(full);
            return d.length === 10 || d.length === 11;
        }

        function extractDDDAndNumber(full) {
            const d = onlyDigits(full);
            return d.length < 10 ? {
                ddd: '',
                numero: ''
            } : {
                ddd: d.slice(0, 2),
                numero: d.slice(2)
            };
        }

        /* ===== ViaCEP (JSONP) ===== */
        $('#cep').on('blur', function() {
            const numCep = onlyDigits($('#cep').val());
            if (numCep.length !== 8) {
                markInvalid($('#cep'), '#cepHelp', 'CEP inválido (8 dígitos).');
                return;
            }
            $('#cepHelp').text('Consultando CEP...');
            $.ajax({
                url: 'https://viacep.com.br/ws/' + numCep + '/json/?callback=?',
                dataType: 'jsonp',
                success: d => {
                    if (d.erro) {
                        markInvalid($('#cep'), '#cepHelp', 'CEP não encontrado.');
                        return;
                    }
                    $('#cep').val(d.cep);
                    $('#endereco').val(d.logradouro);
                    $('#bairro').val(d.bairro);
                    $('#cidade').val(d.localidade);
                    $('#estado').val(d.uf);
                    clearInvalid($('#cep'), '#cepHelp');
                    $('#cep').addClass('is-valid');
                },
                error: () => markInvalid($('#cep'), '#cepHelp', 'Erro ao consultar CEP.')
            });
        });

        /* ===== AJAX unicidade (usar ignore_id no back-end) ===== */
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': CSRF
            }
        });

        // CPF
        let lastCpfChecked = '',
            lastOutcomeCpf = '',
            cpfAjax = null;
        async function validarCpfEdit() {
            const raw = $('#cpf').val() || '',
                digits = onlyDigits(raw);
            if (digits.length < 11 || !isValidCPF(digits)) {
                markInvalid($('#cpf'), '#cpfHelp', 'CPF inválido.');
                return false;
            }
            if (digits === lastCpfChecked && lastOutcomeCpf) {
                return lastOutcomeCpf === 'ok';
            }
            if (digits === ($('#cpf').data('original') || '')) {
                lastCpfChecked = digits;
                lastOutcomeCpf = 'ok';
                clearInvalid($('#cpf'), '#cpfHelp');
                $('#cpf').addClass('is-valid');
                return true;
            }
            if (cpfAjax && cpfAjax.readyState !== 4) cpfAjax.abort();
            try {
                const res = await $.post("{{ route('validar.cpf') }}", {
                    cpf: raw,
                    ignore_id: IGNORE_ID
                });
                lastCpfChecked = digits;
                if (res === 'cpf_error') {
                    lastOutcomeCpf = 'cpf_error';
                    markInvalid($('#cpf'), '#cpfHelp', 'CPF inválido.');
                    return false;
                }
                if (res === 'cpf_exist') {
                    lastOutcomeCpf = 'cpf_exist';
                    markInvalid($('#cpf'), '#cpfHelp', 'Este CPF já está cadastrado.');
                    return false;
                }
                lastOutcomeCpf = 'ok';
                clearInvalid($('#cpf'), '#cpfHelp');
                $('#cpf').addClass('is-valid');
                return true;
            } catch {
                lastOutcomeCpf = '';
                markInvalid($('#cpf'), '#cpfHelp', 'Não foi possível validar o CPF.');
                return false;
            }
        }
        $('#cpf').on('blur', validarCpfEdit);

        // Celular
        let lastPhoneChecked = '',
            lastOutcomePhone = '',
            phoneAjax = null;
        async function validarCelularEdit() {
            const full = $('#celular').val() || '';
            if (!isValidCell(full)) {
                markInvalid($('#celular'), '#celularHelp', 'Informe DDD + número.');
                return false;
            }
            const fullDigits = onlyDigits(full);
            if (fullDigits === lastPhoneChecked && lastOutcomePhone) {
                return lastOutcomePhone === 'ok';
            }
            if (fullDigits === ($('#celular').data('original') || '')) {
                lastPhoneChecked = fullDigits;
                lastOutcomePhone = 'ok';
                clearInvalid($('#celular'), '#celularHelp');
                $('#celular').addClass('is-valid');
                return true;
            }
            const {
                ddd,
                numero
            } = extractDDDAndNumber(full);
            if (!ddd || !numero) {
                markInvalid($('#celular'), '#celularHelp', 'Informe DDD + número.');
                return false;
            }
            if (phoneAjax && phoneAjax.readyState !== 4) phoneAjax.abort();
            try {
                const res = await $.post("{{ route('validar.celular') }}", {
                    ddd,
                    celular: numero,
                    ignore_id: IGNORE_ID
                });
                lastPhoneChecked = fullDigits;
                if (res === 'celular_error') {
                    lastOutcomePhone = 'celular_error';
                    markInvalid($('#celular'), '#celularHelp', 'Número inválido.');
                    return false;
                }
                if (res === 'celular_exist') {
                    lastOutcomePhone = 'celular_exist';
                    markInvalid($('#celular'), '#celularHelp', 'Este celular já está cadastrado.');
                    return false;
                }
                lastOutcomePhone = 'ok';
                clearInvalid($('#celular'), '#celularHelp');
                $('#celular').addClass('is-valid');
                return true;
            } catch {
                lastOutcomePhone = '';
                markInvalid($('#celular'), '#celularHelp', 'Não foi possível validar o celular.');
                return false;
            }
        }
        $('#celular').on('blur', validarCelularEdit);

        // Email
        let lastEmailChecked = '',
            lastOutcomeEmail = '',
            emailAjax = null;
        async function validarEmailEdit() {
            const email = ($('#email').val() || '').trim().toLowerCase();
            if (!isValidEmail(email)) {
                markInvalid($('#email'), '#emailHelp', 'E-mail inválido.');
                return false;
            }
            if (email === lastEmailChecked && lastOutcomeEmail) {
                return lastOutcomeEmail === 'ok';
            }
            if (email === ($('#email').data('original') || '').toLowerCase()) {
                lastEmailChecked = email;
                lastOutcomeEmail = 'ok';
                clearInvalid($('#email'), '#emailHelp');
                $('#email').addClass('is-valid');
                return true;
            }
            if (emailAjax && emailAjax.readyState !== 4) emailAjax.abort();
            try {
                const res = await $.post("{{ route('validar.email') }}", {
                    email,
                    ignore_id: IGNORE_ID
                });
                lastEmailChecked = email;
                if (res === 'email_exist') {
                    lastOutcomeEmail = 'email_exist';
                    markInvalid($('#email'), '#emailHelp', 'Este e-mail já está cadastrado.');
                    return false;
                }
                lastOutcomeEmail = 'ok';
                clearInvalid($('#email'), '#emailHelp');
                $('#email').addClass('is-valid');
                return true;
            } catch {
                lastOutcomeEmail = '';
                markInvalid($('#email'), '#emailHelp', 'Não foi possível validar o e-mail.');
                return false;
            }
        }
        $('#email').on('blur', validarEmailEdit);

        /* ===== Submit FORM 1 ===== */
        $('#editForm').on('submit', async function(e) {
            let ok = true;
            ['#nome', '#nascimento', '#rg', '#bairro', '#cidade', '#estado', '#endereco', '#numero', '#cep', '#celular', '#cpf', '#email'].forEach(sel => {
                if (isEmpty($(sel))) {
                    markInvalid($(sel));
                    ok = false;
                } else {
                    clearInvalid($(sel));
                }
            });
            if (($('#estado').val() || '').length !== 2) {
                markInvalid($('#estado'), null, 'Informe UF com 2 letras');
                ok = false;
            }
            if (!isValidCPF($('#cpf').val())) {
                markInvalid($('#cpf'), '#cpfHelp', 'CPF inválido.');
                ok = false;
            } else {
                ok = ok && await validarCpfEdit();
            }
            if (!isValidCell($('#celular').val())) {
                markInvalid($('#celular'), '#celularHelp', 'Informe DDD + número.');
                ok = false;
            } else {
                ok = ok && await validarCelularEdit();
            }
            if (!isValidEmail($('#email').val())) {
                markInvalid($('#email'), '#emailHelp', 'E-mail inválido.');
                ok = false;
            } else {
                ok = ok && await validarEmailEdit();
            }
            if (onlyDigits($('#cep').val()).length !== 8) {
                markInvalid($('#cep'), '#cepHelp', 'CEP inválido (8 dígitos).');
                ok = false;
            }
            if (!ok) e.preventDefault();
        });

        /* ====== TROCA DE SENHA ====== */
        function passMarkInvalid($el, helpSel, msg) {
            markInvalid($el, helpSel, msg);
        }

        function passClear($el, helpSel) {
            clearInvalid($el, helpSel);
        }

        async function validarSenhaAtualAJAX(cur) {
            try {
                const res = await $.post("{{ route('validar.senha.atual') }}", {
                    current_password: cur
                });
                return (res === 'ok');
            } catch {
                return true;
            } // se rota não existir, deixa validar no back-end
        }

        function validaBlocoSenhaLocal() {
            const cur = $('#current_password').val() || '';
            const n = $('#new_password').val() || '';
            const nc = $('#new_password_confirmation').val() || '';
            let ok = true;

            if (cur.length < 8) {
                passMarkInvalid($('#current_password'), '#curPassHelp', 'Informe sua senha atual (mín. 8).');
                ok = false;
            } else {
                passClear($('#current_password'), '#curPassHelp');
            }
            if (n.length < 8) {
                passMarkInvalid($('#new_password'), '#newPassHelp', 'Mínimo 8 caracteres.');
                ok = false;
            } else {
                passClear($('#new_password'), '#newPassHelp');
            }
            if (nc.length < 8 || n !== nc) {
                passMarkInvalid($('#new_password_confirmation'), '#confPassHelp', 'Senhas não conferem.');
                ok = false;
            } else {
                passClear($('#new_password_confirmation'), '#confPassHelp');
            }
            if (cur && n && cur === n) {
                passMarkInvalid($('#new_password'), '#newPassHelp', 'A nova senha deve ser diferente da atual.');
                ok = false;
            }

            return ok;
        }

        $('#editPassForm').on('submit', async function(e) {
            e.preventDefault();
            let ok = validaBlocoSenhaLocal();
            if (!ok) return;

            // (opcional) verifica senha atual no servidor
            const cur = $('#current_password').val() || '';
            const validServer = await validarSenhaAtualAJAX(cur);
            if (!validServer) {
                passMarkInvalid($('#current_password'), '#curPassHelp', 'Senha atual incorreta.');
                return;
            }

            // tudo certo -> envia
            this.submit();
        });
    </script>
@endsection
