@extends('site.base')
@section('titulo', 'Minhas Indicações')
@section('description', '')
@section('image', url('site/images/favicon.png'))

@section('content')
    <div class="pt-[64px] pb-12 bg-gray-50 min-h-screen">
        <div class="relative px-4 md:px-12 4xl:w-[70%] 4xl:mx-auto">

            {{-- LINK DE DIVULGADOR --}}
            <div class="bg-white rounded-2xl p-5 shadow-sm border border-gray-200 mt-5">
                <h2 class="text-gray-800 font-bold text-lg mb-2 flex items-center gap-2">
                    <i class="fas fa-link text-primary-green"></i>
                    Seu link de divulgação
                </h2>

                @php
                    $linkDivulgador = route('site.indicacao', Auth::user()->id);
                @endphp

                <div class="flex items-center bg-gray-100 rounded-lg px-3 py-2 justify-between">
                    <span id="divulgador-link" class="text-sm text-gray-700 truncate max-w-[80%]">
                        {{ $linkDivulgador }}
                    </span>
                    <button onclick="copiarLink()" class="text-primary-green font-semibold text-sm flex items-center gap-1 hover:underline">
                        <i class="fas fa-copy"></i> Copiar
                    </button>
                </div>
                <p class="text-xs text-gray-500 mt-1">
                    Compartilhe este link e ganhe comissão nas vendas realizadas.
                </p>
            </div>

            {{-- Card de Saldo --}}
            <div class="to-yellow-300 rounded-3xl mt-6 relative">
                <div class="bg-white rounded-2xl p-5 shadow-sm">
                    <div class="flex justify-between items-center">
                        <h2 class="text-gray-800 font-bold text-xl">Saldo disponível</h2>
                    </div>

                    <div class="mt-3 flex items-center justify-between">
                        <h1 class="text-3xl md:text-4xl font-bold text-gray-900">
                            R$ {{ moeda(Auth::user()->saldo) }}
                        </h1>
                        <i class="fas fa-eye text-gray-600 text-lg"></i>
                    </div>

                    <div class="mt-5">
                        <div class="rounded-full w-[80%] md:w-full text-center py-2 bg-success-600 text-white text-[14px] font-semibold hover:bg-success-700 transition">
                            <a href="#" target="_blank">
                                Solicitar Saque
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Lista de Indicações estilo extrato --}}
            <section class="relative py-6">
                <h3 class="font-bold text-2xl text-primary-green mb-4">Histórico de Indicações</h3>

                <div class="flex flex-col gap-3">
                    @forelse (Auth::user()->Indicacoes as $indicacao)
                        <div class="mtk-flex mtk-justify-between mtk-items-center bg-white rounded-xl shadow-sm mtk-border-2 mtk-border-gray p-4 mtk-hover-shadow">
                            <div class="mtk-flex mtk-items-start gap-3">
                                {{-- Ícone --}}
                                <div
                                    class="mtk-relative mtk-flex-shrink-0 mtk-w-10 mtk-h-10 mtk-flex mtk-items-center mtk-justify-center mtk-rounded-full mtk-border-2
                @if ($indicacao->status == 'Pendente') mtk-border-orange
                @elseif($indicacao->status == 'Pago') mtk-border-green
                @else mtk-border-gray @endif">
                                    <i class="fas fa-bag-shopping mtk-text-gray-800"></i>
                                    @if ($indicacao->status == 'Pendente')
                                        {{-- Usando a classe mtk-status-badge para o marcador de ponto --}}
                                        <span class="mtk-status-badge">!</span>
                                    @endif
                                </div>

                                {{-- Conteúdo --}}
                                <div class="mtk-flex mtk-flex-col">
                                    <span class="mtk-font-semibold mtk-text-gray-900 mtk-text-sm">Venda de produtos</span>
                                    <span class="mtk-text-sm mtk-text-gray-700">
                                        @if ($indicacao->status == 'Pendente')
                                            <span class="mtk-text-orange mtk-font-semibold">Pendente</span> •
                                        @elseif($indicacao->status == 'Pago')
                                            <span class="mtk-text-green mtk-font-semibold">Pago</span> •
                                        @elseif($indicacao->status == 'Cancelado')
                                            <span class="mtk-text-red mtk-font-semibold">Cancelado</span> •
                                        @endif
                                        {{ $indicacao->Cliente->name ?? 'Cliente não encontrado' }}
                                    </span>
                                    <span class="mtk-text-xs mtk-text-gray-500">Transação {{ $indicacao->id }}</span>
                                </div>
                            </div>

                            {{-- Valor e hora --}}
                            <div class="mtk-flex mtk-flex-col mtk-items-end">
                                <span class="mtk-text-green mtk-font-semibold mtk-text-sm">
                                    + R$ {{ moeda(porcentagem(env('COMISSAO'), $indicacao->total)) }}
                                </span>
                                <span class="mtk-text-xs mtk-text-gray-500">
                                    {{ \Carbon\Carbon::parse($indicacao->created_at)->format('H\hi') }}
                                </span>
                            </div>
                        </div>
                    @empty
                        <div class="bg-white mtk-border-2 mtk-border-gray mtk-rounded-full p-6 text-center mtk-text-gray-500">
                            Nenhuma indicação encontrada.
                        </div>
                    @endforelse
                </div>
            </section>
        </div>
    </div>
@endsection

@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        function copiarLink() {
            const texto = document.getElementById('divulgador-link').innerText;
            navigator.clipboard.writeText(texto).then(() => {
                Swal.fire({
                    icon: 'success',
                    title: 'Link copiado!',
                    text: 'Agora é só compartilhar seu link de divulgação.',
                    showConfirmButton: false,
                    timer: 2000
                });
            }).catch(err => {
                console.error('Erro ao copiar link:', err);
            });
        }
    </script>
@endsection
