@extends('site.base')
@section('titulo', 'Meus dados')
@section('content')
    <main id="page_content">
        <div class="hero" style="background-image: url({{ url('site') }}/images/banner/event.jpg);"></div>
        <div class="under-hero container">
            <div class="section">
                <div class="plan bg-light">
                    <div class="card plan__info overflow-hidden">
                        <div class="card-body d-flex flex-column p-0">
                            <div class="p-4">
                                <h3 class="h4 mb-3">Olá <span class="text-primary">{{ Auth::user()->name }}</span></h3>
                                <p class="fs-6">Edite e atualize seus dados.</p>

                            </div>
                            <div class="px-3 text-center mt-auto"><img width="320" height="374" alt="Plan image" class="img-fluid" src="{{ url('site') }}/images/misc/plan.png"></div>
                        </div>
                    </div>
                    <div class="plan__data">
                        <form id="FormEditarDados" class="px-4 pt-2 pe-xl-0 pt-sm-0 mt-4 mb-3 my-sm-0 w-100" action="{{ route('dados.update') }}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="d-flex align-items-center mb-4">
                                <div class="avatar avatar--xl">
                                    <div class="avatar__image">
                                        <label for="imageInput">
                                            <img id="selectedImage" class="img-fluid" width="128" height="128" alt="{{ Auth::user()->name }}" src="{{ Auth::user()->foto ? url('storage/' . Auth::user()->foto) : url('site/images/users/thumb.jpg') }}">
                                        </label>
                                        <input name="image" type="file" class="form-control" style="display: none" id="imageInput" accept="image/*">
                                    </div>
                                </div>
                            </div>
                            <div class="row g-4">
                                <div class="col-sm-6">
                                    <label for="f_name" class="form-label fw-medium">Nome</label>
                                    <input value="{{ Auth::user()->name }}" id="name" class="form-control" type="text" name="name">
                                </div>
                                <div class="col-sm-6">
                                    <label for="l_name" class="form-label fw-medium">Sobrenome</label>
                                    <input value="{{ Auth::user()->sobrenome }}" id="sobrenome" class="form-control" type="text" name="sobrenome">
                                </div>
                                <div class="col-sm-6">
                                    <label for="d_name" class="form-label fw-medium">E-mail</label>
                                    <input value="{{ Auth::user()->email }}" id="email" class="form-control" type="text" name="email">
                                </div>
                                <div class="col-sm-6">
                                    <label for="d_name" class="form-label fw-medium">CPF</label>
                                    <input value="{{ Auth::user()->cpf }}" id="cpf" class="form-control" type="tel" name="cpf">
                                </div>
                                <div class="col-sm-6">
                                    <label for="d_name" class="form-label fw-medium">Celular</label>
                                    <input value="{{ Auth::user()->celular }}" id="celular" class="form-control" type="tel" name="celular">
                                </div>
                            </div>
                            <button type="submit" id="btnAtualizar" class="mt-4 btn btn-primary btn-loading">
                                Atualizar
                            </button>
                        </form>
                        <hr>
                        <form id="FormEditarSenha" style="padding-top: 50px" class="px-4 mt-4 mb-3 my-sm-0 w-100" action="{{ route('update.password') }}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="row g-4">
                                <div class="col-sm-6">
                                    <label for="d_name" class="form-label fw-medium">Senha atual*</label>
                                    <input id="celular" class="form-control" type="password" name="password">
                                </div>
                            </div>
                            <div class="row g-4">
                                <div class="col-sm-6">
                                    <label for="d_name" class="form-label fw-medium">Nova senha*</label>
                                    <input id="celular" class="form-control" type="password" name="password_new">
                                </div>
                                <div class="col-sm-6">
                                    <label for="d_name" class="form-label fw-medium">Confirmar nova senha*</label>
                                    <input id="celular" class="form-control" type="password" name="password_new_confirme">
                                </div>
                            </div>
                            <button type="submit" id="btnAtualizarSenha" class="mt-4 btn btn-primary btn-loading">
                                Atualizar
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </main>
@endsection
@section('js')
    <!-- SweetAlert2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">

    <!-- SweetAlert2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.all.min.js"></script>

    <script>
        $(document).ready(function() {
            const imageInput = document.getElementById('imageInput');
            const selectedImage = document.getElementById('selectedImage');

            imageInput.addEventListener('change', () => {
                const file = imageInput.files[0];
                const reader = new FileReader();

                reader.addEventListener('load', () => {
                    selectedImage.setAttribute('src', reader.result);
                });
                reader.readAsDataURL(file);
            });
        });

        function aplicarMascara(elemento, mascara) {
            elemento.addEventListener('input', (event) => {
                let valor = elemento.value.replace(/\D/g, ''); // Remove tudo que não for número
                let resultado = '';
                let i = 0;

                // Detecta se foi backspace comparando o tamanho
                const digitando = valor.length >= elemento.getAttribute('data-valor-anterior')?.length;

                for (let char of mascara) {
                    if (char === '#') {
                        if (i < valor.length) {
                            resultado += valor[i];
                            i++;
                        } else {
                            break;
                        }
                    } else {
                        if (digitando && i < valor.length) {
                            resultado += char;
                        }
                    }
                }

                elemento.value = resultado;
                elemento.setAttribute('data-valor-anterior', valor);
            });
        }

        document.addEventListener('DOMContentLoaded', () => {
            const celular = document.querySelector('#celular');
            const data = document.querySelector('#data');
            const cpf = document.querySelector('#cpf');
            const cep = document.querySelector('#cep');

            if (celular) aplicarMascara(celular, '(##) #####-####');
            if (data) aplicarMascara(data, '##/##/####');
            if (cpf) aplicarMascara(cpf, '###.###.###-##');
            if (cep) aplicarMascara(cep, '#####-###');
        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const formDados = document.getElementById('FormEditarDados');
            const botaoDados = document.getElementById('btnAtualizar');

            formDados.addEventListener('submit', function() {
                botaoDados.disabled = true;
                botaoDados.innerHTML = 'Processando...';
            });

            const formSenha = document.getElementById('FormEditarSenha');
            const botaoSenha = document.getElementById('btnAtualizarSenha');

            formSenha.addEventListener('submit', function() {
                botaoSenha.disabled = true;
                botaoSenha.innerHTML = 'Processando...';
            });
        });

        @if(session('success'))
        Swal.fire({
            icon: 'success',
            title: 'Sucesso!',
            text: '{{ session('success') }}',
            confirmButtonText: 'Ok'
        });
    @endif

    @if(session('error'))
        Swal.fire({
            icon: 'error',
            title: 'Erro!',
            text: '{{ session('error') }}',
            confirmButtonText: 'Ok'
        });
    @endif
    </script>

@endsection
