@extends('carteira.base')
@section('titulo', 'Carteira')
@section('content')
    @if ($pedido)
        <div class="appHeader bg-primary text-light">
            <div class="left">

            </div>
            <div class="pageTitle">
                DOCUMENTO VÁLIDO
            </div>
            <div class="right">

            </div>
        </div>
        <div id="appCapsule">
            <div class="section mt-2">
                <!-- card block -->
                <div class="card-block mb-2" style="background-color: transparent;">
                    <div class="card-main"
                        style="background-image: url(https://ucesub.com.br/storage/carteira/{{ date('Y') }}.png);
                width: 100%; height: 300px;
                background-size: contain;
                background-repeat: no-repeat;
                background-position: center;">
                        <table class="carteira" style="width: 95%;">
                            <tbody>
                                <tr>
                                    <th style="width: 147px;">

                                        <div id="foto">
                                            <img src="{{ $ingresso->foto }}" style="width: 90px; height: 117px; object-fit: cover; margin: 35px 0 0 0;">
                                            <br>
                                            <img src="{{ $qrcode }}" style="width: 50px; height: 50px; margin: 15px 0 0 20px;">
                                        </div>

                                    </th>
                                    <th style="width: 355px; text-align:left;">
                                        <div class="dados" style="font-size: 12px; margin-top: 20px;">
                                            <span class="text-dark" id="nome">{{ $ingresso->nome_completo }}</span><br>
                                            <span class="text-dark" id="insituicao">{{ $ingresso->instituicao_ensino) }}</span><br>
                                            <span class="text-dark" id="curso">{{ $ingresso->curso }}</span><br>
                                            <span class="text-dark" id="cpf">CPF: {{ $ingresso->cpf }}</span><br>
                                            <span class="text-dark" id="rg">RG: {{ $cliente->rg }}</span><br>
                                            <span class="text-dark" id="nascimento">Nasc.: {{ $cliente->nascimento }}</span><br>
                                            <span class="text-dark" id="matricula">Matrícula: {{ $ingresso->matricula }}</span><br>
                                            <span class="text-dark" id="cod">COD. USO: {{ $ingresso->registro }}</span>
                                        </div>
                                    </th>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="section" style="margin-top: 80px;">
                <div class="section-title">Certificado de Atributo</div>
                <div class="card">
                    <div class="card-body" style="font-size: 8px; text-align: justify;">{{ $certificado }}</div>
                </div>
            </div>
        </div>
    @else
        <div class="appHeader bg-danger text-light">
            <div class="left">

            </div>
            <div class="pageTitle">
                DOCUMENTO INVÁLIDO
            </div>
            <div class="right">

            </div>
        </div>
        <div id="appCapsule">
            <div class="section mt-2">
                <!-- card block -->
                <div class="card-block mb-2" style="background-color: transparent;">
                    <div class="card-main"
                        style="background-image: url(https://ucesub.com.br/storage/carteira/{{ date('Y') }}.png);
                                width: 100%; height: 300px;
                                background-size: contain;
                                background-repeat: no-repeat;
                                background-position: center;">
                        <table class="carteira" style="width: 95%;">
                            <tbody>
                                <tr>
                                    <th style="width: 147px;">
                                        <div id="foto">

                                        </div>
                                    </th>
                                    <th style="width: 355px; text-align:left;">

                                    </th>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="section" style="margin-top: 80px;">
                <div class="section-title">Certificado de Atributo</div>
                <div class="card">
                    <div class="card-body" style="font-size: 8px; text-align: justify;"></div>
                </div>
            </div>
        </div>
    @endif

@endsection
@section('js')
    <!-- SweetAlert2 CDN -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        @if ($pedido)
            Swal.fire({
                title: "Sucesso!",
                text: "Documento Válido",
                icon: "success"
            });
        @else
            Swal.fire({
                title: "Atenção!",
                text: "Documento Inválido",
                icon: "error"
            });
        @endif
    </script>

@endsection
