<!doctype html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="theme-color" content="#000000">
    <title>{{ env('APP_NAME') }}</title>
    <meta name="description" content="{{ env('APP_NAME') }}">
    <link rel="icon" type="image/png" href="{{ url('carteira') }}/assets/img/favicon.png" sizes="32x32">
    <link rel="apple-touch-icon" sizes="180x180" href="{{ url('carteira') }}/assets/img/icon/192x192.png">
    <link rel="stylesheet" href="{{ url('carteira') }}/assets/css/style.css?v={{ rand() }}">
    <link rel="manifest" href="{{ url('carteira') }}/__manifest.json">

    @yield('pixel')

    <meta property="og:type" content="website" />
    <meta property="og:url" content="@yield('url')">
    <meta property="og:title" content="@yield('titulo')" />
    <meta property="og:description" content="@yield('description')" />
    <meta property="og:image" content="@yield('image')" />
    <meta property="og:image:secure_url" content="@yield('image')" />
    @yield('css')
</head>

<body>


    @yield('content')

    <!-- App Sidebar -->
    <div class="modal fade panelbox panelbox-left" id="sidebarPanel" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="p-0 modal-body">

                </div>
            </div>
        </div>
    </div>
    <!-- * App Sidebar -->


    <script src="{{ url('carteira') }}/assets/js/lib/jquery-3.4.1.min.js"></script>

    <script src="{{ url('carteira') }}/assets/js/lib/bootstrap.bundle.min.js"></script>
    <!-- Ionicons -->
    <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
    <!-- Splide -->
    <script src="{{ url('carteira') }}/assets/js/plugins/splide/splide.min.js"></script>
    <!-- Base Js File -->
    <script src="{{ url('carteira') }}/assets/js/base.js"></script>

    @yield('js')

</body>

</html>
