@extends('site.base')
@section('titulo', 'Criar Conta na Musa Ticket | Comece a Viver Novas Experiências')
@section('description', 'Cadastre-se gratuitamente na Musa Ticket e tenha acesso antecipado a eventos imperdíveis. Acompanhe compras, receba promoções e mais!')
@section('url', route('register'))
@section('image', url('site/images/favicon.png'))
@section('content')
    <div id="wrapper">
        <div class="auth py-5">
            <div class="container">
                <div class="row">
                    <div class="col-xl-5 col-lg-7 col-md-9 col-sm-11 mx-auto">
                        <div class="card">
                            <div class="card-body p-sm-5">
                                <h4><span class="text-primary">Cadastro</span></h4>
                                <p class="fs-6">Informe seus dados para se cadastrar</p>
                                @if (session('status'))
                                    <div class="alert alert-success">
                                        <strong>{{ session('status') }}</strong>
                                    </div>
                                @endif

                                @if ($errors->any())
                                    <div class="alert alert-danger">
                                        <ul class="mb-0">
                                            @foreach ($errors->all() as $error)
                                                <li><strong>{{ $error }}</strong></li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                                <form id="loginForm" class="form-login form-wrapper form-narrow" method="POST" action="{{ route('register') }}">
                                    @csrf
                                    <div class="mb-3">
                                        <label for="name" class="form-label fw-medium">Nome Completo</label>
                                        <input name="name" type="text" id="name" class="form-control" required>
                                    </div>
                                    <div class="mb-3">
                                        <label for="celular" class="form-label fw-medium">Celular</label>
                                        <input name="celular" type="tel" id="celular" class="form-control" required>
                                    </div>
                                    <div class="mb-3">
                                        <label for="email" class="form-label fw-medium">E-mail</label>
                                        <input name="email" type="email" id="email" class="form-control" required>
                                    </div>
                                    <div class="mb-3">
                                        <label for="email" class="form-label fw-medium">CPF</label>
                                        <input name="cpf" type="tel" id="cpf" class="form-control" required>
                                    </div>
                                    <div class="mb-2">
                                        <label for="password" class="form-label fw-medium">Senha</label>
                                        <input name="password" type="password" id="password" class="form-control" required>
                                    </div>
                                    <div class="mb-2">
                                        <label for="password" class="form-label fw-medium">Confirme a Senha</label>
                                        <input name="password_confirmation" type="password" id="password" class="form-control" required>
                                    </div>
                                    <div class="mb-5">
                                        <input id="btnLogin" type="submit" class="btn btn-primary w-100" value="Cadastrar">
                                    </div>
                                    <p>Possui uma conta? <br><a href="{{ route('login') }}" class="fw-medium external">Voltar e logar!</a></p>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const formDados = document.getElementById('loginForm');
            const botaoDados = document.getElementById('btnLogin');

            formDados.addEventListener('submit', function() {
                botaoDados.disabled = true;
                botaoDados.value = 'Processando...'; // Use `.value` para <input type="submit">
            });
        });
    </script>
@endsection
