@extends('site.base')
@section('titulo', 'Entrar na Musa Ticket | Acesse sua Conta e Gerencie seus Ingressos')
@section('description', 'Faça login na Musa Ticket e acompanhe seus pedidos, baixe seus ingressos e fique por dentro dos próximos eventos. Acesso rápido e seguro.')
@section('url', route('login'))
@section('image', url('site/images/favicon.png'))

@section('content')
    <div class="relative w-full">
        {{-- FORM --}}
        <div class="pt-[64px]">
            <div class="relative w-[95%] max-h-[100%] md:w-4/6 lg:w-3/6 xl:w-[40%] 4xl:w-[25%] my-6 mx-auto">
                <div class="overflow-auto rounded-2xl shadow-lg flex flex-col w-full h-full bg-white">
                    <div class="h-full p-6">
                        <h1 class="text-primary-green font-bold text-2xl mb-3 mt-6">Entrar na minha conta</h1>
                        <p class="text-gray-dark mb-6">Informe abaixo seu e-mail e senha para acessar.</p>

                        {{-- Mensagens de status --}}
                        @if (session('status'))
                            <div class="bg-green-100 text-green-800 px-4 py-2 rounded-lg mb-4">
                                {{ session('status') }}
                            </div>
                        @endif

                        {{-- Erros --}}
                        @if ($errors->any())
                            <div class="bg-red-100 text-red-800 px-4 py-2 rounded-lg mb-4">
                                <ul class="list-disc list-inside">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <form id="loginForm" action="{{ route('login') }}" method="POST" novalidate>
                            @csrf

                            {{-- Email --}}
                            <div class="mb-4">
                                <label for="email" class="mb-1 text-primary-green">E-mail</label>
                                <input type="email" id="email" name="email" class="bg-green-light w-full h-11 px-4 rounded-full text-tertiary-green text-base focus:outline-none focus:bg-green-light/60" placeholder="seu@email.com"
                                    value="{{ old('email') }}" required>
                            </div>

                            {{-- Senha --}}
                            <div class="mb-4">
                                <label for="password" class="mb-1 text-primary-green">Senha</label>
                                <input type="password" id="password" name="password" class="bg-green-light w-full h-11 px-4 rounded-full text-tertiary-green text-base focus:outline-none focus:bg-green-light/60" placeholder="Digite sua senha" required>
                            </div>

                            {{-- Esqueceu senha --}}
                            <div class="mb-4 text-right">
                                <a href="{{ route('password.request') }}" class="text-primary-green hover:underline">
                                    Esqueceu a senha?
                                </a>
                            </div>

                            {{-- Botões --}}
                            <div class="flex flex-col gap-4 mt-6">
                                <button type="submit" id="btnLogin" class="bg-primary-green w-full hover:bg-primary-green/90 rounded-full px-4 py-[0.6rem] flex justify-center items-center text-white font-medium">
                                    <span id="btnLoginText">Entrar</span>
                                    <span id="btnLoginLoader" class="hidden flex gap-2 items-center justify-center">
                                        <span class="dot"></span>
                                        <span class="dot delay-150"></span>
                                        <span class="dot delay-300"></span>
                                    </span>
                                </button>
                            </div>

                            <div class="mt-6 text-center">
                                <p class="text-gray-dark">
                                    Não possui uma conta?
                                    <a href="{{ route('site.cadastro') }}" class="text-primary-green font-bold">Cadastre-se!</a>
                                </p>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('css')
    <style>
        /* Loader pontinhos */
        .dot {
            width: 6px;
            height: 6px;
            border-radius: 50%;
            background: white;
            display: inline-block;
            animation: bounce 1.2s infinite;
        }

        .dot.delay-150 {
            animation-delay: 0.15s;
        }

        .dot.delay-300 {
            animation-delay: 0.3s;
        }

        @keyframes bounce {

            0%,
            80%,
            100% {
                transform: scale(0);
            }

            40% {
                transform: scale(1);
            }
        }
    </style>
@endsection

@section('js')
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const form = document.getElementById("loginForm");
            const btn = document.getElementById("btnLogin");
            const text = document.getElementById("btnLoginText");
            const loader = document.getElementById("btnLoginLoader");

            if (form) {
                form.addEventListener("submit", function() {
                    btn.disabled = true;
                    text.classList.add("hidden");
                    loader.classList.remove("hidden");
                });
            }
        });
    </script>
@endsection
