@extends('app.base')
@section('content')
    <style>
        /* Torna o fundo do modal transparente */
        .modal.fade#modalPagamento .modal-dialog {
            background: transparent;
            pointer-events: none;
            /* para não clicar fora */
        }

        /* Remove sombra e bordas do conteúdo */
        .modal.fade#modalPagamento .modal-content {
            background: transparent !important;
            box-shadow: none;
            border: none;
            color: white;
        }

        /* Esconde o cabeçalho e rodapé, se quiser */
        .modal.fade#modalPagamento .modal-header,
        .modal.fade#modalPagamento .modal-footer {
            display: none;
        }

        /* Centraliza conteúdo sem fundo */
        .modal.fade#modalPagamento .modal-body {
            padding: 0;
        }
    </style>
    <div class="appHeader">
        <div class="left">
            <a href="{{ route('site.home') }}" class="headerButton goBack">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
            Compra #{{ $Pedido->id }}
        </div>
    </div>
    <div id="appCapsule" class="full-height">
        <div class="modal center-modal fade" id="modalPagamento" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Modal title</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div id="statusScreenBrick_container"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="section mt-4">
            <div class="transactions" style="margin-bottom: 20px;">
                <h4>Olá {{ $Pedido->Cliente->name }}, segue dados da sua compra:</h4>
                @foreach ($Pedido->Ingressos as $item)
                    <a href="#" class="item">
                        <div class="detail">
                            <img src="{{ $item->Evento->banner }}" alt="{{ $item->Evento->titulo }}" class="image-block imaged" style="width: 100px; height: 100px; object-fit: cover; object-position: center;">
                            <div>
                                <strong>{{ $item->Evento->titulo }}</strong>
                                <h4>{{ $item->Pacote->nome }}</h4>
                                @if ($item->cupom)
                                    <div class="price text-success"> R$ {{ moeda($item->valor_final) }}</div>
                                @else
                                    <div class="price text-success"> R$ {{ moeda($item->valor_final) }}</div>
                                @endif
                            </div>
                        </div>
                    </a>
                @endforeach
            </div>
            <div id="paymentBrick_container"></div>
        </div>
    </div>
    <div id="toast-17" class="toast-box toast-top bg-danger">
        <div class="in">
            <div class="text">
                Você esta realizando pagamento para <strong>{{ $Pedido->Cliente->name }} {{ $Pedido->Cliente->sobrenome }}</strong>, caso não seja você, não realize este pagamento.
            </div>
        </div>
        <button type="button" class="btn btn-sm btn-text-light close-button">OK</button>
    </div>
@endsection
@push('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


    <script>
        toastbox('toast-17')
        // Configurar o token CSRF nas requisições AJAX
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var mp = new MercadoPago('{{ $getway->public_key }}');
        const bricksBuilder = mp.bricks();

        var responseId = null;

        const renderPaymentBrick = async (bricksBuilder) => {
            const settings = {
                initialization: {
                    amount: {{ moeda2($Pedido->total + porcentagem(4.98, $Pedido->total)) }},
                    payer: {
                        email: "{{ $Pedido->Cliente->email ? $Pedido->Cliente->email : '' }}"
                    },
                },
                customization: {
                    paymentMethods: {
                        bankTransfer: "all",
                        creditCard: "all",
                        prepaidCard: "all",
                        mercadoPago: "all",
                        minInstallments: 1,
                        maxInstallments: 10,
                    },
                },
                callbacks: {
                    onReady: () => {
                        console.log('im read!')
                    },
                    onSubmit: ({
                        selectedPaymentMethod,
                        formData
                    }) => {
                        // 1. Coleta os dados do formulário principal
                        const formDataManual = $('#form_pedido').serializeArray(); // dados do formulário Laravel

                        // 2. Transforma em objeto
                        const formObject = formDataManual.reduce((obj, item) => {
                            obj[item.name] = item.value;
                            return obj;
                        }, {});

                        // 3. Adiciona manualmente campos com ID (caso não estejam no form diretamente)
                        formObject['name'] = $('#id_nome_completo').val();
                        formObject['email'] = $('#id_email').val();
                        formObject['cpf'] = $('#id_cpf_cnpj').val();

                        // 4. Junta os dados do Brick + Formulário
                        const finalPayload = {
                            ...formData,
                            ...formObject
                        };

                        // callback chamado ao clicar no botão de submissão dos dados
                        return new Promise((resolve, reject) => {
                            fetch("{{ route('pay.app', $Pedido->id) }}", {
                                    method: "POST",
                                    headers: {
                                        "Content-Type": "application/json",
                                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') // Passando o token CSRF
                                    },
                                    body: JSON.stringify(finalPayload),
                                })
                                .then((response) => response.json())
                                .then((response) => {
                                    responseId = response.id;
                                    pedidoId = response.pedido_id || null;
                                    boletoId = response.boleto_id || null;

                                    const renderStatusScreenBrick = async (bricksBuilder) => {
                                        const settings = {
                                            initialization: {
                                                paymentId: response.id, // id do pagamento a ser mostrado
                                            },
                                            callbacks: {
                                                onReady: (response) => {
                                                    console.log(response);
                                                },
                                                onError: (error) => {
                                                    // callback chamado para todos os casos de erro do Brick
                                                    console.error(error);
                                                },
                                            },
                                        };
                                        window.statusScreenBrickController = await bricksBuilder.create(
                                            'statusScreen',
                                            'statusScreenBrick_container',
                                            settings,
                                        );
                                    };
                                    renderStatusScreenBrick(bricksBuilder);
                                    $("#modalPagamento").modal('show');
                                    resolve();
                                })
                                .catch((error) => {
                                    // lidar com a resposta de erro ao tentar criar o pagamento
                                    reject();
                                });
                        });
                    },
                    onError: (error) => {
                        // callback chamado para todos os casos de erro do Brick
                        console.error(error);
                    },
                },
            };
            window.paymentBrickController = await bricksBuilder.create(
                "payment",
                "paymentBrick_container",
                settings
            );
        };
        renderPaymentBrick(bricksBuilder);

        var statusPagamentoInterval = null;

        function StatusPagamento() {
            console.log('response: ', responseId)
            if (!responseId) {
                statusPagamentoInterval = setTimeout(StatusPagamento, 5000); // 5 segundos
                return;
            }

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "https://musaticket.com.br/retorno-mp/" + responseId,
                method: "GET",
                success: function(result) {
                    if (result && result.success) {
                        const status = (result.response || "").toLowerCase();

                        if (status === "approved") {
                            clearTimeout(statusPagamentoInterval);
                            $("#modalPagamento").modal("hide");
                            showSuccessAlert();

                            // Redireciona para a página de impressão/ingressos
                            if (result.redirect) {
                                window.location.href = result.redirect;
                                return;
                            }
                        } else if (["pending", "in_process", "authorized"].includes(status) && result.dados?.payment_method_id !== "pix") {
                            clearTimeout(statusPagamentoInterval);
                            $("#modalPagamento").modal("hide");
                            showProcessAlert();
                        } else {
                            // Continua o polling
                            statusPagamentoInterval = setTimeout(StatusPagamento, 5000);
                        }
                    } else {
                        // Falha controlada: tenta novamente
                        statusPagamentoInterval = setTimeout(StatusPagamento, 7000);
                    }
                },
                error: function(xhr, status, error) {
                    console.error("Erro ao verificar pagamento:", error);
                    // Tenta novamente após 10s em caso de erro de rede/servidor
                    statusPagamentoInterval = setTimeout(StatusPagamento, 10000);
                },
            });
        }
        StatusPagamento();

        $(window).on('beforeunload', function() {
            clearTimeout(statusPagamentoInterval);
        });

        function showSuccessAlert() {
            let timerInterval;
            Swal.fire({
                title: "Pagamento Confirmado",
                html: "Você está sendo redirecionado... <b></b>",
                timer: 2000,
                timerProgressBar: true,
                didOpen: () => {
                    Swal.showLoading();
                    const timer = Swal.getPopup().querySelector("b");
                    timerInterval = setInterval(() => {
                        timer.textContent = `${Math.ceil(Swal.getTimerLeft() / 1000)}s`;
                    }, 100);
                },
                willClose: () => {
                    clearInterval(timerInterval);
                    window.location.href = "{{ route('cliente.ingressos') }}";
                }
            });
        }

        function showProcessAlert() {
            let timerInterval;
            Swal.fire({
                title: "Pagamento em processamento...",
                html: "Você está sendo redirecionado... <b></b>",
                timer: 2000,
                timerProgressBar: true,
                didOpen: () => {
                    Swal.showLoading();
                    const timer = Swal.getPopup().querySelector("b");
                    timerInterval = setInterval(() => {
                        timer.textContent = `${Math.ceil(Swal.getTimerLeft() / 1000)}s`;
                    }, 100);
                },
                willClose: () => {
                    clearInterval(timerInterval);
                    window.location.href = "{{ route('cliente.ingressos') }}";
                }
            });
        }

        // Espera o DOM carregar
        document.addEventListener("DOMContentLoaded", function() {
            // Pega todos os radios do Brick (eles são criados dinamicamente)
            const radios = document.querySelectorAll('.mp-checkout-bricks__radio-1PmnbF');

            radios.forEach((radio, index) => {
                radio.addEventListener('change', function() {
                    const containerPai = radio.closest('.mp-checkout-bricks__selector-1NMycq');
                    const textoMetodo = containerPai.querySelector('p')?.textContent;

                    if (textoMetodo && textoMetodo.toLowerCase().includes("crédito")) {
                        // Executa ação quando seleciona cartão de crédito
                        console.log("Cartão de crédito selecionado");

                        // Exemplo de ação:
                        document.getElementById("id_number_installments").disabled = false;
                        document.querySelector(".card-payment-data").style.display = "block";
                    }
                });
            });
        });
    </script>
@endpush
