<!doctype html>
<html lang="pt">

<head>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="theme-color" content="#000000">
    <title>{{ env('EMPRESA') }}</title>
    <meta name="description" content="{{ env('EMPRESA') }}">
    <meta name="keywords" content="{{ env('EMPRESA') }}" />
    {{-- <link rel="icon" type="image/png" href="{{ url('app') }}/assets/img/favicon.png" sizes="32x32">
    <link rel="apple-touch-icon" sizes="180x180" href="{{ url('app') }}/assets/img/icon/192x192.png"> --}}
    <link rel="stylesheet" href="{{ url('app') }}/assets/css/style.css?v={{ rand() }}">
    <link rel="manifest" href="{{ url('app') }}/__manifest.json">
    <script src="https://sdk.mercadopago.com/js/v2"></script>
</head>

<body>
    @yield('content')
    <div id="error_geral" class="toast-box toast-top bg-danger">
        <div class="in">
            <div class="text">{{ !empty(session('error')) ? session('error') : '' }}</div>
        </div>
        <button type="button" class="btn btn-sm btn-text-light close-button">OK</button>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- ========= JS Files =========  -->
    <!-- Bootstrap -->
    <script src="{{ url('app') }}/assets/js/lib/bootstrap.bundle.min.js"></script>
    <!-- Ionicons -->
    <script type="module" src="https://cdn.jsdelivr.net/npm/ionicons@latest/dist/ionicons/ionicons.esm.js"></script>
    <!-- Splide -->
    <script src="{{ url('app') }}/assets/js/plugins/splide/splide.min.js"></script>
    <!-- Base Js File -->
    <script src="{{ url('app') }}/assets/js/base.js"></script>
    <script>
        @if (session('error'))
            toastbox('error_geral', 3000);
        @endif
    </script>

    @stack('js')
</body>

</html>
