@extends('admin.base.base')
@section('titulo','Recibo VIA Br '. date('d-m-Y'))
@section('content')
<div class="content-wrapper" style="min-height: 589px;">
    <div class="container-full">
              <!-- Main content -->
      <section class="invoice printableArea">
        <div class="row">
          <div class="col-12">
            <div class="bb-1 clearFix">
              <div class="text-end pb-15">
                 <button id="print2" class="btn btn-warning" type="button"> <span><i class="fa fa-print"></i> Imprimir</span> </button>
              </div>
            </div>
          </div>
          <div class="col-12">
            <div class="page-header">
              <h2 class="d-inline"><span class="fs-30">Recibo VIA Br</span></h2>
              <div class="pull-right text-end">
                  <h3>{{ $semana[date('w',strtotime($dia))] }}, {{ date('d',strtotime($dia)) }} de {{ $mes[date('m',strtotime($dia))] }} de {{ date('Y',strtotime($dia)) }}</h3>
              </div>
            </div>
          </div>
        </div>
        <div class="row">
            <div class="table-responsive-sm">
                <table class="table mb-0">
                  <thead>
                    <tr>
                      <th scope="col">Horário</th>
                      <th scope="col">Origem-Destino</th>
                      <th scope="col">Passagens QTD</th>
                      <th scope="col">Valor</th>
                      <th scope="col">Astran</th>
                      <th scope="col">Tut</th>
                      <th scope="col">Subtotal</th>
                    </tr>
                  </thead>
                  <tbody>
                    @php
                        $total_saida = 0;
                        $previous_passagem_id = null;
                    @endphp
                    @foreach ($passagens as $passagem)
                    <tr>
                        <td>{{ $passagem->Viagem->horario }} - {{ $passagem->Viagem->id }} </td>
                        <td>{{ $passagem->Viagem->Origem->nome }}<->{{ $passagem->Viagem->Destino->nome }} </td>
                        <td>{{ $passagem->qtd_total  }}</td>
                        <td>R$ {{ moeda($passagem->preco_unitario) }}</td>
                        <td>R$ {{ $passagem->astran_total   > 0 ? moeda($passagem->qtd_total*env('TAXAASTRAN')) : '0,00' }}
                        <td>R$ {{ $passagem->tut_total      > 0 ? moeda($passagem->qtd_total * env('TAXATUT')) : '0,00' }}</td>
                        <td>R$ {{ moeda($passagem->total_total-(($passagem->astran_total == 1 ? $passagem->qtd_total * env('TAXAASTRAN') : '0')+($passagem->tut_total == 1 ? $passagem->qtd_total * env('TAXATUT') : '0'))) }}</td>
                    </tr>
                    @php
                        if ($previous_passagem_id !== $passagem->Viagem->id) {
                            $total_saida += $passagem->Viagem->valor_saida;
                            $previous_passagem_id = $passagem->Viagem->id;
                        }
                    @endphp
                  @endforeach
                  </tbody>
                  <tfoot>
                    <tr>
                        <td></td>
                        <td></td>
                        <td>{{ $passagens->sum('qtd_total')  }}</td>
                        <td>R$ {{ moeda($passagens->sum('total_total'))  }}</td>
                        <td>R$ {{ moeda($astran->sum('qtd_total')*env('TAXAASTRAN')) }}</td>
                        <td>R$ {{ moeda($tut->sum('qtd_total')*env('TAXATUT')) }}</td>
                        <td>R$ {{ moeda($passagens->sum('total_total')-($astran->sum('qtd_total')*env('TAXAASTRAN')+$tut->sum('qtd_total')*env('TAXATUT'))) }}</td>
                    </tr>
                  </tfoot>
                </table>
              </div>
          <!-- /.col -->
        </div>
        <div class="row">
          <div class="col-12 text-end">
            <br><br>
              <p class="lead"><b>Data do Recebimento</b><span class="text-danger"> __/__/_____ </span></p>
              <div class="total-payment">
                <p>Total saída:R$ {{ moeda($total_saida) }}</p>
                  <h3><b>Total :</b> {{ moeda($passagens->sum('total_total')-($astran->sum('qtd_total')*env('TAXAASTRAN')+$tut->sum('qtd_total')*env('TAXATUT'))-$total_saida) }}</h3>
              </div>
          </div>
          <!-- /.col -->
        </div>
        <div class="row no-print">
          <div class="col-12">
            <button type="button" class="btn btn-success pull-right"><i class="fa fa-credit-card"></i> Confirmar Recebimento</button>
          </div>
        </div>
      </section>
      <!-- /.content -->
    </div>
</div>


@endsection
@section('js')
<script src="{{ url('adm') }}/assets/vendor_components/datatable/datatables.min.js"></script>
<script src="{{ url('adm') }}/src/js/pages/data-table.js"></script>

<script src="{{ url('adm') }}/assets/vendor_plugins/JqueryPrintArea/demo/jquery.PrintArea.js"></script>

<!-- CRMi App -->
<script src="{{ url('adm') }}/src/js/jquery.smartmenus.js"></script>
<script src="{{ url('adm') }}/src/js/menus.js"></script>
<script src="{{ url('adm') }}/src/js/template.js"></script>

<script src="{{ url('adm') }}/src/js/pages/invoice.js"></script>
@endsection
