@extends('admin.base.base')
@section('titulo', 'Relatório de Vendas')
@section('content')
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                <div class="row">
                    <div class="col-12">
                        <div class="box">
                            <div class="row p-10">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">Evento</label>
                                        <select id="eventos" class="form-control select2" multiple="multiple" data-placeholder="Selecione os ingressos" style="width: 100%;">
                                            @foreach ($eventos as $evento)
                                                <option value="{{ $evento->id }}">{{ $evento->titulo }} - {{ date('d/m/Y', strtotime($evento->data_inicio)) }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label class="form-label">Inicio</label>
                                        <input type="date" name="inicio" id="inicio" class="form-control" placeholder="Inicio">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label class="form-label">Fim</label>
                                        <input type="date" name="fim" id="fim" class="form-control" placeholder="Fim">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    {{-- <button type="submit" class="btn btn-primary btn-sm" style="margin-top: 30px">
                                        <i class="ti-save-alt"></i> Filtrar sub
                                    </button> --}}
                                    <button onclick="javascript:Filtrar()" type="button" class="btn btn-primary btn-sm" style="margin-top: 30px">
                                        <i class="ti-save-alt"></i> Filtrar
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-12">
                        <div class="box">
                            <div class="box-body">
                                <div class="table-responsive">
                                    <table class="table table-center table-hover datatable">
                                        <thead class="thead-light">
                                            <tr>
                                                <th style="width: 20%">Evento</th>
                                                <th style="width: 20%">Ingressos Seguro</th>
                                                <th style="width: 20%">Total Seguro</th>
                                                <th style="width: 20%">Ingressos Cliente</th>
                                                <th style="width: 20%">Total Cliente</th>
                                            </tr>
                                        </thead>
                                        <tr id="progress" class="d-none">
                                            <td colspan="6">
                                                <div class="progress">
                                                    <div class="progress-bar progress-bar-success progress-bar-striped progress-bar-animated" role="progressbar" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100" style="width: 100%">
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        <tbody id="result_pagamentos">

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
            </section>
        </div>
    </div>
@endsection
@section('js')

    <!-- Vendor JS -->
    <script src="{{ url('assets/vendor_components/bootstrap-select/dist/js/bootstrap-select.js') }}"></script>
    <script src="{{ url('assets/vendor_components/bootstrap-tagsinput/dist/bootstrap-tagsinput.js') }}"></script>
    <script src="{{ url('assets/vendor_components/bootstrap-touchspin/dist/jquery.bootstrap-touchspin.min.js') }}"></script>
    <script src="{{ url('assets/vendor_components/select2/dist/js/select2.full.js') }}"></script>
    <script src="{{ url('assets/vendor_plugins/input-mask/jquery.inputmask.js') }}"></script>
    <script src="{{ url('assets/vendor_plugins/input-mask/jquery.inputmask.date.extensions.js') }}"></script>
    <script src="{{ url('assets/vendor_plugins/input-mask/jquery.inputmask.extensions.js') }}"></script>
    <script src="{{ url('assets/vendor_components/moment/min/moment.min.js') }}"></script>
    <script src="{{ url('assets/vendor_components/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
    <script src="{{ url('assets/vendor_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js') }}"></script>
    <script src="{{ url('assets/vendor_components/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.min.js') }}"></script>
    <script src="{{ url('assets/vendor_plugins/timepicker/bootstrap-timepicker.min.js') }}"></script>
    <script src="{{ url('assets/vendor_plugins/iCheck/icheck.min.js') }}"></script>

    <script src="{{ url('admin/src/js/pages/advanced-form-element.js') }}"></script>
    <script src="{{ url('assets/vendor_components/datatable/datatables.min.js') }}"></script>
    <script src="{{ url('admin/src/js/pages/data-table.js') }}"></script>

    <script>
        let loadingInterval = null;

        function Filtrar() {
            $("#result_pagamentos").addClass('d-none'); // Esconde o resultado anterior
            let $progress = $("#progress");
            let $progressBar = $progress.find('.progress-bar');

            // Reseta e exibe a barra de progresso
            clearInterval(loadingInterval);
            $progress.removeClass('d-none');
            $progressBar.css('width', '0%').attr('aria-valuenow', 0);

            let percentage = 0;
            loadingInterval = setInterval(() => {
                percentage += Math.floor(Math.random() * 10) + 5;
                if (percentage >= 90) {
                    clearInterval(loadingInterval);
                } else {
                    $progressBar.css('width', percentage + '%').attr('aria-valuenow', percentage);
                }
            }, 200);

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('filtrar.seguros.lopak') }}",
                method: 'POST',
                data: {
                    inicio: $("#inicio").val(),
                    fim: $("#fim").val(),
                    eventos: $("#eventos").val(),
                },
                success: function(result) {
                    $("#result_pagamentos").removeClass('d-none');
                    clearInterval(loadingInterval);
                    $progressBar.css('width', '100%').attr('aria-valuenow', 100);
                    setTimeout(() => {
                        $progress.addClass('d-none');
                        $progressBar.css('width', '0%').attr('aria-valuenow', 0);
                        $("#result_pagamentos").html(result);
                    }, 300);
                },
                error: function() {
                    clearInterval(loadingInterval);
                    $progress.addClass('d-none');
                    $progressBar.css('width', '0%').attr('aria-valuenow', 0);
                    alert('Erro ao gerar relatório');
                }
            });
        }
    </script>

@endsection
