@extends('admin.base.base')
@section('titulo','Relatório Diário '. date('d-m-Y'))
@section('content')
<div class="content-wrapper" style="min-height: 589px;">
    <div class="container-full">
      <!-- Content Header (Page header) -->
      <div class="content-header">
          <div class="d-flex align-items-center">
              <div class="me-auto">
                  <h3 class="page-title">Relatório Diário</h3>
                  <div class="d-inline-block align-items-center">
                      <nav>
                          <ol class="breadcrumb">
                              <li class="breadcrumb-item"><a href="#"><i class="mdi mdi-home-outline"></i></a></li>
                              <li class="breadcrumb-item active" aria-current="page">Relatório Diário</li>
                          </ol>
                      </nav>
                  </div>
              </div>

          </div>
      </div>

      <!-- Main content -->
      <section class="content">
        <div class="row">
          <div class="col-xl-8 col-lg-8 col-12">
              <div class="box">
                  <div class="box-header with-border">
                      <h4 class="box-title">Relatório Diário</h4>
                      <h6 class="box-subtitle">Exporte</h6>
                  </div>
                  <div class="box-body">
                      <div class="table-responsive">
                          <div id="example_wrapper" class="dataTables_wrapper container-fluid dt-bootstrap4 no-footer">
                            <table id="example" class="table table-lg invoice-archive dataTable no-footer" role="grid" aria-describedby="example_info">
                              <thead>
                                  <tr role="row">
                                    <th class="sorting">Data</th>
                                    <th class="sorting">Emb</th>
                                    <th class="sorting">Hora</th>
                                    <th class="sorting">Ori/Des</th>
                                    <th class="sorting">Coordenador</th>
                                    <th class="sorting">Fiscal</th>
                                    <th class="sorting">Marinheiro</th>
                                    <th class="sorting">Máquina</th>
                                    <th class="sorting">Passagens</th>
                                    <th class="sorting">Tut</th>
                                    <th class="sorting">Astran</th>
                                    <th class="sorting">Total</th>
                                    <th class="sorting"></th>
                                 </tr>
                              </thead>
                              <tbody>
                                @foreach ($viagens as $viagem)
                                <tr role="row" class="odd" onclick="javascript:Abrir({{ $viagem->id }})">
                                    <td class="sorting_1">{{ date('d/m/Y',strtotime($viagem->created_at)) }}</td>
                                    <td>{{ $viagem->Embarcacao->nome }}</td>
                                    <td>{{ $viagem->horario }}</td>
                                    <td>{{ $viagem->Origem->nome }}/{{ $viagem->Destino->nome }}</td>
                                    <td>{{ $viagem->Coordenador->name }}</td>
                                    <td>{{ $viagem->Fiscal->name }}</td>
                                    <td>{{ $viagem->Marinheiro->name }}</td>
                                    <td>{{ $viagem->Maquina->name }}</td>
                                    <td>{{ $viagem->Passagens->sum('qtd') }}</td>
                                    <td>
                                        <h6 class="mb-0 fw-bold">
                                            R$ {{ moeda($viagem->Passagens->where('tut','1')->sum('qtd')*env('TAXATUT')) }}
                                            <span class="d-block text-muted fw-normal">{{ $viagem->Passagens->where('tut','1')->sum('qtd') }} Passagens</span>
                                        </h6>
                                    </td>
                                    <td>
                                        <h6 class="mb-0 fw-bold">
                                            R$ {{ moeda($viagem->Passagens->where('astran','1')->sum('qtd')*env('TAXAASTRAN')) }}
                                            <span class="d-block text-muted fw-normal">{{ $viagem->Passagens->where('astran','1')->sum('qtd') }} Passagens</span>
                                        </h6>
                                    </td>
                                    <td><h6 class="mb-0 fw-bold">R$ {{ moeda($viagem->Passagens->sum('total')) }}</h6></td>
                                    <td class="text-center">
                                        <div class="list-icons d-inline-flex">
                                            <a href="#" class="list-icons-item me-10"><i class="fa fa-file-text"></i></a>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                          </table>
                      </div>
                      </div>
                  </div>
              </div>
          </div>
          <div class="col-xl-4 col-lg-4 col-12">
            <a class="btn btn-primary" href="{{ route('recibo.recebimento',date('Y-m-d')) }}">Gerar Recibo de Recebimento</a>
            <div class="box">
                <div class="box-header">
                    <h4 class="box-title">Resumo Faturamento Hoje</h4>
                </div>
                <div class="box-body">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th colspan="2" class="text-center">Resumo Faturamento Hoje</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td colspan="2" class="text-end">R$ {{ $resumo['bruto'] }}</td>
                            </tr>
                            <tr>
                                <td colspan="2" class="text-center"><strong>TARIFAS/SAÍDAS(PASSAGEM IMPRESSA)</strong></td>
                            </tr>
                            <tr>
                                <td>Astran</td>
                                <td class="text-end">R$ {{ $resumo['astran'] }}</td>
                            </tr>
                            <tr>
                                <td>TUT</td>
                                <td class="text-end">R$ {{ $resumo['tut'] }}</td>
                            </tr>
                            <tr>
                                <td>Saídas</td>
                                <td class="text-end">R$ {{ moeda($viagens->sum('valor_saida')) }}</td>
                            </tr>
                            <tr>
                                <td colspan="2" class="text-center"><strong>TARIFAS (AVULSA)</strong></td>
                            </tr>
                            <tr>
                                <td>Astran</td>
                                <td class="text-end">R$ {{ $resumo['astran_av'] }}</td>
                            </tr>
                            <tr>
                                <td>TUT</td>
                                <td class="text-end">R$ {{ $resumo['tut_av'] }}</td>
                            </tr>
                            <tr>
                                <td colspan="2" class="text-center"><strong>FATURAMENTO HOJE</strong></td>
                            </tr>
                            <tr>
                                <td colspan="2" class="text-end">R$ {{ $resumo['saldo'] }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        </div>
      </section>
      <!-- /.content -->
    </div>
</div>

<div id="recibo" class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="myLargeModalLabel">Via Br</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="result_recibo"></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger text-start" data-bs-dismiss="modal">Fechar</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
@endsection
@section('js')
<script src="{{ url('adm') }}/assets/vendor_components/datatable/datatables.min.js"></script>
<script src="{{ url('adm') }}/src/js/pages/data-table.js"></script>
<script>
    function Abrir(id){
        $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('gerar.recibo') }}",
                method: 'POST',
                data: {
                    id
                },
                success: function(result) {
                    $("#result_recibo").html(result);
                    $("#recibo").modal('show');
                }
            });
    }
</script>
