<div class="modal-header">
    <h4 class="modal-title" id="myLargeModalLabel">Via Br</h4>
    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
</div>
<div class="modal-body">

<section class="invoice printableArea">
    <div class="row">
      <div class="col-12">
        <div class="page-header">
          <h2 class="d-inline"><span class="fs-30">Recibo de Viagem {{ $viagem->id  }}</span></h2>
          <div class="pull-right text-end">
              <h3>{{ date('d/m/Y',strtotime($viagem->created_at)) }}</h3>
          </div>
        </div>
      </div>
      <!-- /.col -->
    </div>
    <div class="row invoice-info">
      <div class="col-sm-12 invoice-col mb-15">
          <div class="invoice-details row no-margin">
            <div class="col-md-6 col-lg-3"><b>De </b>{{ $viagem->Destino->nome }} às {{ $viagem->horario }}</div>
            <div class="col-md-6 col-lg-3"><b>Para:</b> {{ $viagem->Destino->nome }}</div>
          </div>
      </div>
    <!-- /.col -->
    </div>
    <div class="row">
      <div class="col-12 table-responsive">
        <table class="table table-bordered">
          <tbody>
          <tr>
            <th>Tabela</th>
            <th>QTD</th>
            <th>Valor</th>
            <th>Total</th>
          </tr>
          <tr>
            @foreach ($viagem->Passagens as $item)
                <tr>
                    <td>{{ $item->TabelaPreco->categoria }}</td>
                    <td>{{ $item->qtd }}</td>
                    <td>R$ {{ moeda($item->preco) }}</td>
                    <td>R$ {{ moeda($item->preco*$item->qtd) }}</td>
                </tr>
            @endforeach
          </tr>
          </tbody>
        </table>
      </div>
      <!-- /.col -->
    </div>
    <div class="row">
      <div class="col-12 text-end">
          <div class="total-payment">
              <h3><b>Total :</b> R$ {{ moeda($viagem->Passagens->sum('total')) }}</h3>
          </div>
      </div>
    </div>
  </section>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger text-start pull-left" onclick="javascript:ExcluirViagens({{ $viagem->id }})">Excluir</button>
    <button type="button" class="btn btn-danger text-start  pull-right" data-bs-dismiss="modal">Fechar</button>
</div>
