<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <title>Carteira Estudantil</title>

    <style>
        body {
            margin: 0;
            padding: 0;
            background: transparent;
            font-family: Arial, Helvetica, sans-serif;
        }

        /* CONTAINER REAL DO CARTÃO */
        .carteira-wrapper {
            position: relative;
            width: 86mm;
            height: 54mm;
            margin: 0 auto;
            background: transparent;
        }

        /* CAMPOS */
        .campo {
            position: absolute;
            color: #000;
        }

        /* ================= NOME ================= */
        .campo.nome-principal {
            left: 11%;
            top: 25%;
            width: 48mm;
            font-size: 11px;
            font-weight: bold;
            text-transform: uppercase;

            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }


        /* ================= FOTO ================= */
        .campo.foto {
            left: 9%;
            top: 41%;
            width: 35mm;
            height: 45mm;
        }

        .campo.foto img {
            width: 81px;
            height: 101px;
            object-fit: cover;
            border-radius: 6px;
        }

        /* ================= DADOS ================= */
        .campo.dados {
            left: 36%;
            top: 44%;
            width: 38%;
            font-size: 10px;
            line-height: 1.4;
        }

        /* ================= QR CODE ================= */
        .campo.qrcode {
            right: 4mm;
            top: 32%;
            width: 14mm;
            /* ZONA FIXA */
            text-align: center;
        }

        .campo.qrcode {
            z-index: 10;
        }

        .campo.nome-principal {
            z-index: 1;
        }


        .campo.qrcode img {
            width: 46px;
            height: 46px;
        }

        .campo.qrcode .codigo {
            margin-top: 4px;
            font-size: 9px;
        }

        /* ================= IMPRESSÃO ================= */
        @media print {
            @page {
                size: 86mm 54mm;
                margin: 0;
            }

            body {
                margin: 0;
            }
        }
    </style>
</head>

<body>

    <div class="carteira-wrapper">

        <!-- NOME -->
        <div class="campo nome-principal">
            {{ $carteira->nome_completo }}
        </div>

        <!-- FOTO -->
        <div class="campo foto">
            <img src="{{ $carteira->foto }}">
        </div>

        <!-- DADOS -->
        <div class="campo dados">
            <div>CPF/CIN: {{ $carteira->cpf }}</div>
            <div>Data nasc.: {{ $carteira->nascimento }}</div>
            <div>Inst. Ensino: {{ $carteira->instituicao_ensino }}</div>
            <div>Nível de Ensino: {{ $carteira->nivel_ensino }}</div>
            <div>Curso: {{ $carteira->curso }}</div>
        </div>

        <!-- QR CODE -->
        <div class="campo qrcode">
            <img src="{{ $carteira->qr_code }}">
            <div class="codigo">
                <small>Cód. de uso CNE</small><br>
                <strong>{{ $carteira->registro }}</strong>
            </div>
        </div>

    </div>

</body>

</html>
