@extends('admin.base.base')
@section('titulo', 'Home')
@section('content')
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                <div class="row">
                    <div class="col-12">
                        <div class="box">
                            <div class="box-body">
                                <p class="subtitle mb-20">Gerar nova carteira</p>
                                <div class="clearfix">
                                    <a href="https://intranet.ucesub.com.br/carteira/create " class="waves-effect waves-light btn btn-primary mb-5">Criar</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="box">
                            <div class="box-header with-border">
                                <h4 class="box-title">Carteirinhas</h4>
                            </div>
                            <div class="box-body p-15">
                                <div class="table-responsive">
                                    <div id="tickets_wrapper" class="dataTables_wrapper container-fluid dt-bootstrap4 no-footer">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <table id="tickets" class="table mt-0 table-hover no-wrap dataTable no-footer" data-page-size="10" role="grid" aria-describedby="tickets_info">
                                                    <thead>
                                                        <tr role="row">
                                                            <th class="sorting"></th>
                                                            <th class="sorting_des" tabindex="0" aria-sort="ascending">Nome</th>
                                                            <th class="sorting">CPF</th>
                                                            <th class="sorting">RG</th>
                                                            <th class="sorting">Nascimento</th>
                                                            <th class="sorting">Instituição</th>
                                                            <th class="sorting">Curso</th>
                                                            <th class="sorting">Cod</th>
                                                            <th class="sorting">Data</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach ($carteiras as $carteira)
                                                            <tr>
                                                                <td>
                                                                    <a href="{{ route('gerenciar.pedido', $carteira->Pedido) }}" target="_blank" class="waves-effect waves-light btn btn-warning btn-xs">Gerenciar</a>
                                                                </td>
                                                                <td>{{ $carteira->nome_completo }}</td>
                                                                <td>{{ $carteira->cpf }}</td>
                                                                <td>{{ $carteira->Cliente->rg ?? '' }}</td>
                                                                <td>{{ date('d/m/Y', strtotime($carteira->Cliente->nascimento)) ?? '' }}</td>

                                                                {{-- agora vindo do JSON --}}
                                                                <td>{{ $carteira->instituicao_ensino }}</td>
                                                                <td>{{ $carteira->curso }}</td>
                                                                <td>{{ $carteira->matricula }}</td>
                                                                <td>
                                                                    <span class="badge badge-warning">{{ $carteira->registro }}</span>
                                                                </td>
                                                                <td>{{ date('d/m/Y', strtotime($carteira->created_at)) }}</td>
                                                            </tr>
                                                        @endforeach

                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
@endsection
@section('js')


    <script src="{{ url('adm') }}/assets/vendor_components/datatable/datatables.min.js"></script>
    <script src="{{ url('adm') }}/assets/vendor_components/jquery.peity/jquery.peity.js"></script>

    <!-- CRMi App -->
    <script src="{{ url('adm') }}/src/js/jquery.smartmenus.js"></script>
    <script src="{{ url('adm') }}/src/js/menus.js"></script>
    <script src="{{ url('adm') }}/src/js/template.js"></script>

    <script src="{{ url('adm') }}/src/js/pages/data-table.js"></script>
    <script src="{{ url('adm') }}/src/js/pages/app-ticket.js"></script>

    <script src="{{ url('adm') }}/assets/vendor_components/sweetalert/sweetalert.min.js"></script>
    <script src="{{ url('adm') }}/assets/vendor_components/sweetalert/jquery.sweet-alert.custom.js"></script>

    <script>
        @if (session('success'))
            swal(
                "Sucesso",
                "{{ session('success') }}",
                "success"
            );
        @endif
    </script>
@endsection
