@extends('admin.base.base')
@section('titulo', 'Participantes ' . $Evento->titulo)
@section('content')
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                @include('admin.evento.include.info')

                <div class="row">
                    <div class="col-sm-12">
                        <div class="box">
                            <div class="box-body">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="form-label">Busca Rápida</label>
                                            <input type="text" id="busca_participante" class="form-control" placeholder="Nome do participante">
                                        </div>
                                    </div>
                                </div>
                                <table id="ingressos" class="table mt-0 table-hover no-wrap dataTable no-footer" data-page-size="10" role="grid" aria-describedby="tickets_info">
                                    <thead>
                                        <tr role="row">
                                            <th class="sorting">Nº Pedido</th>
                                            <th class="sorting center" colspan="2"></th>
                                            <th class="sorting center">Status</th>
                                            <th class="sorting">Participante</th>
                                            <th class="sorting">Cód Segurança</th>
                                            <th class="sorting">Tipo</th>
                                            <th class="sorting">Comprado Por</th>
                                            <th class="sorting">Data da Compra</th>
                                        </tr>
                                    </thead>
                                    <tbody id="result_ingressos">
                                        @foreach ($ingressos as $item)
                                            <tr role="row" class="odd">
                                                <td>
                                                    <a href="{{ route('editar.pedido', $item->pedido_id) }}" target="_blank" class="waves-effect waves-light btn btn-success btn-xs">Gerenciar</a>
                                                </td>
                                                <td>
                                                    <a href="{{ route('validar.carteira', $item->Pedido->registro) }}" target="_blank" class="waves-effect waves-light btn btn-info btn-xs">Abrir</a>
                                                </td>
                                                <td>
                                                    <a href="javascript:void(0)" onclick="javascript:SendEmail({{ $item->id }})" class="waves-effect waves-light btn btn-info btn-xs">Enviar</a>
                                                </td>
                                                <td class="center">
                                                    <span class="badge badge-xl badge-dot badge-{{ $cor_status_ingresso[$item->status] }}"></span>
                                                </td>
                                                <td>{{ $item->nome_completo }}</td>
                                                <td>{{ $item->Pedido->registro }}</td>
                                                <td>{{ $item->Pacote->nome }}</td>
                                                <td>{{ !empty($item->Pedido->Cliente->name) ? $item->Pedido->Cliente->name : 'Não informado' }}
                                                    {{ !empty($item->Pedido->Cliente->sobrenome) ? $item->Pedido->Cliente->sobrenome : '' }}
                                                </td>
                                                <td>{{ date('d/m/Y H:i', strtotime($item->created_at)) }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
@endsection
@section('css')
    <style>

    </style>
@endsection
@section('js')
    <script src="{{ url('assets/vendor_components/datatable/datatables.min.js') }}"></script>
    <script src="{{ url('assets/vendor_components/jquery.peity/jquery.peity.js') }}"></script>
    <script src="{{ url('admin') }}/src/js/pages/data-table.js"></script>
    <script src="{{ url('admin') }}/src/js/pages/app-ticket.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        function SendEmail(id) {
            mostrarLoaderSwal();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('enviar.ingresso.email') }}",
                method: 'POST',
                data: {
                    id: id
                },
                success: function(result) {
                    Swal.close();
                },
                error: function(xhr, status, error) {
                    swal(
                        "Erro",
                        "Erro ao enviar",
                        "danger"
                    );
                    setTimeout(() => {
                        swal.close();
                    }, 1500);
                }
            });
        }


        function mostrarLoaderSwal() {
            Swal.fire({
                title: "Aguarde",
                html: "Enviando E-mail... <b></b>",
                allowOutsideClick: false,
                allowEscapeKey: false,
                timer: 10000,
                timerProgressBar: true,
                didOpen: () => {
                    Swal.showLoading();
                    const timer = Swal.getPopup().querySelector("b");
                    timerInterval = setInterval(() => {
                        if (Swal.getTimerLeft() !== null) {
                            timer.textContent = `${Math.ceil(Swal.getTimerLeft() / 1000)}s`;
                        }
                    }, 100);
                },
                willClose: () => {
                    clearInterval(timerInterval);
                }
            });
        }

        let offset = 10;
        let carregando = false;
        $(window).on('scroll', function() {
            if (!carregando && $(window).scrollTop() + $(window).height() >= $(document).height() - 100) {
                carregando = true;

                $.ajax({
                    url: "{{ route('evento.participantes', ['Evento' => $Evento->id]) }}",
                    method: 'GET',
                    data: {
                        offset: offset
                    },
                    success: function(response) {
                        if (response.count > 0) {
                            $('#ingressos tbody').append(response.html);
                            offset += response.count;
                            carregando = false;
                        }
                    },
                    error: function() {
                        carregando = false;
                    }
                });
            }
        });

        $(document).ready(function() {
            $("#busca_participante").keyup(function() {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: "{{ route('buscar.participante') }}",
                    method: 'POST',
                    data: {
                        s: $("#busca_participante").val(),
                        evento_id: "{{ $Evento->id }}"
                    },
                    success: function(response) {
                        $("#result_ingressos").html(response);
                    },
                    error: function() {
                        console.error('Erro ao buscar participante.');
                    }
                });
            });
        });
    </script>
@endsection
