@extends('admin.base.base')
@section('titulo', $Evento->titulo)
@section('content')
    <div class="content-wrapper">
        <div class="container-full">
            <!-- Main content -->
            <section class="content">
                @include('admin.evento.include.info')
                <div class="row">
                    <div class="col-lg-7 col-md-7 col-sm-12">
                        <div class="box">
                            <div class="box-body">
                                <div class="d-md-flex justify-content-between align-items-center">
                                    <div>
                                        <h4 class="mb-0">Detalhes do evento</h4>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <!-- Coluna Esquerda -->
                                    <div class="col-12 col-xl-6">
                                        <div class="row">
                                            <!-- Status -->
                                            <div class="col-12">
                                                <div class="py-10">
                                                    <div class="text-fade">Status</div>
                                                    <div class="">
                                                        <span class="badge badge-lg badge-dot badge-{{ $status[$Evento->status] }}"></span>
                                                        <span class="text-{{ $status[$Evento->status] }}">{{ $Evento->status }}</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Visibilidade -->
                                            <div class="col-12">
                                                <div class="py-10">
                                                    <div class="text-fade">Visibilidade</div>
                                                    <div class="">{{ $Evento->tipo }}</div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Coluna Direita -->
                                    <div class="col-12 col-xl-6">
                                        <div class="row">
                                            <!-- Visualizações da página de vendas -->
                                            <div class="col-12">
                                                <div class="py-10">
                                                    <div class="text-fade">Visualizações da página de vendas
                                                    </div>
                                                    <div class="">{{ $Evento->views }}</div>
                                                </div>
                                            </div>
                                            <!-- Compartilhar -->
                                            <div class="col-12">
                                                <div class="py-10">
                                                    <div class="text-fade">Compartilhar:
                                                        <a href="https://www.facebook.com/sharer/sharer.php?u={{ env('BASE_SITE') }}/evento/{{ $Evento->url }}/{{ $Evento->id }}" target="_blank">
                                                            <img src="http://d1gkntzr8mxq7s.cloudfront.net/6661d0092d036.svg" width="20">
                                                        </a>
                                                        <a href="https://twitter.com/intent/tweet?url={{ env('BASE_SITE') }}/evento/{{ $Evento->url }}/{{ $Evento->id }}" target="_blank">
                                                            <img src="http://d1gkntzr8mxq7s.cloudfront.net/6661ce3f75d4e.svg" width="20">
                                                        </a>
                                                        <a href="https://web.whatsapp.com/send?text={{ env('BASE_SITE') }}/evento/{{ $Evento->url }}/{{ $Evento->id }}" target="_blank">
                                                            <img src="http://d1gkntzr8mxq7s.cloudfront.net/6661ccf8020f1.svg" width="20">
                                                        </a>
                                                        <a href="https://www.tiktok.com/share/item?url={{ env('BASE_SITE') }}/evento/{{ $Evento->url }}/{{ $Evento->id }}" target="_blank">
                                                            <img src="http://d1gkntzr8mxq7s.cloudfront.net/6679e9aab3b87.svg" width="20">
                                                        </a>
                                                        <a href="https://www.instagram.com/?url={{ env('BASE_SITE') }}/evento/{{ $Evento->url }}/{{ $Evento->id }}" target="_blank">
                                                            <img src="http://d1gkntzr8mxq7s.cloudfront.net/667b258544738.svg" width="20">
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Link Sympla -->
                                            <div class="col-12">
                                                <div class="py-10">
                                                    <a href="{{ env('BASE_SITE') }}/evento/{{ $Evento->url }}/{{ $Evento->id }}" class="text-primary" target="_blank">
                                                        {{ env('BASE_SITE') }}/evento/{{ $Evento->url }}/{{ $Evento->id }}
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Conteúdo do Detalhes do Evento aqui -->
                            </div>
                        </div>
                    </div>

                    <!-- Bloco Financeiro (40%) -->
                    <div class="col-lg-5 col-md-5 col-sm-12">
                        <div class="box">
                            <div class="box-body">
                                <div class="d-md-flex justify-content-between align-items-center">
                                    <div>
                                        <h4 class="mb-0">Financeiro</h4>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <!-- Coluna Esquerda -->
                                    <div class="col-12 col-xl-6">
                                        <div class="row">
                                            <!-- Vendas Totais -->
                                            <div class="col-12">
                                                <div class="py-10">
                                                    <div class="text-fade">Total com taxas</div>
                                                    <div class="fs-18 text-success">R$
                                                        {{ moeda($Evento->Pedidos->where('status', 'Aprovado')->sum('total')) }}
                                                    </div>
                                                    <!-- Verde para Vendas Totais -->
                                                </div>
                                            </div>
                                            <!-- Total a Receber -->
                                            <div class="col-12">
                                                <div class="py-10">
                                                    <div class="text-fade">Total sem taxas</div>
                                                    <div class="fs-18">R$ {{ moeda($Evento->Pedidos->where('status', 'Aprovado')->sum('sub_total')) }}
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Ticket Médio Bruto -->
                                            <div class="col-12">
                                                <div class="py-10">
                                                    <div class="text-fade">Ticket médio (bruto)</div>
                                                    @if (count($Evento->Ingressos->where('status', '1')) > 0 && $Evento->Pedidos->where('status', 'Aprovado')->sum('total') > 0)
                                                        <div class="fs-18">R$ {{ moeda($Evento->Pedidos->where('status', 'Aprovado')->sum('total') / count($Evento->Ingressos->where('status', '1'))) }}
                                                        </div>
                                                    @else
                                                        <div class="fs-18">R$ 0,00</div>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Coluna Direita -->
                                    <div class="col-12 col-xl-6">
                                        <div class="row">
                                            <!-- Em Processamento -->
                                            <div class="col-12">
                                                <div class="py-10">
                                                    <div class="text-fade">Em Processamento (Pendentes)
                                                    </div>
                                                    <div class="fs-18 text-warning">R$ {{ moeda($Evento->Pedidos->where('status', 'Pendente')->sum('total')) }}</div>
                                                    <!-- Amarelo para Em Processamento -->
                                                </div>
                                            </div>
                                            <!-- Total Recebido -->
                                            <div class="col-12">
                                                <div class="py-10">
                                                    <div class="text-fade">Taxas</div>
                                                    <div class="fs-18">R$ {{ moeda($Evento->Pedidos->where('status', 'Aprovado')->sum('taxa')) }}</div>
                                                </div>
                                            </div>
                                            <!-- Ticket Médio Líquido -->
                                            <div class="col-12">
                                                <div class="py-10">
                                                    <div class="text-fade">Ticket Médio (Líquido)</div>
                                                    <div class="fs-18">
                                                        @if ($Evento->Pedidos->where('status', 'Aprovado')->sum('total') > 0 && count($Evento->Ingressos->where('status', '1')) > 0)
                                                            R$
                                                            {{ moeda(($Evento->Pedidos->where('status', 'Aprovado')->sum('total') - $Evento->Pedidos->where('status', 'Aprovado')->sum('taxa')) / count($Evento->Ingressos->where('status', '1'))) }}
                                                        @else
                                                            R$ 0,00
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-xxxl-12 col-xl-12 col-12">
                        <div class="row">
                            <div class="col-xl-4 col-lg-6 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <div>
                                                <div class="bg-warning mb-20 w-50 h-50 rounded10 text-center l-h-50">
                                                    <i class="fs-18 fa fa-money"></i>
                                                </div>
                                                <h4 class="mb-5">Receita</h4>
                                                <p class="text-mute mb-0">R$ {{ moeda($Evento->Pedidos->where('status', 'Aprovado')->sum('sub_total')) }}</p>
                                            </div>
                                            <div id="TotalIngressos"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-6 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <div>
                                                <div class="bg-info mb-20 w-50 h-50 rounded10 text-center l-h-50">
                                                    <i class="fs-18 fa fa-cogs"></i>
                                                </div>
                                                <h4 class="mb-5 text-nowrap">Vendas</h4>
                                                <p class="text-mute mb-0">{{ count($Evento->Pedidos->where('status', 'Aprovado')) }}</p>
                                            </div>
                                            <div id="QtdVendas"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <div>
                                                <div class="bg-success mb-20 w-50 h-50 rounded10 text-center l-h-50">
                                                    <i class="fs-18 fa fa-users"></i>
                                                </div>
                                                <h4 class="mb-5">Participantes</h4>
                                                <p class="text-mute mb-0">{{ count($Evento->Ingressos->where('status', '1')) }}</p>
                                            </div>
                                            <div id="QTDParticiopantes"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="box">
                            <div class="box-header">
                                <h3 class="box-title">
                                    Evolução das vendas
                                </h3>
                            </div>
                            <div class="box-body pb-0">
                                <div id="vendas_meses"></div>
                            </div>
                            <div class="box-body pb-0">
                                <div class="row">
                                    <div class="col-xl-4 col-md-4 col-sm-12">
                                        <div class="box box-body">
                                            <div class="fs-18 flexbox align-items-center text-success">
                                                <span>Carteiras Aprovadas</span>
                                                <i class="icon-Ticket"></i>
                                            </div>
                                            @php
                                                $ingressosAprovados = 0;
                                                $totalIngressos = 0;

                                                foreach ($Evento->Pacotes as $pacote) {
                                                    $qtdAprovados = $pacote->Ingressos->where('status', '1')->count();
                                                    $qtdPorPacote = $pacote->qtd_ingressos > 0 ? $pacote->qtd_ingressos : 1;

                                                    // soma proporcional dos ingressos vendidos
                                                    $ingressosAprovados += $qtdAprovados / $qtdPorPacote;

                                                    // soma do total de ingressos disponíveis
                                                    $totalIngressos += $pacote->qtd;
                                                }

                                                $percentual = MediaVendas($ingressosAprovados, $totalIngressos);
                                            @endphp
                                            <div class="progress progress-xxs mt-10 mb-10">
                                                <div class="progress-bar bg-success" role="progressbar" style="width: {{ $percentual }}%; height: 4px;" aria-valuenow="{{ $percentual }}" aria-valuemin="0"
                                                    aria-valuemax="{{ $totalIngressos }}">
                                                </div>
                                            </div>
                                            <small class="fw-500 mb-5 text-success fs-18">{{ intval($ingressosAprovados) }}</small>
                                        </div>
                                    </div>
                                    <div class="col-xl-4 col-md-4 col-sm-12">
                                        <div class="box box-body">
                                            <div class="fs-18 flexbox align-items-center text-warning">
                                                <span>Carteiras Pendentes</span>
                                                <i class="icon-Ticket"></i>
                                            </div>
                                            @php
                                                $ingressosAprovados = 0;
                                                $totalIngressos = 0;

                                                foreach ($Evento->Pacotes as $pacote) {
                                                    $qtdAprovados = $pacote->Ingressos->where('status', '0')->count();
                                                    $qtdPorPacote = $pacote->qtd_ingressos > 0 ? $pacote->qtd_ingressos : 1;

                                                    // soma proporcional dos ingressos vendidos
                                                    $ingressosAprovados += $qtdAprovados / $qtdPorPacote;

                                                    // soma do total de ingressos disponíveis
                                                    $totalIngressos += $pacote->qtd;
                                                }

                                                $percentual = MediaVendas($ingressosAprovados, $totalIngressos);
                                            @endphp
                                            <div class="progress progress-xxs mt-10 mb-10">
                                                <div class="progress-bar bg-warning" role="progressbar" style="width: {{ $percentual }}%; height: 4px;" aria-valuenow="{{ $percentual }}" aria-valuemin="0"
                                                    aria-valuemax="{{ $totalIngressos }}">
                                                </div>
                                            </div>
                                            <small class="fw-500 mb-5 text-warning fs-18">{{ intval($ingressosAprovados) }}</small>
                                        </div>
                                    </div>
                                    <div class="col-xl-4 col-md-4 col-sm-12">
                                        <div class="box box-body">
                                            <div class="fs-18 flexbox align-items-center text-dark">
                                                <span>Carteiras Canceladas</span>
                                                <i class="icon-Ticket"></i>
                                            </div>
                                            @php
                                                $ingressosAprovados = 0;
                                                $totalIngressos = 0;

                                                foreach ($Evento->Pacotes as $pacote) {
                                                    $qtdAprovados = $pacote->Ingressos->where('status', '2')->count();
                                                    $qtdPorPacote = $pacote->qtd_ingressos > 0 ? $pacote->qtd_ingressos : 1;

                                                    // soma proporcional dos ingressos vendidos
                                                    $ingressosAprovados += $qtdAprovados / $qtdPorPacote;

                                                    // soma do total de ingressos disponíveis
                                                    $totalIngressos += $pacote->qtd;
                                                }

                                                $percentual = MediaVendas($ingressosAprovados, $totalIngressos);
                                            @endphp
                                            <div class="progress progress-xxs mt-10 mb-10">
                                                <div class="progress-bar bg-dark" role="progressbar" style="width: {{ $percentual }}%; height: 4px;" aria-valuenow="{{ $percentual }}" aria-valuemin="0" aria-valuemax="{{ $totalIngressos }}">
                                                </div>
                                            </div>
                                            <small class="fw-500 mb-5 text-dark fs-18">{{ intval($ingressosAprovados) }}</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-12 col-12" id="ingressos">
                        <div class="box">
                            <div class="box-body">
                                <h4 class="box-title text-info mb-0"><i class="glyphicon glyphicon-ticket"></i> Carteiras</h4>
                                <hr class="my-15">
                                <div class="row">
                                    @if (Auth::user()->nivel == '1')
                                    @endif
                                    <div class="col-md-12 text-center" style="margin: 100px 0;">
                                        <p class="text-center">Que tipo de carteira você deseja criar?</p>
                                        <button data-bs-toggle="modal" data-bs-target=".modal_ingresso_pago" type="button" class="waves-effect waves-light btn btn-outline btn-rounded btn-info mb-5">+ Adicionar Carteira</button>
                                        {{-- <button type="button" class="waves-effect waves-light btn btn-outline btn-rounded btn-info mb-5">+ Ingresso Gratuito</button> --}}
                                    </div>
                                    <div class="table-responsive-sm">
                                        <table class="table mb-0">
                                            <thead>
                                                <tr>
                                                    <th scope="col">Tipo</th>
                                                    <th scope="col">Vendidos/Total</th>
                                                    <th scope="col">Valor a Receber</th>
                                                    <th scope="col">Taxa</th>
                                                    <th scope="col">Visibilidade</th>
                                                    <th scope="col"></th>
                                                </tr>
                                            </thead>
                                            <tbody id="result_pacotes">
                                                @foreach ($Evento->Pacotes as $pacote)
                                                    <tr>
                                                        <td>{{ $pacote->nome }}</td>
                                                        <td>
                                                            @php
                                                                $vendidos = count($pacote->Ingressos->where('status', '1'));
                                                                $qtd_ingressos = max($pacote->qtd_ingressos, 1);
                                                                $qtd = max($pacote->qtd, 1);
                                                                $valor = floor($vendidos / $qtd_ingressos); // inteiro
                                                                $percentual = MediaVendas($valor, $qtd);
                                                            @endphp
                                                            <div class="row">
                                                                <div class="text-right nopadding">
                                                                    <div class="progress-container">
                                                                        <div class="progress soldticket-bar pull-left">
                                                                            <div role="progressbar" aria-valuenow="{{ $valor }}" aria-valuemin="0" aria-valuemax="{{ $qtd }}" class="progress-bar"
                                                                                style="width: {{ $percentual }}%;">
                                                                            </div>
                                                                            <span class="progress-sold">{{ $valor }}</span>
                                                                            <span class="progress-total">{{ $qtd }}</span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                        </td>
                                                        <td>R$ {{ moeda($pacote->preco) }}</td>
                                                        <td>R$ {{ moeda(porcentagem(env('TAXA'), $pacote->preco)) }} </td>
                                                        <td>
                                                            <button onclick="javascript:UpdateStatus({{ $pacote->id }})" type="button" class="btn btn-sm btn-toggle btn-info {{ $pacote->status == 'Ativo' ? 'active' : '' }}" data-toggle="button"
                                                                aria-pressed="true"><span class="handle"></span></button>
                                                        </td>
                                                        <td>
                                                            @if (Auth::user()->nivel == '1')
                                                                <a href="javascript:void(0)" onclick="javascript:EditPacote({{ $pacote->id }})">
                                                                    <i class="glyphicon glyphicon-pencil"></i>
                                                                </a>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <td colspan="6" id="taxa_servico">
                                                        <div class="switch serviceFee animated fadeIn">
                                                            <label class="lever-container">
                                                                @if ($Evento->taxa_servico == 0)
                                                                <button onclick="javascript:Desativar({{ $Evento->id }})" type="button" @else <button onclick="javascript:AtivarTaxa({{ $Evento->id }})" type="button" @endif
                                                                        class="btn btn-sm btn-toggle btn-{{ $Evento->taxa_servico == 0 ? 'danger' : 'dark' }} {{ $Evento->taxa_servico == 0 ? 'active' : '' }}"
                                                                        data-toggle="button"
                                                                        aria-pressed="true">
                                                                        <span class="handle"></span>
                                                                    </button>
                                                            </label>
                                                            <span class="f-12 f-w-600 switch__description">
                                                                Absorver a taxa de serviço
                                                                <br>
                                                                <strong class="text-danger">Selecionar essa opção a taxa de serviço de {{ env('TAXA') }}% será incluído no preço final
                                                                    da venda e isso não será mostrado ao comprador.</strong>
                                                            </span>
                                                        </div>
                                                    </td>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- /.content -->
        </div>
    </div>

    <div class="modal fade modal_ingresso_pago" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myLargeModalLabel">Criar ingresso <strong>Pago</strong></h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Título do ingresso</label>
                                    <input type="text" id="titulo_ingresso_pago" class="form-control" placeholder="Ingresso único, Meia-Entrada, VIP, etc">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Quantidade</label>
                                    <input id="qtd_ingresso_pago" type="text" class="form-control" placeholder="Ex. 100">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Valor a receber</label>
                                    <input type="text" id="valor_ingresso_pago" class="form-control preco" placeholder="R$">
                                </div>
                            </div>
                            <div class="form-group ichack-input">
                                <div class="demo-checkbox">
                                    <input type="checkbox" id="criar_meia_entrada" class="chk-col-info">
                                    <label for="criar_meia_entrada"> Criar meia-entrada para este ingresso</label>
                                </div>
                            </div>
                        </div>
                        <div class="row d-none" id="box_meia_entrada">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Título do ingresso</label>
                                    <input type="text" id="nome_meia_pago" class="form-control" placeholder="Ingresso único, Meia-Entrada, VIP, etc" readonly>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Quantidade</label>
                                    <input id="qtd_meia_pago" type="text" class="form-control" placeholder="Ex. 100">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Valor a receber</label>
                                    <input type="text" id="valor_meia_pago" class="form-control preco" placeholder="R$">
                                </div>
                            </div>
                        </div>
                        <div class="row mt-30">
                            <label class="form-label">Período das vendas deste ingresso</label>
                            <div class="row">
                                <div class="col-lg-3 col-md-3 col-6">
                                    <div class="form-group">
                                        <label class="form-label">Data Início</label>
                                        <input id="data_inicio_pago" value="{{ old('data_inicio') }}" type="date" class="form-control date-time">
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-6">
                                    <div class="form-group">
                                        <label class="form-label">Hora Início</label>
                                        <input id="hora_inicio_pago" value="{{ old('hora_inicio') }}" type="time" class="form-control date-time">
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-6">
                                    <div class="form-group">
                                        <label class="form-label">Data Final</label>
                                        <input id="data_fim_pago" value="{{ old('data_fim') }}" type="date" class="form-control date-time">
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-6">
                                    <div class="form-group">
                                        <label class="form-label">Hora Final</label>
                                        <input id="hora_fim_pago" value="{{ old('hora_fim') }}" type="time" class="form-control date-time">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-30">
                            <label class="form-label">Disponibilidade do Ingresso</label>
                            <div class="form-group">
                                <div class="radio">
                                    <input name="disponibilidade" type="radio" id="Option_1" checked="" value="Público">
                                    <label for="Option_1">Para todo o público </label>
                                </div>
                                <div class="radio">
                                    <input name="disponibilidade" type="radio" id="Option_2" value="Convidados">
                                    <label for="Option_2">Restrito a convidados</label>
                                </div>
                                <div class="radio">
                                    <input name="disponibilidade" type="radio" id="Option_3" value="Manual">
                                    <label for="Option_3">Para ser adicionado manualmente</label>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-30">
                            <label class="form-label">Quantidade permitida por compra</label>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label">Mínima</label>
                                            <input id="qtd_minima_compra" type="text" class="form-control" value="1">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label">Máxima</label>
                                            <input id="qtd_maxima_compra" type="text" class="form-control" value="5">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-30">
                            <label class="form-label">Este pacote vai gerar quantos ingressos?</label>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label">Mínima</label>
                                            <input id="qtd_ingressos" type="text" class="form-control" value="1">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger text-start btn-sm" data-bs-dismiss="modal">Cancelar</button>
                    <button onclick="javascript:IngressoStore()" type="button" class="btn btn-primary float-end btn-sm">Criar Ingresso</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>


    <div class="modal fade pacote_modal_edit" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-lg" id="result_pacote">

        </div>
    </div>
@endsection
@section('js')
    <script>
        var totalPedidos = {{ count($Evento->Pedidos) }};
        var pedidosAprovados = {{ count($Evento->Pedidos->where('status', 'Aprovado')) }};
        var pedidosNaoAprovados = totalPedidos - pedidosAprovados;

        var ingressosConfirmados = {{ count($Evento->Ingressos->where('status', '1')) }};
        var ingressosPendentes = {{ count($Evento->Ingressos->where('status', '0')) }};
        var totalIngressos = ingressosConfirmados + ingressosPendentes;

        // --- TotalIngressos ---
        var optionsTotal = {
            series: [pedidosAprovados, pedidosNaoAprovados],
            labels: ['Pagos', 'Pendentes'],
            chart: {
                type: 'donut',
                height: 140,
                width: 140,
            },
            legend: {
                show: false,
            },
            dataLabels: {
                enabled: false,
            },
            plotOptions: {
                pie: {
                    customScale: 0.90,
                    donut: {
                        size: '80%',
                        labels: {
                            show: true,
                            total: {
                                showAlways: true,
                                show: true,
                                label: 'Total',
                                formatter: function() {
                                    return totalPedidos.toString();
                                }
                            }
                        }
                    },
                    offsetY: 0,
                },
                stroke: {
                    colors: undefined
                }
            },
            colors: ['#FFA800', '#FFE9BF'],
        };

        var chart = new ApexCharts(document.querySelector("#TotalIngressos"), optionsTotal);
        chart.render();

        // --- QtdVendas ---
        var optionsQtd = {
            series: [pedidosAprovados, pedidosNaoAprovados],
            labels: ['Pagos', 'Pendentes'],
            chart: {
                type: 'donut',
                height: 140,
                width: 140,
            },
            legend: {
                show: false,
            },
            dataLabels: {
                enabled: false,
            },
            plotOptions: {
                pie: {
                    customScale: 0.90,
                    donut: {
                        size: '80%',
                        labels: {
                            show: true,
                            total: {
                                showAlways: true,
                                show: true,
                                label: 'Total',
                                formatter: function() {
                                    return totalPedidos.toString();
                                }
                            }
                        }
                    },
                    offsetY: 0,
                },
                stroke: {
                    colors: undefined
                }
            },
            colors: ['#006699', '#CEEFFF'],
        };

        var chartVendas = new ApexCharts(document.querySelector("#QtdVendas"), optionsQtd);
        chartVendas.render();

        // --- QTDParticiopantes ---
        var optionsParticipantes = {
            series: [ingressosConfirmados, ingressosPendentes],
            labels: ['Confirmados', 'Pendentes'],
            chart: {
                type: 'donut',
                height: 140,
                width: 140,
            },
            legend: {
                show: false,
            },
            dataLabels: {
                enabled: false,
            },
            plotOptions: {
                pie: {
                    customScale: 0.90,
                    donut: {
                        size: '80%',
                        labels: {
                            show: true,
                            total: {
                                showAlways: true,
                                show: true,
                                label: 'Total',
                                formatter: function() {
                                    return totalIngressos.toString();
                                }
                            }
                        }
                    },
                    offsetY: 0,
                },
                stroke: {
                    colors: undefined
                }
            },
            colors: ['#28a745', '#B20000'], // verde e verde claro
        };

        var chartParticipantes = new ApexCharts(document.querySelector("#QTDParticiopantes"), optionsParticipantes);
        chartParticipantes.render();


        var analyticsBarChartOptions = {
            chart: {
                height: 228,
                type: 'bar',
                toolbar: {
                    show: true
                }
            },
            plotOptions: {
                bar: {
                    horizontal: false,
                    columnWidth: '45%',
                    borderRadius: 3
                },
            },
            dataLabels: {
                enabled: false
            },
            colors: ['#7047ee'],
            series: [{
                name: 'Total de Vendas',
                data: {!! json_encode($vendasDiarias->pluck('total')) !!}
            }],
            xaxis: {
                categories: {!! json_encode($vendasDiarias->pluck('data')) !!},
                axisBorder: {
                    show: false
                },
                axisTicks: {
                    show: false
                },
                labels: {
                    style: {
                        colors: '#333333'
                    }
                }
            },
            yaxis: {
                labels: {
                    style: {
                        color: '#333333'
                    },
                    formatter: function(val) {
                        return 'R$ ' + parseFloat(val).toLocaleString('pt-BR', {
                            minimumFractionDigits: 2
                        });
                    }
                }
            },
            legend: {
                show: false,
            },
            tooltip: {
                y: {
                    formatter: function(val) {
                        return parseFloat(val).toLocaleString('pt-BR', {
                            style: 'currency',
                            currency: 'BRL'
                        });
                    }
                }
            }
        }

        var analyticsBarChart = new ApexCharts(
            document.querySelector("#vendas_meses"),
            analyticsBarChartOptions
        );
        analyticsBarChart.render();


        function IngressoStore() {
            var disponibilidade = $("input[name='disponibilidade']:checked").val();

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('pacote.store') }}",
                method: 'POST',
                data: {
                    evento_id: {{ $Evento->id }},
                    nome: $("#titulo_ingresso_pago").val(),
                    qtd: $("#qtd_ingresso_pago").val(),
                    preco: $("#valor_ingresso_pago").val(),
                    nome_meia_pago: $("#nome_meia_pago").val(),
                    qtd_meia_pago: $("#qtd_meia_pago").val(),
                    valor_meia_pago: $("#valor_meia_pago").val(),
                    data_inicio: $("#data_inicio_pago").val(),
                    hora_inicio: $("#hora_inicio_pago").val(),
                    data_fim: $("#data_fim_pago").val(),
                    hora_fim: $("#hora_fim_pago").val(),
                    qtd_minima_compra: $("#qtd_minima_compra").val(),
                    qtd_maxima_compra: $("#qtd_maxima_compra").val(),
                    qtd_ingressos: $("#qtd_ingressos").val(),
                    tipo: disponibilidade,
                },
                success: function(result) {
                    // Atualiza o resultado e fecha o modal
                    $("#result_pacotes").html(result);
                    $(".modal_ingresso_pago").modal('hide');

                    // Limpa os campos do formulário
                    $("#titulo_ingresso_pago").val('');
                    $("#qtd_ingresso_pago").val('');
                    $("#valor_ingresso_pago").val('');
                    $("#nome_meia_pago").val('');
                    $("#qtd_meia_pago").val('');
                    $("#valor_meia_pago").val('');
                    $("#data_inicio_pago").val('');
                    $("#hora_inicio_pago").val('');
                    $("#data_fim_pago").val('');
                    $("#hora_fim_pago").val('');
                    $("input[name='disponibilidade']").prop('checked', false); // Desmarca o checkbox
                }
            });
        }

        function IngressoUpdate(id) {
            var disponibilidade = $("input[name='disponibilidade_update']:checked").val();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('pacote.update') }}",
                method: 'POST',
                data: {
                    pacote_id: id,
                    evento_id: {{ $Evento->id }},
                    nome: $("#titulo_ingresso_update").val(),
                    qtd: $("#qtd_ingresso_update").val(),
                    preco: $("#valor_ingresso_update").val(),
                    data_inicio: $("#data_inicio_update").val(),
                    hora_inicio: $("#hora_inicio_update").val(),
                    data_fim: $("#data_fim_update").val(),
                    hora_fim: $("#hora_fim_update").val(),
                    qtd_minima_compra: $("#qtd_minima_compra_update").val(),
                    qtd_maxima_compra: $("#qtd_maxima_compra_update").val(),
                    tipo: disponibilidade,
                },
                success: function(result) {
                    if (result == 'error_excluir') {
                        swal("Atenção", "Já existe vendas para este ingresso, ele não pode ser removido", "error");
                    } else {
                        $("#result_pacotes").html(result);
                        $(".pacote_modal_edit").modal('hide');
                    }
                }
            });
        }

        function UpdateStatus(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('pacote.update.status') }}",
                method: 'POST',
                data: {
                    id: id
                },
                success: function(result) {
                    $("#result_pacotes").html(result); // Corrigido o uso de "result"
                },
                error: function(xhr, status, error) {
                    console.error("Erro na requisição:", error);
                    alert("Não foi possível atualizar o status. Tente novamente.");
                }
            });
        }

        function EditPacote(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('pacote.show') }}",
                method: 'POST',
                data: {
                    id: id
                },
                success: function(result) {
                    $("#result_pacote").html(result);
                    $(".pacote_modal_edit").modal('show');
                },
                error: function(xhr, status, error) {
                    console.error("Erro na requisição:", error);
                    alert("Não foi possível atualizar o status. Tente novamente.");
                }
            });
        }
        @if (session('success'))
            swal(
                "Sucesso",
                "{{ session('success') }}",
                "success"
            );
        @endif
    </script>

    <script>
        $(document).ready(function() {


            const inputsValores = document.querySelectorAll('.preco');
            inputsValores.forEach(function(inputValor) {
                inputValor.addEventListener('input', function(event) {
                    // Pega o valor do input e remove tudo que não é número
                    let valor = inputValor.value.replace(/\D/g, '');

                    // Formata o valor como dinheiro
                    if (valor) {
                        valor = (parseInt(valor) / 100).toLocaleString('pt-BR', {
                            style: 'currency',
                            currency: 'BRL'
                        });
                    } else {
                        valor = '';
                    }

                    // Atualiza o valor no input
                    inputValor.value = valor;
                });
            });

            const imageInput = document.getElementById('imageInput');
            const selectedImage = document.getElementById('selectedImage');

            imageInput.addEventListener('change', () => {
                const file = imageInput.files[0];
                const reader = new FileReader();

                reader.addEventListener('load', () => {
                    selectedImage.setAttribute('src', reader.result);
                });
                reader.readAsDataURL(file);
            });

            $("#cep").on("blur", function() {
                var numCep = $("#cep").val();
                var url = "https://viacep.com.br/ws/" + numCep.replace(/[\.-]/g, '') + "/json";
                $.ajax({
                    url: url,
                    type: "get",
                    dataType: "json",
                    success: function(dados) {
                        console.log(dados);
                        $("#cep").val(dados.cep);
                        $("#endereco").val(dados.logradouro);
                        $("#bairro").val(dados.bairro);
                        $("#cidade").val(dados.localidade);
                        $("#estado").val(dados.uf);
                    }
                });
            });
        });

        document.addEventListener('DOMContentLoaded', function() {
            const criarMeiaEntrada = document.getElementById('criar_meia_entrada');
            const boxMeiaEntrada = document.getElementById('box_meia_entrada');
            const tituloIngresso = document.getElementById('titulo_ingresso_pago');
            const valorIngresso = document.getElementById('valor_ingresso_pago');
            const tituloMeia = document.getElementById('nome_meia_pago');
            const valorMeia = document.getElementById('valor_meia_pago');

            // Mostra ou esconde a seção de meia-entrada
            criarMeiaEntrada.addEventListener('change', function() {
                if (this.checked) {
                    boxMeiaEntrada.classList.remove('d-none');
                } else {
                    boxMeiaEntrada.classList.add('d-none');
                }
            });

            // Atualiza o título da meia-entrada
            tituloIngresso.addEventListener('input', function() {
                const titulo = tituloIngresso.value;
                tituloMeia.value = `${titulo} (meia-entrada)`;
            });

            // Função para formatar valor no padrão brasileiro
            function formatarValor(valor) {
                return valor.toLocaleString('pt-BR', {
                    minimumFractionDigits: 2,
                    maximumFractionDigits: 2
                });
            }

            // Calcula e formata os valores após o input
            valorIngresso.addEventListener('keyup', function() {
                // Remove caracteres inválidos e converte para número
                let valor = parseFloat(valorIngresso.value.replace(/[^\d,]/g, '').replace(',', '.'));

                if (!isNaN(valor)) {
                    // Calcula o valor da meia-entrada
                    const meiaEntrada = valor / 2;

                    // Formata os valores
                    valorIngresso.value = `R$ ${formatarValor(valor)}`;
                    valorMeia.value = `R$ ${formatarValor(meiaEntrada)}`;
                } else {
                    // Reseta os valores caso não seja um número válido
                    valorIngresso.value = '';
                    valorMeia.value = '';
                }
            });
        });

        document.addEventListener('DOMContentLoaded', function() {
            const porDataRadio = document.getElementById('por_data');
            const porLoteRadio = document.getElementById('por_lote');

            porDataRadio.addEventListener('change', function() {
                console.log('data');
                if (this.checked) {
                    $("#box_por_data").removeClass('d-none');
                    $("#box_por_lote").addClass('d-none');
                }
            });

            porLoteRadio.addEventListener('change', function() {
                console.log('periodo');
                if (this.checked) {
                    $("#box_por_lote").removeClass('d-none');
                    $("#box_por_data").addClass('d-none');
                }
            });
        });


        function IngressoStore() {
            var disponibilidade = $("input[name='disponibilidade']:checked").val();

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('pacote.store') }}",
                method: 'POST',
                data: {
                    evento_id: {{ $Evento->id }},
                    nome: $("#titulo_ingresso_pago").val(),
                    qtd: $("#qtd_ingresso_pago").val(),
                    preco: $("#valor_ingresso_pago").val(),
                    nome_meia_pago: $("#nome_meia_pago").val(),
                    qtd_meia_pago: $("#qtd_meia_pago").val(),
                    valor_meia_pago: $("#valor_meia_pago").val(),
                    data_inicio: $("#data_inicio_pago").val(),
                    hora_inicio: $("#hora_inicio_pago").val(),
                    data_fim: $("#data_fim_pago").val(),
                    hora_fim: $("#hora_fim_pago").val(),
                    qtd_minima_compra: $("#qtd_minima_compra").val(),
                    qtd_maxima_compra: $("#qtd_maxima_compra").val(),
                    qtd_ingressos: $("#qtd_ingressos").val(),
                    tipo: disponibilidade,
                },
                success: function(result) {
                    // Atualiza o resultado e fecha o modal
                    $("#result_pacotes").html(result);
                    $(".modal_ingresso_pago").modal('hide');

                    // Limpa os campos do formulário
                    $("#titulo_ingresso_pago").val('');
                    $("#qtd_ingresso_pago").val('');
                    $("#valor_ingresso_pago").val('');
                    $("#nome_meia_pago").val('');
                    $("#qtd_meia_pago").val('');
                    $("#valor_meia_pago").val('');
                    $("#data_inicio_pago").val('');
                    $("#hora_inicio_pago").val('');
                    $("#data_fim_pago").val('');
                    $("#hora_fim_pago").val('');
                    $("input[name='disponibilidade']").prop('checked', false); // Desmarca o checkbox
                }
            });
        }

        function IngressoUpdate(id) {
            var disponibilidade = $("input[name='disponibilidade_update']:checked").val();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('pacote.update') }}",
                method: 'POST',
                data: {
                    pacote_id: id,
                    evento_id: {{ $Evento->id }},
                    nome: $("#titulo_ingresso_update").val(),
                    qtd: $("#qtd_ingresso_update").val(),
                    preco: $("#valor_ingresso_update").val(),
                    data_inicio: $("#data_inicio_update").val(),
                    hora_inicio: $("#hora_inicio_update").val(),
                    data_fim: $("#data_fim_update").val(),
                    hora_fim: $("#hora_fim_update").val(),
                    qtd_minima_compra: $("#qtd_minima_compra_update").val(),
                    qtd_maxima_compra: $("#qtd_maxima_compra_update").val(),
                    qtd_ingressos: $("#qtd_ingressos_update").val(),
                    tipo: disponibilidade,
                },
                success: function(result) {
                    if (result == 'error_excluir') {
                        swal("Atenção", "Já existe vendas para este ingresso, ele não pode ser removido", "error");
                    } else {
                        $("#result_pacotes").html(result);
                        $(".pacote_modal_edit").modal('hide');
                    }
                }
            });
        }

        function UpdateStatus(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('pacote.update.status') }}",
                method: 'POST',
                data: {
                    id: id
                },
                success: function(result) {
                    $("#result_pacotes").html(result); // Corrigido o uso de "result"
                },
                error: function(xhr, status, error) {
                    console.error("Erro na requisição:", error);
                    alert("Não foi possível atualizar o status. Tente novamente.");
                }
            });
        }

        function EditPacote(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('pacote.show') }}",
                method: 'POST',
                data: {
                    id: id
                },
                success: function(result) {
                    $("#result_pacote").html(result);
                    $(".pacote_modal_edit").modal('show');
                },
                error: function(xhr, status, error) {
                    console.error("Erro na requisição:", error);
                    alert("Não foi possível atualizar o status. Tente novamente.");
                }
            });
        }
        @if (session('success'))
            swal(
                "Sucesso",
                "{{ session('success') }}",
                "success"
            );
        @endif

        function AtivarTaxa(id) {
            swal({
                title: "ABSORVER A TAXA DE SERVIÇO",
                text: "Alterando essa opção, a taxa de serviço será descontada do preço final da venda do ingresso e não será descontada do comprador. Tem certeza que quer continuar?",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Continuar",
                cancelButtonText: "Cancelar",
                closeOnConfirm: false,
                closeOnCancel: false
            }, function(isConfirm) {
                if (isConfirm) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });

                    $.ajax({
                        url: "{{ route('update.taxa.servico') }}",
                        method: 'POST',
                        data: {
                            id
                        },
                        success: function(result) {
                            $("#taxa_servico").html(result.html);
                            if (result.nova_taxa == 10) {
                                swal("Desativado", "Agora a taxa de serviço será paga pelo cliente", "success");
                            } else {
                                swal("Ativado", "Agora a taxa de serviço de {{ env('TAXA') }}% será descontada do preço final", "success");
                            }
                        },
                        error: function(xhr, status, error) {

                        }
                    });
                } else {
                    swal("Cancelado", "A taxa de {{ env('TAXA') }}% será paga pelo cliente,", "error");
                }
            });
        }

        function Desativar(id) {
            swal({
                title: "REPASSAR A TAXA DE SERVIÇO",
                text: "Desativando essa opção, a taxa de serviço será repassada ao comprador. Tem certeza que quer continuar?",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Continuar",
                cancelButtonText: "Cancelar",
                closeOnConfirm: false,
                closeOnCancel: false
            }, function(isConfirm) {
                if (isConfirm) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });

                    $.ajax({
                        url: "{{ route('update.taxa.servico') }}",
                        method: 'POST',
                        data: {
                            id
                        },
                        success: function(result) {
                            $("#taxa_servico").html(result.html);
                            if (result.nova_taxa == 10) {
                                swal("Desativado", "Agora a taxa de serviço será paga pelo cliente", "success");
                            } else {
                                swal("Ativado", "Agora a taxa de serviço de {{ env('TAXA') }}% será descontada do preço final", "success");
                            }
                        },
                        error: function(xhr, status, error) {

                        }
                    });
                } else {
                    swal("Cancelado", "A taxa de {{ env('TAXA') }}% será paga pelo cliente,", "error");
                }
            });
        }
    </script>

@endsection
