@extends('admin.base.base')
@section('titulo', 'Cadastro de Evento')
@section('content')
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                {{-- @include('admin.evento.include.info') --}}
                <div class="row">
                    <div class="col-12">
                        <form action="{{ route('evento.store') }}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <h4 class="box-title text-info mb-0"><i class="glyphicon glyphicon-info-sign"></i> Informações básicas</h4>
                                        <hr class="my-15">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <label class="form-label" for="imageInput">
                                                    <img src="{{ url('images/sem-foto.jpeg') }}" id="selectedImage" width="150" style="border-radius: 20px; cursor:pointer;">
                                                    <br>
                                                    Arte da Carteira
                                                </label>
                                                <input name="image" type="file" class="form-control d-none" id="imageInput" accept="image/*">

                                            </div>

                                            <div class="col-lg-6 col-md-6 col-6">
                                                <div class="form-group">
                                                    <label class="form-label">Titulo</label>
                                                    <input name="titulo" type="text" class="form-control">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <h4 class="box-title text-info mb-0"><i class="glyphicon glyphicon-font"></i> Descrição da adesão</h4>
                                        <hr class="my-15">
                                        <div class="row">
                                            <textarea id="editor1" name="editor1"></textarea>
                                            <textarea name="descricao" class="textarea" style="width: 100%; height: 200px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;"></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <h4 class="box-title text-info mb-0"><i class="glyphicon glyphicon-calendar"></i> Data e horário</h4>
                                        <hr class="my-15">
                                        <div class="row">
                                            <div class="col-lg-3 col-md-3 col-6">
                                                <div class="form-group">
                                                    <label class="form-label">Data Início</label>
                                                    <input name="data_inicio" value="{{ old('data_inicio') }}" type="date" class="form-control date-time">
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-6">
                                                <div class="form-group">
                                                    <label class="form-label">Hora Início</label>
                                                    <input name="hora_inicio" value="{{ old('hora_inicio') }}" type="time" class="form-control date-time">
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-6">
                                                <div class="form-group">
                                                    <label class="form-label">Data Final</label>
                                                    <input name="data_fim" value="{{ old('data_fim') }}" type="date" class="form-control date-time">
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-6">
                                                <div class="form-group">
                                                    <label class="form-label">Hora Final</label>
                                                    <input name="hora_fim" value="{{ old('hora_fim') }}" type="time" class="form-control date-time">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="form-label">Visibilidade da Venda</label>
                                                    <div class="radio-list">
                                                        <label class="p-0 radio-inline me-10">
                                                            <div class="radio radio-info">
                                                                <input id="statuss" type="radio" name="tipo" value="Público" checked>
                                                                <label for="statuss">Público</label>
                                                            </div>
                                                        </label>
                                                        <label class="radio-inline">
                                                            <div class="radio radio-info">
                                                                <input id="statusn" type="radio" name="tipo" value="Privado">
                                                                <label for="statusn">Privado</label>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <button type="submit" class="btn btn-primary btn-sm"> <i class="fa fa-check"></i> Publicar</button>
                                                <button type="submit" class="btn-sm waves-effect waves-light btn btn-outline btn-primary"> <i class="fa fa-check"></i> Salvar Rascunho</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </section>
        </div>
    </div>

    <div class="modal fade modal_ingresso_pago" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myLargeModalLabel">Criar ingresso <strong>Pago</strong></h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Título do ingresso</label>
                                    <input type="text" id="titulo_ingresso_pago" class="form-control" placeholder="Ingresso único, Meia-Entrada, VIP, etc">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Quantidade</label>
                                    <input id="qtd_ingresso_pago" type="text" class="form-control" placeholder="Ex. 100">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Valor a receber</label>
                                    <input type="text" id="valor_ingresso_pago" class="form-control preco" placeholder="R$">
                                </div>
                            </div>
                            <div class="form-group ichack-input">
                                <div class="demo-checkbox">
                                    <input type="checkbox" id="criar_meia_entrada" class="chk-col-info">
                                    <label for="criar_meia_entrada"> Criar meia-entrada para este ingresso</label>
                                </div>
                            </div>
                        </div>
                        <div class="row d-none" id="box_meia_entrada">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Título do ingresso</label>
                                    <input type="text" id="nome_meia_pago" class="form-control" placeholder="Ingresso único, Meia-Entrada, VIP, etc" readonly>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Quantidade</label>
                                    <input id="qtd_meia_pago" type="text" class="form-control" placeholder="Ex. 100">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Valor a receber</label>
                                    <input type="text" id="valor_meia_pago" class="form-control preco" placeholder="R$">
                                </div>
                            </div>
                        </div>
                        <div class="row mt-30">
                            <label class="form-label">Período das vendas deste ingresso</label>
                            <div class="row">
                                <div class="col-lg-3 col-md-3 col-6">
                                    <div class="form-group">
                                        <label class="form-label">Data Início</label>
                                        <input id="data_inicio_pago" value="{{ old('data_inicio') }}" type="date" class="form-control date-time">
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-6">
                                    <div class="form-group">
                                        <label class="form-label">Hora Início</label>
                                        <input id="hora_inicio_pago" value="{{ old('hora_inicio') }}" type="time" class="form-control date-time">
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-6">
                                    <div class="form-group">
                                        <label class="form-label">Data Final</label>
                                        <input id="data_fim_pago" value="{{ old('data_fim') }}" type="date" class="form-control date-time">
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-6">
                                    <div class="form-group">
                                        <label class="form-label">Hora Final</label>
                                        <input id="hora_fim_pago" value="{{ old('hora_fim') }}" type="time" class="form-control date-time">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-30">
                            <label class="form-label">Disponibilidade do Ingresso</label>
                            <div class="form-group">
                                <div class="radio">
                                    <input name="disponibilidade" type="radio" id="Option_1" checked="" value="Público">
                                    <label for="Option_1">Para todo o público </label>
                                </div>
                                <div class="radio">
                                    <input name="disponibilidade" type="radio" id="Option_2" value="Convidados">
                                    <label for="Option_2">Restrito a convidados</label>
                                </div>
                                <div class="radio">
                                    <input name="disponibilidade" type="radio" id="Option_3" value="Manual">
                                    <label for="Option_3">Para ser adicionado manualmente</label>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-30">
                            <label class="form-label">Quantidade permitida por compra</label>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label">Mínima</label>
                                            <input id="qtd_minima_compra" type="text" class="form-control" value="1">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label">Máxima</label>
                                            <input id="qtd_maxima_compra" type="text" class="form-control" value="5">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger text-start btn-sm" data-bs-dismiss="modal">Cancelar</button>
                    <button onclick="javascript:IngressoStore()" type="button" class="btn btn-primary float-end btn-sm">Criar Ingresso</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>


    <div class="modal fade pacote_modal_edit" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-lg" id="result_pacote">

        </div>
    </div>
@endsection
@section('js')
    <script src="{{ url('assets/vendor_plugins/iCheck/icheck.min.js') }}"></script>
    <script src="{{ url('assets/vendor_components/formatter/formatter.js') }}"></script>
    <script src="{{ url('assets/vendor_components/formatter/jquery.formatter.js') }}"></script>
    <script src="{{ url('admin') }}/src/js/pages/formatter.js"></script>

    <script src="{{ url('assets/vendor_components/sweetalert/sweetalert.min.js') }}"></script>
    <script src="{{ url('assets/vendor_components/sweetalert/jquery.sweet-alert.custom.js') }}"></script>

    <script src="{{ url('assets/vendor_components/ckeditor/ckeditor.js') }}"></script>
    <script src="{{ url('assets/vendor_plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.js') }}"></script>
    <script src="{{ url('admin') }}/src/js/pages/editor.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const imageInput = document.getElementById('imageInput');
            const selectedImage = document.getElementById('selectedImage');

            if (imageInput) {
                imageInput.addEventListener('change', function() {
                    const file = this.files[0];
                    if (file) {
                        const reader = new FileReader();
                        reader.onload = function(e) {
                            selectedImage.src = e.target.result;
                        };
                        reader.readAsDataURL(file);
                    }
                });
            }

            // Permite clicar na imagem para abrir o seletor
            selectedImage.addEventListener('click', function() {
                imageInput.click();
            });
        });
    </script>


@endsection
