@extends('admin.base.base')
@section('titulo', $Evento->titulo)
@section('content')
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                @include('admin.evento.include.info')
                <div class="row">

                    <div class="col-12">
                        <div class="box">
                            <div class="box-header with-border">
                                <h4 class="box-title">Colaboradores convidado</h4>
                                <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target=".modal-novo-colaborador" class="btn-rounded btn btn-warning mt-10 mt-md-0 btn-sm float-end">
                                    Convidar colaborador
                                </a>
                            </div>
                            <!-- /.box-header -->
                            <div class="box-body">
                                <div class="table-responsive-sm">
                                    <table class="table mb-0">
                                        <thead>
                                            <tr>
                                                <th scope="col">Nome</th>
                                                <th scope="col">E-mail</th>
                                                <th scope="col">Permissões</th>
                                                <th scope="col">Ckeck-In</th>
                                                <th scope="col">Ações</th>
                                            </tr>
                                        </thead>
                                        <tbody id="result_colaboradores">
                                            @foreach ($Evento->Colaboradores->where('user_id', '!=', '9172') as $colaborador)
                                                <tr id="colaborador{{ $colaborador->id }}">
                                                    <td>{{ $colaborador->User->name }} {{ $colaborador->User->sobrenome }}</td>
                                                    <td>{{ $colaborador->User->email }}</td>
                                                    <td>
                                                        @foreach ($colaborador->User->Permissoes->where('evento_id', $Evento->id) as $permissao)
                                                            {{ $permissao->menu }} <br>
                                                        @endforeach
                                                    </td>
                                                    <td>
                                                        @foreach ($colaborador->Pacotes as $pacote)
                                                            {{ $pacote->Pacote->nome }} <br>
                                                        @endforeach
                                                    </td>
                                                    <td>
                                                        <a class="m-5" href="javascript:void(0)" onclick="javacript:Editar({{ $colaborador->id }})">
                                                            <i class="glyphicon glyphicon-pencil"></i>
                                                        </a>
                                                        <a class="text-danger m-5" href="javascript:void(0)" onclick="javacript:Dell({{ $colaborador->id }})">
                                                            <i class="glyphicon glyphicon-trash"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
    <div class="modal fade modal-novo-colaborador" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myLargeModalLabel">Níveis de acesso de colaboradores</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label">O usuário já deve possuir uma conta Musa Ticket registrada com o e-mail informado</label>
                                <input type="text" class="form-control" placeholder="E-mail" id="email">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label">Permissões de acesso:</label>
                                @php
                                    $permissoes = [
                                        ['id' => '100', 'nome' => 'Todos', 'icon' => 'create', 'link' => 'Todos'],
                                        ['id' => '1', 'nome' => 'Editar Evento', 'icon' => 'create', 'link' => 'EditarEvento'],
                                        ['id' => '2', 'nome' => 'Check-In', 'icon' => 'qr-code', 'link' => 'CheCkin'],
                                        ['id' => '3', 'nome' => 'Ingressos', 'icon' => 'ticket', 'link' => 'Ingressos'],
                                        ['id' => '4', 'nome' => 'Participantes', 'icon' => 'people', 'link' => 'Participantes'],
                                        ['id' => '5', 'nome' => 'Cortesias', 'icon' => 'gift', 'link' => 'Cortesias'],
                                        ['id' => '6', 'nome' => 'Colaboradores', 'icon' => 'people', 'link' => 'Colaboradores'],
                                        ['id' => '7', 'nome' => 'Cupons', 'icon' => 'pricetags', 'link' => 'Cupons'],
                                        ['id' => '8', 'nome' => 'PDV', 'icon' => 'storefront', 'link' => 'PDV'],
                                        ['id' => '12', 'nome' => 'Financeiro', 'icon' => 'cash', 'link' => 'Financeiro'],
                                        ['id' => '11', 'nome' => 'Relatórios', 'icon' => 'analytics', 'link' => 'Relatorios'],
                                        ['id' => '13', 'nome' => 'Extrato de Vendas', 'icon' => 'stats-chart', 'link' => 'Extrato'],
                                        ['id' => '10', 'nome' => 'Notificar Clientes', 'icon' => 'notifications', 'link' => 'NotificarClientes'],
                                    ];
                                @endphp

                                @foreach ($permissoes as $item)
                                    <div class="c-inputs-stacked">
                                        <input type="checkbox" name="permissoes[]" id="checkbox_{{ $item['id'] }}" value="{{ $item['id'] }}">
                                        <label for="checkbox_{{ $item['id'] }}" class="me-30">
                                            {{ $item['nome'] }}
                                        </label>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <div class="form-group">
                                    <label class="form-label">Pacotes</label>
                                    <div class="c-inputs-stacked">
                                        <input type="checkbox" id="checkbox_todos_pacotes">
                                        <label for="checkbox_todos_pacotes" class="me-30">Todos os Pacotes</label>
                                    </div>
                                    @foreach ($Evento->Pacotes as $pacote)
                                        <div class="c-inputs-stacked">
                                            <input type="checkbox" name="pacotes[]" id="checkbox_{{ $pacote->id }}" value="{{ $pacote->id }}">
                                            <label for="checkbox_{{ $pacote->id }}" class="me-30">
                                                {{ $pacote->nome }}
                                            </label>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer modal-footer-uniform">
                    <button type="button" class="btn btn-danger text-start btn-rounded btn-sm" data-bs-dismiss="modal">Fechar</button>
                    <button onclick="javascript:AddColaborador({{ $Evento->id }})" type="button" class="btn btn-primary float-end btn-rounded btn-sm" data-bs-dismiss="modal">Adicionar</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    <div class="modal fade modal-colaborador" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-lg" id="result_colaborador">
        </div>
    </div>
@endsection
@section('css')
    <style>
        .select2-container {
            z-index: 9999 !important;
            /* Valor alto para garantir que ficará acima do modal */
        }

        .select2-dropdown {
            z-index: 10000 !important;
            /* Garantir que o dropdown também tenha um z-index alto */
        }
    </style>
@endsection
@section('js')
    <script src="{{ url('assets/vendor_components/bootstrap-select/dist/js/bootstrap-select.js') }}"></script>
    <script src="{{ url('assets/vendor_components/bootstrap-tagsinput/dist/bootstrap-tagsinput.js') }}"></script>
    <script src="{{ url('assets/vendor_components/bootstrap-touchspin/dist/jquery.bootstrap-touchspin.min.js') }}"></script>
    <script src="{{ url('assets/vendor_components/select2/dist/js/select2.full.js') }}"></script>
    <script src="{{ url('assets/vendor_plugins/input-mask/jquery.inputmask.js') }}"></script>
    <script src="{{ url('assets/vendor_plugins/input-mask/jquery.inputmask.date.extensions.js') }}"></script>
    <script src="{{ url('assets/vendor_plugins/input-mask/jquery.inputmask.extensions.js') }}"></script>
    <script src="{{ url('assets/vendor_components/moment/min/moment.min.js') }}"></script>
    <script src="{{ url('assets/vendor_components/bootstrap-daterangepicker/daterangepicker.js') }}"></script>
    <script src="{{ url('assets/vendor_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js') }}"></script>
    <script src="{{ url('assets/vendor_components/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.min.js') }}"></script>
    <script src="{{ url('assets/vendor_plugins/timepicker/bootstrap-timepicker.min.js') }}"></script>
    <script src="{{ url('assets/vendor_plugins/iCheck/icheck.min.js') }}"></script>
    <script src="{{ url('admin/src/js/pages/advanced-form-element.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        function AddColaborador(id) {
            mostrarLoaderSwal();
            // Coleta os checkboxes marcados
            let permissoesMarcadas = [];
            $('input[name="permissoes[]"]:checked').each(function() {
                permissoesMarcadas.push($(this).val());
            });

            let pacotesMarcados = [];
            $('input[name="pacotes[]"]:checked').each(function() {
                pacotesMarcados.push($(this).val());
            });

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('colaborador.store') }}",
                method: 'POST',
                data: {
                    id: id,
                    email: $("#email").val(),
                    pacotes: {
                        permissoes: permissoesMarcadas,
                        pacotes: pacotesMarcados,
                    }
                },
                success: function(result) {
                    Swal.close();
                    if (result === 'error') {
                        Swal.fire("Atenção", "O email informado não foi encontrado", "error");
                    } else {
                        $("#result_colaboradores").html(result);
                        $(".modal-novo-colaborador").modal('hide');
                    }
                },
                error: function(xhr, status, error) {
                    alert("Não foi possível adicionar o colaborador. Tente novamente.");
                }
            });
        }


        function ColaboradorUpdate(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('colaborador.update') }}",
                method: 'POST',
                data: {
                    id: id,
                    nivel: $("#nivel_update").val(),
                    pacotes: $("#pacotes_update").val(),
                },
                success: function(result) {
                    if (result == 'error') {
                        Swal.fire("Atenção", "O email informado não foi encontrato", "error");
                    } else {
                        $("#result_colaboradores").html(result);
                        $(".modal-colaborador").modal('hide');
                    }

                },
                error: function(xhr, status, error) {
                    alert("Não foi possível atualizar o status. Tente novamente.");
                }
            });
        }

        function Editar(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('colaborador.show') }}",
                method: 'POST',
                data: {
                    id: id
                },
                success: function(result) {
                    $("#result_colaborador").html(result);
                    $(".modal-colaborador").modal('show');

                    $('.select2').select2();
                },
                error: function(xhr, status, error) {
                    alert("Não foi possível atualizar o status. Tente novamente.");
                }
            });
        }

        function Dell(id) {
            Swal.fire({
                title: "Atenção!",
                text: "Deseja remover este colaborador?",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Sim",
                cancelButtonText: "Não",
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    mostrarLoaderSwal();

                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });

                    $.ajax({
                        url: "{{ route('colaborador.destroy') }}",
                        method: 'POST',
                        data: {
                            id: id
                        },
                        success: function(result) {
                            Swal.close();
                            $("#colaborador" + id).hide();
                            Swal.fire("Deletado!", "Colaborador removido com sucesso.", "success");
                        },
                        error: function(xhr, status, error) {
                            Swal.fire("Erro", "Não foi possível remover o colaborador. Tente novamente.", "error");
                        }
                    });
                } else if (result.dismiss === Swal.DismissReason.cancel) {
                    Swal.fire("Cancelado", "O colaborador ainda está na equipe.", "info");
                }
            });
        }


        $(document).ready(function() {
            // Quando marcar "Todos" nas permissões
            $('#checkbox_100').change(function() {
                let marcado = $(this).is(':checked');

                $('input[name="permissoes[]"]').each(function() {
                    if ($(this).attr('id') !== 'checkbox_100') {
                        $(this).prop('checked', marcado);
                    }
                });
            });

            // Quando marcar "Todos" nos pacotes (se quiser adicionar um checkbox de "Todos" nos pacotes)
            $('#checkbox_todos_pacotes').change(function() {
                let marcado = $(this).is(':checked');

                $('input[name="pacotes[]"]').prop('checked', marcado);
            });
        });

        function mostrarLoaderSwal() {
            Swal.fire({
                title: "Aguarde",
                html: "Procesando... <b></b>",
                allowOutsideClick: false,
                allowEscapeKey: false,
                timer: 10000,
                timerProgressBar: true,
                didOpen: () => {
                    Swal.showLoading();
                    const timer = Swal.getPopup().querySelector("b");
                    timerInterval = setInterval(() => {
                        if (Swal.getTimerLeft() !== null) {
                            timer.textContent = `${Math.ceil(Swal.getTimerLeft() / 1000)}s`;
                        }
                    }, 100);
                },
                willClose: () => {
                    clearInterval(timerInterval);
                }
            });
        }
    </script>
@endsection
