@extends('admin.base.base')
@section('titulo', $Evento->titulo)
@section('content')
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                @include('admin.evento.include.info')
                <div class="row">
                    <div class="col-xl-3 col-lg-6 col-12">
                        <div class="box">
                            <div class="box-body text-center">
                                <h4 class="box-title mx-auto">Realizados</h4>
                                <div style="min-height: 162px; position: relative;">
                                    <div id="realizados" style="min-height: 140.5px;"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-9 col-lg-6 col-12">
                        <div class="box">
                            <div class="box-body">
                                <div class="table-responsive-sm">
                                    <table class="table mb-0">
                                        <thead>
                                            <tr>
                                                <th scope="col">Tipo de ingresso</th>
                                                <th scope="col">Check-ins realizados</th>
                                            </tr>
                                        </thead>
                                        <tbody id="result_pacotes">
                                            @foreach ($Evento->Pacotes as $pacote)
                                                <tr>
                                                    <td>{{ $pacote->nome }}</td>
                                                    <td>
                                                        <div class="row">
                                                            <div class="text-right nopadding">
                                                                <div class="progress-container">
                                                                    <div class="progress soldticket-bar pull-left">
                                                                        <div role="progressbar" aria-valuenow="{{ count($pacote->Ingressos->where('check_in_status','1')) }}" aria-valuemin="0" aria-valuemax="{{ $pacote->qtd }}"
                                                                            class="progress-bar" style="width: {{ MediaVendas(count($pacote->Ingressos->where('check_in_status','1')), $pacote->qtd) }}%;"></div>
                                                                        <span class="progress-sold">{{ count($pacote->Ingressos->where('check_in_status','1')) }}</span>
                                                                        <span class="progress-total">{{ $pacote->qtd }}</span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="row">
                    <div class="col-xl-3 col-lg-6 col-12">
                        <div class="box">
                            <div class="box-body text-center">
                                <h4 class="box-title mx-auto">Restantes</h4>
                                <div style="min-height: 162px; position: relative;">
                                    <div id="restantes" style="min-height: 140.5px;"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
@endsection
@section('js')
    <script>
        var options = {
            series: [{{ $Realizados }}],
            chart: {
                height: 279,
                type: 'radialBar',
                sparkline: {
                    enabled: true
                }
            },
            colors: ['#ffa800'],
            plotOptions: {
                radialBar: {
                    startAngle: -90,
                    endAngle: 90,
                    track: {
                        background: "#e7e7e7",
                        strokeWidth: '97%',
                        margin: 5, // margin is in pixels
                    },
                    dataLabels: {
                        name: {
                            show: false
                        },
                        value: {
                            offsetY: -20,
                            fontSize: '22px'
                        }
                    }
                }
            },
            grid: {
                padding: {
                    top: -0
                }
            },
            labels: ['Average Results'],
        };

        var chart = new ApexCharts(document.querySelector("#realizados"), options);
        chart.render();



        var options = {
            series: [{{ $NaoRealizados }}],
            chart: {
                height: 279,
                type: 'radialBar',
                sparkline: {
                    enabled: true
                }
            },
            colors: ['#006699'],
            plotOptions: {
                radialBar: {
                    startAngle: -90,
                    endAngle: 90,
                    track: {
                        background: "#e7e7e7",
                        strokeWidth: '97%',
                        margin: 5, // margin is in pixels
                    },
                    dataLabels: {
                        name: {
                            show: false
                        },
                        value: {
                            offsetY: -20,
                            fontSize: '22px'
                        }
                    }
                }
            },
            grid: {
                padding: {
                    top: -0
                }
            },
            labels: ['Average Results'],
        };

        var chart = new ApexCharts(document.querySelector("#restantes"), options);
        chart.render();
    </script>
@endsection
