@foreach ($Evento->Pacotes as $pacote)
    <tr>
        <td>{{ $pacote->nome }}</td>
        <td>
            <div class="row">
                <div class="text-right nopadding">
                    <div class="progress-container">
                        <div class="progress soldticket-bar pull-left">
                            <div role="progressbar" aria-valuenow="{{ $pacote->qtd_ingressos > 0 ? count($pacote->Ingressos->where('status', '1')) / $pacote->qtd_ingressos : 0 }}" aria-valuemin="0" aria-valuemax="{{ $pacote->qtd }}" class="progress-bar"
                                style="width: {{ $pacote->qtd_ingressos > 0 ? MediaVendas(count($pacote->Ingressos->where('status', '1')) / $pacote->qtd_ingressos, $pacote->qtd) : 0 }}%;"></div>
                            <span class="progress-sold">{{ $pacote->qtd_ingressos > 0 ? count($pacote->Ingressos->where('status', '1')) / $pacote->qtd_ingressos : 0 }}</span>
                            <span class="progress-total">{{ $pacote->qtd }}</span>
                        </div>
                    </div>
                </div>
            </div>
        </td>
        <td>R$ {{ moeda($pacote->preco) }}</td>
        <td>R$ {{ moeda(porcentagem(env('TAXA'), $pacote->preco)) }} </td>
        <td>
            <button onclick="javascript:UpdateStatus({{ $pacote->id }})" type="button" class="btn btn-sm btn-toggle btn-info {{ $pacote->status == 'Ativo' ? 'active' : '' }}" data-toggle="button" aria-pressed="true"><span
                    class="handle"></span></button>
        </td>
        <td>
            @if (Auth::user()->nivel == '1')
                <a href="javascript:void(0)" onclick="javascript:EditPacote({{ $pacote->id }})">
                    <i class="glyphicon glyphicon-pencil"></i>
                </a>
            @endif
        </td>
    </tr>
@endforeach
